# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.hdinsight import HDInsightManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hdinsight
# USAGE
    python create_kafka_cluster_with_kafka_rest_proxy.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HDInsightManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.clusters.begin_create(
        resource_group_name="rg1",
        cluster_name="cluster1",
        parameters={
            "properties": {
                "clusterDefinition": {
                    "componentVersion": {"Kafka": "2.1"},
                    "configurations": {
                        "gateway": {
                            "restAuthCredential.isEnabled": True,
                            "restAuthCredential.password": "**********",
                            "restAuthCredential.username": "admin",
                        }
                    },
                    "kind": "kafka",
                },
                "clusterVersion": "4.0",
                "computeProfile": {
                    "roles": [
                        {
                            "hardwareProfile": {"vmSize": "Large"},
                            "name": "headnode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "**********", "username": "sshuser"}
                            },
                            "targetInstanceCount": 2,
                        },
                        {
                            "dataDisksGroups": [{"disksPerNode": 8}],
                            "hardwareProfile": {"vmSize": "Large"},
                            "name": "workernode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "**********", "username": "sshuser"}
                            },
                            "targetInstanceCount": 3,
                        },
                        {
                            "hardwareProfile": {"vmSize": "Small"},
                            "name": "zookeepernode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "**********", "username": "sshuser"}
                            },
                            "targetInstanceCount": 3,
                        },
                        {
                            "hardwareProfile": {"vmSize": "Standard_D4_v2"},
                            "name": "kafkamanagementnode",
                            "osProfile": {
                                "linuxOperatingSystemProfile": {"password": "**********", "username": "kafkauser"}
                            },
                            "targetInstanceCount": 2,
                        },
                    ]
                },
                "kafkaRestProperties": {
                    "clientGroupInfo": {
                        "groupId": "00000000-0000-0000-0000-111111111111",
                        "groupName": "Kafka security group name",
                    }
                },
                "osType": "Linux",
                "storageProfile": {
                    "storageaccounts": [
                        {
                            "container": "containername",
                            "enableSecureChannel": True,
                            "isDefault": True,
                            "key": "storagekey",
                            "name": "mystorage.blob.core.windows.net",
                        }
                    ]
                },
                "tier": "Standard",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/hdinsight/resource-manager/Microsoft.HDInsight/preview/2025-01-15-preview/examples/CreateKafkaClusterWithKafkaRestProxy.json
if __name__ == "__main__":
    main()
