; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx803 < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9-NODL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx906 < %s | FileCheck -check-prefixes=GFX9-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1011 < %s | FileCheck -check-prefixes=GFX10-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1012 < %s | FileCheck -check-prefixes=GFX10-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11-DL,GFX11-DL-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11-DL,GFX11-DL-FAKE16 %s

define amdgpu_kernel void @udot4_acc32(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, s4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v6, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 8, 8
; GFX8-NEXT:    v_bfe_u32 v6, v3, 16, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX8-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, s0
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v4, v5, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    v_mad_u32_u24 v1, v6, v7, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc32:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v4, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v2, v3, s0, v4
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v5, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc32:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc32:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, s0
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc32:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad1 = add i32 %mul1, %acc
  %mad2 = add i32 %mad1, %mul2
  %mad3 = add i32 %mad2, %mul3
  %mad4 = add i32 %mad3, %mul4

  store i32 %mad4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_acc16(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc16:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    buffer_load_ushort v1, off, s[4:7], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v7, v0, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v6, v1
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v8, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v8, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ushort v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_and_b32_e32 v6, 0xff, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v3
; GFX8-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX8-NEXT:    v_and_b32_sdwa v10, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v7, 0xff, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v2
; GFX8-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v4, v6, v7, v4
; GFX8-NEXT:    v_and_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_mad_u16 v4, v8, v9, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_mad_u16 v4, v10, v5, v4
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc16:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v5, 0xff, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 8, v2
; GFX9-NODL-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX9-NODL-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v4, v5, v3
; GFX9-NODL-NEXT:    v_and_b32_sdwa v8, v1, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_and_b32_sdwa v9, v2, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v6, v7, v3
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v8, v9, v3
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-NODL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc16:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_ushort v4, v1, s[6:7]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v0, v2, v3, v4
; GFX9-DL-NEXT:    global_store_short v1, v0, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc16:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_ushort v4, v1, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v2, v3, v4
; GFX10-DL-NEXT:    global_store_short v1, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc16:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_u16 v3, v1, s[4:5]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v2, v0, v3
; GFX11-DL-NEXT:    global_store_b16 v1, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i16
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i16
  %mul1 = mul nuw nsw i16 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i16
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i16
  %mul2 = mul nuw nsw i16 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i16
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i16
  %mul3 = mul nuw nsw i16 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i16
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i16
  %mul4 = mul nuw nsw i16 %cv1e3, %cv2e3

  %acc = load i16, ptr addrspace(1) %dst, align 2
  %mad1 = add i16 %mul1, %acc
  %mad2 = add i16 %mad1, %mul2
  %mad3 = add i16 %mad2, %mul3
  %mad4 = add i16 %mad3, %mul4

  store i16 %mad4, ptr addrspace(1) %dst, align 2
  ret void
}

define amdgpu_kernel void @udot4_acc8(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    buffer_load_ubyte v1, off, s[4:7], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v7, v0, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v6, v1
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v8, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v8, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ubyte v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    v_mad_u16 v2, v7, v8, v2
; GFX8-NEXT:    v_mad_u16 v2, v5, v6, v2
; GFX8-NEXT:    v_mad_u16 v2, v9, v10, v2
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc8:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 8, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v6, v7, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v4, v5, v1
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v8, v9, v1
; GFX9-NODL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_ubyte v4, v1, s[6:7]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v0, v2, v3, v4
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_ubyte v4, v1, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v2, v3, v4
; GFX10-DL-NEXT:    global_store_byte v1, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc8:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_u8 v3, v1, s[4:5]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v2, v0, v3
; GFX11-DL-NEXT:    global_store_b8 v1, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                      ptr addrspace(1) %src2,
                                      ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %mul1 = mul nuw nsw i8 %v1e0, %v2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %mul2 = mul nuw nsw i8 %v1e1, %v2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %mul3 = mul nuw nsw i8 %v1e2, %v2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %mul4 = mul nuw nsw i8 %v1e3, %v2e3

  %acc = load i8, ptr addrspace(1) %dst, align 2
  %mad1 = add i8 %mul1, %acc
  %mad2 = add i8 %mad1, %mul2
  %mad3 = add i8 %mad2, %mul3
  %mad4 = add i8 %mad3, %mul4

  store i8 %mad4, ptr addrspace(1) %dst, align 2
  ret void
}

define amdgpu_kernel void @udot2_8(ptr addrspace(1) %src1,
; GFX7-LABEL: udot2_8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    buffer_load_ubyte v1, off, s[4:7], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v4, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot2_8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ubyte v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 8, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 8, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    v_mad_u16 v2, v5, v6, v2
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot2_8:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX9-NODL-NEXT:    global_load_ubyte v4, v1, s[6:7]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v0, 8, v2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 8, v3
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v2, v2, v3, v4
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v0, v0, v5, v2
; GFX9-NODL-NEXT:    global_store_byte v1, v0, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot2_8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_mov_b32 s0, 0xc0c0100
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, v3
; GFX9-DL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot2_8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0100
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v2, v2, v2, 0xc0c0100
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, v3
; GFX10-DL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot2_8:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_u8 v3, v2, s[4:5]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0100
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc0c0100
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, v3
; GFX11-DL-NEXT:    global_store_b8 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                   ptr addrspace(1) %src2,
                                   ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %mul1 = mul nuw nsw i8 %v1e0, %v2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %mul2 = mul nuw nsw i8 %v1e1, %v2e1

  %acc = load i8, ptr addrspace(1) %dst, align 2
  %mad1 = add i8 %mul1, %acc
  %mad2 = add i8 %mad1, %mul2
  store i8 %mad2, ptr addrspace(1) %dst, align 2
  ret void
}

define amdgpu_kernel void @udot4_CommutationInsideMAD(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_CommutationInsideMAD:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    buffer_load_ubyte v1, off, s[4:7], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v7, v0, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v6, v3, v1
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v8, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v7, v4, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v8, v5, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_CommutationInsideMAD:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ubyte v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v2, v2, v3, v4
; GFX8-NEXT:    v_mad_u16 v2, v8, v7, v2
; GFX8-NEXT:    v_mad_u16 v2, v6, v5, v2
; GFX8-NEXT:    v_mad_u16 v2, v10, v9, v2
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_CommutationInsideMAD:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 8, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v2, v1, v3
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v7, v6, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v5, v4, v1
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v9, v8, v1
; GFX9-NODL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_CommutationInsideMAD:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_ubyte v4, v1, s[6:7]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v0, v3, v2, v4
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_CommutationInsideMAD:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_ubyte v4, v1, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v3, v2, v4
; GFX10-DL-NEXT:    global_store_byte v1, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_CommutationInsideMAD:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_u8 v3, v1, s[4:5]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v2, v3
; GFX11-DL-NEXT:    global_store_b8 v1, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                                      ptr addrspace(1) %src2,
                                                      ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %mul1 = mul nuw nsw i8 %v2e0, %v1e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %mul2 = mul nuw nsw i8 %v2e1, %v1e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %mul3 = mul nuw nsw i8 %v2e2, %v1e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %mul4 = mul nuw nsw i8 %v2e3, %v1e3

  %acc = load i8, ptr addrspace(1) %dst, align 2
  %mad1 = add i8 %acc, %mul1
  %mad2 = add i8 %mul2, %mad1
  %mad3 = add i8 %mul3, %mad2
  %mad4 = add i8 %mul4, %mad3

  store i8 %mad4, ptr addrspace(1) %dst, align 2
  ret void
}

define amdgpu_kernel void @udot4_CommutationAccrossMADs(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_CommutationAccrossMADs:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    buffer_load_ubyte v1, off, s[4:7], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v7, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v7, v4, v1
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v8, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v6, v3, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v8, v5, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v2, v1
; GFX7-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_CommutationAccrossMADs:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ubyte v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v4, v8, v7, v4
; GFX8-NEXT:    v_mad_u16 v2, v2, v3, v4
; GFX8-NEXT:    v_mad_u16 v2, v6, v5, v2
; GFX8-NEXT:    v_mad_u16 v2, v10, v9, v2
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_CommutationAccrossMADs:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 8, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v7, v6, v3
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v2, v1, v3
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v5, v4, v1
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v9, v8, v1
; GFX9-NODL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_CommutationAccrossMADs:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_ubyte v4, v1, s[6:7]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v0, v3, v2, v4
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_CommutationAccrossMADs:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_ubyte v4, v1, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v3, v2, v4
; GFX10-DL-NEXT:    global_store_byte v1, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_CommutationAccrossMADs:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_dual_mov_b32 v1, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_u8 v3, v1, s[4:5]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v2, v3
; GFX11-DL-NEXT:    global_store_b8 v1, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                                        ptr addrspace(1) %src2,
                                                        ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %mul1 = mul nuw nsw i8 %v2e0, %v1e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %mul2 = mul nuw nsw i8 %v2e1, %v1e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %mul3 = mul nuw nsw i8 %v2e2, %v1e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %mul4 = mul nuw nsw i8 %v2e3, %v1e3

  %acc = load i8, ptr addrspace(1) %dst, align 2
  %mad1 = add i8 %acc, %mul2
  %mad2 = add i8 %mad1, %mul1
  %mad3 = add i8 %mad2, %mul3
  %mad4 = add i8 %mad3, %mul4

  store i8 %mad4, ptr addrspace(1) %dst, align 2
  ret void
}

define amdgpu_kernel void @udot4_multiuse_mul1(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_multiuse_mul1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v8, v1, v5, s4
; GFX7-NEXT:    v_mad_u32_u24 v3, v3, v6, v8
; GFX7-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_multiuse_mul1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 8, 8
; GFX8-NEXT:    v_bfe_u32 v6, v3, 16, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX8-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v8, v1, v2, s0
; GFX8-NEXT:    v_mad_u32_u24 v4, v4, v5, v8
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    v_mad_u32_u24 v1, v6, v7, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_multiuse_mul1:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mul_u32_u24_e32 v2, v3, v4
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v3, v3, v4, s0
; GFX9-NODL-NEXT:    v_add3_u32 v2, v5, v3, v2
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_multiuse_mul1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_u32_u24 v3, v3, v4, s0
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_multiuse_mul1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 0xff, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_u32_u24 v0, v0, v3, s0
; GFX10-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v2, v0
; GFX10-DL-NEXT:    global_store_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_multiuse_mul1:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-DL-NEXT:    v_mad_u32_u24 v2, v2, v3, s0
; GFX11-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, v2
; GFX11-DL-NEXT:    global_store_b32 v3, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                               ptr addrspace(1) %src2,
                                               ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add = add i32 %mul1, %acc
  %add1 = add i32 %mul2, %add
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4

  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_multiuse_add1(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_multiuse_add1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v3, v3, v6, s4
; GFX7-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_add_i32_e32 v6, vcc, s4, v3
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_multiuse_add1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_u32 v4, v3, 8, 8
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v6, v3, 16, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v4, v4, v5, s0
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    v_mad_u32_u24 v1, v6, v7, v1
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, s0, v4
; GFX8-NEXT:    v_mad_u32_u24 v0, v3, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v0, v5
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_multiuse_add1:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_bfe_u32 v4, v1, 8, 8
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_bfe_u32 v5, v2, 8, 8
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v4, v5, s0
; GFX9-NODL-NEXT:    v_add_u32_e32 v4, s0, v2
; GFX9-NODL-NEXT:    v_add3_u32 v2, v2, v3, v6
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v1, v4
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_multiuse_add1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    s_add_i32 s1, s0, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mul_u32_u24_sdwa v3, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, s0
; GFX9-DL-NEXT:    v_add3_u32 v1, s1, v3, v1
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_multiuse_add1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mul_u32_u24_sdwa v0, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, s0
; GFX10-DL-NEXT:    s_add_i32 s0, s0, s0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_add3_u32 v0, s0, v0, v1
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_multiuse_add1:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_bfe_u32 v2, v1, 8, 8
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX11-DL-NEXT:    s_add_i32 s0, s0, s0
; GFX11-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-DL-NEXT:    v_mul_u32_u24_e32 v2, v2, v3
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_add3_u32 v0, s0, v2, v0
; GFX11-DL-NEXT:    global_store_b32 v1, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                               ptr addrspace(1) %src2,
                                               ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul2, %acc
  %add = add i32 %add1, %acc
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  %res = add i32 %add4, %add
  store i32 %res, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @notdot4_mixedtypes(ptr addrspace(1) %src1,
; GFX7-LABEL: notdot4_mixedtypes:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v3, v2, 0, 8
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v6, v0, 0, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v8, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v6, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v8, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: notdot4_mixedtypes:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ushort v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v3
; GFX8-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX8-NEXT:    v_bfe_i32 v6, v3, 0, 8
; GFX8-NEXT:    v_and_b32_sdwa v10, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v2
; GFX8-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX8-NEXT:    v_bfe_i32 v7, v2, 0, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v4, v8, v9, v4
; GFX8-NEXT:    v_and_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_mad_u16 v4, v6, v7, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_mad_u16 v4, v10, v5, v4
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: notdot4_mixedtypes:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 8, v2
; GFX9-NODL-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX9-NODL-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX9-NODL-NEXT:    v_bfe_i32 v4, v1, 0, 8
; GFX9-NODL-NEXT:    v_bfe_i32 v5, v2, 0, 8
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v6, v7, v3
; GFX9-NODL-NEXT:    v_and_b32_sdwa v8, v1, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_and_b32_sdwa v9, v2, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v4, v5, v3
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v8, v9, v3
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-NODL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: notdot4_mixedtypes:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_mov_b32 s0, 0xc0c0302
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 8, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 8, v2
; GFX9-DL-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX9-DL-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX9-DL-NEXT:    v_bfe_i32 v4, v1, 0, 8
; GFX9-DL-NEXT:    v_bfe_i32 v5, v2, 0, 8
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v6, v7, v3
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s0
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v4, v5, v3
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s0
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, v3
; GFX9-DL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: notdot4_mixedtypes:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 8, v2
; GFX10-DL-NEXT:    v_bfe_i32 v6, v1, 0, 8
; GFX10-DL-NEXT:    v_bfe_i32 v7, v2, 0, 8
; GFX10-DL-NEXT:    v_perm_b32 v2, v2, v2, 0xc0c0302
; GFX10-DL-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX10-DL-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX10-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0302
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v3, v4, v5, v3
; GFX10-DL-NEXT:    v_mad_u16 v3, v6, v7, v3
; GFX10-DL-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, v3
; GFX10-DL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-TRUE16-LABEL: notdot4_mixedtypes:
; GFX11-DL-TRUE16:       ; %bb.0: ; %entry
; GFX11-DL-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-TRUE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-TRUE16-NEXT:    v_mov_b32_e32 v6, 0
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-TRUE16-NEXT:    s_clause 0x1
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v4, v0, s[0:1]
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v5, v0, s[2:3]
; GFX11-DL-TRUE16-NEXT:    global_load_d16_b16 v0, v6, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(2)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v4
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v2, 8, v5
; GFX11-DL-TRUE16-NEXT:    v_bfe_i32 v3, v4, 0, 8
; GFX11-DL-TRUE16-NEXT:    v_bfe_i32 v7, v5, 0, 8
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v1.l
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v2.l
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v3.l
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v7.l
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v0.h, v1.l, v0.l
; GFX11-DL-TRUE16-NEXT:    v_perm_b32 v1, v5, v5, 0xc0c0302
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v2.l, v3.l, v0.l
; GFX11-DL-TRUE16-NEXT:    v_perm_b32 v2, v4, v4, 0xc0c0302
; GFX11-DL-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_dot4_u32_u8 v0, v2, v1, v0
; GFX11-DL-TRUE16-NEXT:    global_store_b16 v6, v0, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_endpgm
;
; GFX11-DL-FAKE16-LABEL: notdot4_mixedtypes:
; GFX11-DL-FAKE16:       ; %bb.0: ; %entry
; GFX11-DL-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-FAKE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-FAKE16-NEXT:    s_clause 0x1
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX11-DL-FAKE16-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-FAKE16-NEXT:    v_bfe_i32 v6, v1, 0, 8
; GFX11-DL-FAKE16-NEXT:    v_bfe_i32 v7, v0, 0, 8
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-DL-FAKE16-NEXT:    global_load_u16 v3, v2, s[4:5]
; GFX11-DL-FAKE16-NEXT:    v_perm_b32 v0, v0, v0, 0xc0c0302
; GFX11-DL-FAKE16-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0302
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v3, v4, v5, v3
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v3, v6, v7, v3
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_dot4_u32_u8 v0, v1, v0, v3
; GFX11-DL-FAKE16-NEXT:    global_store_b16 v2, v0, s[4:5]
; GFX11-DL-FAKE16-NEXT:    s_endpgm
                                              ptr addrspace(1) %src2,
                                              ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = sext i8 %v1e0 to i16
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = sext i8 %v2e0 to i16
  %mul1 = mul nuw nsw i16 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i16
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i16
  %mul2 = mul nuw nsw i16 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i16
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i16
  %mul3 = mul nuw nsw i16 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i16
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i16
  %mul4 = mul nuw nsw i16 %cv1e3, %cv2e3

  %acc = load i16, ptr addrspace(1) %dst, align 2
  %add1 = add i16 %mul2, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul3
  %add4 = add i16 %add3, %mul4

  store i16 %add4, ptr addrspace(1) %dst, align 2
  ret void
}


define amdgpu_kernel void @notdot4_mixedtypes2(ptr addrspace(1) %src1,
; GFX7-LABEL: notdot4_mixedtypes2:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v3, v2, 0, 8
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v7, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX7-NEXT:    v_bfe_i32 v5, v2, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX7-NEXT:    v_bfe_u32 v8, v0, 16, 8
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v6, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v8, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: notdot4_mixedtypes2:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ushort v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v3
; GFX8-NEXT:    v_and_b32_e32 v9, 0xff, v9
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v3
; GFX8-NEXT:    v_bfe_i32 v7, v3, 0, 8
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v2
; GFX8-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX8-NEXT:    v_and_b32_e32 v8, 0xff, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v4, v9, v10, v4
; GFX8-NEXT:    v_and_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_mad_u16 v4, v7, v8, v4
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX8-NEXT:    v_mad_u16 v4, v6, v5, v4
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: notdot4_mixedtypes2:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX9-NODL-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX9-NODL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX9-NODL-NEXT:    v_bfe_i32 v5, v1, 0, 8
; GFX9-NODL-NEXT:    v_and_b32_e32 v6, 0xff, v2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v7, v8, v3
; GFX9-NODL-NEXT:    v_and_b32_sdwa v9, v2, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX9-NODL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v5, v6, v3
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX9-NODL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v3, v4, v9, v3
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-NODL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: notdot4_mixedtypes2:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_movk_i32 s0, 0xff
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 8, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX9-DL-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX9-DL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX9-DL-NEXT:    v_bfe_i32 v5, v1, 0, 8
; GFX9-DL-NEXT:    v_and_b32_e32 v6, 0xff, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v7, v8, v3
; GFX9-DL-NEXT:    v_and_b32_sdwa v9, v2, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX9-DL-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v5, v6, v3
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX9-DL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX9-DL-NEXT:    v_mad_legacy_u16 v3, v4, v9, v3
; GFX9-DL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-DL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: notdot4_mixedtypes2:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v8, 0xff
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 8, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX10-DL-NEXT:    v_bfe_i32 v7, v1, 0, 8
; GFX10-DL-NEXT:    v_and_b32_e32 v9, 0xff, v2
; GFX10-DL-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX10-DL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v3, v4, v5, v3
; GFX10-DL-NEXT:    v_bfe_i32 v4, v6, 0, 8
; GFX10-DL-NEXT:    v_and_b32_sdwa v5, v2, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX10-DL-NEXT:    v_mad_u16 v3, v7, v9, v3
; GFX10-DL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-DL-NEXT:    v_mad_u16 v3, v4, v5, v3
; GFX10-DL-NEXT:    v_mad_u16 v1, v1, v2, v3
; GFX10-DL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-TRUE16-LABEL: notdot4_mixedtypes2:
; GFX11-DL-TRUE16:       ; %bb.0: ; %entry
; GFX11-DL-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-TRUE16-NEXT:    v_dual_mov_b32 v5, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-TRUE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-TRUE16-NEXT:    s_clause 0x1
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v3, v0, s[2:3]
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v4, v0, s[0:1]
; GFX11-DL-TRUE16-NEXT:    global_load_d16_b16 v0, v5, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(2)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v3
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v2, 8, v4
; GFX11-DL-TRUE16-NEXT:    v_bfe_i32 v6, v4, 0, 8
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.h
; GFX11-DL-TRUE16-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v2.l
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v3.l
; GFX11-DL-TRUE16-NEXT:    v_bfe_i32 v7, v7, 0, 8
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v6.l
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v0.h, v1.l, v0.l
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v3.h
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v7.l
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v3, 24, v4
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v2.l, v1.h, v0.l
; GFX11-DL-TRUE16-NEXT:    v_bfe_i32 v2, v6, 0, 8
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v1.l, v0.h, v0.l
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v3.l, v1.l, v0.l
; GFX11-DL-TRUE16-NEXT:    global_store_b16 v5, v0, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_endpgm
;
; GFX11-DL-FAKE16-LABEL: notdot4_mixedtypes2:
; GFX11-DL-FAKE16:       ; %bb.0: ; %entry
; GFX11-DL-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-FAKE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-FAKE16-NEXT:    s_clause 0x1
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-FAKE16-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 8, v1
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v9, 0xff, v0
; GFX11-DL-FAKE16-NEXT:    global_load_u16 v3, v2, s[4:5]
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v0
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX11-DL-FAKE16-NEXT:    v_bfe_i32 v8, v1, 0, 8
; GFX11-DL-FAKE16-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-DL-FAKE16-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v3, v4, v5, v3
; GFX11-DL-FAKE16-NEXT:    v_bfe_i32 v4, v6, 0, 8
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v7
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v3, v8, v9, v3
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v3, v4, v5, v3
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v0, v1, v0, v3
; GFX11-DL-FAKE16-NEXT:    global_store_b16 v2, v0, s[4:5]
; GFX11-DL-FAKE16-NEXT:    s_endpgm
                                              ptr addrspace(1) %src2,
                                              ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = sext i8 %v1e0 to i16
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i16
  %mul1 = mul nuw nsw i16 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i16
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = sext i8 %v2e1 to i16
  %mul2 = mul nuw nsw i16 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = sext i8 %v1e2 to i16
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i16
  %mul3 = mul nuw nsw i16 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i16
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = sext i8 %v2e3 to i16
  %mul4 = mul nuw nsw i16 %cv1e3, %cv2e3

  %acc = load i16, ptr addrspace(1) %dst, align 2
  %add1 = add i16 %mul2, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul3
  %add4 = add i16 %add3, %mul4

  store i16 %add4, ptr addrspace(1) %dst, align 2
  ret void
}

; TODO: cleanup s_lshr_b32
define amdgpu_kernel void @udot4_acc32_vecMul(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc32_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, s4
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v6, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v4, v7, v0
; GFX7-NEXT:    v_mad_u32_u24 v0, v1, v5, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc32_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 16, 8
; GFX8-NEXT:    v_lshrrev_b16_e32 v5, 8, v3
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_bfe_u32 v6, v0, 16, 8
; GFX8-NEXT:    v_lshrrev_b16_e32 v7, 8, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v0, v3, v0, s0
; GFX8-NEXT:    v_mad_u32_u24 v0, v5, v7, v0
; GFX8-NEXT:    v_mad_u32_u24 v0, v4, v6, v0
; GFX8-NEXT:    v_mad_u32_u24 v2, v1, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc32_vecMul:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v4, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v2, v3, s0, v4
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v5, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc32_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc32_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, s0
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc32_vecMul:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                              ptr addrspace(1) %src2,
                                              ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %cvec1 = zext <4 x i8> %vec1 to <4 x i32>
  %cvec2 = zext <4 x i8> %vec2 to <4 x i32>

  %mul = mul <4 x i32> %cvec1, %cvec2
  %mul0 = extractelement <4 x i32> %mul, i64 0
  %mul1 = extractelement <4 x i32> %mul, i64 1
  %mul2 = extractelement <4 x i32> %mul, i64 2
  %mul3 = extractelement <4 x i32> %mul, i64 3

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul0, %acc
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3

  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

; TODO: This pattern should be recognized.
define amdgpu_kernel void @udot4_acc16_vecMul(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc16_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[4:5], s[10:11]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v1, off, s[0:3], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v7, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_alignbit_b32 v0, v6, v0, 16
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v7, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v3, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v6, v5, v0
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc16_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    v_mov_b32_e32 v5, 0xff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ushort v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v3
; GFX8-NEXT:    v_lshrrev_b16_e32 v7, 8, v3
; GFX8-NEXT:    v_and_b32_sdwa v10, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v2
; GFX8-NEXT:    v_lshrrev_b16_e32 v9, 8, v2
; GFX8-NEXT:    v_and_b32_sdwa v5, v2, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    v_mad_u16 v2, v7, v9, v2
; GFX8-NEXT:    v_mad_u16 v2, v10, v5, v2
; GFX8-NEXT:    v_mad_u16 v2, v6, v8, v2
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc16_vecMul:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NODL-NEXT:    s_mov_b32 s1, 0x5040100
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b16_e32 v4, 8, v1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b16_e32 v6, 8, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX9-NODL-NEXT:    v_and_b32_e32 v8, 0xff, v1
; GFX9-NODL-NEXT:    v_and_b32_sdwa v1, v1, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_and_b32_e32 v9, 0xff, v2
; GFX9-NODL-NEXT:    v_and_b32_sdwa v2, v2, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_perm_b32 v2, v7, v2, s1
; GFX9-NODL-NEXT:    v_perm_b32 v1, v5, v1, s1
; GFX9-NODL-NEXT:    v_perm_b32 v5, v6, v9, s1
; GFX9-NODL-NEXT:    v_perm_b32 v4, v4, v8, s1
; GFX9-NODL-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-NODL-NEXT:    v_pk_mul_lo_u16 v2, v4, v5
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_add_u16_e32 v3, v2, v3
; GFX9-NODL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NODL-NEXT:    v_add_u16_e32 v2, v2, v1
; GFX9-NODL-NEXT:    v_add_u16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NODL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc16_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_movk_i32 s0, 0xff
; GFX9-DL-NEXT:    s_mov_b32 s1, 0x5040100
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b16_e32 v4, 8, v1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b16_e32 v6, 8, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX9-DL-NEXT:    v_and_b32_e32 v8, 0xff, v1
; GFX9-DL-NEXT:    v_and_b32_sdwa v1, v1, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-DL-NEXT:    v_and_b32_e32 v9, 0xff, v2
; GFX9-DL-NEXT:    v_and_b32_sdwa v2, v2, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-DL-NEXT:    v_perm_b32 v2, v7, v2, s1
; GFX9-DL-NEXT:    v_perm_b32 v1, v5, v1, s1
; GFX9-DL-NEXT:    v_perm_b32 v5, v6, v9, s1
; GFX9-DL-NEXT:    v_perm_b32 v4, v4, v8, s1
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v2, v4, v5
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_add_u16_e32 v3, v2, v3
; GFX9-DL-NEXT:    v_add_u16_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v2, v2, v1
; GFX9-DL-NEXT:    v_add_u16_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc16_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v8, 0xff
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ushort v3, v0, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_lshrrev_b16 v4, 8, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b16 v5, 8, v2
; GFX10-DL-NEXT:    v_and_b32_e32 v6, 0xff, v2
; GFX10-DL-NEXT:    v_and_b32_e32 v7, 0xff, v1
; GFX10-DL-NEXT:    v_perm_b32 v5, v5, v6, 0x5040100
; GFX10-DL-NEXT:    v_perm_b32 v4, v4, v7, 0x5040100
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX10-DL-NEXT:    v_and_b32_sdwa v2, v2, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-DL-NEXT:    v_and_b32_sdwa v1, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v4, v4, v5
; GFX10-DL-NEXT:    v_perm_b32 v2, v7, v2, 0x5040100
; GFX10-DL-NEXT:    v_perm_b32 v1, v6, v1, 0x5040100
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_add_nc_u16 v3, v4, v3
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX10-DL-NEXT:    v_add_nc_u16 v2, v3, v5
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v2, v1
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-DL-NEXT:    global_store_short v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-TRUE16-LABEL: udot4_acc16_vecMul:
; GFX11-DL-TRUE16:       ; %bb.0: ; %entry
; GFX11-DL-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-TRUE16-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-TRUE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-TRUE16-NEXT:    s_clause 0x1
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v2, v0, s[2:3]
; GFX11-DL-TRUE16-NEXT:    global_load_d16_b16 v0, v3, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(2)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b16 v4.h, 8, v1.l
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b16 v5.h, 8, v2.l
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v1.l
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v2.l
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.h
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.h
; GFX11-DL-TRUE16-NEXT:    v_pk_mul_lo_u16 v4, v4, v5
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v2.h, v6.l
; GFX11-DL-TRUE16-NEXT:    v_mov_b16_e32 v1.h, v7.l
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-DL-TRUE16-NEXT:    v_add_nc_u16 v0.l, v4.l, v0.l
; GFX11-DL-TRUE16-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v4.h
; GFX11-DL-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.h
; GFX11-DL-TRUE16-NEXT:    global_store_b16 v3, v0, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_endpgm
;
; GFX11-DL-FAKE16-LABEL: udot4_acc16_vecMul:
; GFX11-DL-FAKE16:       ; %bb.0: ; %entry
; GFX11-DL-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-FAKE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-FAKE16-NEXT:    s_clause 0x1
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-FAKE16-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_and_b32 v7, 0xff, v1
; GFX11-DL-FAKE16-NEXT:    global_load_u16 v3, v2, s[4:5]
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b16 v4, 8, v1
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b16 v5, 8, v0
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v0
; GFX11-DL-FAKE16-NEXT:    v_perm_b32 v4, v4, v7, 0x5040100
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX11-DL-FAKE16-NEXT:    v_perm_b32 v5, v5, v6, 0x5040100
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v9
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v8
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-DL-FAKE16-NEXT:    v_pk_mul_lo_u16 v4, v4, v5
; GFX11-DL-FAKE16-NEXT:    v_perm_b32 v0, v0, v6, 0x5040100
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-DL-FAKE16-NEXT:    v_perm_b32 v1, v1, v7, 0x5040100
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_pk_mul_lo_u16 v0, v1, v0
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-FAKE16-NEXT:    v_add_nc_u16 v3, v4, v3
; GFX11-DL-FAKE16-NEXT:    v_add_nc_u16 v1, v3, v5
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-DL-FAKE16-NEXT:    v_add_nc_u16 v0, v1, v0
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v3
; GFX11-DL-FAKE16-NEXT:    global_store_b16 v2, v0, s[4:5]
; GFX11-DL-FAKE16-NEXT:    s_endpgm
                                              ptr addrspace(1) %src2,
                                              ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %cvec1 = zext <4 x i8> %vec1 to <4 x i16>
  %cvec2 = zext <4 x i8> %vec2 to <4 x i16>

  %mul = mul <4 x i16> %cvec1, %cvec2
  %mul0 = extractelement <4 x i16> %mul, i64 0
  %mul1 = extractelement <4 x i16> %mul, i64 1
  %mul2 = extractelement <4 x i16> %mul, i64 2
  %mul3 = extractelement <4 x i16> %mul, i64 3

  %acc = load i16, ptr addrspace(1) %dst, align 4
  %add1 = add i16 %mul0, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul2
  %add4 = add i16 %add3, %mul3

  store i16 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

; TODO: Support this pattern.
define amdgpu_kernel void @udot4_acc8_vecMul(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc8_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    buffer_load_ubyte v1, off, s[4:7], 0
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v5, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v7, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v8, v0, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v8, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v6, v0
; GFX7-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc8_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_load_ubyte v4, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-NEXT:    v_mul_lo_u16_sdwa v7, v3, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX8-NEXT:    v_mul_lo_u16_e32 v9, v5, v6
; GFX8-NEXT:    v_or_b32_sdwa v7, v9, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_mul_lo_u16_sdwa v8, v3, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX8-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v2, v3, v2, v4
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v8
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v7
; GFX8-NEXT:    v_mad_u16 v2, v5, v6, v2
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v7
; GFX8-NEXT:    flat_store_byte v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc8_vecMul:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-NODL-NEXT:    v_mul_lo_u16_sdwa v6, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mul_lo_u16_e32 v7, v4, v5
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v8, 8, v6
; GFX9-NODL-NEXT:    v_or_b32_sdwa v6, v7, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NODL-NEXT:    v_mul_lo_u16_sdwa v6, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PRESERVE src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 8, v6
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-NODL-NEXT:    v_add_u16_e32 v1, v1, v6
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v1, v4, v5, v1
; GFX9-NODL-NEXT:    v_add_u16_e32 v1, v1, v8
; GFX9-NODL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc8_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v6, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_mul_lo_u16_e32 v7, v4, v5
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v6
; GFX9-DL-NEXT:    v_or_b32_sdwa v6, v7, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-DL-NEXT:    v_mul_lo_u16_sdwa v6, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PRESERVE src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 8, v6
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v1, v1, v2, v3
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v1, v6
; GFX9-DL-NEXT:    v_mad_legacy_u16 v1, v4, v5, v1
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v1, v8
; GFX9-DL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc8_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ubyte v3, v0, s[6:7]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 24, v2
; GFX10-DL-NEXT:    v_lshrrev_b16 v6, 8, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX10-DL-NEXT:    v_lshrrev_b16 v9, 8, v2
; GFX10-DL-NEXT:    v_mul_lo_u16 v4, v4, v5
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v1, v1, v2, v3
; GFX10-DL-NEXT:    v_mul_lo_u16 v5, v7, v8
; GFX10-DL-NEXT:    v_mul_lo_u16 v6, v6, v9
; GFX10-DL-NEXT:    v_lshlrev_b16 v4, 8, v4
; GFX10-DL-NEXT:    v_lshlrev_b16 v6, 8, v6
; GFX10-DL-NEXT:    v_or_b32_sdwa v5, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 8, v4
; GFX10-DL-NEXT:    v_or_b32_sdwa v5, v6, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 8, v5
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX10-DL-NEXT:    v_mad_u16 v1, v7, v8, v1
; GFX10-DL-NEXT:    v_add_nc_u16 v1, v1, v2
; GFX10-DL-NEXT:    global_store_byte v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-TRUE16-LABEL: udot4_acc8_vecMul:
; GFX11-DL-TRUE16:       ; %bb.0: ; %entry
; GFX11-DL-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-TRUE16-NEXT:    v_dual_mov_b32 v5, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-TRUE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-TRUE16-NEXT:    s_clause 0x1
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v3, v0, s[0:1]
; GFX11-DL-TRUE16-NEXT:    global_load_b32 v4, v0, s[2:3]
; GFX11-DL-TRUE16-NEXT:    global_load_d16_u8 v0, v5, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(2)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v6, 24, v4
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b16 v0.h, 8, v3.l
; GFX11-DL-TRUE16-NEXT:    v_mul_lo_u16 v1.l, v3.h, v4.h
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b16 v1.h, 8, v4.l
; GFX11-DL-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v3.l, v4.l, v0.l
; GFX11-DL-TRUE16-NEXT:    v_mul_lo_u16 v2.l, v2.l, v6.l
; GFX11-DL-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-DL-TRUE16-NEXT:    v_mul_lo_u16 v0.h, v0.h, v1.h
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-DL-TRUE16-NEXT:    v_lshlrev_b16 v6.l, 8, v2.l
; GFX11-DL-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v0.h
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-DL-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v6.l
; GFX11-DL-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-DL-TRUE16-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-DL-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-DL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v6
; GFX11-DL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-TRUE16-NEXT:    v_mad_u16 v0.l, v3.h, v4.h, v0.l
; GFX11-DL-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-DL-TRUE16-NEXT:    global_store_b8 v5, v0, s[4:5]
; GFX11-DL-TRUE16-NEXT:    s_endpgm
;
; GFX11-DL-FAKE16-LABEL: udot4_acc8_vecMul:
; GFX11-DL-FAKE16:       ; %bb.0: ; %entry
; GFX11-DL-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-FAKE16-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-FAKE16-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-FAKE16-NEXT:    s_clause 0x1
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-FAKE16-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-FAKE16-NEXT:    global_load_u8 v3, v2, s[4:5]
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(2)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v1
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b16 v8, 8, v1
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b16 v9, 8, v0
; GFX11-DL-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v0, v1, v0, v3
; GFX11-DL-FAKE16-NEXT:    v_mul_lo_u16 v5, v5, v6
; GFX11-DL-FAKE16-NEXT:    v_mul_lo_u16 v6, v4, v7
; GFX11-DL-FAKE16-NEXT:    v_mul_lo_u16 v8, v8, v9
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-DL-FAKE16-NEXT:    v_lshlrev_b16 v5, 8, v5
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-DL-FAKE16-NEXT:    v_lshlrev_b16 v8, 8, v8
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v5
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-DL-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v5
; GFX11-DL-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-DL-FAKE16-NEXT:    v_or_b32_e32 v6, v8, v6
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 8, v6
; GFX11-DL-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v6
; GFX11-DL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-DL-FAKE16-NEXT:    v_mad_u16 v0, v4, v7, v0
; GFX11-DL-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-DL-FAKE16-NEXT:    global_store_b8 v2, v0, s[4:5]
; GFX11-DL-FAKE16-NEXT:    s_endpgm
                                             ptr addrspace(1) %src2,
                                             ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %mul = mul <4 x i8> %vec1, %vec2
  %mul0 = extractelement <4 x i8> %mul, i64 0
  %mul1 = extractelement <4 x i8> %mul, i64 1
  %mul2 = extractelement <4 x i8> %mul, i64 2
  %mul3 = extractelement <4 x i8> %mul, i64 3

  %acc = load i8, ptr addrspace(1) %dst, align 4
  %add1 = add i8 %mul0, %acc
  %add2 = add i8 %add1, %mul1
  %add3 = add i8 %add2, %mul2
  %add4 = add i8 %add3, %mul3

  store i8 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_2ele(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_2ele:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v3, s0
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_2ele:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v3, v3, 8, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX8-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, s0
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_2ele:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v3, s0, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_2ele:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    s_mov_b32 s1, 0xc0c0100
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_2ele:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v1, v1, 0xc0c0100
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v2, v2, 0xc0c0100
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_2ele:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0100
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc0c0100
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul1, %acc
  %add2 = add i32 %add1, %mul2
  store i32 %add2, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_3ele(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_3ele:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v4, s0
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v5, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_3ele:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 8, 8
; GFX8-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX8-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, s0
; GFX8-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v4, v5, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_3ele:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, v4, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v5, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_3ele:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    s_mov_b32 s1, 0xc020100
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_3ele:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v1, v1, 0xc020100
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v2, v2, 0xc020100
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_3ele:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc020100
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc020100
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul1, %acc
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  store i32 %add3, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_3ele_permuted(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_3ele_permuted:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v4, s0
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v5, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_3ele_permuted:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_and_b32_e32 v4, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX8-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, s0
; GFX8-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v4, v5, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_3ele_permuted:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, v4, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v5, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_3ele_permuted:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    s_mov_b32 s1, 0xc020003
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_3ele_permuted:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v1, v1, 0xc020003
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v2, v2, 0xc020003
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_3ele_permuted:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc020003
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc020003
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 3
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 3
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 0
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 0
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul1, %acc
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  store i32 %add3, ptr addrspace(1) %dst, align 4
  ret void
}


define amdgpu_kernel void @idot4_acc32_opt(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_opt:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX7-NEXT:    v_mul_u32_u24_e32 v3, v3, v6
; GFX7-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_opt:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v7, v3, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v5, 0xff, v2
; GFX8-NEXT:    v_mul_u32_u24_sdwa v6, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v4, v4, v5, v6
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_mad_u32_u24 v4, v7, v8, v4
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v2, v4
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_opt:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, v4, v5
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_opt:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, 0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_opt:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, 0
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_opt:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, 0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %add2 = add i32 %mul1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_acc32_3src(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc32_3src:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b32 s14, 0
; GFX7-NEXT:    s_mov_b32 s15, s11
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[12:13], s[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[12:13], s[2:3]
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[12:13], s[4:5]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v3, v3, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v1, s0
; GFX7-NEXT:    v_bfe_u32 v5, v2, 16, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v6, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v3, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v6, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc32_3src:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v1, s0
; GFX8-NEXT:    v_bfe_u32 v5, v3, 16, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_u32 v4, v4, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v2, v4, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_u32 v6, v0, 16, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    v_mad_u32_u24 v1, v5, v6, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc32_3src:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[8:9]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[10:11]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[12:13]
; GFX9-NODL-NEXT:    s_load_dword s0, s[14:15], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v4, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v2, v4, s0, v2
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v5, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[14:15]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc32_3src:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_mov_b32 s0, 0x706010c
; GFX9-DL-NEXT:    s_mov_b32 s2, 0xc0c0c00
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[10:11]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[12:13]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[8:9]
; GFX9-DL-NEXT:    s_load_dword s1, s[14:15], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v2, v1, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v3, v3, s2
; GFX9-DL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v3, v1, s1
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[14:15]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc32_3src:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x2
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[10:11]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[12:13]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[8:9]
; GFX10-DL-NEXT:    s_load_dword s0, s[14:15], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v2, v1, 0x706010c
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v3, v3, 0xc0c0c00
; GFX10-DL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v3, v0, s0
; GFX10-DL-NEXT:    global_store_dword v1, v0, s[14:15]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc32_3src:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x2
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-DL-NEXT:    s_load_b32 s0, s[6:7], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v2, v1, 0x706010c
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v2, v0, v0, 0xc0c0c00
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-DL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[6:7]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) %src3,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2
  %gep3 = getelementptr <4 x i8>, ptr addrspace(1) %src3, i32 %idx
  %vec3 = load <4 x i8>, ptr addrspace(1) %gep3

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv1e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v3e2 = extractelement <4 x i8> %vec3, i64 2
  %cv3e2 = zext i8 %v3e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv3e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v3e3 = extractelement <4 x i8> %vec3, i64 3
  %cv3e3 = zext i8 %v3e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv3e3

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad1 = add i32 %mul1, %acc
  %mad2 = add i32 %mad1, %mul2
  %mad3 = add i32 %mad2, %mul3
  %mad4 = add i32 %mad3, %mul4

  store i32 %mad4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_acc32_3src_3ele(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc32_3src_3ele:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b32 s14, 0
; GFX7-NEXT:    s_mov_b32 s15, s11
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[12:13], s[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[12:13], s[2:3]
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[12:13], s[4:5]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v3, v3, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v1, s0
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v3, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc32_3src_3ele:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v1, s0
; GFX8-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_u32 v4, v4, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v2, v4, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc32_3src_3ele:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[8:9]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[10:11]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[12:13]
; GFX9-NODL-NEXT:    s_load_dword s0, s[14:15], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v2, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v3, v4, v4, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v3, v2, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[14:15]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc32_3src_3ele:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_mov_b32 s0, 0xc06010c
; GFX9-DL-NEXT:    s_mov_b32 s1, 0xc0c0c00
; GFX9-DL-NEXT:    s_mov_b32 s2, 0xc020100
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[10:11]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[12:13]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[8:9]
; GFX9-DL-NEXT:    s_load_dword s3, s[14:15], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v2, v1, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v3, v3, s1
; GFX9-DL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-DL-NEXT:    v_perm_b32 v2, v3, v3, s2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, s3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[14:15]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc32_3src_3ele:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x2
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[10:11]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[12:13]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[8:9]
; GFX10-DL-NEXT:    s_load_dword s0, s[14:15], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v2, v1, 0xc06010c
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v3, v3, 0xc0c0c00
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX10-DL-NEXT:    v_perm_b32 v1, v3, v3, 0xc020100
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[14:15]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc32_3src_3ele:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x2
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-DL-NEXT:    s_load_b32 s0, s[6:7], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v2, v1, 0xc06010c
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v2, v0, v0, 0xc0c0c00
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc020100
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-DL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[6:7]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) %src3,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2
  %gep3 = getelementptr <4 x i8>, ptr addrspace(1) %src3, i32 %idx
  %vec3 = load <4 x i8>, ptr addrspace(1) %gep3

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv1e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v3e2 = extractelement <4 x i8> %vec3, i64 2
  %cv3e2 = zext i8 %v3e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv3e2


  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad1 = add i32 %mul1, %acc
  %mad2 = add i32 %mad1, %mul2
  %mad3 = add i32 %mad2, %mul3

  store i32 %mad3, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_bad_source(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_bad_source:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dword s12, s[4:5], 0xf
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x11
; GFX7-NEXT:    s_and_b32 s1, s12, 0xffff
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, s1, v1
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v5, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_bad_source:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dword s6, s[4:5], 0x3c
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX8-NEXT:    s_and_b32 s3, s6, 0xffff
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v2, s3, v1
; GFX8-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX8-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v4, v5, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_bad_source:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dword s6, s[4:5], 0x3c
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX9-NODL-NEXT:    s_and_b32 s3, s6, 0xffff
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v4, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, s3, v2
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v4, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_bad_source:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dword s6, s[4:5], 0x3c
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX9-DL-NEXT:    s_mov_b32 s3, 0xc0c0201
; GFX9-DL-NEXT:    s_and_b32 s4, s6, 0xffff
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_and_b32_e32 v4, 0xff, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s3
; GFX9-DL-NEXT:    v_mad_u32_u24 v3, v4, s4, v3
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s3
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, v3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_bad_source:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dword s6, s[4:5], 0x3c
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX10-DL-NEXT:    s_and_b32 s3, s6, 0xffff
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_and_b32_e32 v0, 0xff, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v2, v2, v2, 0xc0c0201
; GFX10-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0201
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_u32_u24 v0, v0, s3, s2
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v2, v0
; GFX10-DL-NEXT:    global_store_dword v3, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_bad_source:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    s_load_b32 s6, s[4:5], 0x3c
; GFX11-DL-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x44
; GFX11-DL-NEXT:    s_and_b32 s3, s6, 0xffff
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc0c0201
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0201
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    v_mad_u32_u24 v2, v2, s3, s2
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, v2
; GFX11-DL-NEXT:    global_store_b32 v3, v0, s[0:1]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) %src3,
                                       i16 %badsource,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2
  %gep3 = getelementptr <4 x i8>, ptr addrspace(1) %src3, i32 %idx
  %vec3 = load <4 x i8>, ptr addrspace(1) %gep3

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %other = zext i16 %badsource to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %other

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2


  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad1 = add i32 %mul1, %acc
  %mad2 = add i32 %mad1, %mul2
  %mad3 = add i32 %mad2, %mul3

  store i32 %mad3, ptr addrspace(1) %dst, align 4
  ret void
}


define amdgpu_kernel void @udot4_commutative(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_commutative:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xf
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v4, s0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v5, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_commutative:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x3c
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v4, v3, 8, 8
; GFX8-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX8-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, s0
; GFX8-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v4, v5, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_commutative:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x3c
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, v4, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v5, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_commutative:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x3c
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    s_mov_b32 s1, 0xc020100
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_commutative:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x3c
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v1, v1, 0xc020100
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v2, v2, 0xc020100
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_commutative:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x3c
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc020100
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc020100
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) %src3,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2
  %gep3 = getelementptr <4 x i8>, ptr addrspace(1) %src3, i32 %idx
  %vec3 = load <4 x i8>, ptr addrspace(1) %gep3

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2


  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad1 = add i32 %mul1, %acc
  %mad2 = add i32 %mad1, %mul2
  %mad3 = add i32 %mad2, %mul3

  store i32 %mad3, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_acc32_3src_3ele_src0(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc32_3src_3ele_src0:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; GFX7-NEXT:    s_mov_b32 s11, 0xf000
; GFX7-NEXT:    s_mov_b32 s14, 0
; GFX7-NEXT:    s_mov_b32 s15, s11
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[12:13], s[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[12:13], s[2:3]
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[12:13], s[4:5]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[12:15], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX7-NEXT:    s_mov_b32 s10, -1
; GFX7-NEXT:    s_mov_b32 s8, s6
; GFX7-NEXT:    s_mov_b32 s9, s7
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_u32 v1, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v4, v2, v2, s0
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v2, v4
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[8:11], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc32_3src_3ele_src0:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_u32 v1, v4, 8, 8
; GFX8-NEXT:    v_bfe_u32 v3, v4, 16, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v4, v1, v1, s0
; GFX8-NEXT:    v_mad_u32_u24 v1, v2, v1, v4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc32_3src_3ele_src0:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[10:11]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[12:13]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[8:9]
; GFX9-NODL-NEXT:    s_load_dword s0, s[14:15], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_bfe_u32 v4, v1, 8, 8
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v2, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_u32_u24 v3, v4, v4, s0
; GFX9-NODL-NEXT:    v_add3_u32 v1, v3, v2, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[14:15]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc32_3src_3ele_src0:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_mov_b32 s0, 0xc06010c
; GFX9-DL-NEXT:    s_mov_b32 s1, 0xc0c0c01
; GFX9-DL-NEXT:    s_mov_b32 s2, 0xc020101
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[8:9]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[12:13]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[10:11]
; GFX9-DL-NEXT:    s_load_dword s3, s[14:15], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v2, v1, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v3, v3, s1
; GFX9-DL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-DL-NEXT:    v_perm_b32 v2, v3, v3, s2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, s3
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[14:15]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc32_3src_3ele_src0:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x2
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[8:9]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[12:13]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[10:11]
; GFX10-DL-NEXT:    s_load_dword s0, s[14:15], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v2, v1, 0xc06010c
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v3, v3, 0xc0c0c01
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX10-DL-NEXT:    v_perm_b32 v1, v3, v3, 0xc020101
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[14:15]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc32_3src_3ele_src0:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b256 s[0:7], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x2
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_load_b32 s0, s[6:7], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v2, v1, 0xc06010c
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v2, v0, v0, 0xc0c0c01
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0xc020101
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-DL-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[6:7]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) %src3,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2
  %gep3 = getelementptr <4 x i8>, ptr addrspace(1) %src3, i32 %idx
  %vec3 = load <4 x i8>, ptr addrspace(1) %gep3

  %v2e0 = extractelement <4 x i8> %vec2, i64 1
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv2e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v3e2 = extractelement <4 x i8> %vec3, i64 2
  %cv3e2 = zext i8 %v3e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv2e2, %cv3e2


  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad1 = add i32 %mul1, %acc
  %mad2 = add i32 %mad1, %mul2
  %mad3 = add i32 %mad2, %mul3

  store i32 %mad3, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_4src(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_4src:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x9
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s18, 0
; GFX7-NEXT:    s_mov_b32 s19, s3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[16:17], s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[16:17], s[10:11]
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[16:17], s[12:13]
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[16:17], s[14:15]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[16:19], 0 addr64
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x11
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt vmcnt(3)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v5, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v2, s4
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v4
; GFX7-NEXT:    v_bfe_u32 v4, v4, 8, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v3, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v2, v4, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_4src:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s9
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s8, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s11
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s10, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s13
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s12, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s15
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s14, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(3)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v2, s2
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX8-NEXT:    v_bfe_u32 v4, v4, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v3, v4, v1
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v6, 0xff, v5
; GFX8-NEXT:    v_bfe_u32 v5, v5, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v1, v6, v5, v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v7, 0xff, v0
; GFX8-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v2, v7, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_4src:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[8:9]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[10:11]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[12:13]
; GFX9-NODL-NEXT:    global_load_dword v4, v0, s[14:15]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v2, v2, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v3, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v4, v4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, s2, v2
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, v3, v4
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_4src:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX9-DL-NEXT:    s_mov_b32 s2, 0xc0c0501
; GFX9-DL-NEXT:    s_mov_b32 s3, 0x5010c0c
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[8:9]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[10:11]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[12:13]
; GFX9-DL-NEXT:    global_load_dword v4, v0, s[14:15]
; GFX9-DL-NEXT:    s_mov_b32 s4, 0xc0c0400
; GFX9-DL-NEXT:    s_load_dword s6, s[0:1], 0x0
; GFX9-DL-NEXT:    s_mov_b32 s5, 0x4000c0c
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_perm_b32 v5, v2, v1, s2
; GFX9-DL-NEXT:    v_perm_b32 v1, v2, v1, s4
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v6, v4, v3, s3
; GFX9-DL-NEXT:    v_perm_b32 v2, v4, v3, s5
; GFX9-DL-NEXT:    v_or_b32_e32 v3, v6, v5
; GFX9-DL-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v3, s6
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_4src:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x44
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x3
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[8:9]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[10:11]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[12:13]
; GFX10-DL-NEXT:    global_load_dword v4, v0, s[14:15]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_perm_b32 v0, v2, v1, 0xc0c0501
; GFX10-DL-NEXT:    v_perm_b32 v1, v2, v1, 0xc0c0400
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v5, v4, v3, 0x5010c0c
; GFX10-DL-NEXT:    v_perm_b32 v2, v4, v3, 0x4000c0c
; GFX10-DL-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX10-DL-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s2
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_4src:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b256 s[8:15], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x44
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x3
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[8:9]
; GFX11-DL-NEXT:    global_load_b32 v2, v0, s[10:11]
; GFX11-DL-NEXT:    global_load_b32 v3, v0, s[12:13]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[14:15]
; GFX11-DL-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX11-DL-NEXT:    v_perm_b32 v4, v2, v1, 0xc0c0501
; GFX11-DL-NEXT:    v_perm_b32 v1, v2, v1, 0xc0c0400
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v5, v0, v3, 0x5010c0c
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v3, 0x4000c0c
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-DL-NEXT:    v_or_b32_e32 v2, v5, v4
; GFX11-DL-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v2, s2
; GFX11-DL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) %src3,
                                       ptr addrspace(1) %src4,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()

  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2
  %gep3 = getelementptr <4 x i8>, ptr addrspace(1) %src3, i32 %idx
  %vec3 = load <4 x i8>, ptr addrspace(1) %gep3
  %gep4 = getelementptr <4 x i8>, ptr addrspace(1) %src4, i32 %idx
  %vec4 = load <4 x i8>, ptr addrspace(1) %gep4


  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv1e1

  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv2e0, %cv2e1

  %v3e0 = extractelement <4 x i8> %vec3, i64 0
  %cv3e0 = zext i8 %v3e0 to i32
  %v3e1 = extractelement <4 x i8> %vec3, i64 1
  %cv3e1 = zext i8 %v3e1 to i32
  %mul3 = mul nuw nsw i32 %cv3e0, %cv3e1

  %v4e0 = extractelement <4 x i8> %vec4, i64 0
  %cv4e0 = zext i8 %v4e0 to i32
  %v4e1 = extractelement <4 x i8> %vec4, i64 1
  %cv4e1 = zext i8 %v4e1 to i32
  %mul4 = mul nuw nsw i32 %cv4e0, %cv4e1


  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad1 = add i32 %mul1, %acc
  %mad2 = add i32 %mad1, %mul2
  %mad3 = add i32 %mad2, %mul3
  %mad4 = add i32 %mad3, %mul4

  store i32 %mad4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @udot4_acc32_multi(ptr addrspace(1) %src1,
; GFX7-LABEL: udot4_acc32_multi:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[8:11], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_mov_b64 s[8:9], s[10:11]
; GFX7-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX7-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v7, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v8, v0, 16, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v4, s4
; GFX7-NEXT:    v_and_b32_e32 v9, 0xff, v3
; GFX7-NEXT:    v_mad_u32_u24 v1, v7, v8, v1
; GFX7-NEXT:    v_bfe_u32 v11, v3, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v9, v4, v1
; GFX7-NEXT:    v_bfe_u32 v5, v2, 8, 8
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v11, v8, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v6, v1
; GFX7-NEXT:    v_bfe_u32 v10, v3, 8, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v2, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_mad_u32_u24 v1, v10, v6, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: udot4_acc32_multi:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    flat_load_dword v2, v[2:3]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v3, v3, v4, s0
; GFX8-NEXT:    v_and_b32_e32 v9, 0xff, v1
; GFX8-NEXT:    v_mad_u32_u24 v3, v7, v8, v3
; GFX8-NEXT:    v_bfe_u32 v11, v1, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v3, v9, v4, v3
; GFX8-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX8-NEXT:    v_bfe_u32 v6, v2, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v3, v11, v8, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_mad_u32_u24 v3, v5, v6, v3
; GFX8-NEXT:    v_bfe_u32 v10, v1, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v0, v0, v2, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX8-NEXT:    v_mad_u32_u24 v0, v10, v6, v0
; GFX8-NEXT:    v_mad_u32_u24 v2, v1, v2, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: udot4_acc32_multi:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v3, v2, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v4, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v7, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v8, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v9, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v3, v4, s0, v6
; GFX9-NODL-NEXT:    v_add3_u32 v3, v3, v7, v9
; GFX9-NODL-NEXT:    v_add3_u32 v0, v5, v3, v0
; GFX9-NODL-NEXT:    v_add3_u32 v0, v0, v8, v1
; GFX9-NODL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: udot4_acc32_multi:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-DL-NEXT:    s_mov_b32 s4, 0x3010301
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v3, v2, s[2:3]
; GFX9-DL-NEXT:    s_load_dword s3, s[6:7], 0x0
; GFX9-DL-NEXT:    s_mov_b32 s0, 0x6040200
; GFX9-DL-NEXT:    s_mov_b32 s1, 0x2000200
; GFX9-DL-NEXT:    s_mov_b32 s2, 0x7050301
; GFX9-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v4, v1, v0, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v5, v3, v3, s1
; GFX9-DL-NEXT:    v_perm_b32 v0, v1, v0, s2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v4, v5, s3
; GFX9-DL-NEXT:    v_perm_b32 v3, v3, v3, s4
; GFX9-DL-NEXT:    v_dot4_u32_u8 v0, v0, v3, v1
; GFX9-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: udot4_acc32_multi:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dwordx2 v[0:1], v2, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v3, v2, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v2, v1, v0, 0x6040200
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v4, v3, v3, 0x2000200
; GFX10-DL-NEXT:    v_perm_b32 v0, v1, v0, 0x7050301
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v2, v4, s0
; GFX10-DL-NEXT:    v_perm_b32 v2, v3, v3, 0x3010301
; GFX10-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v0, v2, v1
; GFX10-DL-NEXT:    global_store_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: udot4_acc32_multi:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b64 v[0:1], v2, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v2, v2, s[2:3]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v3, v1, v0, 0x6040200
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v4, v2, v2, 0x2000200
; GFX11-DL-NEXT:    v_perm_b32 v0, v1, v0, 0x7050301
; GFX11-DL-NEXT:    v_perm_b32 v2, v2, v2, 0x3010301
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v1, v3, v4, s0
; GFX11-DL-NEXT:    v_mov_b32_e32 v3, 0
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v2, v1
; GFX11-DL-NEXT:    global_store_b32 v3, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <8 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <8 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <8 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <8 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %v1e4 = extractelement <8 x i8> %vec1, i64 4
  %cv1e4 = zext i8 %v1e4 to i32
  %v2e4 = extractelement <8 x i8> %vec2, i64 4
  %cv2e4 = zext i8 %v2e4 to i32
  %mul5 = mul nuw nsw i32 %cv1e4, %cv2e0

  %v1e5 = extractelement <8 x i8> %vec1, i64 5
  %cv1e5 = zext i8 %v1e5 to i32
  %v2e5 = extractelement <8 x i8> %vec2, i64 5
  %cv2e5 = zext i8 %v2e5 to i32
  %mul6 = mul nuw nsw i32 %cv1e5, %cv2e1

  %v1e6 = extractelement <8 x i8> %vec1, i64 6
  %cv1e6 = zext i8 %v1e6 to i32
  %v2e6 = extractelement <8 x i8> %vec2, i64 6
  %cv2e6 = zext i8 %v2e6 to i32
  %mul7 = mul nuw nsw i32 %cv1e6, %cv2e2

  %v1e7 = extractelement <8 x i8> %vec1, i64 7
  %cv1e7 = zext i8 %v1e7 to i32
  %v2e7 = extractelement <8 x i8> %vec2, i64 7
  %cv2e7 = zext i8 %v2e7 to i32
  %mul8 = mul nuw nsw i32 %cv1e7, %cv2e3

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %mad11 = add i32 %mul1, %acc
  %mad21 = add i32 %mad11, %mul3
  %mad31 = add i32 %mad21, %mul5
  %mad41 = add i32 %mad31, %mul7
  %mad12 = add i32 %mul2, %mad41
  %mad22 = add i32 %mad12, %mul4
  %mad32 = add i32 %mad22, %mul6
  %mad42 = add i32 %mad32, %mul8

  store i32 %mad42, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_hilo(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_hilo:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    s_mov_b64 s[2:3], s[10:11]
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[0:3], 0 addr64 offset:4
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX7-NEXT:    v_mul_u32_u24_e32 v4, v4, v5
; GFX7-NEXT:    v_bfe_u32 v6, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v3, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v6, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_hilo:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX8-NEXT:    v_bfe_u32 v5, v4, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v6, 0xff, v2
; GFX8-NEXT:    v_mul_u32_u24_sdwa v7, v2, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v3, v6, v3, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_mad_u32_u24 v3, v8, v5, v3
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v4, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_hilo:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1] offset:4
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, v4, v5
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_hilo:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1] offset:4
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, 0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_hilo:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1] offset:4
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, 0
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_hilo:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1] offset:4
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, 0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i8> %vec1, i64 4
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <8 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i8> %vec1, i64 5
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <8 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i8> %vec1, i64 6
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <8 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i8> %vec1, i64 7
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <8 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %add1 = add i32 %mul1, 0
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_lohi(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_lohi:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64 offset:4
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v6, v0, 16, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_mul_u32_u24_e32 v3, v3, v6
; GFX7-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 8, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_lohi:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX8-NEXT:    v_bfe_u32 v5, v4, 16, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX8-NEXT:    v_mul_u32_u24_sdwa v4, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_2
; GFX8-NEXT:    v_bfe_u32 v8, v2, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v3, v3, v7, v4
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX8-NEXT:    v_mad_u32_u24 v3, v5, v8, v3
; GFX8-NEXT:    v_mad_u32_u24 v2, v6, v2, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_lohi:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3] offset:4
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, v4, v5
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_lohi:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[2:3] offset:4
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX9-DL-NEXT:    s_mov_b32 s0, 0x10302
; GFX9-DL-NEXT:    s_mov_b32 s1, 0x3020001
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s1
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, 0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_lohi:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[2:3] offset:4
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v1, v1, 0x10302
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v2, v2, 0x3020001
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, 0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_lohi:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3] offset:4
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0x10302
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0x3020001
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, 0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <8 x i8> %vec2, i64 7
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <8 x i8> %vec2, i64 6
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <8 x i8> %vec2, i64 5
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <8 x i8> %vec2, i64 4
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %add1 = add i32 %mul1, 0
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_hihi(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_hihi:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64 offset:4
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64 offset:4
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v5, v0, 16, 8
; GFX7-NEXT:    v_mul_u32_u24_e32 v3, v3, v6
; GFX7-NEXT:    v_bfe_u32 v4, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_hihi:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, s2, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 4, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX8-NEXT:    v_bfe_u32 v7, v2, 8, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_u32 v5, v3, 16, 8
; GFX8-NEXT:    v_mul_u32_u24_sdwa v6, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX8-NEXT:    v_mad_u32_u24 v4, v4, v5, v6
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX8-NEXT:    v_bfe_u32 v3, v3, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v4, v7, v8, v4
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v3, v4
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_hihi:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1] offset:4
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3] offset:4
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v3, v4, v5
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_hihi:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[2:3] offset:4
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[0:1] offset:4
; GFX9-DL-NEXT:    s_mov_b32 s0, 0x1030200
; GFX9-DL-NEXT:    s_mov_b32 s1, 0x3010002
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v2, s1
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, 0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_hihi:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[2:3] offset:4
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[0:1] offset:4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v1, v1, 0x1030200
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v2, v2, 0x3010002
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, 0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_hihi:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[2:3] offset:4
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1] offset:4
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0x1030200
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0x3010002
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, 0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <8 x i8> %vec1, i64 4
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <8 x i8> %vec2, i64 6
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i8> %vec1, i64 6
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <8 x i8> %vec2, i64 4
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i8> %vec1, i64 5
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <8 x i8> %vec2, i64 7
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i8> %vec1, i64 7
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <8 x i8> %vec2, i64 5
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %add1 = add i32 %mul1, 0
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_v8i8(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_v8i8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    s_mov_b32 s3, s7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[0:3], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v4, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v5, v1, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX7-NEXT:    v_mul_u32_u24_e32 v4, v4, v5
; GFX7-NEXT:    v_bfe_u32 v6, v0, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v1, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v2, v2, v3, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_mad_u32_u24 v2, v6, v7, v2
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v1, v2
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_v8i8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX8-NEXT:    v_mul_u32_u24_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX8-NEXT:    v_bfe_u32 v5, v0, 16, 8
; GFX8-NEXT:    v_bfe_u32 v6, v1, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v3, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX8-NEXT:    v_mad_u32_u24 v2, v5, v6, v2
; GFX8-NEXT:    v_mad_u32_u24 v2, v0, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_v8i8:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dwordx2 v[0:1], v0, s[0:1]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mad_u32_u24 v1, v3, v4, v5
; GFX9-NODL-NEXT:    v_add3_u32 v0, v1, v6, v0
; GFX9-NODL-NEXT:    global_store_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_v8i8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dwordx2 v[0:1], v0, s[0:1]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, 0
; GFX9-DL-NEXT:    global_store_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_v8i8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    global_load_dwordx2 v[0:1], v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, 0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_v8i8:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-DL-NEXT:    s_load_b64 s[2:3], s[4:5], 0x34
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    global_load_b64 v[0:1], v0, s[0:1]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, 0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[2:3]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <8 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <8 x i8>, ptr addrspace(1) %gep1


  %v1e0 = extractelement <8 x i8> %vec1, i64 0
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <8 x i8> %vec1, i64 4
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <8 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <8 x i8> %vec1, i64 5
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <8 x i8> %vec1, i64 2
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <8 x i8> %vec1, i64 6
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <8 x i8> %vec1, i64 3
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <8 x i8> %vec1, i64 7
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %add1 = add i32 %mul1, 0
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_v16i8(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_v16i8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 4, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    s_mov_b64 s[0:1], s[2:3]
; GFX7-NEXT:    s_mov_b64 s[2:3], s[10:11]
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v5, v2
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[1:2], s[8:11], 0 addr64
; GFX7-NEXT:    buffer_load_dword v0, v[4:5], s[0:3], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v4, 0xff, v0
; GFX7-NEXT:    v_mul_u32_u24_e32 v2, v2, v5
; GFX7-NEXT:    v_bfe_u32 v6, v3, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v4, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v6, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v3, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_v16i8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 4, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, s0, v1
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, s2, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v3, vcc
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[1:2]
; GFX8-NEXT:    flat_load_dword v4, v[4:5]
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_and_b32_e32 v5, 0xff, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v6, 0xff, v4
; GFX8-NEXT:    v_mul_u32_u24_sdwa v2, v2, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_1
; GFX8-NEXT:    v_bfe_u32 v7, v3, 8, 8
; GFX8-NEXT:    v_bfe_u32 v8, v4, 16, 8
; GFX8-NEXT:    v_mad_u32_u24 v2, v5, v6, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_mad_u32_u24 v2, v7, v8, v2
; GFX8-NEXT:    v_mad_u32_u24 v2, v3, v4, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_v16i8:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v5, 3, v0
; GFX9-NODL-NEXT:    ; kill: killed $vgpr4
; GFX9-NODL-NEXT:    ; kill: killed $vgpr5
; GFX9-NODL-NEXT:    ; kill: killed $sgpr0_sgpr1_sgpr2 killed $sgpr3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dwordx4 v[0:3], v4, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v0, v5, s[2:3]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v5, 0xff, v0
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mad_u32_u24 v2, v4, v5, v2
; GFX9-NODL-NEXT:    v_add3_u32 v0, v2, v6, v0
; GFX9-NODL-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_v16i8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v5, 3, v0
; GFX9-DL-NEXT:    ; kill: killed $vgpr4
; GFX9-DL-NEXT:    ; kill: killed $vgpr5
; GFX9-DL-NEXT:    ; kill: killed $sgpr0_sgpr1_sgpr2 killed $sgpr3
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dwordx4 v[0:3], v4, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v0, v5, s[2:3]
; GFX9-DL-NEXT:    s_mov_b32 s0, 0x7050002
; GFX9-DL-NEXT:    s_mov_b32 s1, 0x3020001
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    v_perm_b32 v2, v3, v2, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v0, v0, v0, s1
; GFX9-DL-NEXT:    v_dot4_u32_u8 v0, v2, v0, 0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_v16i8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v5, 3, v0
; GFX10-DL-NEXT:    ; kill: killed $vgpr4
; GFX10-DL-NEXT:    ; kill: killed $sgpr0_sgpr1_sgpr2 killed $sgpr3
; GFX10-DL-NEXT:    ; kill: killed $vgpr5
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    global_load_dwordx4 v[0:3], v4, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v0, v5, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v1, v3, v2, 0x7050002
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v0, v0, v0, 0x3020001
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, 0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_v16i8:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v1, 4, v0
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    global_load_b128 v[0:3], v1, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v4, s[2:3]
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v3, v2, 0x7050002
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0x3020001
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, 0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <16 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <16 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <16 x i8> %vec1, i64 8
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <8 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <16 x i8> %vec1, i64 10
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <8 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <16 x i8> %vec1, i64 13
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <8 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <16 x i8> %vec1, i64 15
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <8 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %add1 = add i32 %mul1, 0
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_v256i8(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_v256i8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 8, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    s_mov_b64 s[2:3], s[10:11]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 3, v0
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_load_dword v0, v[1:2], s[0:3], 0 addr64 offset:252
; GFX7-NEXT:    buffer_load_dword v1, v[3:4], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_u32 v4, v0, 16, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v1
; GFX7-NEXT:    v_mul_u32_u24_e32 v4, v4, v5
; GFX7-NEXT:    v_and_b32_e32 v6, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v7, v1, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v2, v2, v3, v4
; GFX7-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_mad_u32_u24 v2, v6, v7, v2
; GFX7-NEXT:    v_mad_u32_u24 v0, v0, v1, v2
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_v256i8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 8, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, s0, v1
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    s_movk_i32 s0, 0xfc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v3
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v2, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v3, 0xff, v4
; GFX8-NEXT:    v_bfe_u32 v5, v4, 16, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v2
; GFX8-NEXT:    v_mul_u32_u24_sdwa v7, v2, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_1
; GFX8-NEXT:    v_and_b32_e32 v8, 0xff, v2
; GFX8-NEXT:    v_mad_u32_u24 v3, v6, v3, v7
; GFX8-NEXT:    v_bfe_u32 v2, v2, 8, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_mad_u32_u24 v3, v8, v5, v3
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v4, v3
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_v256i8:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v1, 8, v0
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v2, v1, s[0:1] offset:252
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[2:3]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v1, 24, v2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_and_b32_e32 v4, 0xff, v3
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v6, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mad_u32_u24 v1, v1, v4, v5
; GFX9-NODL-NEXT:    v_add3_u32 v1, v1, v6, v2
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_v256i8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v1, 8, v0
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    global_load_dword v3, v1, s[0:1] offset:252
; GFX9-DL-NEXT:    s_mov_b32 s0, 0x3020001
; GFX9-DL-NEXT:    s_mov_b32 s1, 0x1000302
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_perm_b32 v1, v2, v2, s0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v3, v3, s1
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v2, v1, 0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_v256i8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    global_load_dword v2, v1, s[2:3]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[0:1] offset:252
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_perm_b32 v0, v2, v2, 0x3020001
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v1, v3, v3, 0x1000302
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, 0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_v256i8:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dual_mov_b32 v2, 0 :: v_dual_lshlrev_b32 v1, 3, v0
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    global_load_b32 v1, v1, s[2:3]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[0:1] offset:252
; GFX11-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0x3020001
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v0, 0x1000302
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v0, v1, 0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <256 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <256 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <8 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <8 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <256 x i8> %vec1, i64 255
  %cv1e0 = zext i8 %v1e0 to i32
  %v2e0 = extractelement <8 x i8> %vec2, i64 0
  %cv2e0 = zext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <256 x i8> %vec1, i64 254
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <8 x i8> %vec2, i64 1
  %cv2e1 = zext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <256 x i8> %vec1, i64 252
  %cv1e2 = zext i8 %v1e2 to i32
  %v2e2 = extractelement <8 x i8> %vec2, i64 2
  %cv2e2 = zext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <256 x i8> %vec1, i64 253
  %cv1e3 = zext i8 %v1e3 to i32
  %v2e3 = extractelement <8 x i8> %vec2, i64 3
  %cv2e3 = zext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %add1 = add i32 %mul1, 0
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, ptr addrspace(1) %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc32_anyext(ptr addrspace(1) %src1,
; GFX7-LABEL: idot4_acc32_anyext:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s7
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[0:1]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v1, s0
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_anyext:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX8-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_u32_u24 v1, v1, v1, s0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX8-NEXT:    v_mad_u32_u24 v2, v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_anyext:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NODL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v3, v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_u32_u24_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v1, v3, s0, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_anyext:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX9-DL-NEXT:    s_mov_b32 s1, 0xc0c0500
; GFX9-DL-NEXT:    s_mov_b32 s2, 0xc0c0100
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_perm_b32 v2, v2, v1, s1
; GFX9-DL-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_u32_u8 v1, v1, v2, s0
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[6:7]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_anyext:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-DL-NEXT:    s_load_dword s0, s[6:7], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_perm_b32 v0, v2, v1, 0xc0c0500
; GFX10-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0100
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_endpgm
;
; GFX11-DL-LABEL: idot4_acc32_anyext:
; GFX11-DL:       ; %bb.0: ; %entry
; GFX11-DL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-DL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-DL-NEXT:    s_load_b64 s[4:5], s[4:5], 0x34
; GFX11-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_clause 0x1
; GFX11-DL-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-DL-NEXT:    global_load_b32 v0, v0, s[2:3]
; GFX11-DL-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-DL-NEXT:    v_perm_b32 v0, v0, v1, 0xc0c0500
; GFX11-DL-NEXT:    v_perm_b32 v1, v1, v1, 0xc0c0100
; GFX11-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-DL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-DL-NEXT:    v_dot4_u32_u8 v0, v1, v0, s0
; GFX11-DL-NEXT:    global_store_b32 v2, v0, s[4:5]
; GFX11-DL-NEXT:    s_endpgm
                                       ptr addrspace(1) %src2,
                                       ptr addrspace(1) nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, ptr addrspace(1) %src1, i32 %idx
  %vec1 = load <4 x i8>, ptr addrspace(1) %gep1
  %gep2 = getelementptr <4 x i8>, ptr addrspace(1) %src2, i32 %idx
  %vec2 = load <4 x i8>, ptr addrspace(1) %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0t = sext i8 %v1e0 to i32
  %cv1e0 = and i32 %cv1e0t, 255
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0t = sext i8 %v2e0 to i32
  %cv2e0 = and i32 %cv1e0t, 255
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = zext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1t = sext i8 %v2e1 to i32
  %cv2e1 = and i32 %cv2e1t, 255
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %acc = load i32, ptr addrspace(1) %dst, align 4
  %add1 = add i32 %mul1, %acc
  %add2 = add i32 %add1, %mul2
  store i32 %add2, ptr addrspace(1) %dst, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
