; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+sve,+bf16    < %s | FileCheck %s -check-prefixes=CHECK,SVE
; RUN: llc -mattr=+sve2p2,+bf16 < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sve,+sme2p2,+bf16 < %s | FileCheck %s -check-prefix CHECK-2p2

; RUN: llc -mattr=+sme,+bf16    -force-streaming < %s | FileCheck %s -check-prefixes=CHECK,STREAMING-SVE
; RUN: llc -mattr=+sme2p2,+bf16 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sme,+sve2p2,+bf16 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2

target triple = "aarch64-linux"

define <vscale x 8 x half> @test_svcvt_f16_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_f16_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_f16_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svcvt_f16_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fcvt z0.h, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f16_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fcvt z0.h, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f32(<vscale x 8 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x bfloat> @test_svcvt_bf16_f32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_bf16_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_bf16_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    bfcvt z0.h, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x bfloat> @llvm.aarch64.sve.fcvt.bf16f32.v2(<vscale x 8 x bfloat> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x bfloat> %0
}

define <vscale x 8 x bfloat> @test_svcvt_bf16_f32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_bf16_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    bfcvt z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_bf16_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    bfcvt z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x bfloat> @llvm.aarch64.sve.fcvt.bf16f32.v2(<vscale x 8 x bfloat> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x bfloat> %0
}

define <vscale x 8 x bfloat> @test_svcvt_bf16_f32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svcvt_bf16_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    bfcvt z0.h, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_bf16_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    bfcvt z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_bf16_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    bfcvt z0.h, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x bfloat> @llvm.aarch64.sve.fcvt.bf16f32.v2(<vscale x 8 x bfloat> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x bfloat> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcvt_f16_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.h, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcvt_f16_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.h, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svcvt_f16_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fcvt z0.h, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f16_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fcvt z0.h, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f64(<vscale x 8 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcvt_f32_f64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.s, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcvt_f32_f64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.s, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x double> %x) {
; SVE-LABEL: test_svcvt_f32_f64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fcvt z0.s, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f32_f64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    fcvt z0.s, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f64(<vscale x 4 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f16_x_1(<vscale x 4 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcvt_f32_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.s, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f16(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f16_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcvt_f32_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.s, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f16(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f16_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svcvt_f32_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fcvt z0.s, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f32_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    fcvt z0.s, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f16(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f16_x_1(<vscale x 2 x i1> %pg, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcvt_f64_f16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.d, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f16(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f16_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcvt_f64_f16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.d, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f16(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f16_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 8 x half> %x) {
; SVE-LABEL: test_svcvt_f64_f16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fcvt z0.d, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f64_f16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    fcvt z0.d, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f16(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f32_x_1(<vscale x 2 x i1> %pg, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_f64_f32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_f64_f32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvt z0.d, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 4 x float> %x) {
; SVE-LABEL: test_svcvt_f64_f32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fcvt z0.d, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f64_f32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    fcvt z0.d, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f32(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_f16_f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvt z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f32_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 4 x float> %y ) {
; CHECK-LABEL: test_svcvt_f16_f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvt z0.h, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f32(<vscale x 8 x half> %x, <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x bfloat> @test_svcvt_bf16_f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_bf16_f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_bf16_f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    bfcvt z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x bfloat> @llvm.aarch64.sve.fcvt.bf16f32.v2(<vscale x 8 x bfloat> poison, <vscale x 4 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 8 x bfloat> %0
}

define <vscale x 8 x bfloat> @test_svcvt_bf16_f32_ptrue(double %z0, <vscale x 8 x bfloat> %x, <vscale x 4 x float> %y ) {
; CHECK-LABEL: test_svcvt_bf16_f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_bf16_f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    bfcvt z0.h, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x bfloat> @llvm.aarch64.sve.fcvt.bf16f32.v2(<vscale x 8 x bfloat> %x, <vscale x 4 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 8 x bfloat> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcvt_f16_f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.h, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_f64_ptrue(double %z0, <vscale x 8 x half> %x, <vscale x 2 x double> %y ) {
; CHECK-LABEL: test_svcvt_f16_f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.h, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.h, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.fcvt.f16f64(<vscale x 8 x half> %x, <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f64_ptrue_u(double %z0, <vscale x 2 x double> %x) {
; CHECK-LABEL: test_svcvt_f32_f64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.s, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x double> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f64_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 2 x double> %y ) {
; CHECK-LABEL: test_svcvt_f32_f64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.s, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f64(<vscale x 4 x float> %x, <vscale x 2 x i1> %pg, <vscale x 2 x double> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcvt_f32_f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvt z0.s, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f16(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_f16_ptrue(double %z0, <vscale x 4 x float> %x, <vscale x 8 x half> %y ) {
; CHECK-LABEL: test_svcvt_f32_f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvt z0.s, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    fcvt z0.s, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.fcvt.f32f16(<vscale x 4 x float> %x, <vscale x 4 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f16_ptrue_u(double %z0, <vscale x 8 x half> %x) {
; CHECK-LABEL: test_svcvt_f64_f16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.d, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f16(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 8 x half> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f16_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 8 x half> %y ) {
; CHECK-LABEL: test_svcvt_f64_f16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.d, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f16(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 8 x half> %y)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f32_ptrue_u(double %z0, <vscale x 4 x float> %x) {
; CHECK-LABEL: test_svcvt_f64_f32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.d, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x float> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_f32_ptrue(double %z0, <vscale x 2 x double> %x, <vscale x 4 x float> %y ) {
; CHECK-LABEL: test_svcvt_f64_f32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvt z0.d, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_f32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    fcvt z0.d, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.fcvt.f64f32(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 4 x float> %y)
  ret <vscale x 2 x double> %0
}
