/* puzzle-generator.c generated by valac 0.36.4, the Vala compiler
 * generated from puzzle-generator.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Puzzle generation logic:*/
/* We want to measure a puzzle's difficulty by the number of button presses*/
/* needed to solve it, and have that increase in a controlled manner.*/
/**/
/* Lights Off can be seen as a linear algebra problem over the field GF(2).*/
/* (See e.g. the first page of "Turning Lights Out with Linear Algebra".)*/
/* The linear map from button-press strategies to light configurations*/
/* will in general have a nullspace (of dimension n).*/
/* Thus, any solvable puzzle has 2^n solutions, given by a fixed solution*/
/* plus an element of the nullspace.*/
/* A solution is thus optimal if it presses at most half the buttons*/
/* which make up any element of the nullspace.*/
/**/
/* A basis for the nullspace splits the board into (up to) 2^n regions,*/
/* defined by which basic nullspace elements include a given button.*/
/* (This determines which nullspace elements include the same button.)*/
/* Thus, a solution is optimal if it includes at most half the buttons in any*/
/* region (except the region lying outside all null-sets).*/
/* The converse is not true, but (at least if the regions are even-sized)*/
/* does hold for a large number of puzzles up to the highest difficulty level.*/
/* (Certainly, on average, at most half the lights which belong to at least*/
/* one null set may be used.)*/

#include <glib.h>
#include <glib-object.h>
#include <math.h>
#include <float.h>


#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
typedef struct _PuzzleGeneratorPrivate PuzzleGeneratorPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _PuzzleGenerator {
	GObject parent_instance;
	PuzzleGeneratorPrivate * priv;
};

struct _PuzzleGeneratorClass {
	GObjectClass parent_class;
};

struct _PuzzleGeneratorPrivate {
	gint size;
	gint max_solution_length;
	gint* region_of;
	gint region_of_length1;
	gint _region_of_size_;
	gint* region_size;
	gint region_size_length1;
	gint _region_size_size_;
};


static gpointer puzzle_generator_parent_class = NULL;

GType puzzle_generator_get_type (void) G_GNUC_CONST;
#define PUZZLE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorPrivate))
enum  {
	PUZZLE_GENERATOR_DUMMY_PROPERTY
};
PuzzleGenerator* puzzle_generator_new (gint size);
PuzzleGenerator* puzzle_generator_construct (GType object_type, gint size);
gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self, gint solution_length, int* result_length1, int* result_length2);
static void puzzle_generator_finalize (GObject * obj);


PuzzleGenerator* puzzle_generator_construct (GType object_type, gint size) {
	PuzzleGenerator * self = NULL;
	gint _tmp0_;
	gint* adj_matrix = NULL;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint* _tmp5_;
	gint adj_matrix_length1;
	gint adj_matrix_length2;
	GList* non_pivot_cols = NULL;
	gint ipiv = 0;
	gint* basis_for_ns = NULL;
	GList* _tmp104_;
	guint _tmp105_;
	gint _tmp106_;
	gint _tmp107_;
	gint* _tmp108_;
	gint basis_for_ns_length1;
	gint basis_for_ns_length2;
	gint n = 0;
	GList* _tmp109_;
	GList* _tmp159_;
	guint _tmp160_;
	gint* _tmp161_;
	gint _tmp169_;
	gint _tmp170_;
	gint* _tmp171_;
	gint* _tmp198_;
	gint _tmp198__length1;
	gint _tmp199_;
	self = (PuzzleGenerator*) g_object_new (object_type, NULL);
	_tmp0_ = size;
	self->priv->size = _tmp0_;
	_tmp1_ = size;
	_tmp2_ = size;
	_tmp3_ = size;
	_tmp4_ = size;
	_tmp5_ = g_new0 (gint, (_tmp1_ * _tmp2_) * (_tmp3_ * _tmp4_));
	adj_matrix = _tmp5_;
	adj_matrix_length1 = _tmp1_ * _tmp2_;
	adj_matrix_length2 = _tmp3_ * _tmp4_;
	{
		gint x0 = 0;
		x0 = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = x0;
					x0 = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = x0;
				_tmp9_ = size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				{
					gint y0 = 0;
					y0 = 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							gint _tmp12_;
							gint _tmp13_;
							if (!_tmp10_) {
								gint _tmp11_;
								_tmp11_ = y0;
								y0 = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = y0;
							_tmp13_ = size;
							if (!(_tmp12_ < _tmp13_)) {
								break;
							}
							{
								gint x1 = 0;
								x1 = 0;
								{
									gboolean _tmp14_ = FALSE;
									_tmp14_ = TRUE;
									while (TRUE) {
										gint _tmp16_;
										gint _tmp17_;
										if (!_tmp14_) {
											gint _tmp15_;
											_tmp15_ = x1;
											x1 = _tmp15_ + 1;
										}
										_tmp14_ = FALSE;
										_tmp16_ = x1;
										_tmp17_ = size;
										if (!(_tmp16_ < _tmp17_)) {
											break;
										}
										{
											gint y1 = 0;
											y1 = 0;
											{
												gboolean _tmp18_ = FALSE;
												_tmp18_ = TRUE;
												while (TRUE) {
													gint _tmp20_;
													gint _tmp21_;
													gint dx = 0;
													gint _tmp22_;
													gint _tmp23_;
													gint dy = 0;
													gint _tmp24_;
													gint _tmp25_;
													gint _tmp26_ = 0;
													gint _tmp27_;
													gint _tmp28_;
													gint _tmp29_;
													gint _tmp30_;
													gint* _tmp31_;
													gint _tmp31__length1;
													gint _tmp31__length2;
													gint _tmp32_;
													gint _tmp33_;
													gint _tmp34_;
													gint _tmp35_;
													gint _tmp36_;
													gint _tmp37_;
													gint _tmp38_;
													if (!_tmp18_) {
														gint _tmp19_;
														_tmp19_ = y1;
														y1 = _tmp19_ + 1;
													}
													_tmp18_ = FALSE;
													_tmp20_ = y1;
													_tmp21_ = size;
													if (!(_tmp20_ < _tmp21_)) {
														break;
													}
													_tmp22_ = x0;
													_tmp23_ = x1;
													dx = _tmp22_ - _tmp23_;
													_tmp24_ = y0;
													_tmp25_ = y1;
													dy = _tmp24_ - _tmp25_;
													_tmp27_ = dx;
													_tmp28_ = dx;
													_tmp29_ = dy;
													_tmp30_ = dy;
													if (((_tmp27_ * _tmp28_) + (_tmp29_ * _tmp30_)) <= 1) {
														_tmp26_ = 1;
													} else {
														_tmp26_ = 0;
													}
													_tmp31_ = adj_matrix;
													_tmp31__length1 = adj_matrix_length1;
													_tmp31__length2 = adj_matrix_length2;
													_tmp32_ = x0;
													_tmp33_ = size;
													_tmp34_ = y0;
													_tmp35_ = x1;
													_tmp36_ = size;
													_tmp37_ = y1;
													_tmp31_[(((_tmp32_ * _tmp33_) + _tmp34_) * _tmp31__length2) + ((_tmp35_ * _tmp36_) + _tmp37_)] = _tmp26_;
													_tmp38_ = _tmp31_[(((_tmp32_ * _tmp33_) + _tmp34_) * _tmp31__length2) + ((_tmp35_ * _tmp36_) + _tmp37_)];
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	non_pivot_cols = NULL;
	ipiv = 0;
	{
		gint jpiv = 0;
		jpiv = 0;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gboolean is_pivot_col = FALSE;
				gboolean _tmp102_;
				if (!_tmp39_) {
					gint _tmp40_;
					_tmp40_ = jpiv;
					jpiv = _tmp40_ + 1;
				}
				_tmp39_ = FALSE;
				_tmp41_ = jpiv;
				_tmp42_ = size;
				_tmp43_ = size;
				if (!(_tmp41_ < (_tmp42_ * _tmp43_))) {
					break;
				}
				is_pivot_col = FALSE;
				{
					gint i = 0;
					gint _tmp44_;
					_tmp44_ = ipiv;
					i = _tmp44_;
					{
						gboolean _tmp45_ = FALSE;
						_tmp45_ = TRUE;
						while (TRUE) {
							gint _tmp47_;
							gint _tmp48_;
							gint _tmp49_;
							gint* _tmp50_;
							gint _tmp50__length1;
							gint _tmp50__length2;
							gint _tmp51_;
							gint _tmp52_;
							gint _tmp53_;
							if (!_tmp45_) {
								gint _tmp46_;
								_tmp46_ = i;
								i = _tmp46_ + 1;
							}
							_tmp45_ = FALSE;
							_tmp47_ = i;
							_tmp48_ = size;
							_tmp49_ = size;
							if (!(_tmp47_ < (_tmp48_ * _tmp49_))) {
								break;
							}
							_tmp50_ = adj_matrix;
							_tmp50__length1 = adj_matrix_length1;
							_tmp50__length2 = adj_matrix_length2;
							_tmp51_ = i;
							_tmp52_ = jpiv;
							_tmp53_ = _tmp50_[(_tmp51_ * _tmp50__length2) + _tmp52_];
							if (_tmp53_ != 0) {
								gint _tmp54_;
								gint _tmp55_;
								gint _tmp101_;
								_tmp54_ = i;
								_tmp55_ = ipiv;
								if (_tmp54_ != _tmp55_) {
									{
										gint z = 0;
										z = 0;
										{
											gboolean _tmp56_ = FALSE;
											_tmp56_ = TRUE;
											while (TRUE) {
												gint _tmp58_;
												gint _tmp59_;
												gint _tmp60_;
												gint t = 0;
												gint* _tmp61_;
												gint _tmp61__length1;
												gint _tmp61__length2;
												gint _tmp62_;
												gint _tmp63_;
												gint _tmp64_;
												gint* _tmp65_;
												gint _tmp65__length1;
												gint _tmp65__length2;
												gint _tmp66_;
												gint _tmp67_;
												gint* _tmp68_;
												gint _tmp68__length1;
												gint _tmp68__length2;
												gint _tmp69_;
												gint _tmp70_;
												gint _tmp71_;
												gint _tmp72_;
												gint* _tmp73_;
												gint _tmp73__length1;
												gint _tmp73__length2;
												gint _tmp74_;
												gint _tmp75_;
												gint _tmp76_;
												gint _tmp77_;
												if (!_tmp56_) {
													gint _tmp57_;
													_tmp57_ = z;
													z = _tmp57_ + 1;
												}
												_tmp56_ = FALSE;
												_tmp58_ = z;
												_tmp59_ = size;
												_tmp60_ = size;
												if (!(_tmp58_ < (_tmp59_ * _tmp60_))) {
													break;
												}
												_tmp61_ = adj_matrix;
												_tmp61__length1 = adj_matrix_length1;
												_tmp61__length2 = adj_matrix_length2;
												_tmp62_ = i;
												_tmp63_ = z;
												_tmp64_ = _tmp61_[(_tmp62_ * _tmp61__length2) + _tmp63_];
												t = _tmp64_;
												_tmp65_ = adj_matrix;
												_tmp65__length1 = adj_matrix_length1;
												_tmp65__length2 = adj_matrix_length2;
												_tmp66_ = i;
												_tmp67_ = z;
												_tmp68_ = adj_matrix;
												_tmp68__length1 = adj_matrix_length1;
												_tmp68__length2 = adj_matrix_length2;
												_tmp69_ = ipiv;
												_tmp70_ = z;
												_tmp71_ = _tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_];
												_tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_] = _tmp71_;
												_tmp72_ = _tmp65_[(_tmp66_ * _tmp65__length2) + _tmp67_];
												_tmp73_ = adj_matrix;
												_tmp73__length1 = adj_matrix_length1;
												_tmp73__length2 = adj_matrix_length2;
												_tmp74_ = ipiv;
												_tmp75_ = z;
												_tmp76_ = t;
												_tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_] = _tmp76_;
												_tmp77_ = _tmp73_[(_tmp74_ * _tmp73__length2) + _tmp75_];
											}
										}
									}
								}
								{
									gint j = 0;
									gint _tmp78_;
									_tmp78_ = ipiv;
									j = _tmp78_ + 1;
									{
										gboolean _tmp79_ = FALSE;
										_tmp79_ = TRUE;
										while (TRUE) {
											gint _tmp81_;
											gint _tmp82_;
											gint _tmp83_;
											gint* _tmp84_;
											gint _tmp84__length1;
											gint _tmp84__length2;
											gint _tmp85_;
											gint _tmp86_;
											gint _tmp87_;
											if (!_tmp79_) {
												gint _tmp80_;
												_tmp80_ = j;
												j = _tmp80_ + 1;
											}
											_tmp79_ = FALSE;
											_tmp81_ = j;
											_tmp82_ = size;
											_tmp83_ = size;
											if (!(_tmp81_ < (_tmp82_ * _tmp83_))) {
												break;
											}
											_tmp84_ = adj_matrix;
											_tmp84__length1 = adj_matrix_length1;
											_tmp84__length2 = adj_matrix_length2;
											_tmp85_ = j;
											_tmp86_ = jpiv;
											_tmp87_ = _tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_];
											if (_tmp87_ != 0) {
												{
													gint k = 0;
													k = 0;
													{
														gboolean _tmp88_ = FALSE;
														_tmp88_ = TRUE;
														while (TRUE) {
															gint _tmp90_;
															gint _tmp91_;
															gint _tmp92_;
															gint* _tmp93_;
															gint _tmp93__length1;
															gint _tmp93__length2;
															gint _tmp94_;
															gint _tmp95_;
															gint* _tmp96_;
															gint _tmp96__length1;
															gint _tmp96__length2;
															gint _tmp97_;
															gint _tmp98_;
															gint _tmp99_;
															gint _tmp100_;
															if (!_tmp88_) {
																gint _tmp89_;
																_tmp89_ = k;
																k = _tmp89_ + 1;
															}
															_tmp88_ = FALSE;
															_tmp90_ = k;
															_tmp91_ = size;
															_tmp92_ = size;
															if (!(_tmp90_ < (_tmp91_ * _tmp92_))) {
																break;
															}
															_tmp93_ = adj_matrix;
															_tmp93__length1 = adj_matrix_length1;
															_tmp93__length2 = adj_matrix_length2;
															_tmp94_ = j;
															_tmp95_ = k;
															_tmp96_ = adj_matrix;
															_tmp96__length1 = adj_matrix_length1;
															_tmp96__length2 = adj_matrix_length2;
															_tmp97_ = ipiv;
															_tmp98_ = k;
															_tmp99_ = _tmp96_[(_tmp97_ * _tmp96__length2) + _tmp98_];
															_tmp93_[(_tmp94_ * _tmp93__length2) + _tmp95_] ^= _tmp99_;
															_tmp100_ = _tmp93_[(_tmp94_ * _tmp93__length2) + _tmp95_];
														}
													}
												}
											}
										}
									}
								}
								is_pivot_col = TRUE;
								_tmp101_ = ipiv;
								ipiv = _tmp101_ + 1;
								break;
							}
						}
					}
				}
				_tmp102_ = is_pivot_col;
				if (!_tmp102_) {
					gint _tmp103_;
					_tmp103_ = jpiv;
					non_pivot_cols = g_list_append (non_pivot_cols, (gpointer) ((gintptr) _tmp103_));
				}
			}
		}
	}
	_tmp104_ = non_pivot_cols;
	_tmp105_ = g_list_length (_tmp104_);
	_tmp106_ = size;
	_tmp107_ = size;
	_tmp108_ = g_new0 (gint, _tmp105_ * (_tmp106_ * _tmp107_));
	basis_for_ns = _tmp108_;
	basis_for_ns_length1 = _tmp105_;
	basis_for_ns_length2 = _tmp106_ * _tmp107_;
	n = 0;
	_tmp109_ = non_pivot_cols;
	{
		GList* col_collection = NULL;
		GList* col_it = NULL;
		col_collection = _tmp109_;
		for (col_it = col_collection; col_it != NULL; col_it = col_it->next) {
			gint col = 0;
			col = (gint) ((gintptr) col_it->data);
			{
				gint* _tmp119_;
				gint _tmp119__length1;
				gint _tmp119__length2;
				gint _tmp120_;
				gint _tmp121_;
				gint _tmp122_;
				gint _tmp158_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp110_ = FALSE;
						_tmp110_ = TRUE;
						while (TRUE) {
							gint _tmp112_;
							gint _tmp113_;
							gint _tmp114_;
							gint* _tmp115_;
							gint _tmp115__length1;
							gint _tmp115__length2;
							gint _tmp116_;
							gint _tmp117_;
							gint _tmp118_;
							if (!_tmp110_) {
								gint _tmp111_;
								_tmp111_ = j;
								j = _tmp111_ + 1;
							}
							_tmp110_ = FALSE;
							_tmp112_ = j;
							_tmp113_ = size;
							_tmp114_ = size;
							if (!(_tmp112_ < (_tmp113_ * _tmp114_))) {
								break;
							}
							_tmp115_ = basis_for_ns;
							_tmp115__length1 = basis_for_ns_length1;
							_tmp115__length2 = basis_for_ns_length2;
							_tmp116_ = n;
							_tmp117_ = j;
							_tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_] = 0;
							_tmp118_ = _tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_];
						}
					}
				}
				_tmp119_ = basis_for_ns;
				_tmp119__length1 = basis_for_ns_length1;
				_tmp119__length2 = basis_for_ns_length2;
				_tmp120_ = n;
				_tmp121_ = col;
				_tmp119_[(_tmp120_ * _tmp119__length2) + _tmp121_] = 1;
				_tmp122_ = _tmp119_[(_tmp120_ * _tmp119__length2) + _tmp121_];
				{
					gint i = 0;
					gint _tmp123_;
					gint _tmp124_;
					_tmp123_ = size;
					_tmp124_ = size;
					i = (_tmp123_ * _tmp124_) - 1;
					{
						gboolean _tmp125_ = FALSE;
						_tmp125_ = TRUE;
						while (TRUE) {
							gint _tmp127_;
							gint jpiv = 0;
							gint _tmp137_;
							gint _tmp138_;
							gint _tmp139_;
							if (!_tmp125_) {
								gint _tmp126_;
								_tmp126_ = i;
								i = _tmp126_ - 1;
							}
							_tmp125_ = FALSE;
							_tmp127_ = i;
							if (!(_tmp127_ >= 0)) {
								break;
							}
							jpiv = 0;
							{
								gboolean _tmp128_ = FALSE;
								_tmp128_ = TRUE;
								while (TRUE) {
									gint _tmp130_;
									gint _tmp131_;
									gint _tmp132_;
									gint* _tmp133_;
									gint _tmp133__length1;
									gint _tmp133__length2;
									gint _tmp134_;
									gint _tmp135_;
									gint _tmp136_;
									if (!_tmp128_) {
										gint _tmp129_;
										_tmp129_ = jpiv;
										jpiv = _tmp129_ + 1;
									}
									_tmp128_ = FALSE;
									_tmp130_ = jpiv;
									_tmp131_ = size;
									_tmp132_ = size;
									if (!(_tmp130_ < (_tmp131_ * _tmp132_))) {
										break;
									}
									_tmp133_ = adj_matrix;
									_tmp133__length1 = adj_matrix_length1;
									_tmp133__length2 = adj_matrix_length2;
									_tmp134_ = i;
									_tmp135_ = jpiv;
									_tmp136_ = _tmp133_[(_tmp134_ * _tmp133__length2) + _tmp135_];
									if (_tmp136_ != 0) {
										break;
									}
								}
							}
							_tmp137_ = jpiv;
							_tmp138_ = size;
							_tmp139_ = size;
							if (_tmp137_ == (_tmp138_ * _tmp139_)) {
								continue;
							}
							{
								gint j = 0;
								gint _tmp140_;
								_tmp140_ = jpiv;
								j = _tmp140_ + 1;
								{
									gboolean _tmp141_ = FALSE;
									_tmp141_ = TRUE;
									while (TRUE) {
										gint _tmp143_;
										gint _tmp144_;
										gint _tmp145_;
										gint* _tmp146_;
										gint _tmp146__length1;
										gint _tmp146__length2;
										gint _tmp147_;
										gint _tmp148_;
										gint* _tmp149_;
										gint _tmp149__length1;
										gint _tmp149__length2;
										gint _tmp150_;
										gint _tmp151_;
										gint _tmp152_;
										gint* _tmp153_;
										gint _tmp153__length1;
										gint _tmp153__length2;
										gint _tmp154_;
										gint _tmp155_;
										gint _tmp156_;
										gint _tmp157_;
										if (!_tmp141_) {
											gint _tmp142_;
											_tmp142_ = j;
											j = _tmp142_ + 1;
										}
										_tmp141_ = FALSE;
										_tmp143_ = j;
										_tmp144_ = size;
										_tmp145_ = size;
										if (!(_tmp143_ < (_tmp144_ * _tmp145_))) {
											break;
										}
										_tmp146_ = basis_for_ns;
										_tmp146__length1 = basis_for_ns_length1;
										_tmp146__length2 = basis_for_ns_length2;
										_tmp147_ = n;
										_tmp148_ = jpiv;
										_tmp149_ = adj_matrix;
										_tmp149__length1 = adj_matrix_length1;
										_tmp149__length2 = adj_matrix_length2;
										_tmp150_ = i;
										_tmp151_ = j;
										_tmp152_ = _tmp149_[(_tmp150_ * _tmp149__length2) + _tmp151_];
										_tmp153_ = basis_for_ns;
										_tmp153__length1 = basis_for_ns_length1;
										_tmp153__length2 = basis_for_ns_length2;
										_tmp154_ = n;
										_tmp155_ = j;
										_tmp156_ = _tmp153_[(_tmp154_ * _tmp153__length2) + _tmp155_];
										_tmp146_[(_tmp147_ * _tmp146__length2) + _tmp148_] ^= _tmp152_ * _tmp156_;
										_tmp157_ = _tmp146_[(_tmp147_ * _tmp146__length2) + _tmp148_];
									}
								}
							}
						}
					}
				}
				_tmp158_ = n;
				n = _tmp158_ + 1;
			}
		}
	}
	_tmp159_ = non_pivot_cols;
	_tmp160_ = g_list_length (_tmp159_);
	_tmp161_ = g_new0 (gint, 1 << _tmp160_);
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
	self->priv->region_size = _tmp161_;
	self->priv->region_size_length1 = 1 << _tmp160_;
	self->priv->_region_size_size_ = self->priv->region_size_length1;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp162_ = FALSE;
			_tmp162_ = TRUE;
			while (TRUE) {
				gint _tmp164_;
				gint* _tmp165_;
				gint _tmp165__length1;
				gint* _tmp166_;
				gint _tmp166__length1;
				gint _tmp167_;
				gint _tmp168_;
				if (!_tmp162_) {
					gint _tmp163_;
					_tmp163_ = j;
					j = _tmp163_ + 1;
				}
				_tmp162_ = FALSE;
				_tmp164_ = j;
				_tmp165_ = self->priv->region_size;
				_tmp165__length1 = self->priv->region_size_length1;
				if (!(_tmp164_ < _tmp165__length1)) {
					break;
				}
				_tmp166_ = self->priv->region_size;
				_tmp166__length1 = self->priv->region_size_length1;
				_tmp167_ = j;
				_tmp166_[_tmp167_] = 0;
				_tmp168_ = _tmp166_[_tmp167_];
			}
		}
	}
	_tmp169_ = size;
	_tmp170_ = size;
	_tmp171_ = g_new0 (gint, _tmp169_ * _tmp170_);
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
	self->priv->region_of = _tmp171_;
	self->priv->region_of_length1 = _tmp169_ * _tmp170_;
	self->priv->_region_of_size_ = self->priv->region_of_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp172_ = FALSE;
			_tmp172_ = TRUE;
			while (TRUE) {
				gint _tmp174_;
				gint _tmp175_;
				gint _tmp176_;
				gint* _tmp177_;
				gint _tmp177__length1;
				gint _tmp178_;
				gint _tmp179_;
				gint* _tmp193_;
				gint _tmp193__length1;
				gint* _tmp194_;
				gint _tmp194__length1;
				gint _tmp195_;
				gint _tmp196_;
				gint _tmp197_;
				if (!_tmp172_) {
					gint _tmp173_;
					_tmp173_ = i;
					i = _tmp173_ + 1;
				}
				_tmp172_ = FALSE;
				_tmp174_ = i;
				_tmp175_ = size;
				_tmp176_ = size;
				if (!(_tmp174_ < (_tmp175_ * _tmp176_))) {
					break;
				}
				_tmp177_ = self->priv->region_of;
				_tmp177__length1 = self->priv->region_of_length1;
				_tmp178_ = i;
				_tmp177_[_tmp178_] = 0;
				_tmp179_ = _tmp177_[_tmp178_];
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp180_ = FALSE;
						_tmp180_ = TRUE;
						while (TRUE) {
							gint _tmp182_;
							GList* _tmp183_;
							guint _tmp184_;
							gint* _tmp185_;
							gint _tmp185__length1;
							gint _tmp185__length2;
							gint _tmp186_;
							gint _tmp187_;
							gint _tmp188_;
							if (!_tmp180_) {
								gint _tmp181_;
								_tmp181_ = j;
								j = _tmp181_ + 1;
							}
							_tmp180_ = FALSE;
							_tmp182_ = j;
							_tmp183_ = non_pivot_cols;
							_tmp184_ = g_list_length (_tmp183_);
							if (!(((guint) _tmp182_) < _tmp184_)) {
								break;
							}
							_tmp185_ = basis_for_ns;
							_tmp185__length1 = basis_for_ns_length1;
							_tmp185__length2 = basis_for_ns_length2;
							_tmp186_ = j;
							_tmp187_ = i;
							_tmp188_ = _tmp185_[(_tmp186_ * _tmp185__length2) + _tmp187_];
							if (_tmp188_ != 0) {
								gint* _tmp189_;
								gint _tmp189__length1;
								gint _tmp190_;
								gint _tmp191_;
								gint _tmp192_;
								_tmp189_ = self->priv->region_of;
								_tmp189__length1 = self->priv->region_of_length1;
								_tmp190_ = i;
								_tmp191_ = j;
								_tmp189_[_tmp190_] += 1 << _tmp191_;
								_tmp192_ = _tmp189_[_tmp190_];
							}
						}
					}
				}
				_tmp193_ = self->priv->region_size;
				_tmp193__length1 = self->priv->region_size_length1;
				_tmp194_ = self->priv->region_of;
				_tmp194__length1 = self->priv->region_of_length1;
				_tmp195_ = i;
				_tmp196_ = _tmp194_[_tmp195_];
				_tmp197_ = _tmp193_[_tmp196_];
				_tmp193_[_tmp196_] = _tmp197_ + 1;
			}
		}
	}
	_tmp198_ = self->priv->region_size;
	_tmp198__length1 = self->priv->region_size_length1;
	_tmp199_ = _tmp198_[0];
	self->priv->max_solution_length = _tmp199_;
	{
		gint j = 0;
		j = 1;
		{
			gboolean _tmp200_ = FALSE;
			_tmp200_ = TRUE;
			while (TRUE) {
				gint _tmp202_;
				gint* _tmp203_;
				gint _tmp203__length1;
				gint _tmp204_;
				gint* _tmp205_;
				gint _tmp205__length1;
				gint _tmp206_;
				gint _tmp207_;
				gdouble _tmp208_;
				if (!_tmp200_) {
					gint _tmp201_;
					_tmp201_ = j;
					j = _tmp201_ + 1;
				}
				_tmp200_ = FALSE;
				_tmp202_ = j;
				_tmp203_ = self->priv->region_size;
				_tmp203__length1 = self->priv->region_size_length1;
				if (!(_tmp202_ < _tmp203__length1)) {
					break;
				}
				_tmp204_ = self->priv->max_solution_length;
				_tmp205_ = self->priv->region_size;
				_tmp205__length1 = self->priv->region_size_length1;
				_tmp206_ = j;
				_tmp207_ = _tmp205_[_tmp206_];
				_tmp208_ = floor ((gdouble) (_tmp207_ / 2));
				self->priv->max_solution_length = _tmp204_ + ((gint) _tmp208_);
			}
		}
	}
	basis_for_ns = (g_free (basis_for_ns), NULL);
	_g_list_free0 (non_pivot_cols);
	adj_matrix = (g_free (adj_matrix), NULL);
	return self;
}


PuzzleGenerator* puzzle_generator_new (gint size) {
	return puzzle_generator_construct (TYPE_PUZZLE_GENERATOR, size);
}


gboolean* puzzle_generator_minimal_solution (PuzzleGenerator* self, gint solution_length, int* result_length1, int* result_length2) {
	gboolean* result = NULL;
	gboolean* sol = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint sol_length1;
	gint sol_length2;
	gint* presses_in_region = NULL;
	gint* _tmp15_;
	gint _tmp15__length1;
	gint* _tmp16_;
	gint presses_in_region_length1;
	gint _presses_in_region_size_;
	gint sym = 0;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gint presses_left = 0;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gboolean* _tmp91_;
	gint _tmp91__length1;
	gint _tmp91__length2;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->size;
	_tmp1_ = self->priv->size;
	_tmp2_ = g_new0 (gboolean, _tmp0_ * _tmp1_);
	sol = _tmp2_;
	sol_length1 = _tmp0_;
	sol_length2 = _tmp1_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = x;
					x = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = x;
				_tmp6_ = self->priv->size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							gint _tmp10_;
							gboolean* _tmp11_;
							gint _tmp11__length1;
							gint _tmp11__length2;
							gint _tmp12_;
							gint _tmp13_;
							gboolean _tmp14_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = self->priv->size;
							if (!(_tmp9_ < _tmp10_)) {
								break;
							}
							_tmp11_ = sol;
							_tmp11__length1 = sol_length1;
							_tmp11__length2 = sol_length2;
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = FALSE;
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
						}
					}
				}
			}
		}
	}
	_tmp15_ = self->priv->region_size;
	_tmp15__length1 = self->priv->region_size_length1;
	_tmp16_ = g_new0 (gint, _tmp15__length1);
	presses_in_region = _tmp16_;
	presses_in_region_length1 = _tmp15__length1;
	_presses_in_region_size_ = presses_in_region_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_;
				gint* _tmp20_;
				gint _tmp20__length1;
				gint* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				gint _tmp23_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = self->priv->region_size;
				_tmp20__length1 = self->priv->region_size_length1;
				if (!(_tmp19_ < _tmp20__length1)) {
					break;
				}
				_tmp21_ = presses_in_region;
				_tmp21__length1 = presses_in_region_length1;
				_tmp22_ = i;
				_tmp21_[_tmp22_] = 0;
				_tmp23_ = _tmp21_[_tmp22_];
			}
		}
	}
	_tmp24_ = g_random_double ();
	_tmp25_ = floor (3 * _tmp24_);
	sym = (gint) _tmp25_;
	_tmp26_ = solution_length;
	_tmp27_ = self->priv->max_solution_length;
	_tmp28_ = MIN (_tmp26_, _tmp27_);
	presses_left = _tmp28_;
	while (TRUE) {
		gint _tmp29_;
		gint x[2] = {0};
		gint y[2] = {0};
		gint _tmp30_;
		gdouble _tmp31_;
		gdouble _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gdouble _tmp35_;
		gdouble _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		_tmp29_ = presses_left;
		if (!(_tmp29_ > 0)) {
			break;
		}
		_tmp30_ = self->priv->size;
		_tmp31_ = g_random_double ();
		_tmp32_ = round ((_tmp30_ - 1) * _tmp31_);
		x[0] = (gint) _tmp32_;
		_tmp33_ = x[0];
		_tmp34_ = self->priv->size;
		_tmp35_ = g_random_double ();
		_tmp36_ = round ((_tmp34_ - 1) * _tmp35_);
		y[0] = (gint) _tmp36_;
		_tmp37_ = y[0];
		_tmp38_ = sym;
		if (_tmp38_ == 0) {
			gint _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			_tmp39_ = self->priv->size;
			_tmp40_ = x[0];
			x[1] = (_tmp39_ - 1) - _tmp40_;
			_tmp41_ = x[1];
			_tmp42_ = y[0];
			y[1] = _tmp42_;
			_tmp43_ = y[1];
		} else {
			gint _tmp44_;
			_tmp44_ = sym;
			if (_tmp44_ == 1) {
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				_tmp45_ = self->priv->size;
				_tmp46_ = x[0];
				x[1] = (_tmp45_ - 1) - _tmp46_;
				_tmp47_ = x[1];
				_tmp48_ = self->priv->size;
				_tmp49_ = y[0];
				y[1] = (_tmp48_ - 1) - _tmp49_;
				_tmp50_ = y[1];
			} else {
				gint _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				_tmp51_ = x[0];
				x[1] = _tmp51_;
				_tmp52_ = x[1];
				_tmp53_ = self->priv->size;
				_tmp54_ = y[0];
				y[1] = (_tmp53_ - 1) - _tmp54_;
				_tmp55_ = y[1];
			}
		}
		{
			gint k = 0;
			k = 0;
			{
				gboolean _tmp56_ = FALSE;
				_tmp56_ = TRUE;
				while (TRUE) {
					gint _tmp58_;
					gint r = 0;
					gint* _tmp59_;
					gint _tmp59__length1;
					gint _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					gint _tmp65_;
					gboolean _tmp66_ = FALSE;
					gint _tmp67_;
					gint _tmp90_;
					if (!_tmp56_) {
						gint _tmp57_;
						_tmp57_ = k;
						k = _tmp57_ + 1;
					}
					_tmp56_ = FALSE;
					_tmp58_ = k;
					if (!(_tmp58_ < 2)) {
						break;
					}
					_tmp59_ = self->priv->region_of;
					_tmp59__length1 = self->priv->region_of_length1;
					_tmp60_ = k;
					_tmp61_ = x[_tmp60_];
					_tmp62_ = self->priv->size;
					_tmp63_ = k;
					_tmp64_ = y[_tmp63_];
					_tmp65_ = _tmp59_[(_tmp61_ * _tmp62_) + _tmp64_];
					r = _tmp65_;
					_tmp67_ = r;
					if (_tmp67_ == 0) {
						_tmp66_ = TRUE;
					} else {
						gint* _tmp68_;
						gint _tmp68__length1;
						gint _tmp69_;
						gint _tmp70_;
						gint* _tmp71_;
						gint _tmp71__length1;
						gint _tmp72_;
						gint _tmp73_;
						_tmp68_ = presses_in_region;
						_tmp68__length1 = presses_in_region_length1;
						_tmp69_ = r;
						_tmp70_ = _tmp68_[_tmp69_];
						_tmp71_ = self->priv->region_size;
						_tmp71__length1 = self->priv->region_size_length1;
						_tmp72_ = r;
						_tmp73_ = _tmp71_[_tmp72_];
						_tmp66_ = (2 * (_tmp70_ + 1)) <= _tmp73_;
					}
					if (_tmp66_) {
						gboolean* _tmp74_;
						gint _tmp74__length1;
						gint _tmp74__length2;
						gint _tmp75_;
						gint _tmp76_;
						gint _tmp77_;
						gint _tmp78_;
						gboolean _tmp79_;
						gboolean* _tmp80_;
						gint _tmp80__length1;
						gint _tmp80__length2;
						gint _tmp81_;
						gint _tmp82_;
						gint _tmp83_;
						gint _tmp84_;
						gboolean _tmp85_;
						gint* _tmp86_;
						gint _tmp86__length1;
						gint _tmp87_;
						gint _tmp88_;
						gint _tmp89_;
						_tmp74_ = sol;
						_tmp74__length1 = sol_length1;
						_tmp74__length2 = sol_length2;
						_tmp75_ = k;
						_tmp76_ = x[_tmp75_];
						_tmp77_ = k;
						_tmp78_ = y[_tmp77_];
						_tmp79_ = _tmp74_[(_tmp76_ * _tmp74__length2) + _tmp78_];
						if (_tmp79_) {
							continue;
						}
						_tmp80_ = sol;
						_tmp80__length1 = sol_length1;
						_tmp80__length2 = sol_length2;
						_tmp81_ = k;
						_tmp82_ = x[_tmp81_];
						_tmp83_ = k;
						_tmp84_ = y[_tmp83_];
						_tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_] = TRUE;
						_tmp85_ = _tmp80_[(_tmp82_ * _tmp80__length2) + _tmp84_];
						_tmp86_ = presses_in_region;
						_tmp86__length1 = presses_in_region_length1;
						_tmp87_ = r;
						_tmp88_ = _tmp86_[_tmp87_];
						_tmp86_[_tmp87_] = _tmp88_ + 1;
						_tmp89_ = presses_left;
						presses_left = _tmp89_ - 1;
					}
					_tmp90_ = presses_left;
					if (_tmp90_ == 0) {
						break;
					}
				}
			}
		}
	}
	_tmp91_ = sol;
	_tmp91__length1 = sol_length1;
	_tmp91__length2 = sol_length2;
	if (result_length1) {
		*result_length1 = _tmp91__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp91__length2;
	}
	result = _tmp91_;
	presses_in_region = (g_free (presses_in_region), NULL);
	return result;
}


static void puzzle_generator_class_init (PuzzleGeneratorClass * klass) {
	puzzle_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PuzzleGeneratorPrivate));
	G_OBJECT_CLASS (klass)->finalize = puzzle_generator_finalize;
}


static void puzzle_generator_instance_init (PuzzleGenerator * self) {
	self->priv = PUZZLE_GENERATOR_GET_PRIVATE (self);
}


static void puzzle_generator_finalize (GObject * obj) {
	PuzzleGenerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_GENERATOR, PuzzleGenerator);
	self->priv->region_of = (g_free (self->priv->region_of), NULL);
	self->priv->region_size = (g_free (self->priv->region_size), NULL);
	G_OBJECT_CLASS (puzzle_generator_parent_class)->finalize (obj);
}


GType puzzle_generator_get_type (void) {
	static volatile gsize puzzle_generator_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleGenerator), 0, (GInstanceInitFunc) puzzle_generator_instance_init, NULL };
		GType puzzle_generator_type_id;
		puzzle_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "PuzzleGenerator", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_generator_type_id__volatile, puzzle_generator_type_id);
	}
	return puzzle_generator_type_id__volatile;
}



