/*
 * Decompiled with CFR 0.152.
 */
package pax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;

public class StringVisitor
implements ICOSVisitor {
    protected StringBuffer buf = new StringBuffer();
    boolean nodelim = false;

    @Override
    public Object visitFromNull(COSNull cOSNull) {
        if (this.nodelim) {
            this.buf.append(' ');
        }
        this.buf.append("null");
        this.nodelim = true;
        return this.buf;
    }

    @Override
    public Object visitFromBoolean(COSBoolean cOSBoolean) {
        if (this.nodelim) {
            this.buf.append(' ');
        }
        this.buf.append(cOSBoolean.getValue());
        this.nodelim = true;
        return this.buf;
    }

    @Override
    public Object visitFromInt(COSInteger cOSInteger) {
        if (this.nodelim) {
            this.buf.append(' ');
        }
        this.buf.append(cOSInteger.intValue());
        this.nodelim = true;
        return this.buf;
    }

    @Override
    public Object visitFromFloat(COSFloat cOSFloat) {
        String string;
        if (this.nodelim) {
            this.buf.append(' ');
        }
        if ((string = "" + cOSFloat.floatValue()).endsWith(".0")) {
            this.buf.append(string.substring(0, string.length() - ".0".length()));
        } else {
            this.buf.append(string);
        }
        this.nodelim = true;
        return this.buf;
    }

    @Override
    public Object visitFromName(COSName cOSName) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            cOSName.writePDF(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buf.append(byteArrayOutputStream.toString());
        this.nodelim = true;
        return this.buf;
    }

    @Override
    public Object visitFromString(COSString cOSString) {
        this.buf.append("\\<");
        this.buf.append(cOSString.getHexString());
        this.buf.append("\\>");
        this.nodelim = false;
        return this.buf;
    }

    @Override
    public Object visitFromArray(COSArray cOSArray) throws COSVisitorException {
        this.buf.append('[');
        this.nodelim = false;
        for (int i = 0; i < cOSArray.size(); ++i) {
            cOSArray.getObject(i).accept(this);
        }
        this.buf.append(']');
        this.nodelim = false;
        return this.buf;
    }

    @Override
    public Object visitFromDictionary(COSDictionary cOSDictionary) throws COSVisitorException {
        this.buf.append("<<");
        this.nodelim = false;
        for (COSName cOSName : cOSDictionary.keyList()) {
            COSBase cOSBase = cOSDictionary.getDictionaryObject(cOSName);
            cOSName.accept(this);
            cOSBase.accept(this);
        }
        this.buf.append(">>");
        this.nodelim = false;
        return this.buf;
    }

    @Override
    public Object visitFromStream(COSStream cOSStream) throws COSVisitorException {
        throw new COSVisitorException(new Exception("Unsupported stream object"));
    }

    @Override
    public Object visitFromDocument(COSDocument cOSDocument) throws COSVisitorException {
        throw new COSVisitorException(new Exception("Unsupported documetn object"));
    }
}

