/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.documentation.mdn.MdnApiNamespace;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.documentation.XmlDocumentationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlDocumentationProvider
implements DocumentationProvider {
    public static final ExtensionPointName<DocumentationProvider> SCRIPT_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.html.scriptDocumentationProvider");
    private final boolean myUseStyleProvider;
    @NonNls
    public static final String ELEMENT_ELEMENT_NAME = "element";
    @NonNls
    public static final String NBSP = ":&nbsp;";
    @NonNls
    public static final String BR = "<br>";

    public HtmlDocumentationProvider() {
        this(true);
    }

    public HtmlDocumentationProvider(boolean useStyleProvider) {
        this.myUseStyleProvider = useStyleProvider;
    }

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof SchemaPrefix) {
            return ((SchemaPrefix)element).getQuickNavigateInfo();
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String result = this.getUrlForHtml(element, originalElement);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result == null && styleProvider != null) {
            return styleProvider.getUrlFor(element, originalElement);
        }
        return result != null ? Collections.singletonList(result) : null;
    }

    @Nls
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        String result = this.generateDocForHtml(element, originalElement);
        if (result != null) {
            return result;
        }
        return this.generateDocFromStyleOrScript(element, originalElement);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        DocumentationProvider scriptProvider;
        MdnSymbolDocumentation documentation;
        if (object instanceof PsiElement && (documentation = this.getDocumentation((PsiElement)object, element)) != null) {
            return (PsiElement)object;
        }
        PsiElement result = (PsiElement)ObjectUtils.doIfNotNull((Object)this.findDescriptor(psiManager, object.toString(), element), PsiMetaData::getDeclaration);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result == null && styleProvider != null) {
            result = styleProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result == null && (scriptProvider = HtmlDocumentationProvider.getScriptDocumentationProvider()) != null) {
            result = scriptProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result == null && object instanceof String && element != null) {
            result = XmlDocumentationProvider.findDeclWithName((String)object, element);
        }
        return result;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        DocumentationProvider scriptProvider;
        if (editor == null) {
            HtmlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HtmlDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (contextElement instanceof XmlElement) {
            return null;
        }
        DocumentationProvider styleProvider = this.getStyleProvider();
        PsiElement result = null;
        if (HtmlDocumentationProvider.checkProvider(styleProvider)) {
            result = styleProvider.getCustomDocumentationElement(editor, file, contextElement, targetOffset);
        }
        if (result == null && HtmlDocumentationProvider.checkProvider(scriptProvider = HtmlDocumentationProvider.getScriptDocumentationProvider())) {
            result = scriptProvider.getCustomDocumentationElement(editor, file, contextElement, targetOffset);
        }
        return result;
    }

    @Contract(value="null->false")
    private static boolean checkProvider(@Nullable DocumentationProvider provider) {
        if (provider == null) {
            return false;
        }
        if (provider instanceof CompositeDocumentationProvider && ContainerUtil.or((Iterable)((CompositeDocumentationProvider)provider).getAllProviders(), p -> p instanceof HtmlDocumentationProvider)) {
            Logger.getInstance(HtmlDocumentationProvider.class).error("An 'HtmlDocumentationProvider' is most likely registered through 'com.intellij.documentationProvider' extension point instead of 'com.intellij.lang.documentationProvider'. Recurrent behaviour has been prevented.");
            return false;
        }
        return true;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        PsiElement result = (PsiElement)ObjectUtils.doIfNotNull((Object)this.findDescriptor(psiManager, link, context), PsiMetaData::getDeclaration);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result == null && styleProvider != null) {
            result = styleProvider.getDocumentationElementForLink(psiManager, link, context);
        }
        DocumentationProvider provider = HtmlDocumentationProvider.getScriptDocumentationProvider();
        if (result == null && provider != null && !DumbService.isDumb((Project)psiManager.getProject())) {
            result = provider.getDocumentationElementForLink(psiManager, link, context);
        }
        return result;
    }

    @Nls
    private String generateDocFromStyleOrScript(PsiElement element, PsiElement originalElement) {
        String result;
        String result2;
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (styleProvider != null && (result2 = styleProvider.generateDoc(element, originalElement)) != null) {
            return result2;
        }
        DocumentationProvider scriptProvider = HtmlDocumentationProvider.getScriptDocumentationProvider();
        if (scriptProvider != null && (result = scriptProvider.generateDoc(element, originalElement)) != null) {
            return result;
        }
        return null;
    }

    private String getUrlForHtml(PsiElement element, PsiElement originalElement) {
        return (String)ObjectUtils.doIfNotNull((Object)this.getDocumentation(element, originalElement), MdnSymbolDocumentation::getUrl);
    }

    private MdnSymbolDocumentation getDocumentation(PsiElement element, PsiElement originalElement) {
        PsiElement declaration;
        XmlTag tagContext = this.findTagContext(originalElement);
        if (tagContext != null && !(tagContext instanceof HtmlTag)) {
            return null;
        }
        MdnSymbolDocumentation result = MdnDocumentationKt.getHtmlMdnDocumentation(element, tagContext);
        if (result == null && tagContext == null && (declaration = (PsiElement)ObjectUtils.doIfNotNull((Object)this.findDescriptor(element.getManager(), element.getText(), originalElement), PsiMetaData::getDeclaration)) != null) {
            result = MdnDocumentationKt.getHtmlMdnDocumentation(declaration, null);
        }
        return result;
    }

    @Nls
    private String generateDocForHtml(PsiElement element, PsiElement originalElement) {
        MdnSymbolDocumentation documentation = this.getDocumentation(element, originalElement);
        if (documentation != null) {
            return documentation.getDocumentation(true, null);
        }
        if (element instanceof XmlEntityDecl) {
            XmlEntityDecl entityDecl = (XmlEntityDecl)element;
            return new XmlDocumentationProvider().findDocRightAfterElement(element, entityDecl.getName());
        }
        return null;
    }

    private PsiMetaData findDescriptor(PsiManager psiManager, String text, PsiElement context) {
        boolean isStdTag;
        if (context != null && (context.getNode() == null || context.getNode().getElementType() == XmlTokenType.XML_END_TAG_START || context.getParent() instanceof XmlText)) {
            return null;
        }
        String key = StringUtil.toLowerCase((String)text);
        boolean bl = isStdTag = key != null && (MdnDocumentationKt.getHtmlMdnTagDocumentation(MdnApiNamespace.Html, key) != null || MdnDocumentationKt.getHtmlMdnTagDocumentation(MdnApiNamespace.Svg, key) != null || MdnDocumentationKt.getHtmlMdnTagDocumentation(MdnApiNamespace.MathML, key) != null);
        if (isStdTag && !this.isAttributeContext(context)) {
            try {
                XmlTag tagFromText = XmlElementFactory.getInstance((Project)psiManager.getProject()).createTagFromText((CharSequence)("<" + key + " xmlns=\"http://www.w3.org/1999/xhtml\"/>"));
                return tagFromText.getDescriptor();
            }
            catch (IncorrectOperationException tagFromText) {}
        } else {
            XmlTag tagContext = this.findTagContext(context);
            if (tagContext != null) {
                XmlElementDescriptor tagDescriptor = tagContext.getDescriptor();
                return tagDescriptor != null ? tagDescriptor.getAttributeDescriptor(text, tagContext) : null;
            }
        }
        return null;
    }

    protected boolean isAttributeContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof XmlAttribute || context instanceof XmlToken && ((XmlToken)context).getTokenType() == XmlTokenType.XML_TAG_END) {
            return true;
        }
        return context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlAttribute;
    }

    protected XmlTag findTagContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlTag) {
            return (XmlTag)prevSibling;
        }
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
    }

    @Nullable
    private static DocumentationProvider getScriptDocumentationProvider() {
        return (DocumentationProvider)ContainerUtil.getFirstItem((List)SCRIPT_PROVIDER_EP_NAME.getExtensionList());
    }

    @Nullable
    private DocumentationProvider getStyleProvider() {
        if (!this.myUseStyleProvider) {
            return null;
        }
        Language cssLanguage = Language.findLanguageByID((String)"CSS");
        if (cssLanguage != null) {
            return LanguageDocumentation.INSTANCE.forLanguage(cssLanguage);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/util/documentation/HtmlDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

