/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class TestModeOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private final StringBuilder builder = new StringBuilder();
    private boolean myTransactionStarted;
    private final List<String> myWords = new SmartList();

    TestModeOptimizingSearchHelper() {
    }

    @Override
    public boolean doOptimizing() {
        return true;
    }

    private void append(@NotNull String word, @NotNull String prefix) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(1);
        }
        this.myWords.add(prefix + word);
        this.myTransactionStarted = true;
    }

    @Override
    protected void doAddSearchWordInCode(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(2);
        }
        this.append(word, "in code:");
    }

    @Override
    protected void doAddSearchWordInText(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(3);
        }
        this.append(word, "in text:");
    }

    @Override
    protected void doAddSearchWordInComments(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(4);
        }
        this.append(word, "in comments:");
    }

    @Override
    protected void doAddSearchWordInLiterals(@NotNull String word) {
        if (word == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(5);
        }
        this.append(word, "in literals:");
    }

    @Override
    public void endTransaction() {
        if (!this.myTransactionStarted) {
            return;
        }
        this.myTransactionStarted = false;
        super.endTransaction();
        Collections.sort(this.myWords);
        this.builder.append('[');
        boolean bar = false;
        for (String word : this.myWords) {
            if (bar) {
                this.builder.append('|');
            } else {
                bar = true;
            }
            this.builder.append(word);
        }
        this.builder.append(']');
        this.myWords.clear();
    }

    @Override
    public boolean isScannedSomething() {
        return false;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getFilesSetToScan() {
        assert (!this.myTransactionStarted);
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public String getSearchPlan() {
        assert (!this.myTransactionStarted);
        String plan = this.builder.toString();
        this.builder.setLength(0);
        String string = plan;
        if (string == null) {
            TestModeOptimizingSearchHelper.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/TestModeOptimizingSearchHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/TestModeOptimizingSearchHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesSetToScan";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchPlan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInCode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInComments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddSearchWordInLiterals";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

