// Source: https://github.com/atlassian/react-beautiful-dnd

export const getPercentage = ({
  startOfRange,
  endOfRange,
  current
}) => {
  const range = endOfRange - startOfRange;
  if (range === 0) {
    /**
     * Detected distance range of 0 in the auto scroller
     * This is unexpected and would cause a divide by 0 issue.
     * Not allowing an auto scroll
     */
    return 0;
  }
  const currentInRange = current - startOfRange;
  const percentage = currentInRange / range;
  return percentage;
};