/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.util.Iterator;
import java.util.NoSuchElementException;

class ObjectSet {
    private Hash hash;
    private Object[] table;
    private float loadFactor = 0.75f;
    private int limit;
    private int size;

    public ObjectSet() {
        this(new Hash(){

            @Override
            public boolean equals(Object object, Object object2) {
                return object.equals(object2);
            }

            @Override
            public int hashCodeFor(Object object) {
                return object.hashCode();
            }
        });
    }

    public ObjectSet(Hash hash) {
        this.hash = hash;
        this.table = new Object[11];
        this.limit = (int)((float)this.table.length * this.loadFactor);
    }

    public Object get(Object object) {
        int n = (this.hash.hashCodeFor(object) & Integer.MAX_VALUE) % this.table.length;
        while (this.table[n] != null) {
            if (this.hash.equals(object, this.table[n])) {
                return this.table[n];
            }
            n = (n + 1) % this.table.length;
        }
        return null;
    }

    public void put(Object object) {
        if (this.size + 1 > this.limit) {
            this.rehash(this.table.length * 2);
        }
        ++this.size;
        int n = (this.hash.hashCodeFor(object) & Integer.MAX_VALUE) % this.table.length;
        while (this.table[n] != null && !this.hash.equals(object, this.table[n])) {
            n = (n + 1) % this.table.length;
        }
        this.table[n] = object;
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public Iterator iterator() {
        return new Iterator(){
            int ptr = 0;
            Object next;

            @Override
            public boolean hasNext() {
                while (this.next == null && this.ptr < ObjectSet.this.table.length) {
                    this.next = ObjectSet.this.table[this.ptr++];
                }
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.next;
                this.next = null;
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void rehash(int n) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < this.table.length; ++i) {
            Object object = this.table[i];
            if (object == null) continue;
            int n2 = (this.hash.hashCodeFor(object) & Integer.MAX_VALUE) % objectArray.length;
            while (objectArray[n2] != null) {
                n2 = (n2 + 1) % objectArray.length;
            }
            objectArray[n2] = object;
        }
        this.table = objectArray;
        this.limit = (int)((float)this.table.length * this.loadFactor);
    }

    public static interface Hash {
        public int hashCodeFor(Object var1);

        public boolean equals(Object var1, Object var2);
    }
}

