﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/comprehendmedical/model/StartSNOMEDCTInferenceJobRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::ComprehendMedical::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartSNOMEDCTInferenceJobRequest::SerializePayload() const {
  JsonValue payload;

  if (m_inputDataConfigHasBeenSet) {
    payload.WithObject("InputDataConfig", m_inputDataConfig.Jsonize());
  }

  if (m_outputDataConfigHasBeenSet) {
    payload.WithObject("OutputDataConfig", m_outputDataConfig.Jsonize());
  }

  if (m_dataAccessRoleArnHasBeenSet) {
    payload.WithString("DataAccessRoleArn", m_dataAccessRoleArn);
  }

  if (m_jobNameHasBeenSet) {
    payload.WithString("JobName", m_jobName);
  }

  if (m_clientRequestTokenHasBeenSet) {
    payload.WithString("ClientRequestToken", m_clientRequestToken);
  }

  if (m_kMSKeyHasBeenSet) {
    payload.WithString("KMSKey", m_kMSKey);
  }

  if (m_languageCodeHasBeenSet) {
    payload.WithString("LanguageCode", LanguageCodeMapper::GetNameForLanguageCode(m_languageCode));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StartSNOMEDCTInferenceJobRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "ComprehendMedical_20181030.StartSNOMEDCTInferenceJob"));
  return headers;
}
