;;; py-ert-end-tests.el --- Just some more tests 

;; Copyright (C) 2011-2014  Andreas Roehler
;; Author: Andreas Roehler <andreas.roehler@online.de>
;; Keywords: languages, convenience

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file is generated by function from python-mode-utils.el - see in
;; directory devel. Edits here might not be persistent.

;;; Code:


(ert-deftest py-ert-end-of-block-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-block)
    (should (eq (char-before) ?s))))

(ert-deftest py-ert-end-of-clause-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-clause)
    (should (eq (char-before) ?s))))

(ert-deftest py-ert-end-of-block-or-clause-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-block-or-clause)
    (should (eq (char-before) ?s))))

(ert-deftest py-ert-end-of-def-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-def)
    (should (eq (char-before) ?2))))

(ert-deftest py-ert-end-of-class-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-class)
    (should (eq (char-before) ?2))))

(ert-deftest py-ert-end-of-def-or-class-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-def-or-class)
    (should (eq (char-before) ?2))))

(ert-deftest py-ert-end-of-if-block-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-if-block)
    (should (eq (char-before) ?s))))

(ert-deftest py-ert-end-of-try-block-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-try-block)
    (should (eq (char-before) ?s))))

(ert-deftest py-ert-end-of-minor-block-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-minor-block)
    (should (eq (char-before) ?s))))

(ert-deftest py-ert-end-of-for-block-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-for-block)
    (should (eq (char-before) ?s))))

(ert-deftest py-ert-end-of-top-level-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-top-level)
    (should (eq (char-before) ?2))))

(ert-deftest py-ert-end-of-statement-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-statement)
    (should (eq (char-before) ?:))))

(ert-deftest py-ert-end-of-expression-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-expression)
    (should (eq (char-before) ?r))))

(ert-deftest py-ert-end-of-partial-expression-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-partial-expression)
    (should (eq (char-before) ?r))))

(ert-deftest py-ert-end-of-block-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-block-bol)
    (should (eq (point) 140))))

(ert-deftest py-ert-end-of-clause-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-clause-bol)
    (should (eq (point) 140))))

(ert-deftest py-ert-end-of-block-or-clause-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-block-or-clause-bol)
    (should (eq (point) 140))))

(ert-deftest py-ert-end-of-def-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-def-bol)
    (should (eq (point) 175))))

(ert-deftest py-ert-end-of-class-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-class-bol)
    (should (eq (point) 175))))

(ert-deftest py-ert-end-of-def-or-class-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-def-or-class-bol)
    (should (eq (point) 175))))

(ert-deftest py-ert-end-of-if-block-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-if-block-bol)
    (should (eq (point) 140))))

(ert-deftest py-ert-end-of-try-block-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-try-block-bol)
    (should (eq (point) 140))))

(ert-deftest py-ert-end-of-minor-block-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-minor-block-bol)
    (should (eq (point) 140))))

(ert-deftest py-ert-end-of-for-block-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-for-block-bol)
    (should (eq (point) 140))))

(ert-deftest py-ert-end-of-top-level-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-top-level-bol)
    (should (eq (point) 175))))

(ert-deftest py-ert-end-of-statement-bol-test ()
  (py-test-with-temp-buffer
      "
# -*- coding: utf-8 -*-
class bar:
    def foo ():
        try:
            if True:
                for a in b:
                    pass
        except:
            block2
"
    (goto-char 103)
    (py-end-of-statement-bol)
    (should (eq (point) 115))))

(provide 'py-ert-end-tests)
;;; py-ert-end-tests.el ends here
