// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`DeleteObjects`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name containing the objects to delete.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must follow the format <code> <i>bucket-base-name</i>--<i>zone-id</i>--x-s3</code> (for example, <code> <i>amzn-s3-demo-bucket</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts, the destination bucket must be the Outposts access point ARN or the access point alias. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`delete(Delete)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::delete) / [`set_delete(Option<Delete>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::set_delete):<br>required: **true**<br><p>Container for the request.</p><br>
    ///   - [`mfa(impl Into<String>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::mfa) / [`set_mfa(Option<String>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::set_mfa):<br>required: **false**<br><p>The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled.</p> <p>When performing the <code>DeleteObjects</code> operation on an MFA delete enabled bucket, which attempts to delete the specified versioned objects, you must include an MFA token. If you don't provide an MFA token, the entire request will fail, even if there are non-versioned objects that you are trying to delete. If you provide an invalid token, whether there are versioned object keys in the request or not, the entire Multi-Object Delete request will fail. For information about MFA Delete, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete"> MFA Delete</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`bypass_governance_retention(bool)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::bypass_governance_retention) / [`set_bypass_governance_retention(Option<bool>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::set_bypass_governance_retention):<br>required: **false**<br><p>Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. To use this header, you must have the <code>s3:BypassGovernanceRetention</code> permission.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum-<i>algorithm</i> </code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>.</p> <p>For the <code>x-amz-checksum-<i>algorithm</i> </code> header, replace <code> <i>algorithm</i> </code> with the supported algorithm from the following list:</p> <ul>  <li>   <p><code>CRC32</code></p></li>  <li>   <p><code>CRC32C</code></p></li>  <li>   <p><code>CRC64NVME</code></p></li>  <li>   <p><code>SHA1</code></p></li>  <li>   <p><code>SHA256</code></p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If the individual checksum value you provide through <code>x-amz-checksum-<i>algorithm</i> </code> doesn't match the checksum algorithm you set through <code>x-amz-sdk-checksum-algorithm</code>, Amazon S3 fails the request with a <code>BadDigest</code> error.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p><br>
    /// - On success, responds with [`DeleteObjectsOutput`](crate::operation::delete_objects::DeleteObjectsOutput) with field(s):
    ///   - [`deleted(Option<Vec::<DeletedObject>>)`](crate::operation::delete_objects::DeleteObjectsOutput::deleted): <p>Container element for a successful delete. It identifies the object that was successfully deleted.</p>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::delete_objects::DeleteObjectsOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`errors(Option<Vec::<Error>>)`](crate::operation::delete_objects::DeleteObjectsOutput::errors): <p>Container for a failed delete action that describes the object that Amazon S3 attempted to delete and the error it encountered.</p>
    /// - On failure, responds with [`SdkError<DeleteObjectsError>`](crate::operation::delete_objects::DeleteObjectsError)
    pub fn delete_objects(&self) -> crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder {
        crate::operation::delete_objects::builders::DeleteObjectsFluentBuilder::new(self.handle.clone())
    }
}
