import { __InputStylesNames, BoxProps, Factory, InputVariant, MantineComponentStaticProperties, StylesApiProps } from '@mantine/core';
import { DatePickerType } from '../../types';
import { CalendarStylesNames } from '../Calendar';
import { DatePickerBaseProps } from '../DatePicker';
import { DateInputSharedProps } from '../PickerInputBase';
export type DatePickerInputStylesNames = __InputStylesNames | 'placeholder' | CalendarStylesNames;
export interface DatePickerInputProps<Type extends DatePickerType = 'default'> extends BoxProps, DateInputSharedProps, DatePickerBaseProps<Type>, StylesApiProps<DatePickerInputFactory> {
    /** Dayjs format to display input value, "MMMM D, YYYY" by default  */
    valueFormat?: string;
}
export type DatePickerInputFactory = Factory<{
    props: DatePickerInputProps;
    ref: HTMLButtonElement;
    stylesNames: DatePickerInputStylesNames;
    variant: InputVariant;
}>;
type DatePickerInputComponent = (<Type extends DatePickerType = 'default'>(props: DatePickerInputProps<Type> & {
    ref?: React.ForwardedRef<HTMLButtonElement>;
}) => React.JSX.Element) & {
    displayName?: string;
} & MantineComponentStaticProperties<DatePickerInputFactory>;
export declare const DatePickerInput: DatePickerInputComponent;
export {};
