/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Damien
	CALISTE, laboratoire L_Sim, (2017)
  
	Adresse mèl :
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant à visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est régi par la licence CeCILL soumise au droit français et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accepté les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Damien
	CALISTE, laboratoire L_Sim, (2017)

	E-mail address:
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef TOOL_POOL_H
#define TOOL_POOL_H

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

/**
 * TOOL_TYPE_POOL:
 *
 * return the type of #ToolDataAtomic.
 */
#define TOOL_TYPE_POOL	     (tool_pool_get_type ())
/**
 * TOOL_POOL:
 * @obj: a #GObject to cast.
 *
 * Cast the given @obj into #ToolDataAtomic type.
 */
#define TOOL_POOL(obj)	     (G_TYPE_CHECK_INSTANCE_CAST(obj, TOOL_TYPE_POOL, ToolPool))
/**
 * TOOL_POOL_CLASS:
 * @klass: a #GObjectClass to cast.
 *
 * Cast the given @klass into #ToolPoolClass.
 */
#define TOOL_POOL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST(klass, TOOL_TYPE_POOL, ToolPoolClass))
/**
 * TOOL_IS_POOL:
 * @obj: a #GObject to test.
 *
 * Test if the given @ogj is of the type of #ToolPool object.
 */
#define TOOL_IS_POOL(obj)    (G_TYPE_CHECK_INSTANCE_TYPE(obj, TOOL_TYPE_POOL))
/**
 * TOOL_IS_POOL_CLASS:
 * @klass: a #GObjectClass to test.
 *
 * Test if the given @klass is of the type of #ToolPoolClass class.
 */
#define TOOL_IS_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE(klass, TOOL_TYPE_POOL))
/**
 * TOOL_POOL_GET_CLASS:
 * @obj: a #GObject to get the class of.
 *
 * It returns the class of the given @obj.
 */
#define TOOL_POOL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS(obj, TOOL_TYPE_POOL, ToolPoolClass))

typedef struct _ToolPoolPrivate ToolPoolPrivate;
typedef struct _ToolPool ToolPool;
struct _ToolPool
{
  GObject parent;

  ToolPoolPrivate *priv;
};

/**
 * ToolPoolClass:
 * @parent: the parent class.
 *
 * A short way to identify #_ToolPoolClass structure.
 */
typedef struct _ToolPoolClass ToolPoolClass;
struct _ToolPoolClass
{
  GObjectClass parent;
};

/**
 * tool_pool_get_type:
 *
 * This method returns the type of #ToolPool, use TOOL_TYPE_POOL instead.
 *
 * Returns: the type of #ToolPool.
 */
GType tool_pool_get_type(void);


ToolPool* tool_pool_new(GType type, GCompareFunc compare);

gpointer tool_pool_add(ToolPool *pool, gconstpointer boxed);
gpointer tool_pool_take(ToolPool *pool, gpointer boxed);
GList* tool_pool_asList(ToolPool *pool);
gpointer tool_pool_getById(ToolPool *pool, guint num);
gpointer tool_pool_getByData(ToolPool *pool, gconstpointer boxed);
gint tool_pool_index(ToolPool *pool, gconstpointer boxed);

G_END_DECLS

#endif
