# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage Class Access Mode."""

    READ_WRITE_ONCE = "ReadWriteOnce"
    """Read Write Once (RWO) access mode"""
    READ_WRITE_MANY = "ReadWriteMany"
    """Read Write Many (RWX) access mode"""


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AdvertiseMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of advertise mode."""

    ARP = "ARP"
    """ARP advertise mode"""
    BGP = "BGP"
    """BGP advertise mode"""
    BOTH = "Both"
    """both ARP and BGP advertise mode"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DataResilienceTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data resilience tier of a storage class."""

    NOT_DATA_RESILIENT = "NotDataResilient"
    """Not data resilient"""
    DATA_RESILIENT = "DataResilient"
    """Data resilient"""


class FailoverTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Failover tier of a storage class."""

    NOT_AVAILABLE = "NotAvailable"
    """Not available Failover Tier"""
    SLOW = "Slow"
    """Slow Failover Tier"""
    FAST = "Fast"
    """Fast Failover Tier"""
    SUPER = "Super"
    """Super Failover Tier"""


class NfsDirectoryActionOnVolumeDeletion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action to take when a NFS volume is deleted."""

    DELETE = "Delete"
    """When the volume is deleted, delete the directory"""
    RETAIN = "Retain"
    """When the volume is deleted, retain the directory"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PerformanceTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Performance tier of a storage class."""

    UNDEFINED = "Undefined"
    """Undefined Performance Tier"""
    BASIC = "Basic"
    """Basic Performance Tier"""
    STANDARD = "Standard"
    """Standard Performance Tier"""
    PREMIUM = "Premium"
    """Premium Performance Tier"""
    ULTRA = "Ultra"
    """Ultra Performance Tier"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """Initial provisioning in progress"""
    UPDATING = "Updating"
    """Update in progress"""
    DELETING = "Deleting"
    """Deletion in progress"""
    ACCEPTED = "Accepted"
    """Change accepted for processing"""


class SCType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of a storage class."""

    NATIVE = "Native"
    """Native storage class"""
    RWX = "RWX"
    """RWX storage class"""
    BLOB = "Blob"
    """Blob storage class"""
    NFS = "NFS"
    """NFS storage class"""
    SMB = "SMB"
    """SMB storage class"""


class VolumeBindingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Storage class volume binding mode."""

    IMMEDIATE = "Immediate"
    """Immediate binding mode"""
    WAIT_FOR_FIRST_CONSUMER = "WaitForFirstConsumer"
    """Wait for first consumer binding mode"""


class VolumeExpansion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Ability to expand volumes of a storage class."""

    ALLOW = "Allow"
    """Allow volume expansion"""
    DISALLOW = "Disallow"
    """Disallow volume expansion"""
