/* GreeterWidget.c generated by valac 0.56.17, the Vala compiler
 * generated from GreeterWidget.vala, do not modify */

/*
 * Copyright (c) 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "a11y.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <glib-object.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtkx.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	A11_Y_GREETER_WIDGET_0_PROPERTY,
	A11_Y_GREETER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* a11_y_greeter_widget_properties[A11_Y_GREETER_WIDGET_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

struct _A11YGreeterWidgetPrivate {
	GKeyFile* settings;
	GtkWindow* keyboard_window;
	gint status;
	gint reader_pid;
	gint keyboard_pid;
};

struct _Block1Data {
	int _ref_count_;
	A11YGreeterWidget* self;
	GraniteSwitchModelButton* onscreen_keyboard;
};

static gint A11YGreeterWidget_private_offset;
static gpointer a11_y_greeter_widget_parent_class = NULL;

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void a11_y_greeter_widget_toggle_keyboard (A11YGreeterWidget* self,
                                           gboolean active);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void a11_y_greeter_widget_finalize (GObject * obj);
static GType a11_y_greeter_widget_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
a11_y_greeter_widget_get_instance_private (A11YGreeterWidget* self)
{
	return G_STRUCT_MEMBER_P (self, A11YGreeterWidget_private_offset);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		A11YGreeterWidget* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->onscreen_keyboard);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_)
{
	A11YGreeterWidget* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data1_->self;
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) _data1_->onscreen_keyboard);
	_tmp1_ = _tmp0_;
	a11_y_greeter_widget_toggle_keyboard (self, _tmp1_);
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ (self);
}

A11YGreeterWidget*
a11_y_greeter_widget_construct (GType object_type)
{
	A11YGreeterWidget * self = NULL;
	Block1Data* _data1_;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gint position = 0;
	GraniteSwitchModelButton* screen_reader = NULL;
	GraniteSwitchModelButton* _tmp2_;
	GraniteSwitchModelButton* _tmp3_;
	gint _tmp4_;
	GSettings* applications_settings = NULL;
	GSettings* _tmp5_;
	GraniteSwitchModelButton* _tmp6_ = NULL;
	GraniteSwitchModelButton* _tmp7_;
	gint _tmp8_;
	GError* _inner_error0_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	self = (A11YGreeterWidget*) g_object_new (object_type, NULL);
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_key_file_set_boolean (_tmp1_, "greeter", "onscreen-keyboard", FALSE);
	position = 0;
	_tmp2_ = granite_switch_model_button_new (_ ("Screen Reader"));
	g_object_ref_sink (_tmp2_);
	screen_reader = _tmp2_;
	_tmp3_ = screen_reader;
	_tmp4_ = position;
	position = _tmp4_ + 1;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp3_, 0, _tmp4_, 1, 1);
	_tmp5_ = g_settings_new ("org.gnome.desktop.a11y.applications");
	applications_settings = _tmp5_;
	g_settings_bind (applications_settings, "screen-reader-enabled", (GObject*) screen_reader, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = granite_switch_model_button_new (_ ("Onscreen Keyboard"));
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp6_, FALSE);
	g_object_ref_sink (_tmp6_);
	_data1_->onscreen_keyboard = _tmp6_;
	g_signal_connect_data ((GObject*) _data1_->onscreen_keyboard, "notify::active", (GCallback) ___lambda4__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp7_ = _data1_->onscreen_keyboard;
	_tmp8_ = position;
	position = _tmp8_ + 1;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp7_, 0, _tmp8_, 1, 1);
	{
		gboolean _tmp9_ = FALSE;
		GKeyFile* _tmp10_;
		_tmp10_ = self->priv->settings;
		_tmp9_ = g_key_file_get_boolean (_tmp10_, "greeter", "onscreen-keyboard", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) _data1_->onscreen_keyboard, _tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("GreeterWidget.vala:50: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (applications_settings);
		_g_object_unref0 (screen_reader);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_object_unref0 (applications_settings);
	_g_object_unref0 (screen_reader);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

A11YGreeterWidget*
a11_y_greeter_widget_new (void)
{
	return a11_y_greeter_widget_construct (A11_Y_TYPE_GREETER_WIDGET);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
a11_y_greeter_widget_toggle_keyboard (A11YGreeterWidget* self,
                                      gboolean active)
{
	GtkWindow* _tmp0_;
	gint id = 0;
	gint onboard_stdout_fd = 0;
	GtkSocket* keyboard_socket = NULL;
	GtkSocket* _tmp15_;
	GtkWindow* _tmp16_;
	GtkWindow* _tmp17_;
	GtkWindow* _tmp18_;
	GtkWindow* _tmp19_;
	GtkWindow* _tmp20_;
	GtkSocket* _tmp21_;
	GtkSocket* _tmp22_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp23_;
	GdkDisplay* _tmp24_;
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp25_;
	GdkMonitor* _tmp26_;
	GdkMonitor* _tmp27_;
	gint keyboard_width = 0;
	gint keyboard_height = 0;
	GdkRectangle geom = {0};
	GdkMonitor* _tmp28_;
	GdkRectangle _tmp29_ = {0};
	GtkWindow* _tmp30_;
	GdkRectangle _tmp31_;
	GdkRectangle _tmp32_;
	GtkWindow* _tmp33_;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	GtkWindow* _tmp36_;
	GdkRectangle _tmp37_;
	GdkRectangle _tmp38_;
	GdkRectangle _tmp39_;
	GtkWindow* _tmp40_;
	GtkWindow* _tmp41_;
	GKeyFile* _tmp42_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->keyboard_window;
	if (_tmp0_ != NULL) {
		GtkWindow* _tmp1_;
		GKeyFile* _tmp2_;
		_tmp1_ = self->priv->keyboard_window;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, active);
		_tmp2_ = self->priv->settings;
		g_key_file_set_boolean (_tmp2_, "greeter", "onscreen-keyboard", active);
		return;
	}
	id = 0;
	{
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gchar** _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gchar** _tmp5_;
		gint _tmp5__length1;
		GPid _tmp6_ = 0;
		gint _tmp7_ = 0;
		FILE* f = NULL;
		FILE* _tmp8_;
		gchar* stdout_text = NULL;
		gchar* _tmp9_;
		gint stdout_text_length1;
		gint _stdout_text_size_;
		FILE* _tmp10_;
		gchar* _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gint _tmp12__length1;
		g_shell_parse_argv ("onboard --xid", &_tmp4_, &_tmp3_, &_inner_error0_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		argv = _tmp3_;
		argv_length1 = _tmp4_;
		_argv_size_ = argv_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		_tmp5_ = argv;
		_tmp5__length1 = argv_length1;
		g_spawn_async_with_pipes (NULL, _tmp5_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp6_, NULL, &_tmp7_, NULL, &_inner_error0_);
		self->priv->keyboard_pid = (gint) _tmp6_;
		onboard_stdout_fd = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		_tmp8_ = fdopen (onboard_stdout_fd, "r");
		f = _tmp8_;
		_tmp9_ = g_new0 (gchar, 1024);
		stdout_text = _tmp9_;
		stdout_text_length1 = 1024;
		_stdout_text_size_ = stdout_text_length1;
		_tmp10_ = f;
		_tmp11_ = stdout_text;
		_tmp11__length1 = stdout_text_length1;
		fgets (_tmp11_, (gint) _tmp11__length1, _tmp10_);
		_tmp12_ = stdout_text;
		_tmp12__length1 = stdout_text_length1;
		id = atoi ((const gchar*) _tmp12_);
		stdout_text = (g_free (stdout_text), NULL);
		_fclose0 (f);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("GreeterWidget.vala:89: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp15_ = (GtkSocket*) gtk_socket_new ();
	g_object_ref_sink (_tmp15_);
	keyboard_socket = _tmp15_;
	_tmp16_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->keyboard_window);
	self->priv->keyboard_window = _tmp16_;
	_tmp17_ = self->priv->keyboard_window;
	gtk_window_set_type_hint (_tmp17_, GDK_WINDOW_TYPE_HINT_DOCK);
	_tmp18_ = self->priv->keyboard_window;
	gtk_window_set_accept_focus (_tmp18_, FALSE);
	_tmp19_ = self->priv->keyboard_window;
	gtk_window_set_focus_on_map (_tmp19_, FALSE);
	_tmp20_ = self->priv->keyboard_window;
	_tmp21_ = keyboard_socket;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = keyboard_socket;
	gtk_socket_add_id (_tmp22_, (Window) id);
	_tmp23_ = gdk_display_get_default ();
	_tmp24_ = _g_object_ref0 (_tmp23_);
	display = _tmp24_;
	_tmp25_ = display;
	_tmp26_ = gdk_display_get_primary_monitor (_tmp25_);
	_tmp27_ = _g_object_ref0 (_tmp26_);
	monitor = _tmp27_;
	_tmp28_ = monitor;
	gdk_monitor_get_geometry (_tmp28_, &_tmp29_);
	geom = _tmp29_;
	_tmp30_ = self->priv->keyboard_window;
	_tmp31_ = geom;
	_tmp32_ = geom;
	gtk_window_resize (_tmp30_, _tmp31_.width / 2, _tmp32_.height / 4);
	_tmp33_ = self->priv->keyboard_window;
	gtk_window_get_size (_tmp33_, &_tmp34_, &_tmp35_);
	keyboard_width = _tmp34_;
	keyboard_height = _tmp35_;
	_tmp36_ = self->priv->keyboard_window;
	_tmp37_ = geom;
	_tmp38_ = geom;
	_tmp39_ = geom;
	gtk_window_move (_tmp36_, _tmp37_.x + (keyboard_width / 2), _tmp38_.y + (_tmp39_.height - keyboard_height));
	_tmp40_ = self->priv->keyboard_window;
	gtk_window_set_keep_above (_tmp40_, TRUE);
	_tmp41_ = self->priv->keyboard_window;
	gtk_widget_show_all ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->settings;
	g_key_file_set_boolean (_tmp42_, "greeter", "onscreen-keyboard", TRUE);
	_g_object_unref0 (monitor);
	_g_object_unref0 (display);
	_g_object_unref0 (keyboard_socket);
}

static void
a11_y_greeter_widget_class_init (A11YGreeterWidgetClass * klass,
                                 gpointer klass_data)
{
	a11_y_greeter_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &A11YGreeterWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = a11_y_greeter_widget_finalize;
}

static void
a11_y_greeter_widget_instance_init (A11YGreeterWidget * self,
                                    gpointer klass)
{
	self->priv = a11_y_greeter_widget_get_instance_private (self);
}

static void
a11_y_greeter_widget_finalize (GObject * obj)
{
	A11YGreeterWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, A11_Y_TYPE_GREETER_WIDGET, A11YGreeterWidget);
	if (self->priv->keyboard_pid != 0) {
		gint _tmp0_ = 0;
		kill ((pid_t) self->priv->keyboard_pid, (gint) SIGKILL);
		waitpid ((pid_t) self->priv->keyboard_pid, &_tmp0_, 0);
		self->priv->status = _tmp0_;
		self->priv->keyboard_pid = 0;
	}
	if (self->priv->reader_pid != 0) {
		gint _tmp1_ = 0;
		kill ((pid_t) self->priv->reader_pid, (gint) SIGKILL);
		waitpid ((pid_t) self->priv->reader_pid, &_tmp1_, 0);
		self->priv->status = _tmp1_;
		self->priv->reader_pid = 0;
	}
	_g_key_file_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->keyboard_window);
	G_OBJECT_CLASS (a11_y_greeter_widget_parent_class)->finalize (obj);
}

static GType
a11_y_greeter_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (A11YGreeterWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) a11_y_greeter_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (A11YGreeterWidget), 0, (GInstanceInitFunc) a11_y_greeter_widget_instance_init, NULL };
	GType a11_y_greeter_widget_type_id;
	a11_y_greeter_widget_type_id = g_type_register_static (gtk_grid_get_type (), "A11YGreeterWidget", &g_define_type_info, 0);
	A11YGreeterWidget_private_offset = g_type_add_instance_private (a11_y_greeter_widget_type_id, sizeof (A11YGreeterWidgetPrivate));
	return a11_y_greeter_widget_type_id;
}

GType
a11_y_greeter_widget_get_type (void)
{
	static volatile gsize a11_y_greeter_widget_type_id__once = 0;
	if (g_once_init_enter (&a11_y_greeter_widget_type_id__once)) {
		GType a11_y_greeter_widget_type_id;
		a11_y_greeter_widget_type_id = a11_y_greeter_widget_get_type_once ();
		g_once_init_leave (&a11_y_greeter_widget_type_id__once, a11_y_greeter_widget_type_id);
	}
	return a11_y_greeter_widget_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

