/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_CLIENT_PROTOCOL_H
#define TREELAND_SHORTCUT_MANAGER_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_shortcut_manager_v2 The treeland_shortcut_manager_v2 protocol
 * @section page_ifaces_treeland_shortcut_manager_v2 Interfaces
 * - @subpage page_iface_treeland_shortcut_manager_v2 - global shortcuts manager for treeland
 * @section page_copyright_treeland_shortcut_manager_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024-2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_shortcut_manager_v2;

#ifndef TREELAND_SHORTCUT_MANAGER_V2_INTERFACE
#define TREELAND_SHORTCUT_MANAGER_V2_INTERFACE
/**
 * @page page_iface_treeland_shortcut_manager_v2 treeland_shortcut_manager_v2
 * @section page_iface_treeland_shortcut_manager_v2_desc Description
 *
 * This interface allows privileged clients to register global shortcuts.
 *
 * In treeland, global shortcuts are managed in a per-user context.
 * Shortcuts for different users are isolated, and will not interfere with each other.
 * This allows multiple users to use their own set of global Shortcuts
 * on the same system without conflicts.
 * This behavior is transparent to the clients of this interface (i.e
 * the user context used by this protocol is the same as that of the client.)
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_shortcut_manager_v2_api API
 * See @ref iface_treeland_shortcut_manager_v2.
 */
/**
 * @defgroup iface_treeland_shortcut_manager_v2 The treeland_shortcut_manager_v2 interface
 *
 * This interface allows privileged clients to register global shortcuts.
 *
 * In treeland, global shortcuts are managed in a per-user context.
 * Shortcuts for different users are isolated, and will not interfere with each other.
 * This allows multiple users to use their own set of global Shortcuts
 * on the same system without conflicts.
 * This behavior is transparent to the clients of this interface (i.e
 * the user context used by this protocol is the same as that of the client.)
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_shortcut_manager_v2_interface;
#endif

#ifndef TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM
enum treeland_shortcut_manager_v2_direction {
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_DOWN = 1,
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_LEFT = 2,
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_UP = 3,
	TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_RIGHT = 4,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_DIRECTION_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * compositor actions
 *
 * Compositor actions that can be assigned to a shortcut.
 */
enum treeland_shortcut_manager_v2_action {
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_NOTIFY = 1,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_1 = 2,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_2 = 3,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_3 = 4,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_4 = 5,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_5 = 6,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_WORKSPACE_6 = 7,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_PREV_WORKSPACE = 8,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_NEXT_WORKSPACE = 9,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHOW_DESKTOP = 10,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_MAXIMIZE = 11,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_CANCEL_MAXIMIZE = 12,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_MOVE_WINDOW = 13,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_CLOSE_WINDOW = 14,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHOW_WINDOW_MENU = 15,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_OPEN_MULTITASK_VIEW = 16,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_CLOSE_MULTITASK_VIEW = 17,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TOGGLE_MULTITASK_VIEW = 18,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TOGGLE_FPS_DISPLAY = 19,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_LOCKSCREEN = 20,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_SHUTDOWN_MENU = 21,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_QUIT = 22,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_ENTER = 23,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_NEXT = 24,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_PREV = 25,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_SAMEAPP_NEXT = 26,
	TREELAND_SHORTCUT_MANAGER_V2_ACTION_TASKSWITCH_SAMEAPP_PREV = 27,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_ACTION_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_FLAG_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_FLAG_ENUM
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * keybinding flags
 *
 * Flags to specify the keybinding mode.
 * with key_press, the action is triggered on key press.
 * with key_release, the action is triggered on key release.
 * with repeat, the action is repeatedly triggered if the key is held down.
 *
 * Examples:
 * key_press | repeat: the action is triggered on key press, and repeatedly
 * triggered if the key is held down.
 * key_press | key_release: the action is triggered on both key press and
 * key release, auto-repeated events are ignored.
 * key_press | key_release | repeat: note that treeland repeats both key
 * press and key release events.
 */
enum treeland_shortcut_manager_v2_keybind_flag {
	/**
	 * bind key press events
	 */
	TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_FLAG_KEY_PRESS = 0x1,
	/**
	 * bind key release events
	 */
	TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_FLAG_KEY_RELEASE = 0x2,
	/**
	 * bind autorepeat events.
	 */
	TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_FLAG_REPEAT = 0x4,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_KEYBIND_FLAG_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * binding error codes
 *
 * Error codes indicating the reason of a binding failure.
 */
enum treeland_shortcut_manager_v2_bind_error {
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_NAME_CONFLICT = 1,
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_DUPLICATE_BINDING = 2,
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_INVALID_ARGUMENT = 3,
	TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_INTERNAL_ERROR = 4,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_BIND_ERROR_ENUM */

#ifndef TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM
#define TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM
enum treeland_shortcut_manager_v2_error {
	TREELAND_SHORTCUT_MANAGER_V2_ERROR_OCCUPIED = 1,
	TREELAND_SHORTCUT_MANAGER_V2_ERROR_NOT_ACQUIRED = 2,
	TREELAND_SHORTCUT_MANAGER_V2_ERROR_INVALID_COMMIT = 3,
};
#endif /* TREELAND_SHORTCUT_MANAGER_V2_ERROR_ENUM */

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 * @struct treeland_shortcut_manager_v2_listener
 */
struct treeland_shortcut_manager_v2_listener {
	/**
	 * a shortcut has been activated
	 *
	 * This event is emitted when a binding registered with action
	 * `notify` is activated.
	 *
	 * the flags argument indicates the type of key event as defined in
	 * keybind_flag enum.
	 * @param name binding id of the activated shortcut
	 * @param flags flags for the key event
	 */
	void (*activated)(void *data,
			  struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2,
			  const char *name,
			  uint32_t flags);
	/**
	 * the last commit was successful
	 *
	 * This event is emitted in response to a commit request,
	 * indicating that the commit was successful.
	 */
	void (*commit_success)(void *data,
			       struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2);
	/**
	 * the last commit has failed
	 *
	 * This event is emitted in response to a commit request,
	 * indicating that the commit has failed.
	 *
	 * The error argument indicates the first error that caused the
	 * commit to fail.
	 * @param name binding name that caused the failure
	 * @param error error code indicating the reason of the failure
	 */
	void (*commit_failure)(void *data,
			       struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2,
			       const char *name,
			       uint32_t error);
};

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
static inline int
treeland_shortcut_manager_v2_add_listener(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2,
					  const struct treeland_shortcut_manager_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_shortcut_manager_v2,
				     (void (**)(void)) listener, data);
}

#define TREELAND_SHORTCUT_MANAGER_V2_DESTROY 0
#define TREELAND_SHORTCUT_MANAGER_V2_ACQUIRE 1
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_KEY 2
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_SWIPE_GESTURE 3
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_HOLD_GESTURE 4
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT 5
#define TREELAND_SHORTCUT_MANAGER_V2_UNBIND 6

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_ACTIVATED_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_SUCCESS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_FAILURE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_ACQUIRE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_SWIPE_GESTURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_BIND_HOLD_GESTURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_shortcut_manager_v2
 */
#define TREELAND_SHORTCUT_MANAGER_V2_UNBIND_SINCE_VERSION 1

/** @ingroup iface_treeland_shortcut_manager_v2 */
static inline void
treeland_shortcut_manager_v2_set_user_data(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_shortcut_manager_v2, user_data);
}

/** @ingroup iface_treeland_shortcut_manager_v2 */
static inline void *
treeland_shortcut_manager_v2_get_user_data(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_shortcut_manager_v2);
}

static inline uint32_t
treeland_shortcut_manager_v2_get_version(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 *
 * Destroy the shortcut manager.
 * Existing shortcuts created through this interface remain valid.
 */
static inline void
treeland_shortcut_manager_v2_destroy(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_shortcut_manager_v2,
			 TREELAND_SHORTCUT_MANAGER_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 *
 * Acquire the shortcut manager for the current client.
 *
 * This request must be sent before any bind/unbind request can be performed.
 *
 * Only one client hold exclusive control of the shortcut manager at a time,
 * for a given session.
 * If the shortcut manager is already acquired by another client, an protocol error
 */
static inline void
treeland_shortcut_manager_v2_acquire(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_shortcut_manager_v2,
			 TREELAND_SHORTCUT_MANAGER_V2_ACQUIRE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2), 0);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 *
 * Bind a key sequence to a compositor action.
 *
 * The key sequence is specified in the string format used by QKeySequence,
 * see https://doc.qt.io/qt-6/qkeysequence.html#toString for details.
 *
 * Sending this request without first acquiring the shortcut manager
 * will result in a `not_acquired` protocol error.
 *
 * The name argument must be unique among all existing bindings.
 * If a binding with the same name already exists, the bind_key request will fail.
 *
 * The action argument specifies the compositor action to be executed
 * when the key sequence is activated.
 *
 * Each keybind has a flags argument to specify the exact condition of triggering,
 * see documentation of keybind_flag enum for details.
 *
 * If a binding with the same key sequence and action already exists,
 * its flags will be updated to the new value.
 *
 * Note that the binding will not take effect until a commit request is sent.
 */
static inline void
treeland_shortcut_manager_v2_bind_key(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2, const char *name, const char *key, uint32_t flags, uint32_t action)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_shortcut_manager_v2,
			 TREELAND_SHORTCUT_MANAGER_V2_BIND_KEY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2), 0, name, key, flags, action);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 *
 * Bind a swipe gesture to a compositor action.
 *
 * Sending this request without first acquiring the shortcut manager
 * will result in a `not_acquired` protocol error.
 *
 * The name argument must be unique among all existing bindings.
 * If a binding with the same name already exists, the bind_swipe_gesture request will fail.
 *
 * The direction argument specifies the direction towards which the swipe gesture must be performed.
 * If this argument is not one of the defined enum values, the bind_swipe_gesture request will fail.
 *
 * The action argument specifies the compositor action to be executed
 * when the swipe gesture is activated.
 * If a binding with the same gesture and action already exists,
 * the bind_swipe_gesture request will fail.
 *
 * Note that the binding will not take effect until a commit request is sent.
 */
static inline void
treeland_shortcut_manager_v2_bind_swipe_gesture(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2, const char *name, uint32_t finger, uint32_t direction, uint32_t action)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_shortcut_manager_v2,
			 TREELAND_SHORTCUT_MANAGER_V2_BIND_SWIPE_GESTURE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2), 0, name, finger, direction, action);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 *
 * Bind a hold gesture to a compositor action.
 *
 * Sending this request without first acquiring the shortcut manager
 * will result in a `not_acquired` protocol error.
 *
 * The name argument must be unique among all existing bindings.
 * If a binding with the same name already exists, the bind_hold_gesture request will fail.
 *
 * The action argument specifies the compositor action to be executed
 * when the hold gesture is activated.
 * If a binding with the same gesture and action already exists,
 * the bind_hold_gesture request will fail.
 *
 * Note that the binding will not take effect until a commit request is sent.
 */
static inline void
treeland_shortcut_manager_v2_bind_hold_gesture(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2, const char *name, uint32_t finger, uint32_t action)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_shortcut_manager_v2,
			 TREELAND_SHORTCUT_MANAGER_V2_BIND_HOLD_GESTURE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2), 0, name, finger, action);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 *
 * Commit the pending bindings.
 *
 * This request applies all the bind_key, bind_swipe_gesture and bind_hold_gesture
 * requests sent since the last commit.
 *
 * After processing this request, the compositor will emit a `commit_status` event
 * if the commit was successful or `commit_failure` event if the commit failed.
 *
 * On a successful commit, all the pending bindings will take effect.
 * On a failed commit, none of the pending bindings will take effect.
 *
 * Sending this request without first acquiring the shortcut manager
 * will result in a `not_acquired` protocol error.
 *
 * Sending further commit requests before `commit_success` or `commit_failure`
 * is sent is a protocol error.
 */
static inline void
treeland_shortcut_manager_v2_commit(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_shortcut_manager_v2,
			 TREELAND_SHORTCUT_MANAGER_V2_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2), 0);
}

/**
 * @ingroup iface_treeland_shortcut_manager_v2
 *
 * Remove an existing binding.
 *
 * The binding to be removed is identified by its unique name.
 * If no binding with the specified name exists, the unbind request has no effect.
 */
static inline void
treeland_shortcut_manager_v2_unbind(struct treeland_shortcut_manager_v2 *treeland_shortcut_manager_v2, const char *name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_shortcut_manager_v2,
			 TREELAND_SHORTCUT_MANAGER_V2_UNBIND, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_shortcut_manager_v2), 0, name);
}

#ifdef  __cplusplus
}
#endif

#endif
