/* rygel-import-resource.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-import-resource.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-server.h"
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;
enum  {
	RYGEL_IMPORT_RESOURCE_0_PROPERTY,
	RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY,
	RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY,
	RYGEL_IMPORT_RESOURCE_NUM_PROPERTIES
};
static GParamSpec* rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY_ERROR (rygel_content_directory_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _RygelImportResourceRunData RygelImportResourceRunData;
typedef struct _RygelImportResourceFetchItemData RygelImportResourceFetchItemData;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelImportResourcePrivate {
	RygelMediaFileItem* item;
	SoupSession* session;
	GCancellable* _cancellable;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GUPnPServiceAction* action;
	GFileOutputStream* output_stream;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()

struct _RygelImportResourceRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelImportResource* self;
	GUPnPServiceAction* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GUPnPServiceAction* _tmp7_;
	RygelMediaFileItem* _tmp8_;
	RygelMediaFileItem* _tmp9_;
	RygelMediaFileItem* _tmp10_;
	GError* _error_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GUPnPServiceAction* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp18_;
	RygelObjectRemovalQueue* _tmp19_;
	RygelMediaFileItem* _tmp20_;
	GFile* source_file;
	RygelMediaFileItem* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFileOutputStream* _tmp26_;
	GFile* _tmp27_;
	GCancellable* _tmp28_;
	GCancellable* _tmp29_;
	GFileOutputStream* _tmp30_;
	GFileOutputStream* _tmp31_;
	SoupMessage* message;
	const gchar* _tmp32_;
	SoupMessage* _tmp33_;
	const gchar* _tmp34_;
	RygelMediaFileItem* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GInputStream* stream;
	SoupSession* _tmp38_;
	SoupMessage* _tmp39_;
	GCancellable* _tmp40_;
	GCancellable* _tmp41_;
	GInputStream* _tmp42_;
	gboolean _tmp43_;
	SoupMessage* _tmp44_;
	guint _tmp45_;
	guint _tmp46_;
	SoupMessage* _tmp47_;
	guint _tmp48_;
	guint _tmp49_;
	SoupMessage* _tmp50_;
	SoupMessage* _tmp51_;
	SoupMessageHeaders* _tmp52_;
	SoupMessageHeaders* _tmp53_;
	GUPnPServiceAction* _tmp54_;
	GBytes* bytes;
	GInputStream* _tmp55_;
	GCancellable* _tmp56_;
	GCancellable* _tmp57_;
	GBytes* _tmp58_;
	gboolean _tmp59_;
	GBytes* _tmp60_;
	GBytes* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gssize bytes_to_write;
	GBytes* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	GBytes* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gssize bytes_written;
	GFileOutputStream* _tmp70_;
	GBytes* _tmp71_;
	GCancellable* _tmp72_;
	GCancellable* _tmp73_;
	GBytes* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	GBytes* _tmp77_;
	GBytes* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	GBytes* _tmp81_;
	GError* err;
	GError* _tmp82_;
	RygelObjectRemovalQueue* _tmp83_;
	RygelMediaFileItem* _tmp84_;
	GCancellable* _tmp85_;
	GCancellable* _tmp86_;
	GError* _inner_error0_;
};

struct _RygelImportResourceFetchItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelImportResource* self;
	RygelMediaFileItem* result;
	RygelHTTPItemURI* uri;
	RygelHTTPItemURI* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPItemURI* _tmp3_;
	RygelHTTPItemURI* _tmp4_;
	GError* _error_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp11_;
	gchar* msg;
	RygelMediaFileItem* media_item;
	RygelMediaObject* _tmp12_;
	RygelMediaFileItem* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	RygelMediaObject* _tmp16_;
	RygelMediaFileItem* _tmp17_;
	RygelMediaObject* _tmp18_;
	RygelMediaContainer* _tmp19_;
	RygelMediaContainer* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	RygelMediaFileItem* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	RygelMediaObject* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	RygelMediaObject* _tmp30_;
	GeeList* _tmp31_;
	GeeList* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	GError* _inner_error0_;
};

static gint RygelImportResource_private_offset;
static gpointer rygel_import_resource_parent_class = NULL;
static guint32 rygel_import_resource_last_transfer_id;
static guint32 rygel_import_resource_last_transfer_id = (guint32) 0;
static RygelStateMachineIface * rygel_import_resource_rygel_state_machine_parent_iface = NULL;

VALA_EXTERN GType rygel_transfer_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_import_resource_get_type (void) G_GNUC_CONST ;
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
VALA_EXTERN RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir,
                                                GUPnPServiceAction* action);
VALA_EXTERN RygelImportResource* rygel_import_resource_construct (GType object_type,
                                                      RygelContentDirectory* content_dir,
                                                      GUPnPServiceAction* action);
static void __lambda6_ (RygelImportResource* self);
static void ___lambda6__g_cancellable_cancelled (GCancellable* _sender,
                                          gpointer self);
static void rygel_import_resource_real_run_data_free (gpointer _data);
static void rygel_import_resource_real_run (RygelStateMachine* base,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean rygel_import_resource_real_run_co (RygelImportResourceRunData* _data_);
VALA_EXTERN GQuark rygel_content_directory_error_quark (void);
VALA_EXTERN GType rygel_content_directory_error_get_type (void) G_GNUC_CONST ;
static void rygel_import_resource_fetch_item (RygelImportResource* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static RygelMediaFileItem* rygel_import_resource_fetch_item_finish (RygelImportResource* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void rygel_import_resource_run_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
VALA_EXTERN GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
VALA_EXTERN gboolean rygel_object_removal_queue_dequeue (RygelObjectRemovalQueue* self,
                                             RygelMediaObject* object);
static void rygel_import_resource_handle_transfer_error (RygelImportResource* self,
                                                  SoupMessage* message);
VALA_EXTERN void rygel_object_removal_queue_remove_now (RygelObjectRemovalQueue* self,
                                            RygelMediaObject* object,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void rygel_object_removal_queue_remove_now_finish (RygelObjectRemovalQueue* self,
                                                   GAsyncResult* _res_);
static void rygel_import_resource_fetch_item_data_free (gpointer _data);
static gboolean rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* _data_);
static void rygel_import_resource_fetch_item_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
static void rygel_import_resource_finalize (GObject * obj);
static GType rygel_import_resource_get_type_once (void);
static void _vala_rygel_import_resource_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_rygel_import_resource_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

 G_GNUC_NO_INLINE static GType
rygel_transfer_status_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_TRANSFER_STATUS_COMPLETED, "RYGEL_TRANSFER_STATUS_COMPLETED", "completed"}, {RYGEL_TRANSFER_STATUS_ERROR, "RYGEL_TRANSFER_STATUS_ERROR", "error"}, {RYGEL_TRANSFER_STATUS_IN_PROGRESS, "RYGEL_TRANSFER_STATUS_IN_PROGRESS", "in-progress"}, {RYGEL_TRANSFER_STATUS_STOPPED, "RYGEL_TRANSFER_STATUS_STOPPED", "stopped"}, {0, NULL, NULL}};
	GType rygel_transfer_status_type_id;
	rygel_transfer_status_type_id = g_enum_register_static ("RygelTransferStatus", values);
	return rygel_transfer_status_type_id;
}

GType
rygel_transfer_status_get_type (void)
{
	static volatile gsize rygel_transfer_status_type_id__once = 0;
	if (g_once_init_enter (&rygel_transfer_status_type_id__once)) {
		GType rygel_transfer_status_type_id;
		rygel_transfer_status_type_id = rygel_transfer_status_get_type_once ();
		g_once_init_leave (&rygel_transfer_status_type_id__once, rygel_transfer_status_type_id);
	}
	return rygel_transfer_status_type_id__once;
}

static inline gpointer
rygel_import_resource_get_instance_private (RygelImportResource* self)
{
	return G_STRUCT_MEMBER_P (self, RygelImportResource_private_offset);
}

static void
_vala_GUPnPServiceAction_free (GUPnPServiceAction* self)
{
	g_boxed_free (gupnp_service_action_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda6_ (RygelImportResource* self)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	g_cancellable_cancel (_tmp1_);
}

static void
___lambda6__g_cancellable_cancelled (GCancellable* _sender,
                                     gpointer self)
{
	__lambda6_ ((RygelImportResource*) self);
}

RygelImportResource*
rygel_import_resource_construct (GType object_type,
                                 RygelContentDirectory* content_dir,
                                 GUPnPServiceAction* action)
{
	RygelImportResource * self = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	RygelHTTPServer* _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	GUPnPServiceAction* _tmp6_;
	guint32 _tmp7_;
	SoupSession* _tmp8_;
	GCancellable* _tmp9_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelImportResource*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir->root_container;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->root_container);
	self->priv->root_container = _tmp1_;
	_tmp2_ = content_dir->http_server;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->http_server);
	self->priv->http_server = _tmp3_;
	_tmp4_ = g_cancellable_new ();
	_tmp5_ = _tmp4_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp6_;
	_tmp7_ = rygel_import_resource_last_transfer_id;
	rygel_import_resource_last_transfer_id = _tmp7_ + 1;
	self->transfer_id = rygel_import_resource_last_transfer_id;
	self->bytes_copied = (gint64) 0;
	self->bytes_total = (gint64) 0;
	self->status = RYGEL_TRANSFER_STATUS_IN_PROGRESS;
	_tmp8_ = soup_session_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp8_;
	_tmp9_ = content_dir->cancellable;
	g_signal_connect_object (_tmp9_, "cancelled", (GCallback) ___lambda6__g_cancellable_cancelled, self, 0);
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}

RygelImportResource*
rygel_import_resource_new (RygelContentDirectory* content_dir,
                           GUPnPServiceAction* action)
{
	return rygel_import_resource_construct (RYGEL_TYPE_IMPORT_RESOURCE, content_dir, action);
}

static void
rygel_import_resource_real_run_data_free (gpointer _data)
{
	RygelImportResourceRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelImportResourceRunData, _data_);
}

static void
rygel_import_resource_real_run (RygelStateMachine* base,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	RygelImportResource * self;
	RygelImportResourceRunData* _data_;
	RygelImportResource* _tmp0_;
	self = (RygelImportResource*) base;
	_data_ = g_slice_new0 (RygelImportResourceRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_import_resource_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_import_resource_real_run_co (_data_);
}

static void
rygel_import_resource_run_finish (RygelStateMachine* base,
                                  GAsyncResult* _res_)
{
	RygelImportResourceRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_import_resource_run_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	RygelImportResourceRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_import_resource_real_run_co (_data_);
}

static gint
_vala_g_bytes_get_length (GBytes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) g_bytes_get_size (self);
	return result;
}

static gboolean
rygel_import_resource_real_run_co (RygelImportResourceRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->action;
	_data_->_tmp1_ = NULL;
	_data_->_tmp2_ = NULL;
	gupnp_service_action_get (_data_->_tmp0_, "SourceURI", G_TYPE_STRING, &_data_->_tmp1_, "DestinationURI", G_TYPE_STRING, &_data_->_tmp2_, NULL);
	_g_free0 (_data_->self->source_uri);
	_data_->self->source_uri = _data_->_tmp1_;
	_g_free0 (_data_->self->destination_uri);
	_data_->self->destination_uri = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->self->source_uri;
		if (_data_->_tmp3_ == NULL) {
			_data_->_tmp4_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Must provide source URI");
			_data_->_inner_error0_ = _data_->_tmp4_;
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->self->destination_uri;
		if (_data_->_tmp5_ == NULL) {
			_data_->_tmp6_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE, "Must provide destination URI");
			_data_->_inner_error0_ = _data_->_tmp6_;
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->self->priv->action;
		gupnp_service_action_set (_data_->_tmp7_, "TransferID", G_TYPE_UINT, _data_->self->transfer_id, NULL);
		_data_->_state_ = 1;
		rygel_import_resource_fetch_item (_data_->self, rygel_import_resource_run_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = rygel_import_resource_fetch_item_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = _data_->_tmp8_;
		_data_->_tmp8_ = NULL;
		_g_object_unref0 (_data_->self->priv->item);
		_data_->self->priv->item = _data_->_tmp10_;
		_g_object_unref0 (_data_->_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->self->destination_uri;
		_data_->_tmp12_ = _data_->_error_;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning (_ ("Failed to get original URI for “%s”: %s"), _data_->_tmp11_, _data_->_tmp13_);
		_data_->_tmp14_ = _data_->self->priv->action;
		_data_->_tmp15_ = _data_->_error_;
		_data_->_tmp16_ = _data_->_error_;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		gupnp_service_action_return_error (_data_->_tmp14_, (guint) _data_->_tmp15_->code, _data_->_tmp17_);
		_data_->self->status = RYGEL_TRANSFER_STATUS_ERROR;
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
		_g_error_free0 (_data_->_error_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = rygel_object_removal_queue_get_default ();
	_data_->queue = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->queue;
	_data_->_tmp20_ = _data_->self->priv->item;
	rygel_object_removal_queue_dequeue (_data_->_tmp19_, (RygelMediaObject*) _data_->_tmp20_);
	{
		_data_->_tmp21_ = _data_->self->priv->item;
		_data_->_tmp22_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = g_file_new_for_uri (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_g_free0 (_data_->_tmp23_);
		_data_->source_file = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->source_file;
		_data_->_tmp28_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp27_, NULL, FALSE, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, _data_->_tmp29_, rygel_import_resource_run_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp30_ = g_file_replace_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp26_ = _data_->_tmp30_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->source_file);
			goto __catch1_g_error;
		}
		_data_->_tmp31_ = _data_->_tmp26_;
		_data_->_tmp26_ = NULL;
		_g_object_unref0 (_data_->self->priv->output_stream);
		_data_->self->priv->output_stream = _data_->_tmp31_;
		_data_->_tmp32_ = _data_->self->source_uri;
		_data_->_tmp33_ = soup_message_new ("GET", _data_->_tmp32_);
		_data_->message = _data_->_tmp33_;
		_data_->_tmp34_ = _data_->self->source_uri;
		_data_->_tmp35_ = _data_->self->priv->item;
		_data_->_tmp36_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->_tmp35_);
		_data_->_tmp37_ = _data_->_tmp36_;
		g_debug ("rygel-import-resource.vala:147: Importing resource from %s to %s", _data_->_tmp34_, _data_->_tmp37_);
		_g_free0 (_data_->_tmp37_);
		_data_->_tmp38_ = _data_->self->priv->session;
		_data_->_tmp39_ = _data_->message;
		_data_->_tmp40_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_state_ = 3;
		soup_session_send_async (_data_->_tmp38_, _data_->_tmp39_, G_PRIORITY_DEFAULT, _data_->_tmp41_, rygel_import_resource_run_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp42_ = soup_session_send_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error0_);
		_data_->stream = _data_->_tmp42_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->_tmp26_);
			_g_object_unref0 (_data_->source_file);
			goto __catch1_g_error;
		}
		_data_->_tmp44_ = _data_->message;
		g_object_get (_data_->_tmp44_, "status-code", &_data_->_tmp45_, NULL);
		_data_->_tmp46_ = _data_->_tmp45_;
		if (_data_->_tmp46_ >= ((guint) 200)) {
			_data_->_tmp47_ = _data_->message;
			g_object_get (_data_->_tmp47_, "status-code", &_data_->_tmp48_, NULL);
			_data_->_tmp49_ = _data_->_tmp48_;
			_data_->_tmp43_ = _data_->_tmp49_ <= ((guint) 299);
		} else {
			_data_->_tmp43_ = FALSE;
		}
		if (!_data_->_tmp43_) {
			_data_->_tmp50_ = _data_->message;
			rygel_import_resource_handle_transfer_error (_data_->self, _data_->_tmp50_);
			g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
			_g_object_unref0 (_data_->stream);
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->_tmp26_);
			_g_object_unref0 (_data_->source_file);
			_g_object_unref0 (_data_->queue);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp51_ = _data_->message;
		_data_->_tmp52_ = soup_message_get_response_headers (_data_->_tmp51_);
		_data_->_tmp53_ = _data_->_tmp52_;
		_data_->self->bytes_total = soup_message_headers_get_content_length (_data_->_tmp53_);
		_data_->_tmp54_ = _data_->self->priv->action;
		gupnp_service_action_return_success (_data_->_tmp54_);
		__vala_GUPnPServiceAction_free0 (_data_->self->priv->action);
		_data_->self->priv->action = NULL;
		while (TRUE) {
			_data_->_tmp55_ = _data_->stream;
			_data_->_tmp56_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
			_data_->_tmp57_ = _data_->_tmp56_;
			_data_->_state_ = 4;
			g_input_stream_read_bytes_async (_data_->_tmp55_, (gsize) (8192 * 1024), G_PRIORITY_DEFAULT, _data_->_tmp57_, rygel_import_resource_run_ready, _data_);
			return FALSE;
			_state_4:
			_data_->_tmp58_ = g_input_stream_read_bytes_finish (_data_->_tmp55_, _data_->_res_, &_data_->_inner_error0_);
			_data_->bytes = _data_->_tmp58_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->stream);
				_g_object_unref0 (_data_->message);
				_g_object_unref0 (_data_->_tmp26_);
				_g_object_unref0 (_data_->source_file);
				goto __catch1_g_error;
			}
			_data_->_tmp60_ = _data_->bytes;
			if (_data_->_tmp60_ == NULL) {
				_data_->_tmp59_ = TRUE;
			} else {
				_data_->_tmp61_ = _data_->bytes;
				_data_->_tmp62_ = _vala_g_bytes_get_length (_data_->_tmp61_);
				_data_->_tmp63_ = _data_->_tmp62_;
				_data_->_tmp59_ = _data_->_tmp63_ == 0;
			}
			if (_data_->_tmp59_) {
				_g_bytes_unref0 (_data_->bytes);
				break;
			}
			_data_->_tmp64_ = _data_->bytes;
			_data_->_tmp65_ = _vala_g_bytes_get_length (_data_->_tmp64_);
			_data_->_tmp66_ = _data_->_tmp65_;
			_data_->bytes_to_write = (gssize) _data_->_tmp66_;
			_data_->_tmp67_ = _data_->bytes;
			_data_->_tmp68_ = _vala_g_bytes_get_length (_data_->_tmp67_);
			_data_->_tmp69_ = _data_->_tmp68_;
			_data_->self->bytes_copied = _data_->self->bytes_copied + _data_->_tmp69_;
			while (TRUE) {
				if (!(_data_->bytes_to_write != ((gssize) 0))) {
					break;
				}
				_data_->_tmp70_ = _data_->self->priv->output_stream;
				_data_->_tmp71_ = _data_->bytes;
				_data_->_tmp72_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
				_data_->_tmp73_ = _data_->_tmp72_;
				_data_->_state_ = 5;
				g_output_stream_write_bytes_async ((GOutputStream*) _data_->_tmp70_, _data_->_tmp71_, G_PRIORITY_DEFAULT, _data_->_tmp73_, rygel_import_resource_run_ready, _data_);
				return FALSE;
				_state_5:
				_data_->bytes_written = g_output_stream_write_bytes_finish ((GOutputStream*) _data_->_tmp70_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_bytes_unref0 (_data_->bytes);
					_g_object_unref0 (_data_->stream);
					_g_object_unref0 (_data_->message);
					_g_object_unref0 (_data_->_tmp26_);
					_g_object_unref0 (_data_->source_file);
					goto __catch1_g_error;
				}
				_data_->_tmp74_ = _data_->bytes;
				_data_->_tmp75_ = _vala_g_bytes_get_length (_data_->_tmp74_);
				_data_->_tmp76_ = _data_->_tmp75_;
				if (_data_->bytes_written != ((gssize) _data_->_tmp76_)) {
					_data_->_tmp77_ = _data_->bytes;
					_data_->_tmp78_ = _data_->bytes;
					_data_->_tmp79_ = _vala_g_bytes_get_length (_data_->_tmp78_);
					_data_->_tmp80_ = _data_->_tmp79_;
					_data_->_tmp81_ = g_bytes_new_from_bytes (_data_->_tmp77_, (gsize) _data_->bytes_written, (gsize) (_data_->_tmp80_ - _data_->bytes_written));
					_g_bytes_unref0 (_data_->bytes);
					_data_->bytes = _data_->_tmp81_;
				}
				_data_->bytes_to_write -= _data_->bytes_written;
			}
			_g_bytes_unref0 (_data_->bytes);
		}
		if (_data_->self->bytes_total == ((gint64) 0)) {
			_data_->self->bytes_total = _data_->self->bytes_copied;
		} else {
			if (_data_->self->bytes_total != _data_->self->bytes_copied) {
				g_warning ("rygel-import-resource.vala:184: Importing sizes did not match: %lld vs" \
". %lld", _data_->self->bytes_total, _data_->self->bytes_copied);
				_data_->self->status = RYGEL_TRANSFER_STATUS_ERROR;
			}
		}
		if (_data_->self->status == RYGEL_TRANSFER_STATUS_IN_PROGRESS) {
			_data_->self->status = RYGEL_TRANSFER_STATUS_COMPLETED;
		}
		_g_object_unref0 (_data_->stream);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->_tmp26_);
		_g_object_unref0 (_data_->source_file);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp82_ = _data_->err;
		if (g_error_matches (_data_->_tmp82_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->self->status = RYGEL_TRANSFER_STATUS_STOPPED;
		} else {
			_data_->self->status = RYGEL_TRANSFER_STATUS_ERROR;
		}
		_data_->_tmp83_ = _data_->queue;
		_data_->_tmp84_ = _data_->self->priv->item;
		_data_->_tmp85_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp86_ = _data_->_tmp85_;
		_data_->_state_ = 6;
		rygel_object_removal_queue_remove_now (_data_->_tmp83_, (RygelMediaObject*) _data_->_tmp84_, _data_->_tmp86_, rygel_import_resource_run_ready, _data_);
		return FALSE;
		_state_6:
		rygel_object_removal_queue_remove_now_finish (_data_->_tmp83_, _data_->_res_);
		_g_error_free0 (_data_->err);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->queue);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	_g_object_unref0 (_data_->queue);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_import_resource_fetch_item_data_free (gpointer _data)
{
	RygelImportResourceFetchItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelImportResourceFetchItemData, _data_);
}

static void
rygel_import_resource_fetch_item (RygelImportResource* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelImportResourceFetchItemData* _data_;
	RygelImportResource* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelImportResourceFetchItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_import_resource_fetch_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_import_resource_fetch_item_co (_data_);
}

static RygelMediaFileItem*
rygel_import_resource_fetch_item_finish (RygelImportResource* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	RygelMediaFileItem* result;
	RygelImportResourceFetchItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_import_resource_fetch_item_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	RygelImportResourceFetchItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_import_resource_fetch_item_co (_data_);
}

static gboolean
rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = _data_->self->destination_uri;
		_data_->_tmp2_ = _data_->self->priv->http_server;
		_data_->_tmp3_ = rygel_http_item_uri_new_from_string (_data_->_tmp1_, _data_->_tmp2_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->uri);
		_data_->uri = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->_error_;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		_data_->_tmp7_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE, _data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp7_;
		_g_error_free0 (_data_->_error_);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->root_container;
	_data_->_tmp9_ = rygel_http_item_uri_get_item_id (_data_->uri);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp8_, _data_->_tmp10_, NULL, rygel_import_resource_fetch_item_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = rygel_media_container_find_object_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
	_data_->media_object = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->msg = NULL;
	_data_->_tmp12_ = _data_->media_object;
	_data_->_tmp13_ = _g_object_ref0 (RYGEL_IS_MEDIA_FILE_ITEM (_data_->_tmp12_) ? ((RygelMediaFileItem*) _data_->_tmp12_) : NULL);
	_data_->media_item = _data_->_tmp13_;
	_data_->_tmp16_ = _data_->media_object;
	if (_data_->_tmp16_ == NULL) {
		_data_->_tmp15_ = TRUE;
	} else {
		_data_->_tmp17_ = _data_->media_item;
		_data_->_tmp15_ = _data_->_tmp17_ == NULL;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp14_ = TRUE;
	} else {
		_data_->_tmp18_ = _data_->media_object;
		_data_->_tmp19_ = rygel_media_object_get_parent (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp14_ = !RYGEL_IS_WRITABLE_CONTAINER (_data_->_tmp20_);
	}
	if (_data_->_tmp14_) {
		_data_->_tmp21_ = _data_->self->destination_uri;
		_data_->_tmp22_ = g_strdup_printf (_ ("URI “%s” invalid for importing contents to"), _data_->_tmp21_);
		_g_free0 (_data_->msg);
		_data_->msg = _data_->_tmp22_;
	} else {
		_data_->_tmp23_ = _data_->media_item;
		_data_->_tmp24_ = rygel_media_file_item_get_place_holder (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		if (!_data_->_tmp25_) {
			_data_->_tmp26_ = _data_->media_object;
			_data_->_tmp27_ = rygel_media_object_get_id (_data_->_tmp26_);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp29_ = g_strdup_printf (_ ("Pushing data to non-empty item “%s” not allowed"), _data_->_tmp28_);
			_g_free0 (_data_->msg);
			_data_->msg = _data_->_tmp29_;
		} else {
			_data_->_tmp30_ = _data_->media_object;
			_data_->_tmp31_ = rygel_media_object_get_uris (_data_->_tmp30_);
			_data_->_tmp32_ = _data_->_tmp31_;
			_data_->_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp32_);
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = _data_->_tmp34_;
			_g_object_unref0 (_data_->_tmp32_);
			if (_data_->_tmp35_) {
				g_assert_not_reached ();
			}
		}
	}
	_data_->_tmp36_ = _data_->msg;
	if (_data_->_tmp36_ != NULL) {
		_data_->_tmp37_ = _data_->msg;
		_data_->_tmp38_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp37_);
		_data_->_inner_error0_ = _data_->_tmp38_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media_item);
		_g_free0 (_data_->msg);
		_g_object_unref0 (_data_->media_object);
		_g_object_unref0 (_data_->uri);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->media_item;
	_g_free0 (_data_->msg);
	_g_object_unref0 (_data_->media_object);
	_g_object_unref0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_import_resource_handle_transfer_error (RygelImportResource* self,
                                             SoupMessage* message)
{
	gchar* phrase = NULL;
	guint _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GUPnPServiceAction* _tmp17_;
	gboolean _tmp18_ = FALSE;
	guint _tmp19_;
	guint _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	self->status = RYGEL_TRANSFER_STATUS_ERROR;
	{
		GFileOutputStream* _tmp0_;
		GCancellable* _tmp1_;
		GCancellable* _tmp2_;
		GFile* file = NULL;
		RygelMediaFileItem* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GCancellable* _tmp9_;
		GCancellable* _tmp10_;
		_tmp0_ = self->priv->output_stream;
		_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp2_ = _tmp1_;
		g_output_stream_close ((GOutputStream*) _tmp0_, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = self->priv->item;
		_tmp4_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_new_for_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		file = _tmp7_;
		_tmp8_ = file;
		_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		_tmp10_ = _tmp9_;
		g_file_delete (_tmp8_, _tmp10_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_object_get (message, "status-code", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = soup_status_get_phrase (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	phrase = _tmp14_;
	_tmp15_ = self->source_uri;
	_tmp16_ = phrase;
	g_warning (_ ("Failed to import file from %s: %s"), _tmp15_, _tmp16_);
	_tmp17_ = self->priv->action;
	if (_tmp17_ == NULL) {
		_g_free0 (phrase);
		return;
	}
	g_object_get (message, "status-code", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == ((guint) SOUP_STATUS_NOT_FOUND)) {
		_tmp18_ = TRUE;
	} else {
		guint _tmp21_;
		guint _tmp22_;
		g_object_get (message, "status-code", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_ < ((guint) 100);
	}
	if (_tmp18_) {
		GUPnPServiceAction* _tmp23_;
		const gchar* _tmp24_;
		_tmp23_ = self->priv->action;
		_tmp24_ = phrase;
		gupnp_service_action_return_error (_tmp23_, (guint) 714, _tmp24_);
	} else {
		GUPnPServiceAction* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = self->priv->action;
		_tmp26_ = phrase;
		gupnp_service_action_return_error (_tmp25_, (guint) 715, _tmp26_);
	}
	_g_free0 (phrase);
}

const gchar*
rygel_import_resource_get_status_as_string (RygelImportResource* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->status) {
		case RYGEL_TRANSFER_STATUS_COMPLETED:
		{
			result = "COMPLETED";
			return result;
		}
		case RYGEL_TRANSFER_STATUS_ERROR:
		{
			result = "ERROR";
			return result;
		}
		case RYGEL_TRANSFER_STATUS_IN_PROGRESS:
		{
			result = "IN_PROGRESS";
			return result;
		}
		default:
		case RYGEL_TRANSFER_STATUS_STOPPED:
		{
			result = "STOPPED";
			return result;
		}
	}
}

static GCancellable*
rygel_import_resource_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelImportResource* self;
	GCancellable* _tmp0_;
	self = (RygelImportResource*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_import_resource_real_set_cancellable (RygelStateMachine* base,
                                            GCancellable* value)
{
	RygelImportResource* self;
	GCancellable* old_value;
	self = (RygelImportResource*) base;
	old_value = rygel_import_resource_real_get_cancellable (base);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_import_resource_class_init (RygelImportResourceClass * klass,
                                  gpointer klass_data)
{
	rygel_import_resource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelImportResource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_import_resource_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_import_resource_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_import_resource_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY, rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY] = g_param_spec_string ("status-as-string", "status-as-string", "status-as-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY, rygel_import_resource_properties[RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_import_resource_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                          gpointer iface_data)
{
	rygel_import_resource_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_import_resource_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_import_resource_run_finish;
	iface->get_cancellable = rygel_import_resource_real_get_cancellable;
	iface->set_cancellable = rygel_import_resource_real_set_cancellable;
}

static void
rygel_import_resource_instance_init (RygelImportResource * self,
                                     gpointer klass)
{
	self->priv = rygel_import_resource_get_instance_private (self);
}

static void
rygel_import_resource_finalize (GObject * obj)
{
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
	_g_free0 (self->source_uri);
	_g_free0 (self->destination_uri);
	_g_object_unref0 (self->priv->item);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->http_server);
	_g_object_unref0 (self->priv->root_container);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	_g_object_unref0 (self->priv->output_stream);
	G_OBJECT_CLASS (rygel_import_resource_parent_class)->finalize (obj);
}

/**
 * Responsible for handling ImportResource action.
 */
 G_GNUC_NO_INLINE static GType
rygel_import_resource_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelImportResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_import_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImportResource), 0, (GInstanceInitFunc) rygel_import_resource_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_import_resource_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_import_resource_type_id;
	rygel_import_resource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelImportResource", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_import_resource_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelImportResource_private_offset = g_type_add_instance_private (rygel_import_resource_type_id, sizeof (RygelImportResourcePrivate));
	return rygel_import_resource_type_id;
}

GType
rygel_import_resource_get_type (void)
{
	static volatile gsize rygel_import_resource_type_id__once = 0;
	if (g_once_init_enter (&rygel_import_resource_type_id__once)) {
		GType rygel_import_resource_type_id;
		rygel_import_resource_type_id = rygel_import_resource_get_type_once ();
		g_once_init_leave (&rygel_import_resource_type_id__once, rygel_import_resource_type_id);
	}
	return rygel_import_resource_type_id__once;
}

static void
_vala_rygel_import_resource_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
	switch (property_id) {
		case RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING_PROPERTY:
		g_value_set_string (value, rygel_import_resource_get_status_as_string (self));
		break;
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_import_resource_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	RygelImportResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource);
	switch (property_id) {
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

