{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A structure used to describe a text range.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.TextRange
    ( 

-- * Exported types
    TextRange(..)                           ,
    newZeroTextRange                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTextRangeMethod                  ,
#endif



 -- * Properties


-- ** bounds #attr:bounds#
-- | A rectangle giving the bounds of the text range

    getTextRangeBounds                      ,
#if defined(ENABLE_OVERLOADING)
    textRange_bounds                        ,
#endif


-- ** content #attr:content#
-- | The text in the text range

    clearTextRangeContent                   ,
    getTextRangeContent                     ,
    setTextRangeContent                     ,
#if defined(ENABLE_OVERLOADING)
    textRange_content                       ,
#endif


-- ** endOffset #attr:endOffset#
-- | The end offset of a AtkTextRange

    getTextRangeEndOffset                   ,
    setTextRangeEndOffset                   ,
#if defined(ENABLE_OVERLOADING)
    textRange_endOffset                     ,
#endif


-- ** startOffset #attr:startOffset#
-- | The start offset of a AtkTextRange

    getTextRangeStartOffset                 ,
    setTextRangeStartOffset                 ,
#if defined(ENABLE_OVERLOADING)
    textRange_startOffset                   ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Structs.TextRectangle as Atk.TextRectangle

#else
import {-# SOURCE #-} qualified GI.Atk.Structs.TextRectangle as Atk.TextRectangle

#endif

-- | Memory-managed wrapper type.
newtype TextRange = TextRange (SP.ManagedPtr TextRange)
    deriving (Eq)

instance SP.ManagedPtrNewtype TextRange where
    toManagedPtr (TextRange p) = p

foreign import ccall "atk_text_range_get_type" c_atk_text_range_get_type :: 
    IO GType

type instance O.ParentTypes TextRange = '[]
instance O.HasParentTypes TextRange

instance B.Types.TypedObject TextRange where
    glibType = c_atk_text_range_get_type

instance B.Types.GBoxed TextRange

-- | Convert t'TextRange' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TextRange) where
    gvalueGType_ = c_atk_text_range_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr TextRange)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr TextRange)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed TextRange ptr
        else return P.Nothing
        
    

-- | Construct a t'TextRange' struct initialized to zero.
newZeroTextRange :: MonadIO m => m TextRange
newZeroTextRange = liftIO $ callocBoxedBytes 32 >>= wrapBoxed TextRange

instance tag ~ 'AttrSet => Constructible TextRange tag where
    new _ attrs = do
        o <- newZeroTextRange
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@bounds@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRange #bounds
-- @
getTextRangeBounds :: MonadIO m => TextRange -> m Atk.TextRectangle.TextRectangle
getTextRangeBounds s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Atk.TextRectangle.TextRectangle)
    val' <- (newPtr Atk.TextRectangle.TextRectangle) val
    return val'

#if defined(ENABLE_OVERLOADING)
data TextRangeBoundsFieldInfo
instance AttrInfo TextRangeBoundsFieldInfo where
    type AttrBaseTypeConstraint TextRangeBoundsFieldInfo = (~) TextRange
    type AttrAllowedOps TextRangeBoundsFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint TextRangeBoundsFieldInfo = (~) (Ptr Atk.TextRectangle.TextRectangle)
    type AttrTransferTypeConstraint TextRangeBoundsFieldInfo = (~)(Ptr Atk.TextRectangle.TextRectangle)
    type AttrTransferType TextRangeBoundsFieldInfo = (Ptr Atk.TextRectangle.TextRectangle)
    type AttrGetType TextRangeBoundsFieldInfo = Atk.TextRectangle.TextRectangle
    type AttrLabel TextRangeBoundsFieldInfo = "bounds"
    type AttrOrigin TextRangeBoundsFieldInfo = TextRange
    attrGet = getTextRangeBounds
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRange.bounds"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRange.html#g:attr:bounds"
        })

textRange_bounds :: AttrLabelProxy "bounds"
textRange_bounds = AttrLabelProxy

#endif


-- | Get the value of the “@start_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRange #startOffset
-- @
getTextRangeStartOffset :: MonadIO m => TextRange -> m Int32
getTextRangeStartOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@start_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textRange [ #startOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextRangeStartOffset :: MonadIO m => TextRange -> Int32 -> m ()
setTextRangeStartOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextRangeStartOffsetFieldInfo
instance AttrInfo TextRangeStartOffsetFieldInfo where
    type AttrBaseTypeConstraint TextRangeStartOffsetFieldInfo = (~) TextRange
    type AttrAllowedOps TextRangeStartOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextRangeStartOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextRangeStartOffsetFieldInfo = (~)Int32
    type AttrTransferType TextRangeStartOffsetFieldInfo = Int32
    type AttrGetType TextRangeStartOffsetFieldInfo = Int32
    type AttrLabel TextRangeStartOffsetFieldInfo = "start_offset"
    type AttrOrigin TextRangeStartOffsetFieldInfo = TextRange
    attrGet = getTextRangeStartOffset
    attrSet = setTextRangeStartOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRange.startOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRange.html#g:attr:startOffset"
        })

textRange_startOffset :: AttrLabelProxy "startOffset"
textRange_startOffset = AttrLabelProxy

#endif


-- | Get the value of the “@end_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRange #endOffset
-- @
getTextRangeEndOffset :: MonadIO m => TextRange -> m Int32
getTextRangeEndOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Int32
    return val

-- | Set the value of the “@end_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textRange [ #endOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextRangeEndOffset :: MonadIO m => TextRange -> Int32 -> m ()
setTextRangeEndOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data TextRangeEndOffsetFieldInfo
instance AttrInfo TextRangeEndOffsetFieldInfo where
    type AttrBaseTypeConstraint TextRangeEndOffsetFieldInfo = (~) TextRange
    type AttrAllowedOps TextRangeEndOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TextRangeEndOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint TextRangeEndOffsetFieldInfo = (~)Int32
    type AttrTransferType TextRangeEndOffsetFieldInfo = Int32
    type AttrGetType TextRangeEndOffsetFieldInfo = Int32
    type AttrLabel TextRangeEndOffsetFieldInfo = "end_offset"
    type AttrOrigin TextRangeEndOffsetFieldInfo = TextRange
    attrGet = getTextRangeEndOffset
    attrSet = setTextRangeEndOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRange.endOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRange.html#g:attr:endOffset"
        })

textRange_endOffset :: AttrLabelProxy "endOffset"
textRange_endOffset = AttrLabelProxy

#endif


-- | Get the value of the “@content@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textRange #content
-- @
getTextRangeContent :: MonadIO m => TextRange -> m (Maybe T.Text)
getTextRangeContent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@content@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textRange [ #content 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextRangeContent :: MonadIO m => TextRange -> CString -> m ()
setTextRangeContent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: CString)

-- | Set the value of the “@content@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #content
-- @
clearTextRangeContent :: MonadIO m => TextRange -> m ()
clearTextRangeContent s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data TextRangeContentFieldInfo
instance AttrInfo TextRangeContentFieldInfo where
    type AttrBaseTypeConstraint TextRangeContentFieldInfo = (~) TextRange
    type AttrAllowedOps TextRangeContentFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint TextRangeContentFieldInfo = (~) CString
    type AttrTransferTypeConstraint TextRangeContentFieldInfo = (~)CString
    type AttrTransferType TextRangeContentFieldInfo = CString
    type AttrGetType TextRangeContentFieldInfo = Maybe T.Text
    type AttrLabel TextRangeContentFieldInfo = "content"
    type AttrOrigin TextRangeContentFieldInfo = TextRange
    attrGet = getTextRangeContent
    attrSet = setTextRangeContent
    attrConstruct = undefined
    attrClear = clearTextRangeContent
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.TextRange.content"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-TextRange.html#g:attr:content"
        })

textRange_content :: AttrLabelProxy "content"
textRange_content = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TextRange
type instance O.AttributeList TextRange = TextRangeAttributeList
type TextRangeAttributeList = ('[ '("bounds", TextRangeBoundsFieldInfo), '("startOffset", TextRangeStartOffsetFieldInfo), '("endOffset", TextRangeEndOffsetFieldInfo), '("content", TextRangeContentFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTextRangeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTextRangeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTextRangeMethod t TextRange, O.OverloadedMethod info TextRange p) => OL.IsLabel t (TextRange -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTextRangeMethod t TextRange, O.OverloadedMethod info TextRange p, R.HasField t TextRange p) => R.HasField t TextRange p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTextRangeMethod t TextRange, O.OverloadedMethodInfo info TextRange) => OL.IsLabel t (O.MethodProxy info TextRange) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


