/* math-display.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "calculator.h"
#include <gtksourceview/gtksource.h>
#include <adwaita.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;
enum  {
	MATH_DISPLAY_0_PROPERTY,
	MATH_DISPLAY_EQUATION_PROPERTY,
	MATH_DISPLAY_ENABLED_COMPLETIONS_PROPERTY,
	MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY,
	MATH_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* math_display_properties[MATH_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_BUILTIN_COMPLETION_PROVIDER (builtin_completion_provider_get_type ())
#define BUILTIN_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILTIN_COMPLETION_PROVIDER, BuiltinCompletionProvider))
#define BUILTIN_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILTIN_COMPLETION_PROVIDER, BuiltinCompletionProviderClass))
#define IS_BUILTIN_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILTIN_COMPLETION_PROVIDER))
#define IS_BUILTIN_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILTIN_COMPLETION_PROVIDER))
#define BUILTIN_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILTIN_COMPLETION_PROVIDER, BuiltinCompletionProviderClass))

typedef struct _BuiltinCompletionProvider BuiltinCompletionProvider;
typedef struct _BuiltinCompletionProviderClass BuiltinCompletionProviderClass;

#define TYPE_FUNCTION_COMPLETION_PROVIDER (function_completion_provider_get_type ())
#define FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProvider))
#define FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))
#define IS_FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define IS_FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define FUNCTION_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))

typedef struct _FunctionCompletionProvider FunctionCompletionProvider;
typedef struct _FunctionCompletionProviderClass FunctionCompletionProviderClass;

#define TYPE_CURRENCY_COMPLETION_PROVIDER (currency_completion_provider_get_type ())
#define CURRENCY_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY_COMPLETION_PROVIDER, CurrencyCompletionProvider))
#define CURRENCY_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY_COMPLETION_PROVIDER, CurrencyCompletionProviderClass))
#define IS_CURRENCY_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY_COMPLETION_PROVIDER))
#define IS_CURRENCY_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY_COMPLETION_PROVIDER))
#define CURRENCY_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY_COMPLETION_PROVIDER, CurrencyCompletionProviderClass))

typedef struct _CurrencyCompletionProvider CurrencyCompletionProvider;
typedef struct _CurrencyCompletionProviderClass CurrencyCompletionProviderClass;

#define TYPE_VARIABLE_COMPLETION_PROVIDER (variable_completion_provider_get_type ())
#define VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider))
#define VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))
#define IS_VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define IS_VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define VARIABLE_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))

typedef struct _VariableCompletionProvider VariableCompletionProvider;
typedef struct _VariableCompletionProviderClass VariableCompletionProviderClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD,
	BUTTON_MODE_CONVERSION
} ButtonMode;

#define TYPE_BUTTON_MODE (button_mode_get_type ())
enum  {
	MATH_DISPLAY_ARR_KEY_PRESSED_SIGNAL,
	MATH_DISPLAY_NUM_SIGNALS
};
static guint math_display_signals[MATH_DISPLAY_NUM_SIGNALS] = {0};

#define TYPE_COMPLETION_PROPOSAL (completion_proposal_get_type ())
#define COMPLETION_PROPOSAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROPOSAL, CompletionProposal))
#define COMPLETION_PROPOSAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROPOSAL, CompletionProposalClass))
#define IS_COMPLETION_PROPOSAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROPOSAL))
#define IS_COMPLETION_PROPOSAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROPOSAL))
#define COMPLETION_PROPOSAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROPOSAL, CompletionProposalClass))

typedef struct _CompletionProposal CompletionProposal;
typedef struct _CompletionProposalClass CompletionProposalClass;
typedef struct _CompletionProposalPrivate CompletionProposalPrivate;
enum  {
	COMPLETION_PROPOSAL_0_PROPERTY,
	COMPLETION_PROPOSAL_LABEL_PROPERTY,
	COMPLETION_PROPOSAL_DETAILS_PROPERTY,
	COMPLETION_PROPOSAL_NUM_PROPERTIES
};
static GParamSpec* completion_proposal_properties[COMPLETION_PROPOSAL_NUM_PROPERTIES];
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
enum  {
	COMPLETION_PROVIDER_0_PROPERTY,
	COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* completion_provider_properties[COMPLETION_PROVIDER_NUM_PROPERTIES];
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))
typedef struct _FunctionCompletionProviderPrivate FunctionCompletionProviderPrivate;
enum  {
	FUNCTION_COMPLETION_PROVIDER_0_PROPERTY,
	FUNCTION_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* function_completion_provider_properties[FUNCTION_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _FunctionCompletionProviderPopulateAsyncData FunctionCompletionProviderPopulateAsyncData;
typedef struct _BuiltinCompletionProviderPrivate BuiltinCompletionProviderPrivate;
enum  {
	BUILTIN_COMPLETION_PROVIDER_0_PROPERTY,
	BUILTIN_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* builtin_completion_provider_properties[BUILTIN_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _BuiltinCompletionProviderPopulateAsyncData BuiltinCompletionProviderPopulateAsyncData;
typedef struct _CurrencyCompletionProviderPrivate CurrencyCompletionProviderPrivate;
enum  {
	CURRENCY_COMPLETION_PROVIDER_0_PROPERTY,
	CURRENCY_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* currency_completion_provider_properties[CURRENCY_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _CurrencyCompletionProviderPopulateAsyncData CurrencyCompletionProviderPopulateAsyncData;
typedef struct _VariableCompletionProviderPrivate VariableCompletionProviderPrivate;
enum  {
	VARIABLE_COMPLETION_PROVIDER_0_PROPERTY,
	VARIABLE_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* variable_completion_provider_properties[VARIABLE_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _VariableCompletionProviderPopulateAsyncData VariableCompletionProviderPopulateAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MathDisplay {
	GtkBox parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkBoxClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	GtkScrolledWindow* display_scrolled;
	GtkSourceView* source_view;
	GtkTextView* info_view;
	GtkEventControllerKey* event_controller;
	AdwSpinner* spinner;
	GtkButton* backspace_button;
	GHashTable* providers;
	gchar** _enabled_completions;
	gint _enabled_completions_length1;
	gint __enabled_completions_size_;
	gboolean _completion_visible;
	GRegex* only_variable_name;
	GRegex* only_function_definition;
};

struct _CompletionProposal {
	GObject parent_instance;
	CompletionProposalPrivate * priv;
};

struct _CompletionProposalClass {
	GObjectClass parent_class;
};

struct _CompletionProposalPrivate {
	gchar* _label;
	gchar* _details;
};

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
	gchar* (*get_title) (CompletionProvider* self);
	void (*populate_async) (CompletionProvider* self, GtkSourceCompletionContext* context, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GListModel* (*populate_finish) (CompletionProvider* self, GAsyncResult* _res_, GError** error);
	GPtrArray* (*list_alternates) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal);
	gint (*get_priority) (CompletionProvider* self, GtkSourceCompletionContext* context);
	gboolean (*is_trigger) (CompletionProvider* self, GtkTextIter* iter, gunichar ch);
	gboolean (*key_activates) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, guint keyval, GdkModifierType mod);
	void (*display) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkSourceCompletionCell* cell);
	gboolean (*get_start_iter) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
};

struct _FunctionCompletionProvider {
	CompletionProvider parent_instance;
	FunctionCompletionProviderPrivate * priv;
};

struct _FunctionCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _FunctionCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FunctionCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	MathFunction** functions;
	gint _tmp1_;
	MathFunction** _tmp2_;
	gint functions_length1;
	gint _functions_size_;
	gchar* word;
	gchar* _tmp3_;
	MathFunction** _tmp4_;
	gint _tmp4__length1;
	MathFunction** _tmp5_;
	gint _tmp5__length1;
	MathFunction** function_collection;
	gint function_collection_length1;
	gint _function_collection_size_;
	gint function_it;
	MathFunction* _tmp6_;
	MathFunction* function;
	gchar* label_text;
	MathFunction* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* details_text;
	MathFunction* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	MathFunction* _tmp15_;
	MathFunction* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	MathFunction* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar* _tmp24_;
	MathFunction* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	MathFunction* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	MathFunction* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GListStore* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	CompletionProposal* _tmp42_;
	CompletionProposal* _tmp43_;
	GListStore* _tmp44_;
	GListModel* _tmp45_;
	const gchar* _tmp46_;
	GtkStringFilter* _tmp47_;
	GtkFilterListModel* _tmp48_;
};

struct _BuiltinCompletionProvider {
	CompletionProvider parent_instance;
	BuiltinCompletionProviderPrivate * priv;
};

struct _BuiltinCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _BuiltinCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BuiltinCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	gchar** keywords;
	gint _tmp1_;
	gchar** _tmp2_;
	gint keywords_length1;
	gint _keywords_size_;
	gchar* word;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** keyword_collection;
	gint keyword_collection_length1;
	gint _keyword_collection_size_;
	gint keyword_it;
	gchar* _tmp6_;
	gchar* keyword;
	GListStore* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	CompletionProposal* _tmp10_;
	CompletionProposal* _tmp11_;
	GListStore* _tmp12_;
	GListModel* _tmp13_;
	const gchar* _tmp14_;
	GtkStringFilter* _tmp15_;
	GtkFilterListModel* _tmp16_;
};

struct _CurrencyCompletionProvider {
	CompletionProvider parent_instance;
	CurrencyCompletionProviderPrivate * priv;
};

struct _CurrencyCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _CurrencyCompletionProviderPrivate {
	gboolean favorite;
};

struct _CurrencyCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	CurrencyCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	Currency** currencies;
	gint _tmp1_;
	Currency** _tmp2_;
	gint currencies_length1;
	gint _currencies_size_;
	gchar* word;
	gchar* _tmp3_;
	Currency** _tmp4_;
	gint _tmp4__length1;
	Currency** _tmp5_;
	gint _tmp5__length1;
	Currency** currency_collection;
	gint currency_collection_length1;
	gint _currency_collection_size_;
	gint currency_it;
	Currency* _tmp6_;
	Currency* currency;
	gchar* label_text;
	Currency* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* details_text;
	Currency* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	Currency* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GListStore* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	CompletionProposal* _tmp26_;
	CompletionProposal* _tmp27_;
	GListStore* _tmp28_;
	GListModel* _tmp29_;
	const gchar* _tmp30_;
	GtkStringFilter* _tmp31_;
	GtkFilterListModel* _tmp32_;
};

struct _VariableCompletionProvider {
	CompletionProvider parent_instance;
	VariableCompletionProviderPrivate * priv;
};

struct _VariableCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProviderPrivate {
	MathEquation* _equation;
};

struct _VariableCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	VariableCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	gchar** variables;
	MathEquation* _tmp1_;
	MathVariables* _tmp2_;
	MathVariables* _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint variables_length1;
	gint _variables_size_;
	gchar* word;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** variable_collection;
	gint variable_collection_length1;
	gint _variable_collection_size_;
	gint variable_it;
	gchar* _tmp9_;
	gchar* variable;
	gchar* label_text;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* value_text;
	MathEquation* _tmp12_;
	Serializer* _tmp13_;
	Serializer* _tmp14_;
	MathEquation* _tmp15_;
	MathVariables* _tmp16_;
	MathVariables* _tmp17_;
	const gchar* _tmp18_;
	Number* _tmp19_;
	Number* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* details_text;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	GListStore* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	CompletionProposal* _tmp29_;
	CompletionProposal* _tmp30_;
	GListStore* _tmp31_;
	GListModel* _tmp32_;
	const gchar* _tmp33_;
	GtkStringFilter* _tmp34_;
	GtkFilterListModel* _tmp35_;
};

static gint MathDisplay_private_offset;
static gpointer math_display_parent_class = NULL;
static gint CompletionProposal_private_offset;
static gpointer completion_proposal_parent_class = NULL;
static GtkSourceCompletionProposalInterface * completion_proposal_gtk_source_completion_proposal_parent_iface = NULL;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer function_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * function_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer builtin_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * builtin_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gint CurrencyCompletionProvider_private_offset;
static gpointer currency_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * currency_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gint VariableCompletionProvider_private_offset;
static gpointer variable_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * variable_completion_provider_gtk_source_completion_provider_parent_iface = NULL;

VALA_EXTERN GType math_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathDisplay, g_object_unref)
VALA_EXTERN MathDisplay* math_display_new (MathEquation* equation);
VALA_EXTERN MathDisplay* math_display_construct (GType object_type,
                                     MathEquation* equation);
static void math_display_construct_finish (MathDisplay* self);
VALA_EXTERN MathEquation* math_display_get_equation (MathDisplay* self);
static void math_display_create_autocompletion (MathDisplay* self);
VALA_EXTERN GType math_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathWindow, g_object_unref)
VALA_EXTERN GType math_buttons_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathButtons, g_object_unref)
VALA_EXTERN MathButtons* math_window_get_buttons (MathWindow* self);
static void math_display_base_label_changed_cb (MathDisplay* self);
static void _math_display_base_label_changed_cb_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void math_display_status_changed_cb (MathDisplay* self);
static void _math_display_status_changed_cb_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void _math_display_error_status_changed_cb_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void __lambda38_ (MathDisplay* self,
                  GtkMovementStep step,
                  gint count,
                  gboolean extend_selection);
static void ___lambda38__gtk_text_view_move_cursor (GtkTextView* _sender,
                                             GtkMovementStep step,
                                             gint count,
                                             gboolean extend_selection,
                                             gpointer self);
static void __lambda39_ (MathDisplay* self);
static void ___lambda39__gtk_text_view_paste_clipboard (GtkTextView* _sender,
                                                 gpointer self);
VALA_EXTERN void math_display_set_enable_osk (MathDisplay* self,
                                  gboolean enable_osk);
VALA_EXTERN void math_display_display_text (MathDisplay* self,
                                const gchar* prev_eq);
VALA_EXTERN void math_display_insert_text (MathDisplay* self,
                               const gchar* answer);
VALA_EXTERN void math_display_set_enable_autocompletion (MathDisplay* self,
                                             gboolean enable_autocompletion);
static void __lambda15_ (MathDisplay* self,
                  GtkSourceCompletion* completion);
VALA_EXTERN void math_display_set_completion_visible (MathDisplay* self,
                                          gboolean value);
static void ___lambda15__gtk_source_completion_show (GtkSourceCompletion* _sender,
                                              gpointer self);
static void __lambda16_ (MathDisplay* self,
                  GtkSourceCompletion* completion);
static void ___lambda16__gtk_source_completion_hide (GtkSourceCompletion* _sender,
                                              gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN BuiltinCompletionProvider* builtin_completion_provider_new (void);
VALA_EXTERN BuiltinCompletionProvider* builtin_completion_provider_construct (GType object_type);
VALA_EXTERN GType completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
VALA_EXTERN GType builtin_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuiltinCompletionProvider, g_object_unref)
VALA_EXTERN FunctionCompletionProvider* function_completion_provider_new (void);
VALA_EXTERN FunctionCompletionProvider* function_completion_provider_construct (GType object_type);
VALA_EXTERN GType function_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FunctionCompletionProvider, g_object_unref)
VALA_EXTERN CurrencyCompletionProvider* currency_completion_provider_new (gboolean favorite);
VALA_EXTERN CurrencyCompletionProvider* currency_completion_provider_construct (GType object_type,
                                                                    gboolean favorite);
VALA_EXTERN GType currency_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CurrencyCompletionProvider, g_object_unref)
VALA_EXTERN VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation);
VALA_EXTERN VariableCompletionProvider* variable_completion_provider_construct (GType object_type,
                                                                    MathEquation* equation);
VALA_EXTERN GType variable_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VariableCompletionProvider, g_object_unref)
static void __lambda17_ (MathDisplay* self,
                  gboolean enable);
static void ___lambda17__math_equation_set_enable_autocompletion (MathEquation* _sender,
                                                           gboolean enable,
                                                           gpointer self);
static gboolean math_display_key_press_cb (MathDisplay* self,
                                    GtkEventControllerKey* controller,
                                    guint keyval,
                                    guint keycode,
                                    GdkModifierType mod_state);
VALA_EXTERN gboolean math_display_get_completion_visible (MathDisplay* self);
VALA_EXTERN GType button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ButtonMode math_buttons_get_mode (MathButtons* self);
static gboolean _math_display_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                          guint keyval,
                                                                          guint keycode,
                                                                          GdkModifierType state,
                                                                          gpointer self);
static gboolean math_display_scroll_cb (MathDisplay* self,
                                 GtkEventControllerScroll* controller,
                                 gdouble dx,
                                 gdouble dy);
static gboolean _math_display_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                     gdouble dx,
                                                                     gdouble dy,
                                                                     gpointer self);
VALA_EXTERN void math_display_grab_focus (MathDisplay* self);
static void math_display_backspace_cb (MathDisplay* self);
static void _math_display_backspace_cb_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self);
VALA_EXTERN void math_display_set_equation (MathDisplay* self,
                                MathEquation* value);
VALA_EXTERN void math_display_set_enabled_completions (MathDisplay* self,
                                           gchar** value,
                                           gint value_length1);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static GObject * math_display_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _math_display_construct_finish_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void math_display_finalize (GObject * obj);
static GType math_display_get_type_once (void);
static void _vala_math_display_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_math_display_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
VALA_EXTERN GType completion_proposal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProposal, g_object_unref)
VALA_EXTERN CompletionProposal* completion_proposal_new (const gchar* label,
                                             const gchar* details);
VALA_EXTERN CompletionProposal* completion_proposal_construct (GType object_type,
                                                   const gchar* label,
                                                   const gchar* details);
VALA_EXTERN const gchar* completion_proposal_get_label (CompletionProposal* self);
VALA_EXTERN const gchar* completion_proposal_get_details (CompletionProposal* self);
static void completion_proposal_finalize (GObject * obj);
static GType completion_proposal_get_type_once (void);
static void _vala_completion_proposal_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN gchar* completion_provider_get_title (CompletionProvider* self);
VALA_EXTERN GPtrArray* completion_provider_list_alternates (CompletionProvider* self,
                                                GtkSourceCompletionContext* context,
                                                GtkSourceCompletionProposal* proposal);
VALA_EXTERN gint completion_provider_get_priority (CompletionProvider* self,
                                       GtkSourceCompletionContext* context);
VALA_EXTERN gboolean completion_provider_is_trigger (CompletionProvider* self,
                                         GtkTextIter* iter,
                                         gunichar ch);
VALA_EXTERN gboolean completion_provider_key_activates (CompletionProvider* self,
                                            GtkSourceCompletionContext* context,
                                            GtkSourceCompletionProposal* proposal,
                                            guint keyval,
                                            GdkModifierType mod);
VALA_EXTERN void completion_provider_display (CompletionProvider* self,
                                  GtkSourceCompletionContext* context,
                                  GtkSourceCompletionProposal* proposal,
                                  GtkSourceCompletionCell* cell);
VALA_EXTERN gboolean completion_provider_get_start_iter (CompletionProvider* self,
                                             GtkSourceCompletionContext* context,
                                             GtkSourceCompletionProposal* proposal,
                                             GtkTextIter* iter);
static gchar* completion_provider_real_get_title (CompletionProvider* self);
VALA_EXTERN void completion_provider_populate_async (CompletionProvider* self,
                                         GtkSourceCompletionContext* context,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN GListModel* completion_provider_populate_finish (CompletionProvider* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static GPtrArray* completion_provider_real_list_alternates (CompletionProvider* self,
                                                     GtkSourceCompletionContext* context,
                                                     GtkSourceCompletionProposal* proposal);
static gint completion_provider_real_get_priority (CompletionProvider* self,
                                            GtkSourceCompletionContext* context);
static gboolean completion_provider_real_is_trigger (CompletionProvider* self,
                                              GtkTextIter* iter,
                                              gunichar ch);
static gboolean completion_provider_real_key_activates (CompletionProvider* self,
                                                 GtkSourceCompletionContext* context,
                                                 GtkSourceCompletionProposal* proposal,
                                                 guint keyval,
                                                 GdkModifierType mod);
static void completion_provider_real_display (CompletionProvider* self,
                                       GtkSourceCompletionContext* context,
                                       GtkSourceCompletionProposal* proposal,
                                       GtkSourceCompletionCell* cell);
VALA_EXTERN void completion_provider_move_iter_to_name_start (GtkTextIter* iter);
static gboolean completion_provider_real_get_start_iter (CompletionProvider* self,
                                                  GtkSourceCompletionContext* context,
                                                  GtkSourceCompletionProposal* proposal,
                                                  GtkTextIter* iter);
VALA_EXTERN GtkStringFilter* completion_provider_create_filter (const gchar* word);
static void completion_provider_real_refilter (GtkSourceCompletionProvider* base,
                                        GtkSourceCompletionContext* context,
                                        GListModel* model);
static void completion_provider_real_activate (GtkSourceCompletionProvider* base,
                                        GtkSourceCompletionContext* context,
                                        GtkSourceCompletionProposal* proposal);
VALA_EXTERN CompletionProvider* completion_provider_construct (GType object_type);
static GType completion_provider_get_type_once (void);
static gchar* function_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
VALA_EXTERN MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                                  gint* result_length1);
static void function_completion_provider_real_populate_async_data_free (gpointer _data);
static void function_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                       GtkSourceCompletionContext* context,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean function_completion_provider_real_populate_async_co (FunctionCompletionProviderPopulateAsyncData* _data_);
static GType function_completion_provider_get_type_once (void);
static gchar* builtin_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
static gint builtin_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                    GtkSourceCompletionContext* context);
VALA_EXTERN gchar** builtin_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                          gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void builtin_completion_provider_real_populate_async_data_free (gpointer _data);
static void builtin_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                      GtkSourceCompletionContext* context,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean builtin_completion_provider_real_populate_async_co (BuiltinCompletionProviderPopulateAsyncData* _data_);
static GType builtin_completion_provider_get_type_once (void);
static gchar* currency_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
static gint currency_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                     GtkSourceCompletionContext* context);
VALA_EXTERN Currency** currency_completion_provider_get_matches_for_completion_at_cursor (CurrencyCompletionProvider* self,
                                                                              GtkSourceCompletionContext* context,
                                                                              gint* result_length1);
static void currency_completion_provider_real_populate_async_data_free (gpointer _data);
static void currency_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                       GtkSourceCompletionContext* context,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean currency_completion_provider_real_populate_async_co (CurrencyCompletionProviderPopulateAsyncData* _data_);
static void currency_completion_provider_finalize (GObject * obj);
static GType currency_completion_provider_get_type_once (void);
static gchar* variable_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
static gint variable_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                     GtkSourceCompletionContext* context);
VALA_EXTERN gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                           MathVariables* variables,
                                                                           gint* result_length1);
static void variable_completion_provider_real_populate_async_data_free (gpointer _data);
static void variable_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                       GtkSourceCompletionContext* context,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean variable_completion_provider_real_populate_async_co (VariableCompletionProviderPopulateAsyncData* _data_);
static void variable_completion_provider_finalize (GObject * obj);
static GType variable_completion_provider_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;

static inline gpointer
math_display_get_instance_private (MathDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, MathDisplay_private_offset);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

MathDisplay*
math_display_construct (GType object_type,
                        MathEquation* equation)
{
	MathDisplay * self = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, "equation", equation, NULL);
	return self;
}

MathDisplay*
math_display_new (MathEquation* equation)
{
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}

static void
_math_display_base_label_changed_cb_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	math_display_base_label_changed_cb ((MathDisplay*) self);
}

static void
_math_display_status_changed_cb_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	math_display_status_changed_cb ((MathDisplay*) self);
}

static void
_math_display_error_status_changed_cb_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	math_display_error_status_changed_cb ((MathDisplay*) self);
}

static void
__lambda38_ (MathDisplay* self,
             GtkMovementStep step,
             gint count,
             gboolean extend_selection)
{
	GtkTextIter cursor_iter = {0};
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gdouble width = 0.0;
	GtkSourceView* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gint _tmp10_ = 0;
	gdouble margin = 0.0;
	gdouble within_margin = 0.0;
	GtkSourceView* _tmp17_;
	GtkTextIter _tmp18_;
	_tmp0_ = self->priv->_equation;
	_tmp1_ = self->priv->_equation;
	g_object_get ((GtkTextBuffer*) _tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) _tmp0_, &_tmp4_, _tmp3_);
	cursor_iter = _tmp4_;
	_tmp5_ = self->priv->source_view;
	_tmp6_ = gtk_scrollable_get_hadjustment ((GtkScrollable*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_adjustment_get_page_size (_tmp7_);
	_tmp9_ = _tmp8_;
	width = _tmp9_;
	_vala_assert (width > ((gdouble) 0), "width > 0");
	if (count > 0) {
		GtkSourceView* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = self->priv->source_view;
		_tmp12_ = gtk_text_view_get_right_margin ((GtkTextView*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp10_ = _tmp13_;
	} else {
		GtkSourceView* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = self->priv->source_view;
		_tmp15_ = gtk_text_view_get_left_margin ((GtkTextView*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp10_ = _tmp16_;
	}
	margin = (gdouble) _tmp10_;
	within_margin = CLAMP (margin / width, 0.0, 0.5 - DBL_EPSILON);
	_tmp17_ = self->priv->source_view;
	_tmp18_ = cursor_iter;
	gtk_text_view_scroll_to_iter ((GtkTextView*) _tmp17_, &_tmp18_, within_margin, FALSE, (gdouble) 0, (gdouble) 0);
}

static void
___lambda38__gtk_text_view_move_cursor (GtkTextView* _sender,
                                        GtkMovementStep step,
                                        gint count,
                                        gboolean extend_selection,
                                        gpointer self)
{
	__lambda38_ ((MathDisplay*) self, step, count, extend_selection);
}

static void
__lambda39_ (MathDisplay* self)
{
	MathEquation* _tmp0_;
	GtkSourceView* _tmp1_;
	_tmp0_ = self->priv->_equation;
	math_equation_paste (_tmp0_);
	_tmp1_ = self->priv->source_view;
	g_signal_stop_emission_by_name (_tmp1_, "paste-clipboard");
}

static void
___lambda39__gtk_text_view_paste_clipboard (GtkTextView* _sender,
                                            gpointer self)
{
	__lambda39_ ((MathDisplay*) self);
}

static void
math_display_construct_finish (MathDisplay* self)
{
	MathEquation* _tmp0_;
	GtkRoot* _tmp1_;
	GtkRoot* _tmp2_;
	MathButtons* _tmp3_;
	MathButtons* _tmp4_;
	MathEquation* _tmp5_;
	MathEquation* _tmp6_;
	MathEquation* _tmp7_;
	GtkSourceView* _tmp8_;
	GtkSourceView* _tmp9_;
	GtkSourceView* _tmp10_;
	GtkSourceView* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	if (_tmp0_ == NULL) {
		return;
	}
	math_display_create_autocompletion (self);
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_window_get_buttons (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MATH_WINDOW, MathWindow));
	_tmp4_ = _tmp3_;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::mode", (GCallback) _math_display_base_label_changed_cb_g_object_notify, self, 0);
	_tmp5_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::base-label", (GCallback) _math_display_base_label_changed_cb_g_object_notify, self, 0);
	_tmp6_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::status", (GCallback) _math_display_status_changed_cb_g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	_tmp7_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::error-token-end", (GCallback) _math_display_error_status_changed_cb_g_object_notify, self, 0);
	_tmp8_ = self->priv->source_view;
	g_signal_connect_object ((GtkTextView*) _tmp8_, "move-cursor", (GCallback) ___lambda38__gtk_text_view_move_cursor, self, G_CONNECT_AFTER);
	_tmp9_ = self->priv->source_view;
	g_signal_connect_object ((GtkTextView*) _tmp9_, "paste-clipboard", (GCallback) ___lambda39__gtk_text_view_paste_clipboard, self, 0);
	_tmp10_ = self->priv->source_view;
	gtk_text_view_set_extra_menu ((GtkTextView*) _tmp10_, NULL);
	_tmp11_ = self->priv->source_view;
	gtk_widget_set_direction ((GtkWidget*) _tmp11_, GTK_TEXT_DIR_LTR);
}

void
math_display_set_enable_osk (MathDisplay* self,
                             gboolean enable_osk)
{
	GtkButton* _tmp12_;
	g_return_if_fail (self != NULL);
	if (enable_osk) {
		GtkSourceView* _tmp0_;
		GtkSourceView* _tmp1_;
		GtkInputHints _tmp2_;
		GtkInputHints _tmp3_;
		_tmp0_ = self->priv->source_view;
		_tmp1_ = self->priv->source_view;
		_tmp2_ = gtk_text_view_get_input_hints ((GtkTextView*) _tmp1_);
		_tmp3_ = _tmp2_;
		gtk_text_view_set_input_hints ((GtkTextView*) _tmp1_, _tmp3_ & (~GTK_INPUT_HINT_INHIBIT_OSK));
	} else {
		GtkSourceView* _tmp4_;
		GtkSourceView* _tmp5_;
		GtkInputHints _tmp6_;
		GtkInputHints _tmp7_;
		_tmp4_ = self->priv->source_view;
		_tmp5_ = self->priv->source_view;
		_tmp6_ = gtk_text_view_get_input_hints ((GtkTextView*) _tmp5_);
		_tmp7_ = _tmp6_;
		gtk_text_view_set_input_hints ((GtkTextView*) _tmp5_, _tmp7_ | GTK_INPUT_HINT_INHIBIT_OSK);
	}
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_LTR) {
		gint _tmp8_ = 0;
		GtkSourceView* _tmp9_;
		if (enable_osk) {
			_tmp8_ = 14;
		} else {
			_tmp8_ = 0;
		}
		_tmp9_ = self->priv->source_view;
		gtk_text_view_set_right_margin ((GtkTextView*) _tmp9_, _tmp8_);
	} else {
		gint _tmp10_ = 0;
		GtkSourceView* _tmp11_;
		if (enable_osk) {
			_tmp10_ = 14;
		} else {
			_tmp10_ = 0;
		}
		_tmp11_ = self->priv->source_view;
		gtk_text_view_set_left_margin ((GtkTextView*) _tmp11_, _tmp10_);
	}
	_tmp12_ = self->priv->backspace_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, !enable_osk);
}

void
math_display_display_text (MathDisplay* self,
                           const gchar* prev_eq)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev_eq != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_display_selected (_tmp0_, prev_eq);
}

void
math_display_insert_text (MathDisplay* self,
                          const gchar* answer)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_selected (_tmp0_, answer);
}

void
math_display_set_enable_autocompletion (MathDisplay* self,
                                        gboolean enable_autocompletion)
{
	g_return_if_fail (self != NULL);
	if (enable_autocompletion) {
		GtkSourceView* _tmp0_;
		GtkSourceCompletion* _tmp1_;
		_tmp0_ = self->priv->source_view;
		_tmp1_ = gtk_source_view_get_completion (_tmp0_);
		gtk_source_completion_unblock_interactive (_tmp1_);
	} else {
		GtkSourceView* _tmp2_;
		GtkSourceCompletion* _tmp3_;
		_tmp2_ = self->priv->source_view;
		_tmp3_ = gtk_source_view_get_completion (_tmp2_);
		gtk_source_completion_block_interactive (_tmp3_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda15_ (MathDisplay* self,
             GtkSourceCompletion* completion)
{
	g_return_if_fail (completion != NULL);
	math_display_set_completion_visible (self, TRUE);
}

static void
___lambda15__gtk_source_completion_show (GtkSourceCompletion* _sender,
                                         gpointer self)
{
	__lambda15_ ((MathDisplay*) self, _sender);
}

static void
__lambda16_ (MathDisplay* self,
             GtkSourceCompletion* completion)
{
	g_return_if_fail (completion != NULL);
	math_display_set_completion_visible (self, FALSE);
}

static void
___lambda16__gtk_source_completion_hide (GtkSourceCompletion* _sender,
                                         gpointer self)
{
	__lambda16_ ((MathDisplay*) self, _sender);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda17_ (MathDisplay* self,
             gboolean enable)
{
	math_display_set_enable_autocompletion (self, enable);
}

static void
___lambda17__math_equation_set_enable_autocompletion (MathEquation* _sender,
                                                      gboolean enable,
                                                      gpointer self)
{
	__lambda17_ ((MathDisplay*) self, enable);
}

static void
math_display_create_autocompletion (MathDisplay* self)
{
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceCompletion* _tmp1_;
	GtkSourceCompletion* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	BuiltinCompletionProvider* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	FunctionCompletionProvider* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	CurrencyCompletionProvider* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	CurrencyCompletionProvider* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	MathEquation* _tmp20_;
	VariableCompletionProvider* _tmp21_;
	MathEquation* _tmp22_;
	GSettings* settings = NULL;
	GSettings* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	completion = _tmp2_;
	g_object_set (completion, "select-on-show", TRUE, NULL);
	g_signal_connect_object (completion, "show", (GCallback) ___lambda15__gtk_source_completion_show, self, 0);
	g_signal_connect_object (completion, "hide", (GCallback) ___lambda16__gtk_source_completion_hide, self, 0);
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->providers);
	self->priv->providers = _tmp5_;
	_tmp6_ = self->priv->providers;
	_tmp7_ = g_strdup ("builtin");
	_tmp8_ = builtin_completion_provider_new ();
	g_hash_table_insert (_tmp6_, _tmp7_, (GtkSourceCompletionProvider*) _tmp8_);
	_tmp9_ = self->priv->providers;
	_tmp10_ = g_strdup ("function");
	_tmp11_ = function_completion_provider_new ();
	g_hash_table_insert (_tmp9_, _tmp10_, (GtkSourceCompletionProvider*) _tmp11_);
	_tmp12_ = self->priv->providers;
	_tmp13_ = g_strdup ("currency");
	_tmp14_ = currency_completion_provider_new (FALSE);
	g_hash_table_insert (_tmp12_, _tmp13_, (GtkSourceCompletionProvider*) _tmp14_);
	_tmp15_ = self->priv->providers;
	_tmp16_ = g_strdup ("favorite");
	_tmp17_ = currency_completion_provider_new (TRUE);
	g_hash_table_insert (_tmp15_, _tmp16_, (GtkSourceCompletionProvider*) _tmp17_);
	_tmp18_ = self->priv->providers;
	_tmp19_ = g_strdup ("variable");
	_tmp20_ = self->priv->_equation;
	_tmp21_ = variable_completion_provider_new (_tmp20_);
	g_hash_table_insert (_tmp18_, _tmp19_, (GtkSourceCompletionProvider*) _tmp21_);
	_tmp22_ = self->priv->_equation;
	g_signal_connect_object (_tmp22_, "set-enable-autocompletion", (GCallback) ___lambda17__math_equation_set_enable_autocompletion, self, 0);
	_tmp23_ = g_settings_new ("org.gnome.calculator");
	settings = _tmp23_;
	g_settings_bind (settings, "enabled-completions", (GObject*) self, "enabled_completions", G_SETTINGS_BIND_GET);
	_g_object_unref0 (settings);
	_g_object_unref0 (completion);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
math_display_key_press_cb (MathDisplay* self,
                           GtkEventControllerKey* controller,
                           guint keyval,
                           guint keycode,
                           GdkModifierType mod_state)
{
	GdkModifierType state = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	MathEquation* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	guint new_keyval = 0U;
	guint32 c = 0U;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp74_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	g_info ("math-display.vala:163: event\n");
	state = mod_state & (GDK_CONTROL_MASK | GDK_ALT_MASK);
	if (keyval == GDK_KEY_Escape) {
		_tmp2_ = state == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_completion_visible;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (keyval == GDK_KEY_Delete) {
			_tmp4_ = (mod_state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		MathEquation* _tmp5_;
		_tmp5_ = self->priv->_equation;
		math_equation_clear (_tmp5_);
		math_display_status_changed_cb (self);
		result = TRUE;
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		if (keyval == GDK_KEY_Escape) {
			_tmp7_ = state == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gboolean _tmp8_;
			_tmp8_ = self->priv->_completion_visible;
			_tmp6_ = _tmp8_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkSourceCompletion* completion = NULL;
			GtkSourceView* _tmp9_;
			GtkSourceCompletion* _tmp10_;
			GtkSourceCompletion* _tmp11_;
			GtkSourceCompletion* _tmp12_;
			_tmp9_ = self->priv->source_view;
			_tmp10_ = gtk_source_view_get_completion (_tmp9_);
			_tmp11_ = _g_object_ref0 (_tmp10_);
			completion = _tmp11_;
			_tmp12_ = completion;
			gtk_source_completion_hide (_tmp12_);
			result = TRUE;
			_g_object_unref0 (completion);
			return result;
		}
	}
	_tmp13_ = self->priv->_equation;
	_tmp14_ = math_equation_get_in_solve (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		result = TRUE;
		return result;
	}
	new_keyval = (guint) 0;
	switch (keyval) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = GDK_KEY_9;
			break;
		}
		case GDK_KEY_KP_Delete:
		{
			new_keyval = GDK_KEY_period;
			break;
		}
		default:
		break;
	}
	if (new_keyval != ((guint) 0)) {
		g_info ("math-display.vala:227: forwarding\n");
		result = math_display_key_press_cb (self, controller, new_keyval, keycode, mod_state);
		return result;
	}
	c = gdk_keyval_to_unicode (keyval);
	if (keyval == GDK_KEY_equal) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = keyval == GDK_KEY_KP_Equal;
	}
	if (_tmp16_) {
		gboolean _tmp17_ = FALSE;
		GRegex* _tmp18_;
		MathEquation* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gboolean _tmp25_;
		_tmp18_ = self->priv->only_variable_name;
		_tmp19_ = self->priv->_equation;
		_tmp20_ = math_equation_get_equation (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = string_strip (_tmp22_);
		_tmp24_ = (gchar*) _tmp23_;
		_tmp25_ = g_regex_match (_tmp18_, _tmp24_, 0, NULL);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		if (_tmp25_) {
			_tmp17_ = TRUE;
		} else {
			GRegex* _tmp26_;
			MathEquation* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp26_ = self->priv->only_function_definition;
			_tmp27_ = self->priv->_equation;
			_tmp28_ = math_equation_get_equation (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_;
			_tmp31_ = string_strip (_tmp30_);
			_tmp32_ = (gchar*) _tmp31_;
			_tmp17_ = g_regex_match (_tmp26_, _tmp32_, 0, NULL);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
		}
		if (!_tmp17_) {
			keyval = GDK_KEY_KP_Enter;
		}
	}
	if (keyval == GDK_KEY_Return) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = keyval == GDK_KEY_KP_Enter;
	}
	if (_tmp33_) {
		MathEquation* _tmp34_;
		_tmp34_ = self->priv->_equation;
		math_equation_solve (_tmp34_);
		result = TRUE;
		return result;
	}
	if (keyval == GDK_KEY_KP_Decimal) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = keyval == GDK_KEY_KP_Separator;
	}
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = keyval == GDK_KEY_period;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		_tmp36_ = keyval == GDK_KEY_decimalpoint;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = keyval == GDK_KEY_comma;
	}
	if (_tmp35_) {
		MathEquation* _tmp39_;
		_tmp39_ = self->priv->_equation;
		math_equation_insert_numeric_point (_tmp39_);
		result = TRUE;
		return result;
	}
	if (state == 0) {
		if (c == ((guint32) '*')) {
			MathEquation* _tmp40_;
			_tmp40_ = self->priv->_equation;
			math_equation_insert (_tmp40_, "×");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '>')) {
			MathEquation* _tmp41_;
			_tmp41_ = self->priv->_equation;
			math_equation_insert (_tmp41_, ">");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '<')) {
			MathEquation* _tmp42_;
			_tmp42_ = self->priv->_equation;
			math_equation_insert (_tmp42_, "<");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '/')) {
			MathEquation* _tmp43_;
			_tmp43_ = self->priv->_equation;
			math_equation_insert (_tmp43_, "÷");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '-')) {
			MathEquation* _tmp44_;
			_tmp44_ = self->priv->_equation;
			math_equation_insert_subtract (_tmp44_);
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '\'')) {
			MathEquation* _tmp45_;
			_tmp45_ = self->priv->_equation;
			math_equation_insert (_tmp45_, "′");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '"')) {
			MathEquation* _tmp46_;
			_tmp46_ = self->priv->_equation;
			math_equation_insert (_tmp46_, "″");
			result = TRUE;
			return result;
		}
	}
	if (state == 0) {
		MathEquation* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		_tmp48_ = self->priv->_equation;
		_tmp49_ = math_equation_get_number_base (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp47_ = _tmp50_ == 16;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		guint digit = 0U;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		digit = (guint) 0;
		if (c >= ((guint32) 'A')) {
			_tmp51_ = c <= ((guint32) 'F');
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			digit = (guint) ((c - 'A') + 10);
		}
		if (c >= ((guint32) 'a')) {
			_tmp52_ = c <= ((guint32) 'f');
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			digit = (guint) ((c - 'a') + 10);
		}
		if (digit != ((guint) 0)) {
			MathEquation* _tmp53_;
			math_display_set_enable_autocompletion (self, FALSE);
			_tmp53_ = self->priv->_equation;
			math_equation_insert_digit (_tmp53_, digit);
			math_display_set_enable_autocompletion (self, TRUE);
			result = TRUE;
			return result;
		}
	}
	if (state == GDK_CONTROL_MASK) {
		switch (keyval) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp54_;
				_tmp54_ = self->priv->_equation;
				math_equation_insert (_tmp54_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp55_;
				_tmp55_ = self->priv->_equation;
				math_equation_insert (_tmp55_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp56_;
				_tmp56_ = self->priv->_equation;
				math_equation_insert_exponent (_tmp56_, "×10");
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp57_;
				_tmp57_ = self->priv->_equation;
				math_equation_factorize (_tmp57_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp58_;
				_tmp58_ = self->priv->_equation;
				math_equation_insert (_tmp58_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp59_;
				_tmp59_ = self->priv->_equation;
				math_equation_insert (_tmp59_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_t:
			{
				MathEquation* _tmp60_;
				_tmp60_ = self->priv->_equation;
				math_equation_insert (_tmp60_, "τ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp61_;
				_tmp61_ = self->priv->_equation;
				math_equation_insert (_tmp61_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			{
				GtkRoot* _tmp62_;
				GtkRoot* _tmp63_;
				MathButtons* _tmp64_;
				MathButtons* _tmp65_;
				ButtonMode _tmp66_;
				ButtonMode _tmp67_;
				MathEquation* _tmp68_;
				_tmp62_ = gtk_widget_get_root ((GtkWidget*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = math_window_get_buttons (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_MATH_WINDOW, MathWindow));
				_tmp65_ = _tmp64_;
				_tmp66_ = math_buttons_get_mode (_tmp65_);
				_tmp67_ = _tmp66_;
				if (_tmp67_ == BUTTON_MODE_PROGRAMMING) {
					result = FALSE;
					return result;
				}
				_tmp68_ = self->priv->_equation;
				math_equation_insert (_tmp68_, "°");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp69_;
				_tmp69_ = self->priv->_equation;
				math_equation_insert (_tmp69_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp70_;
				_tmp70_ = self->priv->_equation;
				math_equation_insert (_tmp70_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp71_;
				_tmp71_ = self->priv->_equation;
				math_equation_insert (_tmp71_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	if (state == GDK_ALT_MASK) {
		switch (keyval) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp72_;
				_tmp72_ = self->priv->_equation;
				math_equation_insert (_tmp72_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp73_;
				_tmp73_ = self->priv->_equation;
				math_equation_insert (_tmp73_, "⌋");
				result = TRUE;
				return result;
			}
			case GDK_KEY_Left:
			case GDK_KEY_Right:
			{
				g_signal_emit (self, math_display_signals[MATH_DISPLAY_ARR_KEY_PRESSED_SIGNAL], 0, keyval);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	if (state == GDK_CONTROL_MASK) {
		_tmp74_ = TRUE;
	} else {
		MathEquation* _tmp75_;
		NumberMode _tmp76_;
		NumberMode _tmp77_;
		_tmp75_ = self->priv->_equation;
		_tmp76_ = math_equation_get_number_mode (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp74_ = _tmp77_ == NUMBER_MODE_SUPERSCRIPT;
	}
	if (_tmp74_) {
		MathEquation* _tmp78_;
		gboolean _tmp79_;
		gboolean _tmp80_;
		_tmp78_ = self->priv->_equation;
		_tmp79_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp78_);
		_tmp80_ = _tmp79_;
		if (!_tmp80_) {
			MathEquation* _tmp81_;
			_tmp81_ = self->priv->_equation;
			math_equation_remove_trailing_spaces (_tmp81_);
		}
		switch (keyval) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp82_;
				_tmp82_ = self->priv->_equation;
				math_equation_insert (_tmp82_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp83_;
				_tmp83_ = self->priv->_equation;
				math_equation_insert (_tmp83_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp84_;
				_tmp84_ = self->priv->_equation;
				math_equation_insert (_tmp84_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp85_;
				_tmp85_ = self->priv->_equation;
				math_equation_insert (_tmp85_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp86_;
				_tmp86_ = self->priv->_equation;
				math_equation_insert (_tmp86_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp87_;
				_tmp87_ = self->priv->_equation;
				math_equation_insert (_tmp87_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp88_;
				_tmp88_ = self->priv->_equation;
				math_equation_insert (_tmp88_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp89_;
				_tmp89_ = self->priv->_equation;
				math_equation_insert (_tmp89_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp90_;
				_tmp90_ = self->priv->_equation;
				math_equation_insert (_tmp90_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp91_;
				_tmp91_ = self->priv->_equation;
				math_equation_insert (_tmp91_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp92_ = FALSE;
		if (state == GDK_ALT_MASK) {
			_tmp92_ = TRUE;
		} else {
			MathEquation* _tmp93_;
			NumberMode _tmp94_;
			NumberMode _tmp95_;
			_tmp93_ = self->priv->_equation;
			_tmp94_ = math_equation_get_number_mode (_tmp93_);
			_tmp95_ = _tmp94_;
			_tmp92_ = _tmp95_ == NUMBER_MODE_SUBSCRIPT;
		}
		if (_tmp92_) {
			MathEquation* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = self->priv->_equation;
			_tmp97_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (!_tmp98_) {
				MathEquation* _tmp99_;
				_tmp99_ = self->priv->_equation;
				math_equation_remove_trailing_spaces (_tmp99_);
			}
			switch (keyval) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp100_;
					_tmp100_ = self->priv->_equation;
					math_equation_insert (_tmp100_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp101_;
					_tmp101_ = self->priv->_equation;
					math_equation_insert (_tmp101_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp102_;
					_tmp102_ = self->priv->_equation;
					math_equation_insert (_tmp102_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp103_;
					_tmp103_ = self->priv->_equation;
					math_equation_insert (_tmp103_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp104_;
					_tmp104_ = self->priv->_equation;
					math_equation_insert (_tmp104_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp105_;
					_tmp105_ = self->priv->_equation;
					math_equation_insert (_tmp105_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp106_;
					_tmp106_ = self->priv->_equation;
					math_equation_insert (_tmp106_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp107_;
					_tmp107_ = self->priv->_equation;
					math_equation_insert (_tmp107_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp108_;
					_tmp108_ = self->priv->_equation;
					math_equation_insert (_tmp108_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp109_;
					_tmp109_ = self->priv->_equation;
					math_equation_insert (_tmp109_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
_math_display_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                 guint keyval,
                                                                 guint keycode,
                                                                 GdkModifierType state,
                                                                 gpointer self)
{
	gboolean result;
	result = math_display_key_press_cb ((MathDisplay*) self, _sender, keyval, keycode, state);
	return result;
}

static gboolean
math_display_scroll_cb (MathDisplay* self,
                        GtkEventControllerScroll* controller,
                        gdouble dx,
                        gdouble dy)
{
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* hadjustment = NULL;
	GtkScrolledWindow* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	gdouble step = 0.0;
	GtkAdjustment* _tmp4_;
	gdouble new_value = 0.0;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	if (dy == ((gdouble) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = dx != ((gdouble) 0);
	}
	if (_tmp0_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = self->priv->display_scrolled;
	_tmp2_ = gtk_scrolled_window_get_hadjustment (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	hadjustment = _tmp3_;
	_tmp4_ = hadjustment;
	step = gtk_adjustment_get_step_increment (_tmp4_);
	_tmp5_ = hadjustment;
	new_value = gtk_adjustment_get_value (_tmp5_) + (dy * step);
	_tmp6_ = hadjustment;
	gtk_adjustment_set_value (_tmp6_, new_value);
	result = GDK_EVENT_STOP;
	_g_object_unref0 (hadjustment);
	return result;
}

static gboolean
_math_display_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                            gdouble dx,
                                                            gdouble dy,
                                                            gpointer self)
{
	gboolean result;
	result = math_display_scroll_cb ((MathDisplay*) self, _sender, dx, dy);
	return result;
}

static void
math_display_base_label_changed_cb (MathDisplay* self)
{
	MathEquation* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = math_equation_get_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GtkRoot* _tmp5_;
		GtkRoot* _tmp6_;
		MathButtons* _tmp7_;
		MathButtons* _tmp8_;
		ButtonMode _tmp9_;
		ButtonMode _tmp10_;
		_tmp5_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = math_window_get_buttons (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MATH_WINDOW, MathWindow));
		_tmp8_ = _tmp7_;
		_tmp9_ = math_buttons_get_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == BUTTON_MODE_PROGRAMMING) {
			GtkTextView* _tmp11_;
			GtkTextBuffer* _tmp12_;
			GtkTextBuffer* _tmp13_;
			MathEquation* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp11_ = self->priv->info_view;
			_tmp12_ = gtk_text_view_get_buffer (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->_equation;
			_tmp15_ = math_equation_get_base_label (_tmp14_);
			_tmp16_ = _tmp15_;
			g_object_set (_tmp13_, "text", _tmp16_, NULL);
		} else {
			GtkTextView* _tmp17_;
			GtkTextBuffer* _tmp18_;
			GtkTextBuffer* _tmp19_;
			_tmp17_ = self->priv->info_view;
			_tmp18_ = gtk_text_view_get_buffer (_tmp17_);
			_tmp19_ = _tmp18_;
			g_object_set (_tmp19_, "text", "", NULL);
		}
	}
}

static void
math_display_status_changed_cb (MathDisplay* self)
{
	MathEquation* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp34_ = FALSE;
	MathEquation* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = math_equation_get_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") != 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GtkTextView* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* _tmp7_;
		MathEquation* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		MathEquation* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		MathEquation* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp5_ = self->priv->info_view;
		_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->_equation;
		_tmp9_ = math_equation_get_status (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		g_object_set (_tmp7_, "text", _tmp11_, NULL);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->_equation;
		_tmp13_ = math_equation_get_status (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		gtk_accessible_announce ((GtkAccessible*) self, _tmp15_, GTK_ACCESSIBLE_ANNOUNCEMENT_PRIORITY_MEDIUM);
		_g_free0 (_tmp15_);
		_tmp16_ = self->priv->_equation;
		_tmp17_ = math_equation_get_in_solve (_tmp16_);
		_tmp18_ = _tmp17_;
		if (!_tmp18_) {
			gtk_widget_add_css_class ((GtkWidget*) self, "error");
		}
	} else {
		GtkRoot* _tmp19_;
		GtkRoot* _tmp20_;
		MathButtons* _tmp21_;
		MathButtons* _tmp22_;
		ButtonMode _tmp23_;
		ButtonMode _tmp24_;
		_tmp19_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = math_window_get_buttons (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_MATH_WINDOW, MathWindow));
		_tmp22_ = _tmp21_;
		_tmp23_ = math_buttons_get_mode (_tmp22_);
		_tmp24_ = _tmp23_;
		if (_tmp24_ == BUTTON_MODE_PROGRAMMING) {
			GtkTextView* _tmp25_;
			GtkTextBuffer* _tmp26_;
			GtkTextBuffer* _tmp27_;
			MathEquation* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			_tmp25_ = self->priv->info_view;
			_tmp26_ = gtk_text_view_get_buffer (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = self->priv->_equation;
			_tmp29_ = math_equation_get_base_label (_tmp28_);
			_tmp30_ = _tmp29_;
			g_object_set (_tmp27_, "text", _tmp30_, NULL);
		} else {
			GtkTextView* _tmp31_;
			GtkTextBuffer* _tmp32_;
			GtkTextBuffer* _tmp33_;
			_tmp31_ = self->priv->info_view;
			_tmp32_ = gtk_text_view_get_buffer (_tmp31_);
			_tmp33_ = _tmp32_;
			g_object_set (_tmp33_, "text", "", NULL);
		}
		gtk_widget_remove_css_class ((GtkWidget*) self, "error");
	}
	_tmp35_ = self->priv->_equation;
	_tmp36_ = math_equation_get_in_solve (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		AdwSpinner* _tmp38_;
		_tmp38_ = self->priv->spinner;
		_tmp34_ = !gtk_widget_get_visible ((GtkWidget*) _tmp38_);
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		AdwSpinner* _tmp39_;
		GtkTextView* _tmp40_;
		GtkTextView* _tmp41_;
		_tmp39_ = self->priv->spinner;
		gtk_widget_set_visible ((GtkWidget*) _tmp39_, TRUE);
		_tmp40_ = self->priv->info_view;
		_tmp41_ = self->priv->info_view;
		gtk_text_view_set_right_margin (_tmp41_, 0);
		gtk_text_view_set_left_margin (_tmp40_, 0);
	} else {
		gboolean _tmp42_ = FALSE;
		MathEquation* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp43_ = self->priv->_equation;
		_tmp44_ = math_equation_get_in_solve (_tmp43_);
		_tmp45_ = _tmp44_;
		if (!_tmp45_) {
			AdwSpinner* _tmp46_;
			_tmp46_ = self->priv->spinner;
			_tmp42_ = gtk_widget_get_visible ((GtkWidget*) _tmp46_);
		} else {
			_tmp42_ = FALSE;
		}
		if (_tmp42_) {
			AdwSpinner* _tmp47_;
			GtkTextView* _tmp48_;
			GtkTextView* _tmp49_;
			_tmp47_ = self->priv->spinner;
			gtk_widget_set_visible ((GtkWidget*) _tmp47_, FALSE);
			_tmp48_ = self->priv->info_view;
			_tmp49_ = self->priv->info_view;
			gtk_text_view_set_right_margin (_tmp49_, 12);
			gtk_text_view_set_left_margin (_tmp48_, 12);
		}
	}
}

static void
math_display_error_status_changed_cb (MathDisplay* self)
{
	MathEquation* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	MathEquation* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	MathEquation* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	MathEquation* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	MathEquation* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	MathEquation* _tmp16_;
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	_tmp1_ = math_equation_get_error_token_end (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_equation;
	_tmp4_ = math_equation_get_error_token_start (_tmp3_);
	_tmp5_ = _tmp4_;
	if ((_tmp2_ - _tmp5_) == ((guint) 0)) {
		return;
	}
	_tmp6_ = self->priv->_equation;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp6_, &_tmp7_);
	start = _tmp7_;
	_tmp8_ = self->priv->_equation;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp8_, &_tmp9_);
	end = _tmp9_;
	_tmp10_ = self->priv->_equation;
	_tmp11_ = math_equation_get_error_token_start (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_text_iter_set_offset (&start, (gint) _tmp12_);
	_tmp13_ = self->priv->_equation;
	_tmp14_ = math_equation_get_error_token_end (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_text_iter_set_offset (&end, (gint) _tmp15_);
	_tmp16_ = self->priv->_equation;
	_tmp17_ = start;
	_tmp18_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp16_, &_tmp17_, &_tmp18_);
}

void
math_display_grab_focus (MathDisplay* self)
{
	GtkSourceView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
math_display_backspace_cb (MathDisplay* self)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_backspace (_tmp0_);
}

static void
_math_display_backspace_cb_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self)
{
	math_display_backspace_cb ((MathDisplay*) self);
}

MathEquation*
math_display_get_equation (MathDisplay* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

void
math_display_set_equation (MathDisplay* self,
                           MathEquation* value)
{
	MathEquation* old_value;
	g_return_if_fail (self != NULL);
	old_value = math_display_get_equation (self);
	if (old_value != value) {
		MathEquation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_equation);
		self->priv->_equation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, math_display_properties[MATH_DISPLAY_EQUATION_PROPERTY]);
	}
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
math_display_set_enabled_completions (MathDisplay* self,
                                      gchar** value,
                                      gint value_length1)
{
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceCompletion* _tmp1_;
	GtkSourceCompletion* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	completion = _tmp2_;
	_tmp3_ = self->priv->_enabled_completions;
	_tmp3__length1 = self->priv->_enabled_completions_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp3_;
		name_collection_length1 = _tmp3__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp4_;
			gchar* name = NULL;
			_tmp4_ = g_strdup (name_collection[name_it]);
			name = _tmp4_;
			{
				GtkSourceCompletion* _tmp5_;
				GHashTable* _tmp6_;
				const gchar* _tmp7_;
				gconstpointer _tmp8_;
				_tmp5_ = completion;
				_tmp6_ = self->priv->providers;
				_tmp7_ = name;
				_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
				gtk_source_completion_remove_provider (_tmp5_, (GtkSourceCompletionProvider*) _tmp8_);
				_g_free0 (name);
			}
		}
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = value;
		name_collection_length1 = value_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp9_;
			gchar* name = NULL;
			_tmp9_ = g_strdup (name_collection[name_it]);
			name = _tmp9_;
			{
				GtkSourceCompletion* _tmp10_;
				GHashTable* _tmp11_;
				const gchar* _tmp12_;
				gconstpointer _tmp13_;
				_tmp10_ = completion;
				_tmp11_ = self->priv->providers;
				_tmp12_ = name;
				_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
				gtk_source_completion_add_provider (_tmp10_, (GtkSourceCompletionProvider*) _tmp13_);
				_g_free0 (name);
			}
		}
	}
	_tmp14_ = (value != NULL) ? _vala_array_dup8 (value, value_length1) : value;
	_tmp14__length1 = value_length1;
	self->priv->_enabled_completions = (_vala_array_free (self->priv->_enabled_completions, self->priv->_enabled_completions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_enabled_completions = _tmp14_;
	self->priv->_enabled_completions_length1 = _tmp14__length1;
	self->priv->__enabled_completions_size_ = self->priv->_enabled_completions_length1;
	_g_object_unref0 (completion);
	g_object_notify_by_pspec ((GObject *) self, math_display_properties[MATH_DISPLAY_ENABLED_COMPLETIONS_PROPERTY]);
}

gboolean
math_display_get_completion_visible (MathDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_completion_visible;
	return result;
}

void
math_display_set_completion_visible (MathDisplay* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_display_get_completion_visible (self);
	if (old_value != value) {
		self->priv->_completion_visible = value;
		g_object_notify_by_pspec ((GObject *) self, math_display_properties[MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY]);
	}
}

static void
_math_display_construct_finish_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	math_display_construct_finish ((MathDisplay*) self);
}

static GObject *
math_display_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MathDisplay * self;
	parent_class = G_OBJECT_CLASS (math_display_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	g_signal_connect_object ((GObject*) self, "notify::equation", (GCallback) _math_display_construct_finish_g_object_notify, self, 0);
	return obj;
}

static void
math_display_class_init (MathDisplayClass * klass,
                         gpointer klass_data)
{
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathDisplay_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_display_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_display_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION_PROPERTY, math_display_properties[MATH_DISPLAY_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_ENABLED_COMPLETIONS_PROPERTY, math_display_properties[MATH_DISPLAY_ENABLED_COMPLETIONS_PROPERTY] = g_param_spec_boxed ("enabled-completions", "enabled-completions", "enabled-completions", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY, math_display_properties[MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY] = g_param_spec_boolean ("completion-visible", "completion-visible", "completion-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-display.ui");
	math_display_signals[MATH_DISPLAY_ARR_KEY_PRESSED_SIGNAL] = g_signal_new ("arr-key-pressed", TYPE_MATH_DISPLAY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "display_scrolled", FALSE, MathDisplay_private_offset + G_STRUCT_OFFSET (MathDisplayPrivate, display_scrolled));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_view", FALSE, MathDisplay_private_offset + G_STRUCT_OFFSET (MathDisplayPrivate, source_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_view", FALSE, MathDisplay_private_offset + G_STRUCT_OFFSET (MathDisplayPrivate, info_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "event_controller", FALSE, MathDisplay_private_offset + G_STRUCT_OFFSET (MathDisplayPrivate, event_controller));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner", FALSE, MathDisplay_private_offset + G_STRUCT_OFFSET (MathDisplayPrivate, spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "backspace_button", FALSE, MathDisplay_private_offset + G_STRUCT_OFFSET (MathDisplayPrivate, backspace_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_cb", G_CALLBACK(_math_display_key_press_cb_gtk_event_controller_key_key_pressed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scroll_cb", G_CALLBACK(_math_display_scroll_cb_gtk_event_controller_scroll_scroll));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "backspace_cb", G_CALLBACK(_math_display_backspace_cb_gtk_button_clicked));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "mathdisplay");
}

static void
math_display_instance_init (MathDisplay * self,
                            gpointer klass)
{
	gchar** _tmp0_;
	GRegex* _tmp1_;
	GRegex* _tmp2_;
	self->priv = math_display_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_enabled_completions = _tmp0_;
	self->priv->_enabled_completions_length1 = 0;
	self->priv->__enabled_completions_size_ = self->priv->_enabled_completions_length1;
	_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "^_*\\p{L}+(_|\\p{L})*$", 0));
	self->priv->only_variable_name = _tmp1_;
	_tmp2_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_1, "^[a-zA-Z0-9 ]*\\(([a-zA-z0-9;]*)?\\)[ ]*$", 0));
	self->priv->only_function_definition = _tmp2_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_display_finalize (GObject * obj)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_hash_table_unref0 (self->priv->providers);
	self->priv->_enabled_completions = (_vala_array_free (self->priv->_enabled_completions, self->priv->_enabled_completions_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (self->priv->only_variable_name);
	_g_regex_unref0 (self->priv->only_function_definition);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
math_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
	GType math_display_type_id;
	math_display_type_id = g_type_register_static (gtk_box_get_type (), "MathDisplay", &g_define_type_info, 0);
	MathDisplay_private_offset = g_type_add_instance_private (math_display_type_id, sizeof (MathDisplayPrivate));
	return math_display_type_id;
}

GType
math_display_get_type (void)
{
	static gsize math_display_type_id__once = 0;
	if (g_once_init_enter (&math_display_type_id__once)) {
		GType math_display_type_id;
		math_display_type_id = math_display_get_type_once ();
		g_once_init_leave (&math_display_type_id__once, math_display_type_id);
	}
	return math_display_type_id__once;
}

static void
_vala_math_display_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION_PROPERTY:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		case MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY:
		g_value_set_boolean (value, math_display_get_completion_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_display_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION_PROPERTY:
		math_display_set_equation (self, g_value_get_object (value));
		break;
		case MATH_DISPLAY_ENABLED_COMPLETIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			math_display_set_enabled_completions (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY:
		math_display_set_completion_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
completion_proposal_get_instance_private (CompletionProposal* self)
{
	return G_STRUCT_MEMBER_P (self, CompletionProposal_private_offset);
}

CompletionProposal*
completion_proposal_construct (GType object_type,
                               const gchar* label,
                               const gchar* details)
{
	CompletionProposal * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (details != NULL, NULL);
	self = (CompletionProposal*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (label);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp0_;
	_tmp1_ = g_strdup (details);
	_g_free0 (self->priv->_details);
	self->priv->_details = _tmp1_;
	return self;
}

CompletionProposal*
completion_proposal_new (const gchar* label,
                         const gchar* details)
{
	return completion_proposal_construct (TYPE_COMPLETION_PROPOSAL, label, details);
}

const gchar*
completion_proposal_get_label (CompletionProposal* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

const gchar*
completion_proposal_get_details (CompletionProposal* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_details;
	result = _tmp0_;
	return result;
}

static void
completion_proposal_class_init (CompletionProposalClass * klass,
                                gpointer klass_data)
{
	completion_proposal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CompletionProposal_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_completion_proposal_get_property;
	G_OBJECT_CLASS (klass)->finalize = completion_proposal_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPLETION_PROPOSAL_LABEL_PROPERTY, completion_proposal_properties[COMPLETION_PROPOSAL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPLETION_PROPOSAL_DETAILS_PROPERTY, completion_proposal_properties[COMPLETION_PROPOSAL_DETAILS_PROPERTY] = g_param_spec_string ("details", "details", "details", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
completion_proposal_gtk_source_completion_proposal_interface_init (GtkSourceCompletionProposalInterface * iface,
                                                                   gpointer iface_data)
{
	completion_proposal_gtk_source_completion_proposal_parent_iface = g_type_interface_peek_parent (iface);
}

static void
completion_proposal_instance_init (CompletionProposal * self,
                                   gpointer klass)
{
	self->priv = completion_proposal_get_instance_private (self);
}

static void
completion_proposal_finalize (GObject * obj)
{
	CompletionProposal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_PROPOSAL, CompletionProposal);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_details);
	G_OBJECT_CLASS (completion_proposal_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
completion_proposal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CompletionProposalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_proposal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProposal), 0, (GInstanceInitFunc) completion_proposal_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_proposal_info = { (GInterfaceInitFunc) completion_proposal_gtk_source_completion_proposal_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType completion_proposal_type_id;
	completion_proposal_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProposal", &g_define_type_info, 0);
	g_type_add_interface_static (completion_proposal_type_id, gtk_source_completion_proposal_get_type (), &gtk_source_completion_proposal_info);
	CompletionProposal_private_offset = g_type_add_instance_private (completion_proposal_type_id, sizeof (CompletionProposalPrivate));
	return completion_proposal_type_id;
}

GType
completion_proposal_get_type (void)
{
	static gsize completion_proposal_type_id__once = 0;
	if (g_once_init_enter (&completion_proposal_type_id__once)) {
		GType completion_proposal_type_id;
		completion_proposal_type_id = completion_proposal_get_type_once ();
		g_once_init_leave (&completion_proposal_type_id__once, completion_proposal_type_id);
	}
	return completion_proposal_type_id__once;
}

static void
_vala_completion_proposal_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	CompletionProposal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPLETION_PROPOSAL, CompletionProposal);
	switch (property_id) {
		case COMPLETION_PROPOSAL_LABEL_PROPERTY:
		g_value_set_string (value, completion_proposal_get_label (self));
		break;
		case COMPLETION_PROPOSAL_DETAILS_PROPERTY:
		g_value_set_string (value, completion_proposal_get_details (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gchar*
completion_provider_real_get_title (CompletionProvider* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

gchar*
completion_provider_get_title (CompletionProvider* self)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->get_title) {
		return _klass_->get_title (self);
	}
	return NULL;
}

void
completion_provider_populate_async (CompletionProvider* self,
                                    GtkSourceCompletionContext* context,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	CompletionProviderClass* _klass_;
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->populate_async) {
		_klass_->populate_async (self, context, cancellable, _callback_, _user_data_);
	}
}

GListModel*
completion_provider_populate_finish (CompletionProvider* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	CompletionProviderClass* _klass_;
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->populate_finish) {
		return _klass_->populate_finish (self, _res_, error);
	}
	return NULL;
}

static GPtrArray*
completion_provider_real_list_alternates (CompletionProvider* self,
                                          GtkSourceCompletionContext* context,
                                          GtkSourceCompletionProposal* proposal)
{
	GPtrArray* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (proposal != NULL, NULL);
	result = NULL;
	return result;
}

GPtrArray*
completion_provider_list_alternates (CompletionProvider* self,
                                     GtkSourceCompletionContext* context,
                                     GtkSourceCompletionProposal* proposal)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->list_alternates) {
		return _klass_->list_alternates (self, context, proposal);
	}
	return NULL;
}

static gint
completion_provider_real_get_priority (CompletionProvider* self,
                                       GtkSourceCompletionContext* context)
{
	gint result;
	g_return_val_if_fail (context != NULL, 0);
	result = 0;
	return result;
}

gint
completion_provider_get_priority (CompletionProvider* self,
                                  GtkSourceCompletionContext* context)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->get_priority) {
		return _klass_->get_priority (self, context);
	}
	return -1;
}

static gboolean
completion_provider_real_is_trigger (CompletionProvider* self,
                                     GtkTextIter* iter,
                                     gunichar ch)
{
	gboolean result;
	g_return_val_if_fail (iter != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
completion_provider_is_trigger (CompletionProvider* self,
                                GtkTextIter* iter,
                                gunichar ch)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->is_trigger) {
		return _klass_->is_trigger (self, iter, ch);
	}
	return FALSE;
}

static gboolean
completion_provider_real_key_activates (CompletionProvider* self,
                                        GtkSourceCompletionContext* context,
                                        GtkSourceCompletionProposal* proposal,
                                        guint keyval,
                                        GdkModifierType mod)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	if (keyval == GDK_KEY_Return) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyval == GDK_KEY_KP_Enter;
	}
	result = _tmp0_;
	return result;
}

gboolean
completion_provider_key_activates (CompletionProvider* self,
                                   GtkSourceCompletionContext* context,
                                   GtkSourceCompletionProposal* proposal,
                                   guint keyval,
                                   GdkModifierType mod)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->key_activates) {
		return _klass_->key_activates (self, context, proposal, keyval, mod);
	}
	return FALSE;
}

static void
completion_provider_real_display (CompletionProvider* self,
                                  GtkSourceCompletionContext* context,
                                  GtkSourceCompletionProposal* proposal,
                                  GtkSourceCompletionCell* cell)
{
	CompletionProposal* item = NULL;
	CompletionProposal* _tmp0_;
	GtkSourceCompletionColumn _tmp1_;
	GtkSourceCompletionColumn _tmp2_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (cell != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (proposal, TYPE_COMPLETION_PROPOSAL, CompletionProposal));
	item = _tmp0_;
	_tmp1_ = gtk_source_completion_cell_get_column (cell);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case GTK_SOURCE_COMPLETION_COLUMN_TYPED_TEXT:
		{
			CompletionProposal* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = item;
			_tmp4_ = completion_proposal_get_label (_tmp3_);
			_tmp5_ = _tmp4_;
			g_object_set (cell, "text", _tmp5_, NULL);
			break;
		}
		case GTK_SOURCE_COMPLETION_COLUMN_COMMENT:
		{
			CompletionProposal* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = item;
			_tmp7_ = completion_proposal_get_details (_tmp6_);
			_tmp8_ = _tmp7_;
			g_object_set (cell, "text", _tmp8_, NULL);
			break;
		}
		default:
		{
			break;
		}
	}
	_g_object_unref0 (item);
}

void
completion_provider_display (CompletionProvider* self,
                             GtkSourceCompletionContext* context,
                             GtkSourceCompletionProposal* proposal,
                             GtkSourceCompletionCell* cell)
{
	CompletionProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->display) {
		_klass_->display (self, context, proposal, cell);
	}
}

void
completion_provider_move_iter_to_name_start (GtkTextIter* iter)
{
	g_return_if_fail (iter != NULL);
	while (TRUE) {
		gunichar current_char = 0U;
		if (!gtk_text_iter_backward_char (iter)) {
			break;
		}
		current_char = gtk_text_iter_get_char (iter);
		if (!g_unichar_isalpha (current_char)) {
			gtk_text_iter_forward_char (iter);
			break;
		}
	}
}

static gboolean
completion_provider_real_get_start_iter (CompletionProvider* self,
                                         GtkSourceCompletionContext* context,
                                         GtkSourceCompletionProposal* proposal,
                                         GtkTextIter* iter)
{
	GtkTextIter _vala_iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_vala_iter = _tmp0_;
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

gboolean
completion_provider_get_start_iter (CompletionProvider* self,
                                    GtkSourceCompletionContext* context,
                                    GtkSourceCompletionProposal* proposal,
                                    GtkTextIter* iter)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->get_start_iter) {
		return _klass_->get_start_iter (self, context, proposal, iter);
	}
	return FALSE;
}

static gpointer
_gtk_expression_ref0 (gpointer self)
{
	return self ? gtk_expression_ref (self) : NULL;
}

GtkStringFilter*
completion_provider_create_filter (const gchar* word)
{
	GtkExpression* expr = NULL;
	GtkPropertyExpression* _tmp0_;
	GtkStringFilter* filter = NULL;
	GtkExpression* _tmp1_;
	GtkStringFilter* _tmp2_;
	GtkStringFilter* result;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = (GtkPropertyExpression*) gtk_property_expression_new (TYPE_COMPLETION_PROPOSAL, NULL, "label");
	expr = (GtkExpression*) _tmp0_;
	_tmp1_ = _gtk_expression_ref0 (expr);
	_tmp2_ = gtk_string_filter_new (_tmp1_);
	filter = _tmp2_;
	gtk_string_filter_set_match_mode (filter, GTK_STRING_FILTER_MATCH_MODE_PREFIX);
	gtk_string_filter_set_ignore_case (filter, TRUE);
	gtk_string_filter_set_search (filter, word);
	result = filter;
	_gtk_expression_unref0 (expr);
	return result;
}

static void
completion_provider_real_refilter (GtkSourceCompletionProvider* base,
                                   GtkSourceCompletionContext* context,
                                   GListModel* model)
{
	CompletionProvider * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkStringFilter* _tmp2_;
	GtkStringFilter* _tmp3_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (model != NULL);
	if (!g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) model), gtk_filter_list_model_get_type ())) {
		return;
	}
	_tmp0_ = gtk_source_completion_context_get_word (context);
	_tmp1_ = _tmp0_;
	_tmp2_ = completion_provider_create_filter (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_filter_list_model_set_filter (G_TYPE_CHECK_INSTANCE_CAST (model, gtk_filter_list_model_get_type (), GtkFilterListModel), (GtkFilter*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
completion_provider_real_activate (GtkSourceCompletionProvider* base,
                                   GtkSourceCompletionContext* context,
                                   GtkSourceCompletionProposal* proposal)
{
	CompletionProvider * self;
	gchar* proposed_string = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* word = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	GtkTextBuffer* _tmp24_;
	const gchar* _tmp25_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (proposal != NULL);
	_tmp0_ = completion_proposal_get_label (G_TYPE_CHECK_INSTANCE_CAST (proposal, TYPE_COMPLETION_PROPOSAL, CompletionProposal));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	proposed_string = _tmp2_;
	gtk_source_completion_context_get_bounds (context, &_tmp3_, &_tmp4_);
	start_iter = _tmp3_;
	end_iter = _tmp4_;
	_tmp5_ = end_iter;
	_tmp6_ = gtk_text_iter_get_slice (&start_iter, &_tmp5_);
	_g_free0 (word);
	word = _tmp6_;
	_tmp7_ = gtk_text_iter_get_buffer (&start_iter);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	buffer = _tmp8_;
	_tmp9_ = buffer;
	gtk_text_buffer_begin_user_action (_tmp9_);
	_tmp10_ = proposed_string;
	_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
	_tmp12_ = _tmp11_;
	_tmp13_ = word;
	_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_str_has_prefix (_tmp12_, _tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	if (_tmp16_) {
		GtkTextBuffer* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp17_ = buffer;
		_tmp18_ = proposed_string;
		_tmp19_ = word;
		_tmp20_ = strlen (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = string_substring (_tmp18_, (glong) _tmp21_, (glong) -1);
		_tmp23_ = _tmp22_;
		gtk_text_buffer_insert (_tmp17_, &end_iter, _tmp23_, -1);
		_g_free0 (_tmp23_);
	}
	_tmp24_ = buffer;
	gtk_text_buffer_end_user_action (_tmp24_);
	_tmp25_ = proposed_string;
	if (g_str_has_suffix (_tmp25_, "()")) {
		GtkTextBuffer* _tmp26_;
		GtkTextIter _tmp27_;
		GtkTextIter _tmp28_;
		gtk_text_iter_backward_char (&end_iter);
		_tmp26_ = buffer;
		_tmp27_ = end_iter;
		_tmp28_ = end_iter;
		gtk_text_buffer_select_range (_tmp26_, &_tmp27_, &_tmp28_);
	}
	_g_object_unref0 (buffer);
	_g_free0 (word);
	_g_free0 (proposed_string);
}

CompletionProvider*
completion_provider_construct (GType object_type)
{
	CompletionProvider * self = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	return self;
}

static void
completion_provider_class_init (CompletionProviderClass * klass,
                                gpointer klass_data)
{
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->list_alternates = (GPtrArray* (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*)) completion_provider_real_list_alternates;
	((CompletionProviderClass *) klass)->get_priority = (gint (*) (CompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_get_priority;
	((CompletionProviderClass *) klass)->is_trigger = (gboolean (*) (CompletionProvider*, GtkTextIter*, gunichar)) completion_provider_real_is_trigger;
	((CompletionProviderClass *) klass)->key_activates = (gboolean (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, guint, GdkModifierType)) completion_provider_real_key_activates;
	((CompletionProviderClass *) klass)->display = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkSourceCompletionCell*)) completion_provider_real_display;
	((CompletionProviderClass *) klass)->get_start_iter = (gboolean (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
}

static void
completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                   gpointer iface_data)
{
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) completion_provider_get_title;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) completion_provider_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) completion_provider_populate_finish;
	iface->list_alternates = (GPtrArray* (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*)) completion_provider_list_alternates;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_get_priority;
	iface->is_trigger = (gboolean (*) (GtkSourceCompletionProvider*, GtkTextIter*, gunichar)) completion_provider_is_trigger;
	iface->key_activates = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, guint, GdkModifierType)) completion_provider_key_activates;
	iface->display = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkSourceCompletionCell*)) completion_provider_display;
	iface->refilter = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GListModel*)) completion_provider_real_refilter;
	iface->activate = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*)) completion_provider_real_activate;
}

static void
completion_provider_instance_init (CompletionProvider * self,
                                   gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType completion_provider_type_id;
	completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	return completion_provider_type_id;
}

GType
completion_provider_get_type (void)
{
	static gsize completion_provider_type_id__once = 0;
	if (g_once_init_enter (&completion_provider_type_id__once)) {
		GType completion_provider_type_id;
		completion_provider_type_id = completion_provider_get_type_once ();
		g_once_init_leave (&completion_provider_type_id__once, completion_provider_type_id);
	}
	return completion_provider_type_id__once;
}

static gchar*
function_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	FunctionCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FunctionCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Defined Functions"));
	result = _tmp0_;
	return result;
}

MathFunction**
function_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                   gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp4_;
	MathFunction** functions = NULL;
	gint _tmp5_ = 0;
	MathFunction** _tmp6_;
	gint functions_length1;
	gint _functions_size_;
	MathFunction** _tmp7_;
	gint _tmp7__length1;
	MathFunction** result;
	g_return_val_if_fail (context != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp4_ = function_manager_get_default_function_manager ();
	function_manager = _tmp4_;
	_tmp6_ = function_manager_functions_eligible_for_autocompletion (function_manager, search_pattern, &_tmp5_);
	functions = _tmp6_;
	functions_length1 = _tmp5_;
	_functions_size_ = functions_length1;
	_tmp7_ = functions;
	_tmp7__length1 = functions_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (function_manager);
	_g_free0 (search_pattern);
	return result;
}

static void
function_completion_provider_real_populate_async_data_free (gpointer _data)
{
	FunctionCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FunctionCompletionProviderPopulateAsyncData, _data_);
}

static void
function_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FunctionCompletionProvider * self;
	FunctionCompletionProviderPopulateAsyncData* _data_;
	FunctionCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (FunctionCompletionProvider*) base;
	_data_ = g_slice_new0 (FunctionCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, function_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	function_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
function_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GListModel* result;
	FunctionCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gboolean
function_completion_provider_real_populate_async_co (FunctionCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = function_completion_provider_get_matches_for_completion_at_cursor (_data_->context, &_data_->_tmp1_);
	_data_->functions = _data_->_tmp2_;
	_data_->functions_length1 = _data_->_tmp1_;
	_data_->_functions_size_ = _data_->functions_length1;
	_data_->_tmp3_ = gtk_source_completion_context_get_word (_data_->context);
	_data_->word = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->functions;
	_data_->_tmp4__length1 = _data_->functions_length1;
	if (_data_->_tmp4__length1 > 0) {
		_data_->_tmp5_ = _data_->functions;
		_data_->_tmp5__length1 = _data_->functions_length1;
		{
			_data_->function_collection_length1 = 0;
			_data_->_function_collection_size_ = 0;
			_data_->function_collection = _data_->_tmp5_;
			_data_->function_collection_length1 = _data_->_tmp5__length1;
			for (_data_->function_it = 0; _data_->function_it < _data_->function_collection_length1; _data_->function_it = _data_->function_it + 1) {
				_data_->_tmp6_ = _g_object_ref0 (_data_->function_collection[_data_->function_it]);
				_data_->function = _data_->_tmp6_;
				{
					_data_->_tmp7_ = _data_->function;
					_data_->_tmp8_ = math_function_get_name (_data_->_tmp7_);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->_tmp10_ = g_strconcat (_data_->_tmp9_, "()", NULL);
					_data_->label_text = _data_->_tmp10_;
					_data_->_tmp11_ = _data_->function;
					_data_->_tmp12_ = math_function_get_description (_data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					_data_->_tmp14_ = g_strdup_printf ("%s", _data_->_tmp13_);
					_data_->details_text = _data_->_tmp14_;
					_data_->_tmp15_ = _data_->function;
					if (math_function_is_custom_function (_data_->_tmp15_)) {
						_data_->_tmp16_ = _data_->function;
						_data_->_tmp17_ = math_function_get_name (_data_->_tmp16_);
						_data_->_tmp18_ = _data_->_tmp17_;
						_data_->_tmp19_ = _data_->function;
						_data_->_tmp21_ = 0;
						_data_->_tmp20_ = math_function_get_arguments (_data_->_tmp19_, &_data_->_tmp21_);
						_data_->_tmp20__length1 = _data_->_tmp21_;
						_data_->_tmp22_ = _data_->_tmp20_;
						_data_->_tmp22__length1 = _data_->_tmp20__length1;
						_data_->_tmp23_ = _vala_g_strjoinv (";", _data_->_tmp22_, (gint) _data_->_tmp22__length1);
						_data_->_tmp24_ = _data_->_tmp23_;
						_data_->_tmp25_ = _data_->function;
						_data_->_tmp26_ = math_function_get_expression (_data_->_tmp25_);
						_data_->_tmp27_ = _data_->_tmp26_;
						_data_->_tmp28_ = g_strdup_printf ("%s(%s)=%s", _data_->_tmp18_, _data_->_tmp24_, _data_->_tmp27_);
						_g_free0 (_data_->details_text);
						_data_->details_text = _data_->_tmp28_;
						_g_free0 (_data_->_tmp24_);
						_data_->_tmp29_ = _data_->function;
						_data_->_tmp30_ = math_function_get_description (_data_->_tmp29_);
						_data_->_tmp31_ = _data_->_tmp30_;
						if (g_strcmp0 (_data_->_tmp31_, "") != 0) {
							_data_->_tmp32_ = _data_->details_text;
							_data_->_tmp33_ = _data_->function;
							_data_->_tmp34_ = math_function_get_description (_data_->_tmp33_);
							_data_->_tmp35_ = _data_->_tmp34_;
							_data_->_tmp36_ = g_strdup_printf ("\n%s", _data_->_tmp35_);
							_data_->_tmp37_ = _data_->_tmp36_;
							_data_->_tmp38_ = g_strconcat (_data_->_tmp32_, _data_->_tmp37_, NULL);
							_g_free0 (_data_->details_text);
							_data_->details_text = _data_->_tmp38_;
							_g_free0 (_data_->_tmp37_);
						}
					}
					_data_->_tmp39_ = _data_->proposals;
					_data_->_tmp40_ = _data_->label_text;
					_data_->_tmp41_ = _data_->details_text;
					_data_->_tmp42_ = completion_proposal_new (_data_->_tmp40_, _data_->_tmp41_);
					_data_->_tmp43_ = _data_->_tmp42_;
					g_list_store_append (_data_->_tmp39_, (GObject*) _data_->_tmp43_);
					_g_object_unref0 (_data_->_tmp43_);
					_g_free0 (_data_->details_text);
					_g_free0 (_data_->label_text);
					_g_object_unref0 (_data_->function);
				}
			}
		}
	}
	_data_->_tmp44_ = _data_->proposals;
	_data_->_tmp45_ = _g_object_ref0 ((GListModel*) _data_->_tmp44_);
	_data_->_tmp46_ = _data_->word;
	_data_->_tmp47_ = completion_provider_create_filter (_data_->_tmp46_);
	_data_->_tmp48_ = gtk_filter_list_model_new (_data_->_tmp45_, (GtkFilter*) _data_->_tmp47_);
	_data_->result = (GListModel*) _data_->_tmp48_;
	_g_free0 (_data_->word);
	_data_->functions = (_vala_array_free (_data_->functions, _data_->functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->proposals);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

FunctionCompletionProvider*
function_completion_provider_construct (GType object_type)
{
	FunctionCompletionProvider * self = NULL;
	self = (FunctionCompletionProvider*) completion_provider_construct (object_type);
	return self;
}

FunctionCompletionProvider*
function_completion_provider_new (void)
{
	return function_completion_provider_construct (TYPE_FUNCTION_COMPLETION_PROVIDER);
}

static void
function_completion_provider_class_init (FunctionCompletionProviderClass * klass,
                                         gpointer klass_data)
{
	function_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) function_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) function_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) function_completion_provider_populate_finish;
}

static void
function_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                            gpointer iface_data)
{
	function_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) function_completion_provider_real_get_title;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) function_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) function_completion_provider_populate_finish;
}

static void
function_completion_provider_instance_init (FunctionCompletionProvider * self,
                                            gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
function_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionCompletionProvider), 0, (GInstanceInitFunc) function_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) function_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType function_completion_provider_type_id;
	function_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "FunctionCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (function_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	return function_completion_provider_type_id;
}

GType
function_completion_provider_get_type (void)
{
	static gsize function_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&function_completion_provider_type_id__once)) {
		GType function_completion_provider_type_id;
		function_completion_provider_type_id = function_completion_provider_get_type_once ();
		g_once_init_leave (&function_completion_provider_type_id__once, function_completion_provider_type_id);
	}
	return function_completion_provider_type_id__once;
}

static gchar*
builtin_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	BuiltinCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BuiltinCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Built-in Keywords"));
	result = _tmp0_;
	return result;
}

static gint
builtin_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                               GtkSourceCompletionContext* context)
{
	BuiltinCompletionProvider * self;
	gint result;
	self = (BuiltinCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, 0);
	result = 4;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
builtin_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                  gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar** keywords = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint keywords_length1;
	gint _keywords_size_;
	gchar** _result_ = NULL;
	gchar** _tmp7_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** result;
	g_return_val_if_fail (context != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp4_ = g_strdup (_ ("in"));
	_tmp5_ = g_strdup (_ ("to"));
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	keywords = _tmp6_;
	keywords_length1 = 2;
	_keywords_size_ = keywords_length1;
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp7_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp8_ = keywords;
	_tmp8__length1 = keywords_length1;
	{
		gchar** keyword_collection = NULL;
		gint keyword_collection_length1 = 0;
		gint _keyword_collection_size_ = 0;
		gint keyword_it = 0;
		keyword_collection = _tmp8_;
		keyword_collection_length1 = _tmp8__length1;
		for (keyword_it = 0; keyword_it < keyword_collection_length1; keyword_it = keyword_it + 1) {
			gchar* _tmp9_;
			gchar* keyword = NULL;
			_tmp9_ = g_strdup (keyword_collection[keyword_it]);
			keyword = _tmp9_;
			{
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gboolean _tmp16_;
				_tmp10_ = keyword;
				_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
				_tmp12_ = _tmp11_;
				_tmp13_ = search_pattern;
				_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_str_has_prefix (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				_g_free0 (_tmp12_);
				if (_tmp16_) {
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp17_ = keyword;
					_tmp18_ = g_strdup (_tmp17_);
					_vala_array_add1 (&_result_, &_result__length1, &__result__size_, _tmp18_);
				}
				_g_free0 (keyword);
			}
		}
	}
	_tmp19_ = _result_;
	_tmp19__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	keywords = (_vala_array_free (keywords, keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (search_pattern);
	return result;
}

static void
builtin_completion_provider_real_populate_async_data_free (gpointer _data)
{
	BuiltinCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BuiltinCompletionProviderPopulateAsyncData, _data_);
}

static void
builtin_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                 GtkSourceCompletionContext* context,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	BuiltinCompletionProvider * self;
	BuiltinCompletionProviderPopulateAsyncData* _data_;
	BuiltinCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (BuiltinCompletionProvider*) base;
	_data_ = g_slice_new0 (BuiltinCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, builtin_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	builtin_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
builtin_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GListModel* result;
	BuiltinCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
builtin_completion_provider_real_populate_async_co (BuiltinCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = builtin_completion_provider_get_matches_for_completion_at_cursor (_data_->context, &_data_->_tmp1_);
	_data_->keywords = _data_->_tmp2_;
	_data_->keywords_length1 = _data_->_tmp1_;
	_data_->_keywords_size_ = _data_->keywords_length1;
	_data_->_tmp3_ = gtk_source_completion_context_get_word (_data_->context);
	_data_->word = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->keywords;
	_data_->_tmp4__length1 = _data_->keywords_length1;
	if (_data_->_tmp4__length1 > 0) {
		_data_->_tmp5_ = _data_->keywords;
		_data_->_tmp5__length1 = _data_->keywords_length1;
		{
			_data_->keyword_collection_length1 = 0;
			_data_->_keyword_collection_size_ = 0;
			_data_->keyword_collection = _data_->_tmp5_;
			_data_->keyword_collection_length1 = _data_->_tmp5__length1;
			for (_data_->keyword_it = 0; _data_->keyword_it < _data_->keyword_collection_length1; _data_->keyword_it = _data_->keyword_it + 1) {
				_data_->_tmp6_ = g_strdup (_data_->keyword_collection[_data_->keyword_it]);
				_data_->keyword = _data_->_tmp6_;
				{
					_data_->_tmp7_ = _data_->proposals;
					_data_->_tmp8_ = _data_->keyword;
					_data_->_tmp9_ = _data_->keyword;
					_data_->_tmp10_ = completion_proposal_new (_data_->_tmp8_, _data_->_tmp9_);
					_data_->_tmp11_ = _data_->_tmp10_;
					g_list_store_append (_data_->_tmp7_, (GObject*) _data_->_tmp11_);
					_g_object_unref0 (_data_->_tmp11_);
					_g_free0 (_data_->keyword);
				}
			}
		}
	}
	_data_->_tmp12_ = _data_->proposals;
	_data_->_tmp13_ = _g_object_ref0 ((GListModel*) _data_->_tmp12_);
	_data_->_tmp14_ = _data_->word;
	_data_->_tmp15_ = completion_provider_create_filter (_data_->_tmp14_);
	_data_->_tmp16_ = gtk_filter_list_model_new (_data_->_tmp13_, (GtkFilter*) _data_->_tmp15_);
	_data_->result = (GListModel*) _data_->_tmp16_;
	_g_free0 (_data_->word);
	_data_->keywords = (_vala_array_free (_data_->keywords, _data_->keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->proposals);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BuiltinCompletionProvider*
builtin_completion_provider_construct (GType object_type)
{
	BuiltinCompletionProvider * self = NULL;
	self = (BuiltinCompletionProvider*) completion_provider_construct (object_type);
	return self;
}

BuiltinCompletionProvider*
builtin_completion_provider_new (void)
{
	return builtin_completion_provider_construct (TYPE_BUILTIN_COMPLETION_PROVIDER);
}

static void
builtin_completion_provider_class_init (BuiltinCompletionProviderClass * klass,
                                        gpointer klass_data)
{
	builtin_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) builtin_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) builtin_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) builtin_completion_provider_populate_finish;
}

static void
builtin_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                           gpointer iface_data)
{
	builtin_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) builtin_completion_provider_real_get_title;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) builtin_completion_provider_real_get_priority;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) builtin_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) builtin_completion_provider_populate_finish;
}

static void
builtin_completion_provider_instance_init (BuiltinCompletionProvider * self,
                                           gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
builtin_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BuiltinCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) builtin_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuiltinCompletionProvider), 0, (GInstanceInitFunc) builtin_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) builtin_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType builtin_completion_provider_type_id;
	builtin_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "BuiltinCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (builtin_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	return builtin_completion_provider_type_id;
}

GType
builtin_completion_provider_get_type (void)
{
	static gsize builtin_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&builtin_completion_provider_type_id__once)) {
		GType builtin_completion_provider_type_id;
		builtin_completion_provider_type_id = builtin_completion_provider_get_type_once ();
		g_once_init_leave (&builtin_completion_provider_type_id__once, builtin_completion_provider_type_id);
	}
	return builtin_completion_provider_type_id__once;
}

static inline gpointer
currency_completion_provider_get_instance_private (CurrencyCompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, CurrencyCompletionProvider_private_offset);
}

CurrencyCompletionProvider*
currency_completion_provider_construct (GType object_type,
                                        gboolean favorite)
{
	CurrencyCompletionProvider * self = NULL;
	self = (CurrencyCompletionProvider*) completion_provider_construct (object_type);
	self->priv->favorite = favorite;
	return self;
}

CurrencyCompletionProvider*
currency_completion_provider_new (gboolean favorite)
{
	return currency_completion_provider_construct (TYPE_CURRENCY_COMPLETION_PROVIDER, favorite);
}

static gchar*
currency_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	CurrencyCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (CurrencyCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Defined Currencies"));
	result = _tmp0_;
	return result;
}

static gint
currency_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                GtkSourceCompletionContext* context)
{
	CurrencyCompletionProvider * self;
	gint _tmp0_ = 0;
	gint result;
	self = (CurrencyCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, 0);
	if (self->priv->favorite) {
		_tmp0_ = 2;
	} else {
		_tmp0_ = 1;
	}
	result = _tmp0_;
	return result;
}

Currency**
currency_completion_provider_get_matches_for_completion_at_cursor (CurrencyCompletionProvider* self,
                                                                   GtkSourceCompletionContext* context,
                                                                   gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	CurrencyManager* currency_manager = NULL;
	CurrencyManager* _tmp4_;
	Currency** currencies = NULL;
	gint _tmp5_ = 0;
	Currency** _tmp6_;
	gint currencies_length1;
	gint _currencies_size_;
	Currency** _tmp7_;
	gint _tmp7__length1;
	Currency** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp4_ = currency_manager_get_default (TRUE, TRUE);
	currency_manager = _tmp4_;
	_tmp6_ = currency_manager_currencies_eligible_for_autocompletion (currency_manager, search_pattern, self->priv->favorite, &_tmp5_);
	currencies = _tmp6_;
	currencies_length1 = _tmp5_;
	_currencies_size_ = currencies_length1;
	_tmp7_ = currencies;
	_tmp7__length1 = currencies_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (currency_manager);
	_g_free0 (search_pattern);
	return result;
}

static void
currency_completion_provider_real_populate_async_data_free (gpointer _data)
{
	CurrencyCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (CurrencyCompletionProviderPopulateAsyncData, _data_);
}

static void
currency_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	CurrencyCompletionProvider * self;
	CurrencyCompletionProviderPopulateAsyncData* _data_;
	CurrencyCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (CurrencyCompletionProvider*) base;
	_data_ = g_slice_new0 (CurrencyCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, currency_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	currency_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
currency_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GListModel* result;
	CurrencyCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
currency_completion_provider_real_populate_async_co (CurrencyCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = currency_completion_provider_get_matches_for_completion_at_cursor (_data_->self, _data_->context, &_data_->_tmp1_);
	_data_->currencies = _data_->_tmp2_;
	_data_->currencies_length1 = _data_->_tmp1_;
	_data_->_currencies_size_ = _data_->currencies_length1;
	_data_->_tmp3_ = gtk_source_completion_context_get_word (_data_->context);
	_data_->word = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->currencies;
	_data_->_tmp4__length1 = _data_->currencies_length1;
	if (_data_->_tmp4__length1 > 0) {
		_data_->_tmp5_ = _data_->currencies;
		_data_->_tmp5__length1 = _data_->currencies_length1;
		{
			_data_->currency_collection_length1 = 0;
			_data_->_currency_collection_size_ = 0;
			_data_->currency_collection = _data_->_tmp5_;
			_data_->currency_collection_length1 = _data_->_tmp5__length1;
			for (_data_->currency_it = 0; _data_->currency_it < _data_->currency_collection_length1; _data_->currency_it = _data_->currency_it + 1) {
				_data_->_tmp6_ = _g_object_ref0 (_data_->currency_collection[_data_->currency_it]);
				_data_->currency = _data_->_tmp6_;
				{
					_data_->_tmp7_ = _data_->currency;
					_data_->_tmp8_ = currency_get_name (_data_->_tmp7_);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->_tmp10_ = _data_->_tmp9_;
					_data_->_tmp11_ = g_strdup_printf ("%s", _data_->_tmp10_);
					_data_->_tmp12_ = _data_->_tmp11_;
					_g_free0 (_data_->_tmp10_);
					_data_->label_text = _data_->_tmp12_;
					_data_->_tmp13_ = _data_->currency;
					_data_->_tmp14_ = currency_get_display_name (_data_->_tmp13_);
					_data_->_tmp15_ = _data_->_tmp14_;
					_data_->_tmp16_ = _data_->_tmp15_;
					_data_->_tmp17_ = _data_->currency;
					_data_->_tmp18_ = currency_get_symbol (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp20_ = _data_->_tmp19_;
					_data_->_tmp21_ = g_strdup_printf ("%s - %s", _data_->_tmp16_, _data_->_tmp20_);
					_data_->_tmp22_ = _data_->_tmp21_;
					_g_free0 (_data_->_tmp20_);
					_g_free0 (_data_->_tmp16_);
					_data_->details_text = _data_->_tmp22_;
					_data_->_tmp23_ = _data_->proposals;
					_data_->_tmp24_ = _data_->label_text;
					_data_->_tmp25_ = _data_->details_text;
					_data_->_tmp26_ = completion_proposal_new (_data_->_tmp24_, _data_->_tmp25_);
					_data_->_tmp27_ = _data_->_tmp26_;
					g_list_store_append (_data_->_tmp23_, (GObject*) _data_->_tmp27_);
					_g_object_unref0 (_data_->_tmp27_);
					_g_free0 (_data_->details_text);
					_g_free0 (_data_->label_text);
					_g_object_unref0 (_data_->currency);
				}
			}
		}
	}
	_data_->_tmp28_ = _data_->proposals;
	_data_->_tmp29_ = _g_object_ref0 ((GListModel*) _data_->_tmp28_);
	_data_->_tmp30_ = _data_->word;
	_data_->_tmp31_ = completion_provider_create_filter (_data_->_tmp30_);
	_data_->_tmp32_ = gtk_filter_list_model_new (_data_->_tmp29_, (GtkFilter*) _data_->_tmp31_);
	_data_->result = (GListModel*) _data_->_tmp32_;
	_g_free0 (_data_->word);
	_data_->currencies = (_vala_array_free (_data_->currencies, _data_->currencies_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->proposals);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
currency_completion_provider_class_init (CurrencyCompletionProviderClass * klass,
                                         gpointer klass_data)
{
	currency_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CurrencyCompletionProvider_private_offset);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) currency_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) currency_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) currency_completion_provider_populate_finish;
	G_OBJECT_CLASS (klass)->finalize = currency_completion_provider_finalize;
}

static void
currency_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                            gpointer iface_data)
{
	currency_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) currency_completion_provider_real_get_title;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) currency_completion_provider_real_get_priority;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) currency_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) currency_completion_provider_populate_finish;
}

static void
currency_completion_provider_instance_init (CurrencyCompletionProvider * self,
                                            gpointer klass)
{
	self->priv = currency_completion_provider_get_instance_private (self);
}

static void
currency_completion_provider_finalize (GObject * obj)
{
	CurrencyCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY_COMPLETION_PROVIDER, CurrencyCompletionProvider);
	G_OBJECT_CLASS (currency_completion_provider_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
currency_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CurrencyCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CurrencyCompletionProvider), 0, (GInstanceInitFunc) currency_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) currency_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType currency_completion_provider_type_id;
	currency_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "CurrencyCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (currency_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	CurrencyCompletionProvider_private_offset = g_type_add_instance_private (currency_completion_provider_type_id, sizeof (CurrencyCompletionProviderPrivate));
	return currency_completion_provider_type_id;
}

GType
currency_completion_provider_get_type (void)
{
	static gsize currency_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&currency_completion_provider_type_id__once)) {
		GType currency_completion_provider_type_id;
		currency_completion_provider_type_id = currency_completion_provider_get_type_once ();
		g_once_init_leave (&currency_completion_provider_type_id__once, currency_completion_provider_type_id);
	}
	return currency_completion_provider_type_id__once;
}

static inline gpointer
variable_completion_provider_get_instance_private (VariableCompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, VariableCompletionProvider_private_offset);
}

VariableCompletionProvider*
variable_completion_provider_construct (GType object_type,
                                        MathEquation* equation)
{
	VariableCompletionProvider * self = NULL;
	MathEquation* _tmp0_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (VariableCompletionProvider*) completion_provider_construct (object_type);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp0_;
	return self;
}

VariableCompletionProvider*
variable_completion_provider_new (MathEquation* equation)
{
	return variable_completion_provider_construct (TYPE_VARIABLE_COMPLETION_PROVIDER, equation);
}

static gchar*
variable_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	VariableCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (VariableCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Defined Variables"));
	result = _tmp0_;
	return result;
}

static gint
variable_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                GtkSourceCompletionContext* context)
{
	VariableCompletionProvider * self;
	gint result;
	self = (VariableCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, 0);
	result = 3;
	return result;
}

gchar**
variable_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                   MathVariables* variables,
                                                                   gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar** math_variables = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gint math_variables_length1;
	gint _math_variables_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp5_ = math_variables_variables_eligible_for_autocompletion (variables, search_pattern, &_tmp4_);
	math_variables = _tmp5_;
	math_variables_length1 = _tmp4_;
	_math_variables_size_ = math_variables_length1;
	_tmp6_ = math_variables;
	_tmp6__length1 = math_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_g_free0 (search_pattern);
	return result;
}

static void
variable_completion_provider_real_populate_async_data_free (gpointer _data)
{
	VariableCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (VariableCompletionProviderPopulateAsyncData, _data_);
}

static void
variable_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	VariableCompletionProvider * self;
	VariableCompletionProviderPopulateAsyncData* _data_;
	VariableCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (VariableCompletionProvider*) base;
	_data_ = g_slice_new0 (VariableCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, variable_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	variable_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
variable_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GListModel* result;
	VariableCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
variable_completion_provider_real_populate_async_co (VariableCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->_equation;
	_data_->_tmp2_ = math_equation_get_variables (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = variable_completion_provider_get_matches_for_completion_at_cursor (_data_->context, _data_->_tmp3_, &_data_->_tmp4_);
	_data_->variables = _data_->_tmp5_;
	_data_->variables_length1 = _data_->_tmp4_;
	_data_->_variables_size_ = _data_->variables_length1;
	_data_->_tmp6_ = gtk_source_completion_context_get_word (_data_->context);
	_data_->word = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->variables;
	_data_->_tmp7__length1 = _data_->variables_length1;
	if (_data_->_tmp7__length1 > 0) {
		_data_->_tmp8_ = _data_->variables;
		_data_->_tmp8__length1 = _data_->variables_length1;
		{
			_data_->variable_collection_length1 = 0;
			_data_->_variable_collection_size_ = 0;
			_data_->variable_collection = _data_->_tmp8_;
			_data_->variable_collection_length1 = _data_->_tmp8__length1;
			for (_data_->variable_it = 0; _data_->variable_it < _data_->variable_collection_length1; _data_->variable_it = _data_->variable_it + 1) {
				_data_->_tmp9_ = g_strdup (_data_->variable_collection[_data_->variable_it]);
				_data_->variable = _data_->_tmp9_;
				{
					_data_->_tmp10_ = _data_->variable;
					_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
					_data_->label_text = _data_->_tmp11_;
					_data_->_tmp12_ = _data_->self->priv->_equation;
					_data_->_tmp13_ = math_equation_get_serializer (_data_->_tmp12_);
					_data_->_tmp14_ = _data_->_tmp13_;
					_data_->_tmp15_ = _data_->self->priv->_equation;
					_data_->_tmp16_ = math_equation_get_variables (_data_->_tmp15_);
					_data_->_tmp17_ = _data_->_tmp16_;
					_data_->_tmp18_ = _data_->variable;
					_data_->_tmp19_ = math_variables_get (_data_->_tmp17_, _data_->_tmp18_);
					_data_->_tmp20_ = _data_->_tmp19_;
					_data_->_tmp21_ = serializer_to_string (_data_->_tmp14_, _data_->_tmp20_);
					_data_->_tmp22_ = _data_->_tmp21_;
					_g_object_unref0 (_data_->_tmp20_);
					_data_->value_text = _data_->_tmp22_;
					_data_->_tmp23_ = _data_->variable;
					_data_->_tmp24_ = _data_->value_text;
					_data_->_tmp25_ = g_strdup_printf ("%s=%s", _data_->_tmp23_, _data_->_tmp24_);
					_data_->details_text = _data_->_tmp25_;
					_data_->_tmp26_ = _data_->proposals;
					_data_->_tmp27_ = _data_->label_text;
					_data_->_tmp28_ = _data_->details_text;
					_data_->_tmp29_ = completion_proposal_new (_data_->_tmp27_, _data_->_tmp28_);
					_data_->_tmp30_ = _data_->_tmp29_;
					g_list_store_append (_data_->_tmp26_, (GObject*) _data_->_tmp30_);
					_g_object_unref0 (_data_->_tmp30_);
					_g_free0 (_data_->details_text);
					_g_free0 (_data_->value_text);
					_g_free0 (_data_->label_text);
					_g_free0 (_data_->variable);
				}
			}
		}
	}
	_data_->_tmp31_ = _data_->proposals;
	_data_->_tmp32_ = _g_object_ref0 ((GListModel*) _data_->_tmp31_);
	_data_->_tmp33_ = _data_->word;
	_data_->_tmp34_ = completion_provider_create_filter (_data_->_tmp33_);
	_data_->_tmp35_ = gtk_filter_list_model_new (_data_->_tmp32_, (GtkFilter*) _data_->_tmp34_);
	_data_->result = (GListModel*) _data_->_tmp35_;
	_g_free0 (_data_->word);
	_data_->variables = (_vala_array_free (_data_->variables, _data_->variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->proposals);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
variable_completion_provider_class_init (VariableCompletionProviderClass * klass,
                                         gpointer klass_data)
{
	variable_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &VariableCompletionProvider_private_offset);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) variable_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) variable_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) variable_completion_provider_populate_finish;
	G_OBJECT_CLASS (klass)->finalize = variable_completion_provider_finalize;
}

static void
variable_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                            gpointer iface_data)
{
	variable_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) variable_completion_provider_real_get_title;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) variable_completion_provider_real_get_priority;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) variable_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) variable_completion_provider_populate_finish;
}

static void
variable_completion_provider_instance_init (VariableCompletionProvider * self,
                                            gpointer klass)
{
	self->priv = variable_completion_provider_get_instance_private (self);
}

static void
variable_completion_provider_finalize (GObject * obj)
{
	VariableCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider);
	_g_object_unref0 (self->priv->_equation);
	G_OBJECT_CLASS (variable_completion_provider_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
variable_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VariableCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableCompletionProvider), 0, (GInstanceInitFunc) variable_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) variable_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType variable_completion_provider_type_id;
	variable_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "VariableCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (variable_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	VariableCompletionProvider_private_offset = g_type_add_instance_private (variable_completion_provider_type_id, sizeof (VariableCompletionProviderPrivate));
	return variable_completion_provider_type_id;
}

GType
variable_completion_provider_get_type (void)
{
	static gsize variable_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&variable_completion_provider_type_id__once)) {
		GType variable_completion_provider_type_id;
		variable_completion_provider_type_id = variable_completion_provider_get_type_once ();
		g_once_init_leave (&variable_completion_provider_type_id__once, variable_completion_provider_type_id);
	}
	return variable_completion_provider_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

