/* Generated by wayland-scanner 1.24.0 */

#ifndef GAMESCOPE_SWAPCHAIN_CLIENT_PROTOCOL_H
#define GAMESCOPE_SWAPCHAIN_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_gamescope_swapchain The gamescope_swapchain protocol
 * gamescope-specific swapchain protocol
 *
 * @section page_desc_gamescope_swapchain Description
 *
 * This is a private Gamescope protocol. Regular Wayland clients must not use
 * it.
 *
 * @section page_ifaces_gamescope_swapchain Interfaces
 * - @subpage page_iface_gamescope_swapchain_factory_v2 - 
 * - @subpage page_iface_gamescope_swapchain - 
 * @section page_copyright_gamescope_swapchain Copyright
 * <pre>
 *
 * Copyright © 2023 Joshua Ashton for Valve Software
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gamescope_swapchain;
struct gamescope_swapchain_factory_v2;
struct wl_surface;

#ifndef GAMESCOPE_SWAPCHAIN_FACTORY_V2_INTERFACE
#define GAMESCOPE_SWAPCHAIN_FACTORY_V2_INTERFACE
/**
 * @page page_iface_gamescope_swapchain_factory_v2 gamescope_swapchain_factory_v2
 * @section page_iface_gamescope_swapchain_factory_v2_api API
 * See @ref iface_gamescope_swapchain_factory_v2.
 */
/**
 * @defgroup iface_gamescope_swapchain_factory_v2 The gamescope_swapchain_factory_v2 interface
 */
extern const struct wl_interface gamescope_swapchain_factory_v2_interface;
#endif
#ifndef GAMESCOPE_SWAPCHAIN_INTERFACE
#define GAMESCOPE_SWAPCHAIN_INTERFACE
/**
 * @page page_iface_gamescope_swapchain gamescope_swapchain
 * @section page_iface_gamescope_swapchain_api API
 * See @ref iface_gamescope_swapchain.
 */
/**
 * @defgroup iface_gamescope_swapchain The gamescope_swapchain interface
 */
extern const struct wl_interface gamescope_swapchain_interface;
#endif

#define GAMESCOPE_SWAPCHAIN_FACTORY_V2_DESTROY 0
#define GAMESCOPE_SWAPCHAIN_FACTORY_V2_CREATE_SWAPCHAIN 1


/**
 * @ingroup iface_gamescope_swapchain_factory_v2
 */
#define GAMESCOPE_SWAPCHAIN_FACTORY_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain_factory_v2
 */
#define GAMESCOPE_SWAPCHAIN_FACTORY_V2_CREATE_SWAPCHAIN_SINCE_VERSION 1

/** @ingroup iface_gamescope_swapchain_factory_v2 */
static inline void
gamescope_swapchain_factory_v2_set_user_data(struct gamescope_swapchain_factory_v2 *gamescope_swapchain_factory_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gamescope_swapchain_factory_v2, user_data);
}

/** @ingroup iface_gamescope_swapchain_factory_v2 */
static inline void *
gamescope_swapchain_factory_v2_get_user_data(struct gamescope_swapchain_factory_v2 *gamescope_swapchain_factory_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gamescope_swapchain_factory_v2);
}

static inline uint32_t
gamescope_swapchain_factory_v2_get_version(struct gamescope_swapchain_factory_v2 *gamescope_swapchain_factory_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain_factory_v2);
}

/**
 * @ingroup iface_gamescope_swapchain_factory_v2
 */
static inline void
gamescope_swapchain_factory_v2_destroy(struct gamescope_swapchain_factory_v2 *gamescope_swapchain_factory_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain_factory_v2,
			 GAMESCOPE_SWAPCHAIN_FACTORY_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain_factory_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gamescope_swapchain_factory_v2
 *
 */
static inline struct gamescope_swapchain *
gamescope_swapchain_factory_v2_create_swapchain(struct gamescope_swapchain_factory_v2 *gamescope_swapchain_factory_v2, struct wl_surface *surface)
{
	struct wl_proxy *callback;

	callback = wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain_factory_v2,
			 GAMESCOPE_SWAPCHAIN_FACTORY_V2_CREATE_SWAPCHAIN, &gamescope_swapchain_interface, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain_factory_v2), 0, surface, NULL);

	return (struct gamescope_swapchain *) callback;
}

/**
 * @ingroup iface_gamescope_swapchain
 * @struct gamescope_swapchain_listener
 */
struct gamescope_swapchain_listener {
	/**
	 * information about past presentation
	 *
	 * Gives information on the past presentation timing
	 * @param present_id application provided presentation id
	 * @param desired_present_time_hi high part of the desired presentation time for the commit. (from the app)
	 * @param desired_present_time_lo low part of the desired presentation time for the commit. (from the app)
	 * @param actual_present_time_hi high part of the actual present time for this commit.
	 * @param actual_present_time_lo low part of the actual present time for this commit.
	 * @param earliest_present_time_hi high part of the refresh time that Gamescope thought this commit was done by.
	 * @param earliest_present_time_lo low part of the refresh time that Gamescope thought this commit was done by.
	 * @param present_margin_hi high part of the difference between earliest present time and the earliest latch time
	 * @param present_margin_lo low part of the difference between earliest present time and the earliest latch time
	 */
	void (*past_present_timing)(void *data,
				    struct gamescope_swapchain *gamescope_swapchain,
				    uint32_t present_id,
				    uint32_t desired_present_time_hi,
				    uint32_t desired_present_time_lo,
				    uint32_t actual_present_time_hi,
				    uint32_t actual_present_time_lo,
				    uint32_t earliest_present_time_hi,
				    uint32_t earliest_present_time_lo,
				    uint32_t present_margin_hi,
				    uint32_t present_margin_lo);
	/**
	 * information about refresh cycle for this swapchain
	 *
	 * Gives information on the refresh cycle for this swapchain
	 * @param refresh_cycle_hi high part of the refresh cycle in nanos
	 * @param refresh_cycle_lo low part of the refresh cycle in nanos
	 */
	void (*refresh_cycle)(void *data,
			      struct gamescope_swapchain *gamescope_swapchain,
			      uint32_t refresh_cycle_hi,
			      uint32_t refresh_cycle_lo);
	/**
	 * Swapchain was remotely retired
	 *
	 * 
	 */
	void (*retired)(void *data,
			struct gamescope_swapchain *gamescope_swapchain);
};

/**
 * @ingroup iface_gamescope_swapchain
 */
static inline int
gamescope_swapchain_add_listener(struct gamescope_swapchain *gamescope_swapchain,
				 const struct gamescope_swapchain_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) gamescope_swapchain,
				     (void (**)(void)) listener, data);
}

#define GAMESCOPE_SWAPCHAIN_DESTROY 0
#define GAMESCOPE_SWAPCHAIN_OVERRIDE_WINDOW_CONTENT 1
#define GAMESCOPE_SWAPCHAIN_SWAPCHAIN_FEEDBACK 2
#define GAMESCOPE_SWAPCHAIN_SET_PRESENT_MODE 3
#define GAMESCOPE_SWAPCHAIN_SET_HDR_METADATA 4
#define GAMESCOPE_SWAPCHAIN_SET_PRESENT_TIME 5

/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_PAST_PRESENT_TIMING_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_REFRESH_CYCLE_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_RETIRED_SINCE_VERSION 1

/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_OVERRIDE_WINDOW_CONTENT_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_SWAPCHAIN_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_SET_PRESENT_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_SET_HDR_METADATA_SINCE_VERSION 1
/**
 * @ingroup iface_gamescope_swapchain
 */
#define GAMESCOPE_SWAPCHAIN_SET_PRESENT_TIME_SINCE_VERSION 1

/** @ingroup iface_gamescope_swapchain */
static inline void
gamescope_swapchain_set_user_data(struct gamescope_swapchain *gamescope_swapchain, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gamescope_swapchain, user_data);
}

/** @ingroup iface_gamescope_swapchain */
static inline void *
gamescope_swapchain_get_user_data(struct gamescope_swapchain *gamescope_swapchain)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gamescope_swapchain);
}

static inline uint32_t
gamescope_swapchain_get_version(struct gamescope_swapchain *gamescope_swapchain)
{
	return wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain);
}

/**
 * @ingroup iface_gamescope_swapchain
 */
static inline void
gamescope_swapchain_destroy(struct gamescope_swapchain *gamescope_swapchain)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain,
			 GAMESCOPE_SWAPCHAIN_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gamescope_swapchain
 *
 * Xwayland creates a wl_surface for each X11 window. It sends a
 * WL_SURFACE_ID client message to indicate the mapping between the X11
 * windows and the wl_surface objects.
 *
 * This request overrides this mapping for a given X11 window, allowing an
 * X11 client to submit buffers via the Wayland protocol. The override
 * only affects buffer submission. Everything else (e.g. input events)
 * still uses Xwayland's WL_SURFACE_ID.
 *
 * x11_server is gotten by the GAMESCOPE_XWAYLAND_SERVER_ID property on the
 * root window of the associated server.
 */
static inline void
gamescope_swapchain_override_window_content(struct gamescope_swapchain *gamescope_swapchain, uint32_t gamescope_xwayland_server_id, uint32_t x11_window)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain,
			 GAMESCOPE_SWAPCHAIN_OVERRIDE_WINDOW_CONTENT, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain), 0, gamescope_xwayland_server_id, x11_window);
}

/**
 * @ingroup iface_gamescope_swapchain
 *
 * Provide swapchain feedback to the compositor.
 *
 * This is what the useless tearing protocol should have been.
 * Absolutely not enough information in the final protocol to do what we want for SteamOS --
 * which is have the Allow Tearing toggle apply to *both* Mailbox + Immediate and NOT fifo,
 * essentially acting as an override for tearing on/off for games.
 * The upstream protocol is very useless for our usecase here.
 *
 * Provides image count ahead of time instead of needing to try and calculate it from
 * an initial stall if we are doing low latency.
 *
 * Provides colorspace info for us to do HDR for both HDR10 PQ and scRGB.
 * The upstream HDR efforts seem to have no interest in supporting scRGB but we *need* that so /shrug
 * We can do it here now! Yipee!
 *
 * Swapchain feedback solves so many problems! :D
 */
static inline void
gamescope_swapchain_swapchain_feedback(struct gamescope_swapchain *gamescope_swapchain, uint32_t image_count, uint32_t vk_format, uint32_t vk_colorspace, uint32_t vk_composite_alpha, uint32_t vk_pre_transform, uint32_t vk_clipped, const char *vk_engine_name)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain,
			 GAMESCOPE_SWAPCHAIN_SWAPCHAIN_FEEDBACK, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain), 0, image_count, vk_format, vk_colorspace, vk_composite_alpha, vk_pre_transform, vk_clipped, vk_engine_name);
}

/**
 * @ingroup iface_gamescope_swapchain
 */
static inline void
gamescope_swapchain_set_present_mode(struct gamescope_swapchain *gamescope_swapchain, uint32_t vk_present_mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain,
			 GAMESCOPE_SWAPCHAIN_SET_PRESENT_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain), 0, vk_present_mode);
}

/**
 * @ingroup iface_gamescope_swapchain
 *
 * Forward HDR metadata from Vulkan to the compositor.
 *
 * HDR Metadata Infoframe as per CTA 861.G spec.
 * This is expected to match exactly with the spec.
 *
 * display_primary_*:
 * Color Primaries of the Data.
 * Specifies X and Y coordinates.
 * These are coded as unsigned 16-bit values in units of
 * 0.00002, where 0x0000 represents zero and 0xC350
 * represents 1.0000.
 *
 * white_point_*:
 * White Point of Colorspace Data.
 * Specifies X and Y coordinates.
 * These are coded as unsigned 16-bit values in units of
 * 0.00002, where 0x0000 represents zero and 0xC350
 * represents 1.0000.
 *
 * max_display_mastering_luminance:
 * Max Mastering Display Luminance.
 * This value is coded as an unsigned 16-bit value in units of 1 cd/m2,
 * where 0x0001 represents 1 cd/m2 and 0xFFFF represents 65535 cd/m2.
 *
 * max_display_mastering_luminance:
 * Min Mastering Display Luminance.
 * This value is coded as an unsigned 16-bit value in units of
 * 0.0001 cd/m2, where 0x0001 represents 0.0001 cd/m2 and 0xFFFF
 * represents 6.5535 cd/m2.
 *
 * max_cll:
 * Max Content Light Level.
 * This value is coded as an unsigned 16-bit value in units of 1 cd/m2,
 * where 0x0001 represents 1 cd/m2 and 0xFFFF represents 65535 cd/m2.
 *
 * max_fall:
 * Max Frame Average Light Level.
 * This value is coded as an unsigned 16-bit value in units of 1 cd/m2,
 * where 0x0001 represents 1 cd/m2 and 0xFFFF represents 65535 cd/m2.
 */
static inline void
gamescope_swapchain_set_hdr_metadata(struct gamescope_swapchain *gamescope_swapchain, uint32_t display_primary_red_x, uint32_t display_primary_red_y, uint32_t display_primary_green_x, uint32_t display_primary_green_y, uint32_t display_primary_blue_x, uint32_t display_primary_blue_y, uint32_t white_point_x, uint32_t white_point_y, uint32_t max_display_mastering_luminance, uint32_t min_display_mastering_luminance, uint32_t max_cll, uint32_t max_fall)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain,
			 GAMESCOPE_SWAPCHAIN_SET_HDR_METADATA, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain), 0, display_primary_red_x, display_primary_red_y, display_primary_green_x, display_primary_green_y, display_primary_blue_x, display_primary_blue_y, white_point_x, white_point_y, max_display_mastering_luminance, min_display_mastering_luminance, max_cll, max_fall);
}

/**
 * @ingroup iface_gamescope_swapchain
 *
 * Sets the display timing of the next commit.
 *
 * This gets reset to 0s in the compositor's state after a commit.
 */
static inline void
gamescope_swapchain_set_present_time(struct gamescope_swapchain *gamescope_swapchain, uint32_t present_id, uint32_t desired_present_time_hi, uint32_t desired_present_time_lo)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gamescope_swapchain,
			 GAMESCOPE_SWAPCHAIN_SET_PRESENT_TIME, NULL, wl_proxy_get_version((struct wl_proxy *) gamescope_swapchain), 0, present_id, desired_present_time_hi, desired_present_time_lo);
}

#ifdef  __cplusplus
}
#endif

#endif
