
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "passwordmanager_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_PasswordManager_Type = nullptr;
static PyTypeObject *Sbk_PasswordManager_TypeF(void)
{
    return _Sbk_PasswordManager_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void PasswordManagerWrapper::pysideInitQtMetaTypes()
{
}

void PasswordManagerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

PasswordManagerWrapper::PasswordManagerWrapper(::QObject * parent) : PasswordManager(parent)
{
}

void PasswordManagerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordManager_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("PasswordManager", funcName, gil, pyOverride, event);
}

void PasswordManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordManager_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("PasswordManager", funcName, gil, pyOverride, signal);
}

void PasswordManagerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordManager_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("PasswordManager", funcName, gil, pyOverride, event);
}

void PasswordManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordManager_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("PasswordManager", funcName, gil, pyOverride, signal);
}

bool PasswordManagerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordManager_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("PasswordManager", funcName, gil, pyOverride, event);
}

bool PasswordManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordManager_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("PasswordManager", funcName, gil, pyOverride, watched, event);
}

void PasswordManagerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordManager_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("PasswordManager", funcName, gil, pyOverride, event);
}

const QMetaObject *PasswordManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return PasswordManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int PasswordManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = PasswordManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *PasswordManagerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< PasswordManagerWrapper *>(this));
    }
    return PasswordManager::qt_metacast(_clname);
}

PasswordManagerWrapper::~PasswordManagerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_PasswordManager_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PasswordManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PasswordManager >()))
        return -1;

    PasswordManagerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:PasswordManager", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: PasswordManager::PasswordManager(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // PasswordManager(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // PasswordManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // PasswordManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) PasswordManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new PasswordManagerWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< PasswordManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);
    };


    return 1;
}

static PyObject *Sbk_PasswordManagerFunc_activeBackend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeBackend()
        PasswordBackend * cppResult = cppSelf->activeBackend();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_addEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::addEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // addEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addEntry", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // addEntry(PasswordEntry)
            cppSelf->addEntry(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordManagerFunc_availableBackends(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // availableBackends()
        QHash<QString,PasswordBackend*> cppResult = cppSelf->availableBackends();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QHash_QString_PasswordBackendPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_createHost(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static PasswordManager::createHost(QUrl)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // createHost(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createHost", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // createHost(QUrl)
            QString cppResult = ::PasswordManager::createHost(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_getAllEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAllEntries()
        QList<PasswordEntry> cppResult = cppSelf->getAllEntries();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_getEntries(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::getEntries(QUrl)->QList<PasswordEntry>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getEntries(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getEntries", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getEntries(QUrl)
            QList<PasswordEntry> cppResult = cppSelf->getEntries(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_getUsernames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::getUsernames(QUrl)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getUsernames(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getUsernames", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getUsernames(QUrl)
            QStringList cppResult = cppSelf->getUsernames(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordManagerFunc_registerBackend(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "registerBackend", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PasswordManager::registerBackend(QString,PasswordBackend*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerBackend(QString,PasswordBackend*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "registerBackend", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::PasswordBackend *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerBackend(QString,PasswordBackend*)
            bool cppResult = cppSelf->registerBackend(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_removeAllEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // removeAllEntries()
        cppSelf->removeAllEntries();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordManagerFunc_removeEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::removeEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // removeEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeEntry", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // removeEntry(PasswordEntry)
            cppSelf->removeEntry(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordManagerFunc_switchBackend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::switchBackend(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // switchBackend(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "switchBackend", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // switchBackend(QString)
            cppSelf->switchBackend(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordManagerFunc_unregisterBackend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::unregisterBackend(PasswordBackend*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterBackend(PasswordBackend*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterBackend", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordBackend *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterBackend(PasswordBackend*)
            cppSelf->unregisterBackend(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordManagerFunc_updateEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::updateEntry(PasswordEntry)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // updateEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "updateEntry", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // updateEntry(PasswordEntry)
            bool cppResult = cppSelf->updateEntry(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordManagerFunc_updateLastUsed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PasswordManagerWrapper *>(reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordManager::updateLastUsed(PasswordEntry&)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // updateLastUsed(PasswordEntry&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "updateLastUsed", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // updateLastUsed(PasswordEntry&)
            cppSelf->updateLastUsed(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordManagerFunc_urlEncodePassword(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static PasswordManager::urlEncodePassword(QString)->QByteArray
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // urlEncodePassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "urlEncodePassword", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // urlEncodePassword(QString)
            QByteArray cppResult = ::PasswordManager::urlEncodePassword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_PasswordManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PasswordManager_methods[] = {
    {"activeBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_activeBackend), METH_NOARGS, nullptr},
    {"addEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_addEntry), METH_O, nullptr},
    {"availableBackends", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_availableBackends), METH_NOARGS, nullptr},
    {"createHost", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_createHost), METH_O|METH_STATIC, nullptr},
    {"getAllEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_getAllEntries), METH_NOARGS, nullptr},
    {"getEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_getEntries), METH_O, nullptr},
    {"getUsernames", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_getUsernames), METH_O, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_loadSettings), METH_NOARGS, nullptr},
    {"registerBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_registerBackend), METH_VARARGS, nullptr},
    {"removeAllEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_removeAllEntries), METH_NOARGS, nullptr},
    {"removeEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_removeEntry), METH_O, nullptr},
    {"switchBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_switchBackend), METH_O, nullptr},
    {"unregisterBackend", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_unregisterBackend), METH_O, nullptr},
    {"updateEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_updateEntry), METH_O, nullptr},
    {"updateLastUsed", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_updateLastUsed), METH_O, nullptr},
    {"urlEncodePassword", reinterpret_cast<PyCFunction>(Sbk_PasswordManagerFunc_urlEncodePassword), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_PasswordManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::PasswordManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<PasswordManagerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_PasswordManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_PasswordManager_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_PasswordManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_PasswordManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PasswordManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PasswordManager_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PasswordManager_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PasswordManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_PasswordManager_spec = {
    "1:PyFalkon.PasswordManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_PasswordManager_slots
};

} //extern "C"

static void *Sbk_PasswordManager_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::PasswordManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PasswordManager_PythonToCpp_PasswordManager_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_PasswordManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PasswordManager_PythonToCpp_PasswordManager_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_PasswordManager_TypeF()))
        return PasswordManager_PythonToCpp_PasswordManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PasswordManager_PTR_CppToPython_PasswordManager(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::PasswordManager *>(const_cast<void *>(cppIn)), Sbk_PasswordManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PasswordManager_SignatureStrings[] = {
    "PyFalkon.PasswordManager(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.PasswordManager.activeBackend(self)->PyFalkon.PasswordBackend",
    "PyFalkon.PasswordManager.addEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordManager.availableBackends(self)->QHash[QString, PyFalkon.PasswordBackend]",
    "PyFalkon.PasswordManager.createHost(url:typing.Union[PySide6.QtCore.QUrl, QString])->QString",
    "PyFalkon.PasswordManager.getAllEntries(self)->QList[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordManager.getEntries(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->QList[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordManager.getUsernames(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->QStringList",
    "PyFalkon.PasswordManager.loadSettings(self)",
    "PyFalkon.PasswordManager.registerBackend(self,id:QString,backend:PyFalkon.PasswordBackend)->bool",
    "PyFalkon.PasswordManager.removeAllEntries(self)",
    "PyFalkon.PasswordManager.removeEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordManager.switchBackend(self,backendID:QString)",
    "PyFalkon.PasswordManager.unregisterBackend(self,backend:PyFalkon.PasswordBackend)",
    "PyFalkon.PasswordManager.updateEntry(self,entry:PyFalkon.PasswordEntry)->bool",
    "PyFalkon.PasswordManager.updateLastUsed(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordManager.urlEncodePassword(password:QString)->PySide6.QtCore.QByteArray",
    nullptr}; // Sentinel
#else
static constexpr size_t PasswordManager_SignatureByteSize = 348;
static constexpr uint8_t PasswordManager_SignatureBytes[348] = {
    0x78, 0xda, 0xa5, 0x54, 0xc1, 0x6e, 0x82, 0x40, 0x14, 0xbc, 0xfb, 0x15, 0x1e, 0x35, 0xa1, 0x1c,
    0x7b, 0x20, 0x69, 0x13, 0x6d, 0x6d, 0x6c, 0x62, 0x53, 0x88, 0xf1, 0x64, 0x3c, 0x3c, 0xd8, 0x57,
    0xdc, 0xba, 0xee, 0x92, 0xb7, 0x4f, 0x0d, 0x7f, 0x5f, 0x10, 0x68, 0xb5, 0xba, 0xd8, 0xea, 0xed,
    0x85, 0x1d, 0x66, 0xe6, 0xcd, 0x0e, 0x84, 0xf9, 0x0b, 0xa8, 0x95, 0xd1, 0x7e, 0x08, 0xd6, 0xee,
    0x0c, 0x89, 0x37, 0xd0, 0x90, 0x22, 0xf5, 0x2c, 0xaa, 0x0f, 0x2f, 0x03, 0x42, 0xcd, 0x41, 0x98,
    0x4f, 0xa5, 0xc0, 0x7b, 0x3f, 0xe2, 0x27, 0x43, 0xe8, 0x47, 0xef, 0xf1, 0x27, 0x26, 0xfc, 0xa0,
    0x37, 0x4a, 0x65, 0x4c, 0xfd, 0x4e, 0xe8, 0x20, 0xf1, 0x21, 0x61, 0xb9, 0xc5, 0x21, 0x24, 0x2b,
    0xd4, 0x62, 0x4f, 0xd9, 0xbf, 0x7b, 0x3c, 0x41, 0xd7, 0xe7, 0x2d, 0x34, 0x42, 0x8c, 0x34, 0x53,
    0x5e, 0x99, 0xc2, 0x72, 0x0c, 0x4e, 0xc0, 0x7b, 0x44, 0x9b, 0x97, 0x2d, 0x48, 0x05, 0xb1, 0x6a,
    0xec, 0xd8, 0xc6, 0x4f, 0x34, 0x06, 0xbb, 0x9c, 0x47, 0x53, 0x26, 0xa9, 0x53, 0xaf, 0xeb, 0xb2,
    0xb7, 0x70, 0x53, 0x27, 0x84, 0xc0, 0x38, 0x36, 0x96, 0x7b, 0x1b, 0x52, 0x01, 0xe7, 0x59, 0xc1,
    0xe4, 0xcf, 0xb4, 0x34, 0x7a, 0xfe, 0x3b, 0xbb, 0x19, 0x29, 0xaf, 0x5b, 0x8b, 0x2d, 0x4a, 0xf5,
    0x6a, 0x74, 0x93, 0xa7, 0xc8, 0x03, 0xa5, 0xca, 0xed, 0x24, 0xfe, 0x78, 0x9e, 0x48, 0xcb, 0xf3,
    0xf3, 0x19, 0x2c, 0x5a, 0xb9, 0x0e, 0x89, 0xbc, 0xff, 0xbb, 0xbd, 0x5a, 0x77, 0x66, 0x91, 0x34,
    0xac, 0xaf, 0x57, 0xae, 0xc6, 0x52, 0xdf, 0xad, 0xa3, 0x0c, 0x88, 0x29, 0x32, 0x17, 0xc0, 0x3a,
    0x2a, 0x37, 0x96, 0x30, 0x2d, 0xb8, 0x90, 0x0e, 0xdb, 0xe9, 0x49, 0x11, 0x34, 0x45, 0x88, 0xab,
    0xe7, 0x81, 0xab, 0x0f, 0x85, 0xa7, 0xd8, 0x18, 0xd5, 0x26, 0xb0, 0x36, 0x5b, 0xfc, 0x7d, 0x77,
    0x97, 0xf0, 0xb7, 0x17, 0xdd, 0xee, 0x24, 0x27, 0xcb, 0xa3, 0xb5, 0xea, 0x5d, 0x5e, 0x9f, 0x9b,
    0xed, 0x5a, 0x5e, 0xdf, 0xe8, 0xb3, 0xc9, 0x5c, 0x8c, 0xa3, 0x85, 0x31, 0x13, 0xc5, 0xe7, 0xf1,
    0xd7, 0xc5, 0x2e, 0xc5, 0x5a, 0xb1, 0x4d, 0xc0, 0x96, 0x95, 0x12, 0x37, 0x25, 0x55, 0x94, 0x70,
    0xa4, 0x13, 0x23, 0xb0, 0x39, 0xe8, 0x65, 0xf5, 0xf0, 0x9d, 0x53, 0xf9, 0xbb, 0x3a, 0x2e, 0xe6,
    0x30, 0x67, 0x1c, 0x10, 0x41, 0xde, 0xf9, 0x02, 0x8f, 0x87, 0xf4, 0xac
};
#endif

PyTypeObject *init_PasswordManager(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX].type;

    Shiboken::AutoDecRef Sbk_PasswordManager_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_PasswordManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PasswordManager",
        "PasswordManager*",
        &Sbk_PasswordManager_spec,
        &Shiboken::callCppDestructor< PasswordManager >,
        Sbk_PasswordManager_Type_bases.object(),
        0);
    auto *pyType = _Sbk_PasswordManager_Type; // references _Sbk_PasswordManager_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, PasswordManager_SignatureStrings);
#else
    InitSignatureBytes(pyType, PasswordManager_SignatureBytes, PasswordManager_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_PasswordManager_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_PasswordManager_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        PasswordManager_PythonToCpp_PasswordManager_PTR,
        is_PasswordManager_PythonToCpp_PasswordManager_PTR_Convertible,
        PasswordManager_PTR_CppToPython_PasswordManager);

    Shiboken::Conversions::registerConverterName(converter, "PasswordManager");
    Shiboken::Conversions::registerConverterName(converter, "PasswordManager*");
    Shiboken::Conversions::registerConverterName(converter, "PasswordManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(PasswordManagerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_PasswordManager_TypeF(), &Sbk_PasswordManager_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::PasswordManager::staticMetaObject);
    PasswordManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::PasswordManager::staticMetaObject, sizeof(PasswordManagerWrapper));

    return pyType;
}
