/* Generated by wayland-scanner 1.24.0 */

#ifndef COSMIC_TOPLEVEL_INFO_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define COSMIC_TOPLEVEL_INFO_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_cosmic_toplevel_info_unstable_v1 The cosmic_toplevel_info_unstable_v1 protocol
 * @section page_ifaces_cosmic_toplevel_info_unstable_v1 Interfaces
 * - @subpage page_iface_zcosmic_toplevel_info_v1 - list toplevels and properties thereof
 * - @subpage page_iface_zcosmic_toplevel_handle_v1 - an open toplevel
 * @section page_copyright_cosmic_toplevel_info_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 Ilia Bozhinov
 * Copyright © 2020 Isaac Freund
 * Copyright © 2024 Victoria Brekenfeld
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct ext_foreign_toplevel_handle_v1;
struct ext_workspace_handle_v1;
struct wl_output;
struct zcosmic_toplevel_handle_v1;
struct zcosmic_toplevel_info_v1;
struct zcosmic_workspace_handle_v1;

#ifndef ZCOSMIC_TOPLEVEL_INFO_V1_INTERFACE
#define ZCOSMIC_TOPLEVEL_INFO_V1_INTERFACE
/**
 * @page page_iface_zcosmic_toplevel_info_v1 zcosmic_toplevel_info_v1
 * @section page_iface_zcosmic_toplevel_info_v1_desc Description
 *
 * The purpose of this protocol is to enable clients such as taskbars
 * or docks to access a list of opened applications and basic properties
 * thereof.
 *
 * It thus extends ext_foreign_toplevel_v1 to provide more information
 * and actions on foreign toplevels.
 * @section page_iface_zcosmic_toplevel_info_v1_api API
 * See @ref iface_zcosmic_toplevel_info_v1.
 */
/**
 * @defgroup iface_zcosmic_toplevel_info_v1 The zcosmic_toplevel_info_v1 interface
 *
 * The purpose of this protocol is to enable clients such as taskbars
 * or docks to access a list of opened applications and basic properties
 * thereof.
 *
 * It thus extends ext_foreign_toplevel_v1 to provide more information
 * and actions on foreign toplevels.
 */
extern const struct wl_interface zcosmic_toplevel_info_v1_interface;
#endif
#ifndef ZCOSMIC_TOPLEVEL_HANDLE_V1_INTERFACE
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_INTERFACE
/**
 * @page page_iface_zcosmic_toplevel_handle_v1 zcosmic_toplevel_handle_v1
 * @section page_iface_zcosmic_toplevel_handle_v1_desc Description
 *
 * A zcosmic_toplevel_handle_v1 object represents an open toplevel
 * window. A single app may have multiple open toplevels.
 *
 * Each toplevel has a list of outputs it is visible on, exposed to the
 * client via the output_enter and output_leave events.
 * @section page_iface_zcosmic_toplevel_handle_v1_api API
 * See @ref iface_zcosmic_toplevel_handle_v1.
 */
/**
 * @defgroup iface_zcosmic_toplevel_handle_v1 The zcosmic_toplevel_handle_v1 interface
 *
 * A zcosmic_toplevel_handle_v1 object represents an open toplevel
 * window. A single app may have multiple open toplevels.
 *
 * Each toplevel has a list of outputs it is visible on, exposed to the
 * client via the output_enter and output_leave events.
 */
extern const struct wl_interface zcosmic_toplevel_handle_v1_interface;
#endif

/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 * @struct zcosmic_toplevel_info_v1_listener
 */
struct zcosmic_toplevel_info_v1_listener {
	/**
	 * a toplevel has been created
	 *
	 * This event is never emitted for clients binding version 2 of
	 * this protocol, they should use `get_cosmic_toplevel` instead.
	 *
	 * This event is emitted for clients binding version 1 whenever a
	 * new toplevel window is created. It is emitted for all toplevels,
	 * regardless of the app that has created them.
	 *
	 * All initial properties of the toplevel (title, app_id, states,
	 * etc.) will be sent immediately after this event via the
	 * corresponding events in zcosmic_toplevel_handle_v1.
	 * @deprecated Deprecated since version 2
	 */
	void (*toplevel)(void *data,
			 struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1,
			 struct zcosmic_toplevel_handle_v1 *toplevel);
	/**
	 * the compositor has finished with the toplevel manager
	 *
	 * This event indicates that the compositor is done sending
	 * events to the zcosmic_toplevel_info_v1. The server will destroy
	 * the object immediately after sending this request, so it will
	 * become invalid and the client should free any resources
	 * associated with it.
	 *
	 * Note: This event is emitted immediately after calling `stop` for
	 * clients binding version 2 of this protocol for backwards
	 * compatibility.
	 * @deprecated Deprecated since version 2
	 */
	void (*finished)(void *data,
			 struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1);
	/**
	 * all information about active toplevels have been sent
	 *
	 * This event is sent after all changes for currently active
	 * zcosmic_toplevel_handle_v1 have been sent.
	 *
	 * This allows changes to multiple zcosmic_toplevel_handle_v1
	 * handles and their properties to be seen as atomic, even if they
	 * happen via multiple events.
	 * @since 2
	 */
	void (*done)(void *data,
		     struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1);
};

/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 */
static inline int
zcosmic_toplevel_info_v1_add_listener(struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1,
				      const struct zcosmic_toplevel_info_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zcosmic_toplevel_info_v1,
				     (void (**)(void)) listener, data);
}

#define ZCOSMIC_TOPLEVEL_INFO_V1_STOP 0
#define ZCOSMIC_TOPLEVEL_INFO_V1_GET_COSMIC_TOPLEVEL 1

/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 */
#define ZCOSMIC_TOPLEVEL_INFO_V1_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 */
#define ZCOSMIC_TOPLEVEL_INFO_V1_FINISHED_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 */
#define ZCOSMIC_TOPLEVEL_INFO_V1_DONE_SINCE_VERSION 2

/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 */
#define ZCOSMIC_TOPLEVEL_INFO_V1_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 */
#define ZCOSMIC_TOPLEVEL_INFO_V1_GET_COSMIC_TOPLEVEL_SINCE_VERSION 2

/** @ingroup iface_zcosmic_toplevel_info_v1 */
static inline void
zcosmic_toplevel_info_v1_set_user_data(struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcosmic_toplevel_info_v1, user_data);
}

/** @ingroup iface_zcosmic_toplevel_info_v1 */
static inline void *
zcosmic_toplevel_info_v1_get_user_data(struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcosmic_toplevel_info_v1);
}

static inline uint32_t
zcosmic_toplevel_info_v1_get_version(struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_info_v1);
}

/** @ingroup iface_zcosmic_toplevel_info_v1 */
static inline void
zcosmic_toplevel_info_v1_destroy(struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zcosmic_toplevel_info_v1);
}

/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 *
 * This request indicates that the client no longer wishes to receive
 * events for new toplevels.  However, the compositor may emit further
 * toplevel_created events until the finished event is emitted.
 *
 * The client must not send any more requests after this one.
 *
 * Note: This request isn't necessary for clients binding version 2
 * of this protocol and will be ignored.
 */
static inline void
zcosmic_toplevel_info_v1_stop(struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_info_v1,
			 ZCOSMIC_TOPLEVEL_INFO_V1_STOP, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_info_v1), 0);
}

/**
 * @ingroup iface_zcosmic_toplevel_info_v1
 *
 * Request a zcosmic_toplevel_handle_v1 extension object for an existing
 * ext_foreign_toplevel_handle_v1.
 *
 * All initial properties of the toplevel (states, etc.)
 * will be sent immediately after this event via the corresponding
 * events in zcosmic_toplevel_handle_v1.
 */
static inline struct zcosmic_toplevel_handle_v1 *
zcosmic_toplevel_info_v1_get_cosmic_toplevel(struct zcosmic_toplevel_info_v1 *zcosmic_toplevel_info_v1, struct ext_foreign_toplevel_handle_v1 *foreign_toplevel)
{
	struct wl_proxy *cosmic_toplevel;

	cosmic_toplevel = wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_info_v1,
			 ZCOSMIC_TOPLEVEL_INFO_V1_GET_COSMIC_TOPLEVEL, &zcosmic_toplevel_handle_v1_interface, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_info_v1), 0, NULL, foreign_toplevel);

	return (struct zcosmic_toplevel_handle_v1 *) cosmic_toplevel;
}

#ifndef ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_ENUM
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_ENUM
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 * types of states on the toplevel
 *
 * The different states that a toplevel may have. These have the same
 * meaning as the states with the same names defined in xdg-toplevel
 */
enum zcosmic_toplevel_handle_v1_state {
	/**
	 * the toplevel is maximized
	 */
	ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_MAXIMIZED = 0,
	/**
	 * the toplevel is minimized
	 */
	ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_MINIMIZED = 1,
	/**
	 * the toplevel is active
	 */
	ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_ACTIVATED = 2,
	/**
	 * the toplevel is fullscreen
	 */
	ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_FULLSCREEN = 3,
	/**
	 * the toplevel is sticky
	 * @since 2
	 */
	ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_STICKY = 4,
};
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_STICKY_SINCE_VERSION 2
#endif /* ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_ENUM */

/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 * @struct zcosmic_toplevel_handle_v1_listener
 */
struct zcosmic_toplevel_handle_v1_listener {
	/**
	 * the toplevel has been closed
	 *
	 * The server will emit no further events on the
	 * zcosmic_toplevel_handle_v1 after this event. Any requests
	 * received aside from the destroy request will be ignored. Upon
	 * receiving this event, the client should make the destroy request
	 * to allow freeing of resources.
	 *
	 * Note: This event will not be emitted for clients binding version
	 * 2 of this protocol, as `ext_foreign_toplevel_handle_v1.closed`
	 * is equivalent.
	 * @deprecated Deprecated since version 2
	 */
	void (*closed)(void *data,
		       struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1);
	/**
	 * all information about the toplevel has been sent
	 *
	 * This event is sent after all changes in the toplevel state
	 * have been sent.
	 *
	 * This allows changes to the zcosmic_toplevel_handle_v1 properties
	 * to be seen as atomic, even if they happen via multiple events.
	 *
	 * Note: this is is not sent after the closed event.
	 *
	 * Note: This event will not be emitted for clients binding version
	 * 2 of this protocol, as `ext_foreign_toplevel_handle_v1.done` is
	 * equivalent.
	 * @deprecated Deprecated since version 2
	 */
	void (*done)(void *data,
		     struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1);
	/**
	 * title change
	 *
	 * This event is emitted whenever the title of the toplevel
	 * changes.
	 *
	 * Note: This event will not be emitted for clients binding version
	 * 2 of this protocol, as `ext_foreign_toplevel_handle_v1.title` is
	 * equivalent.
	 * @deprecated Deprecated since version 2
	 */
	void (*title)(void *data,
		      struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
		      const char *title);
	/**
	 * app_id change
	 *
	 * This event is emitted whenever the app_id of the toplevel
	 * changes.
	 *
	 * Note: This event will not be emitted for clients binding version
	 * 2 of this protocol, as `ext_foreign_toplevel_handle_v1.app_id`
	 * is equivalent.
	 * @deprecated Deprecated since version 2
	 */
	void (*app_id)(void *data,
		       struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
		       const char *app_id);
	/**
	 * toplevel entered an output
	 *
	 * This event is emitted whenever the toplevel becomes visible on
	 * the given output. A toplevel may be visible on multiple outputs.
	 */
	void (*output_enter)(void *data,
			     struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
			     struct wl_output *output);
	/**
	 * toplevel left an output
	 *
	 * This event is emitted whenever the toplevel is no longer
	 * visible on a given output. It is guaranteed that an output_enter
	 * event with the same output has been emitted before this event.
	 */
	void (*output_leave)(void *data,
			     struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
			     struct wl_output *output);
	/**
	 * toplevel entered an workspace
	 *
	 * This event is emitted whenever the toplevel becomes visible on
	 * the given workspace. A toplevel may be visible on multiple
	 * workspaces.
	 * @deprecated Deprecated since version 3
	 */
	void (*workspace_enter)(void *data,
				struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
				struct zcosmic_workspace_handle_v1 *workspace);
	/**
	 * toplevel left an workspace
	 *
	 * This event is emitted whenever the toplevel is no longer
	 * visible on a given workspace. It is guaranteed that an
	 * workspace_enter event with the same workspace has been emitted
	 * before this event.
	 * @deprecated Deprecated since version 3
	 */
	void (*workspace_leave)(void *data,
				struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
				struct zcosmic_workspace_handle_v1 *workspace);
	/**
	 * the toplevel state changed
	 *
	 * This event is emitted once on creation of the
	 * zcosmic_toplevel_handle_v1 and again whenever the state of the
	 * toplevel changes.
	 */
	void (*state)(void *data,
		      struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
		      struct wl_array *state);
	/**
	 * the toplevel's position and/or size has changed
	 *
	 * Emitted when the geometry of a toplevel (it's position and/or
	 * size) relative to the provided output has changed.
	 *
	 * This event is emitted once on creation of the
	 * zcosmic_toplevel_handle_v1 for every entered output and again
	 * whenever the geometry of the toplevel changes relative to any
	 * output.
	 * @param x x coordinate of the upper-left corner
	 * @param y y coordinate of the upper-left corner
	 * @param width width of the toplevel
	 * @param height height of the toplevel
	 * @since 2
	 */
	void (*geometry)(void *data,
			 struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
			 struct wl_output *output,
			 int32_t x,
			 int32_t y,
			 int32_t width,
			 int32_t height);
	/**
	 * toplevel entered an workspace
	 *
	 * This event is emitted whenever the toplevel becomes visible on
	 * the given workspace. A toplevel may be visible on multiple
	 * workspaces.
	 * @since 3
	 */
	void (*ext_workspace_enter)(void *data,
				    struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
				    struct ext_workspace_handle_v1 *workspace);
	/**
	 * toplevel left an workspace
	 *
	 * This event is emitted whenever the toplevel is no longer
	 * visible on a given workspace. It is guaranteed that an
	 * workspace_enter event with the same workspace has been emitted
	 * before this event.
	 * @since 3
	 */
	void (*ext_workspace_leave)(void *data,
				    struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
				    struct ext_workspace_handle_v1 *workspace);
};

/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
static inline int
zcosmic_toplevel_handle_v1_add_listener(struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1,
					const struct zcosmic_toplevel_handle_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zcosmic_toplevel_handle_v1,
				     (void (**)(void)) listener, data);
}

#define ZCOSMIC_TOPLEVEL_HANDLE_V1_DESTROY 0

/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_CLOSED_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_WORKSPACE_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_WORKSPACE_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_GEOMETRY_SINCE_VERSION 2
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_EXT_WORKSPACE_ENTER_SINCE_VERSION 3
/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_EXT_WORKSPACE_LEAVE_SINCE_VERSION 3

/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 */
#define ZCOSMIC_TOPLEVEL_HANDLE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zcosmic_toplevel_handle_v1 */
static inline void
zcosmic_toplevel_handle_v1_set_user_data(struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcosmic_toplevel_handle_v1, user_data);
}

/** @ingroup iface_zcosmic_toplevel_handle_v1 */
static inline void *
zcosmic_toplevel_handle_v1_get_user_data(struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcosmic_toplevel_handle_v1);
}

static inline uint32_t
zcosmic_toplevel_handle_v1_get_version(struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_handle_v1);
}

/**
 * @ingroup iface_zcosmic_toplevel_handle_v1
 *
 * This request should be called either when the client will no longer
 * use the zcosmic_toplevel_handle_v1.
 */
static inline void
zcosmic_toplevel_handle_v1_destroy(struct zcosmic_toplevel_handle_v1 *zcosmic_toplevel_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_handle_v1,
			 ZCOSMIC_TOPLEVEL_HANDLE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_handle_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
