#ifndef __AFLLLVMCOMMON_H
#define __AFLLLVMCOMMON_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <list>
#include <string>
#include <fstream>

#ifdef __has_include
  #if __has_include(<optional>)
    #include <optional>
  #endif
#endif

#include <sys/time.h>

#include "llvm/Config/llvm-config.h"

#include "llvm/IR/IRBuilder.h"
#include "llvm/IR/LegacyPassManager.h"
#include "llvm/IR/BasicBlock.h"
#include "llvm/IR/Module.h"
#include "llvm/IR/Instruction.h"
#include "llvm/IR/Value.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/MathExtras.h"
#if LLVM_VERSION_MAJOR < 17
  #include "llvm/Transforms/IPO/PassManagerBuilder.h"
#endif

#include "llvm/IR/DebugInfo.h"
#include "llvm/IR/CFG.h"

#define MNAME M.getSourceFileName()
#define FMNAME F.getParent()->getSourceFileName()
#if LLVM_VERSION_MAJOR >= 16
// None becomes deprecated
// the standard std::nullopt_t is recommended instead
// from C++17 and onwards.
constexpr std::nullopt_t None = std::nullopt;
#endif

char *getBBName(const llvm::BasicBlock *BB);
bool  isIgnoreFunction(const llvm::Function *F);
void  initInstrumentList();
bool  isInInstrumentList(llvm::Function *F, std::string Filename);
unsigned long long int calculateCollisions(uint32_t edges);
void                   scanForDangerousFunctions(llvm::Module *M);
unsigned int           calcCyclomaticComplexity(llvm::Function *F);
bool                   isAflCovInterestingInstruction(llvm::Instruction &I);
bool                   isDecisionUse(const llvm::Value *Cond);
std::pair<bool, bool>  detectIJONUsage(llvm::Module &M);
void createIJONEnabledGlobal(llvm::Module &M, llvm::Type *Int32Ty);
llvm::GlobalVariable *createIJONStateGlobal(llvm::Module &M,
                                            llvm::Type   *Int32Ty,
                                            bool          uses_ijon_state);

#ifndef IS_EXTERN
  #define IS_EXTERN
#endif

IS_EXTERN int debug;
IS_EXTERN int be_quiet;

#undef IS_EXTERN

#endif

