/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.opensearch.rule.attribute_extractor.AttributeExtractor;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.Rule;
import org.opensearch.rule.labelresolver.FeatureValueResolver;
import org.opensearch.rule.storage.AttributeValueStore;
import org.opensearch.rule.storage.AttributeValueStoreFactory;

public class InMemoryRuleProcessingService {
    public static final String WILDCARD = "*";
    private final AttributeValueStoreFactory attributeValueStoreFactory;
    private final Map<Attribute, Integer> prioritizedAttributes;

    public InMemoryRuleProcessingService(AttributeValueStoreFactory attributeValueStoreFactory, Map<Attribute, Integer> prioritizedAttributes) {
        this.attributeValueStoreFactory = attributeValueStoreFactory;
        this.prioritizedAttributes = prioritizedAttributes;
    }

    public void add(Rule rule) {
        this.perform(rule, this::addOperation);
    }

    public void remove(Rule rule) {
        this.perform(rule, this::removeOperation);
    }

    private void perform(Rule rule, BiConsumer<Map.Entry<Attribute, Set<String>>, Rule> ruleOperation) {
        for (Attribute attribute : rule.getFeatureType().getAllowedAttributesRegistry().values()) {
            Set attributeValues = rule.getAttributeMap().containsKey(attribute) ? (Set)rule.getAttributeMap().get(attribute) : Set.of("");
            ruleOperation.accept(Map.entry(attribute, attributeValues), rule);
        }
    }

    private void removeOperation(Map.Entry<Attribute, Set<String>> attributeEntry, Rule rule) {
        AttributeValueStore valueStore = this.attributeValueStoreFactory.getAttributeValueStore(attributeEntry.getKey());
        for (String value : attributeEntry.getValue()) {
            valueStore.remove((Object)value.replace(WILDCARD, ""), (Object)rule.getFeatureValue());
        }
    }

    private void addOperation(Map.Entry<Attribute, Set<String>> attributeEntry, Rule rule) {
        AttributeValueStore valueStore = this.attributeValueStoreFactory.getAttributeValueStore(attributeEntry.getKey());
        for (String value : attributeEntry.getValue()) {
            valueStore.put((Object)value.replace(WILDCARD, ""), (Object)rule.getFeatureValue());
        }
    }

    public Optional<String> evaluateLabel(List<AttributeExtractor<String>> attributeExtractors) {
        attributeExtractors.sort(Comparator.comparingInt(extractor -> this.prioritizedAttributes.getOrDefault(extractor.getAttribute(), Integer.MAX_VALUE)));
        FeatureValueResolver featureValueResolver = new FeatureValueResolver(this.attributeValueStoreFactory, attributeExtractors);
        return featureValueResolver.resolve();
    }
}

