#include "qemu/osdep.h"
#include "qemu/log.h"
#include "cpu.h"
#include "internal.h"
#include "tcg/tcg.h"
#include "tcg/tcg-op.h"
#include "exec/helper-gen.h"
#include "insn.h"
#include "opcodes.h"
#include "translate.h"
#define QEMU_GENERATE
#include "genptr.h"
#include "macros.h"
#include "target/hexagon/idef-generated-emitter.h.inc"
void emit_J4_hintjumpr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV)
/* {fHINTJR(RsV);} */
{
}

void emit_J2_loop0r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 0); } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
gen_log_reg_write(ctx, 33, RsV);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_1);
}

void emit_J2_loop1r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA1 = fREAD_PC()+riV; (LC1 = RsV); } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 34, tmp_0);
gen_log_reg_write(ctx, 35, RsV);
}

void emit_J2_loop0i(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 0); } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (UiV));
gen_log_reg_write(ctx, 33, tmp_1);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_2);
}

void emit_J2_loop1i(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA1 = fREAD_PC()+riV; (LC1 = UiV); } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 34, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (UiV));
gen_log_reg_write(ctx, 35, tmp_1);
}

void emit_J2_ploop1sr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 1); P3 = 0;; } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
gen_log_reg_write(ctx, 33, RsV);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (((int32_t) 0x1)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_1);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, 0xff);
gen_log_pred_write(ctx, 3, tmp_3);
}

void emit_J2_ploop1si(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 1); P3 = 0;; } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (UiV));
gen_log_reg_write(ctx, 33, tmp_1);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0x1)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_2);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_4, tmp_3, 0xff);
gen_log_pred_write(ctx, 3, tmp_4);
}

void emit_J2_ploop2sr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 2); P3 = 0;; } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
gen_log_reg_write(ctx, 33, RsV);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (((int32_t) 0x2)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_1);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, 0xff);
gen_log_pred_write(ctx, 3, tmp_3);
}

void emit_J2_ploop2si(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 2); P3 = 0;; } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (UiV));
gen_log_reg_write(ctx, 33, tmp_1);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0x2)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_2);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_4, tmp_3, 0xff);
gen_log_pred_write(ctx, 3, tmp_4);
}

void emit_J2_ploop3sr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 3); P3 = 0;; } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
gen_log_reg_write(ctx, 33, RsV);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (((int32_t) 0x3)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_1);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, 0xff);
gen_log_pred_write(ctx, 3, tmp_3);
}

void emit_J2_ploop3si(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 3); P3 = 0;; } */
{
int32_t qemu_tmp_0 = ~(((int32_t) 0x3));
int32_t qemu_tmp_1 = riV & qemu_tmp_0;
riV = qemu_tmp_1;
int32_t qemu_tmp_2 = ctx->base.pc_next + riV;
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (qemu_tmp_2));
gen_log_reg_write(ctx, 32, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (UiV));
gen_log_reg_write(ctx, 33, tmp_1);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0x3)));
gen_set_usr_field(ctx, USR_LPCFG, tmp_2);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_4, tmp_3, 0xff);
gen_log_pred_write(ctx, 3, tmp_4);
}

void emit_L2_loadrub_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,1,u,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L4_loadrub_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,1,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L4_loadrub_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,1,u,EA,RdV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadrub_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,1,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L2_loadrub_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,1,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L2_loadrub_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L2_loadrub_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,1,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L2_loadrub_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fLOAD(1,1,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x0));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L2_loadrb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,1,s,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L4_loadrb_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,1,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L4_loadrb_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,1,s,EA,RdV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadrb_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,1,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L2_loadrb_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,1,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L2_loadrb_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L2_loadrb_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,1,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L2_loadrb_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fLOAD(1,1,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x0));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L2_loadruh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,2,u,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L4_loadruh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,2,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L4_loadruh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,2,u,EA,RdV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadruh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,2,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L2_loadruh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,2,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L2_loadruh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L2_loadruh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,2,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L2_loadruh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fLOAD(1,2,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L2_loadrh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,2,s,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L4_loadrh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,2,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L4_loadrh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,2,s,EA,RdV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadrh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,2,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L2_loadrh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,2,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L2_loadrh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L2_loadrh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,2,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L2_loadrh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fLOAD(1,2,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L2_loadri_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,4,u,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L4_loadri_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,4,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L4_loadri_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,4,u,EA,RdV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadri_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,4,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L2_loadri_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,4,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L2_loadri_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L2_loadri_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,4,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L2_loadri_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fLOAD(1,4,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x2));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L2_loadrd_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,8,u,EA,RddV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L4_loadrd_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,8,u,EA,RddV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L4_loadrd_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,8,u,EA,RddV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadrd_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,8,u,EA,RddV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L2_loadrd_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,8,u,EA,RddV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L2_loadrd_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L2_loadrd_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,8,u,EA,RddV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L2_loadrd_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<3,MuV); fLOAD(1,8,u,EA,RddV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x3));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L2_loadbzw2_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } }; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L4_loadbzw2_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_2, i * 16, 16);
}
}

void emit_L4_loadbzw2_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } }; ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_0, i * 16, 16);
}
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadbzw2_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbzw2_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbzw2_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbzw2_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbzw2_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbzw4_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } }; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L4_loadbzw4_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmpV, i * 8, 8);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
tcg_gen_deposit_i64(RddV, RddV, tmp_3, i * 16, 16);
}
}

void emit_L4_loadbzw4_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } }; ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, tmpV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_1, tmp_0);
tcg_gen_deposit_i64(RddV, RddV, tmp_1, i * 16, 16);
}
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadbzw4_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbzw4_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmpV, i * 8, 8);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
tcg_gen_deposit_i64(RddV, RddV, tmp_3, i * 16, 16);
}
}

void emit_L2_loadbzw4_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbzw4_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbzw4_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x2));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbsw2_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } }; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L4_loadbsw2_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_2, i * 16, 16);
}
}

void emit_L4_loadbsw2_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } }; ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_0, i * 16, 16);
}
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadbsw2_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbsw2_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbsw2_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbsw2_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbsw2_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x2); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
tcg_gen_deposit_i32(RdV, RdV, tmp_1, i * 16, 16);
}
}

void emit_L2_loadbsw4_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } }; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L4_loadbsw4_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, tmpV, i * 8, 8);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
tcg_gen_deposit_i64(RddV, RddV, tmp_3, i * 16, 16);
}
}

void emit_L4_loadbsw4_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } }; ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, tmpV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, tmp_0);
tcg_gen_deposit_i64(RddV, RddV, tmp_1, i * 16, 16);
}
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadbsw4_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbsw4_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, tmpV, i * 8, 8);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
tcg_gen_deposit_i64(RddV, RddV, tmp_3, i * 16, 16);
}
}

void emit_L2_loadbsw4_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbsw4_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadbsw4_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmpV = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x2));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmpV, EA, ctx->mem_idx, MO_32 | MO_LE);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, tmpV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, i * 16, 16);
}
}

void emit_L2_loadalignh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); }; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L4_loadalignh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shri_i64(tmp_2, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_4, tmp_2, tmp_3);
tcg_gen_mov_i64(RyyV, tmp_4);
}

void emit_L4_loadalignh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); }; ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_0, 0);
} else {
tcg_gen_shri_i64(tmp_0, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shli_i64(tmp_1, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_2, tmp_0, tmp_1);
tcg_gen_mov_i64(RyyV, tmp_2);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadalignh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L2_loadalignh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shri_i64(tmp_2, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_4, tmp_2, tmp_3);
tcg_gen_mov_i64(RyyV, tmp_4);
}

void emit_L2_loadalignh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L2_loadalignh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L2_loadalignh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_16 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x30);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L2_loadalignb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); }; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L4_loadalignb_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shri_i64(tmp_2, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_4, tmp_2, tmp_3);
tcg_gen_mov_i64(RyyV, tmp_4);
}

void emit_L4_loadalignb_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); }; ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_movi_i32(EA, UiV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_0, 0);
} else {
tcg_gen_shri_i64(tmp_0, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shli_i64(tmp_1, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_2, tmp_0, tmp_1);
tcg_gen_mov_i64(RyyV, tmp_2);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_L2_loadalignb_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L2_loadalignb_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shri_i64(tmp_2, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_4, tmp_2, tmp_3);
tcg_gen_mov_i64(RyyV, tmp_4);
}

void emit_L2_loadalignb_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L2_loadalignb_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_L2_loadalignb_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmpV = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x0));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmpV, EA, ctx->mem_idx, MO_8 | MO_LE);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_1, 0);
} else {
tcg_gen_shri_i64(tmp_1, RyyV, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x38);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmpV, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_3, tmp_1, tmp_2);
tcg_gen_mov_i64(RyyV, tmp_3);
}

void emit_S2_storerb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerb_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerb_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_0, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storerb_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerb_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerb_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerb_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerb_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x0));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,2,EA,fGETHALF(0,RtV)); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_0, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storerh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerf_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,2,EA,fGETHALF(1,RtV)); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_0, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storerf_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerf_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerf_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerf_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerf_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storeri_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,4,EA,RtV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S2_storeri_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,4,EA,RtV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S4_storeri_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,4,EA,RtV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
gen_store4(tcg_env, EA, RtV, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storeri_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,4,EA,RtV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S4_storeri_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,4,EA,RtV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S2_storeri_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,4,EA,RtV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S2_storeri_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,4,EA,RtV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S2_storeri_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fSTORE(1,4,EA,RtV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x2));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S2_storerd_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,8,EA,RttV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_storerd_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,8,EA,RttV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S4_storerd_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i64 RttV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,8,EA,RttV); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
gen_store8(tcg_env, EA, RttV, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storerd_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,8,EA,RttV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S4_storerd_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i64 RttV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,8,EA,RttV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_storerd_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,8,EA,RttV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_storerd_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,8,EA,RttV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_storerd_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<3,MuV); fSTORE(1,8,EA,RttV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x3));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_storerinew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv NtN, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S2_storerinew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S4_storerinew_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv NtN, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
gen_store4(tcg_env, EA, NtN, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storerinew_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S4_storerinew_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv NtN, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S2_storerinew_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S2_storerinew_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S2_storerinew_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x2));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S2_storerbnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv NtN, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerbnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerbnew_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv NtN, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_0, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storerbnew_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerbnew_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv NtN, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerbnew_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerbnew_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerbnew_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x0));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerhnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv NtN, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerhnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerhnew_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv NtN, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); ReV=UiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, UiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_0, insn->slot);
tcg_gen_movi_i32(ReV, UiV);
}

void emit_S2_storerhnew_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storerhnew_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv NtN, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, UiV);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerhnew_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_helper_fbrev(tmp_0, RxV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, MuV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_storerhnew_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (siV));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_storerhnew_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
gen_read_ireg(tmp_0, MuV, ((int32_t) 0x1));
gen_helper_fcircadd(RxV, RxV, tmp_0, MuV, CS);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S2_allocframe(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV)
/* size4u_t EA; { (EA = RxV + -8); fSTORE(1,8,EA,fFRAME_SCRAMBLE((fCAST8_8u(fREAD_LR()) << 32) | fCAST4_4u(fREAD_FP()))); (FP = EA); fFRAMECHECK(EA-uiV,EA); RxV = EA-uiV; } */
{
TCGv_i32 EA = tcg_temp_new_i32();
int32_t qemu_tmp_0 = -(((int32_t) 0x8));
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RxV, qemu_tmp_0);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_1, hex_gpr[31]);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x20);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_2, 0);
} else {
tcg_gen_shli_i64(tmp_2, tmp_1, qemu_tmp_1);
}
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, hex_gpr[30]);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_or_i64(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_read_reg(tmp_7, HEX_REG_FRAMEKEY);
tcg_gen_concat_i32_i64(tmp_5, tmp_7, tmp_7);
tcg_gen_xor_i64(tmp_6, tmp_4, tmp_5);
gen_store8(tcg_env, EA, tmp_6, insn->slot);
gen_log_reg_write(ctx, 30, EA);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_subi_i32(tmp_8, EA, uiV);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_subi_i32(tmp_9, EA, uiV);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_L2_loadw_aq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* size4u_t EA; { (EA = RsV); fLOAD(1,4,u,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RsV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L4_loadd_aq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* size4u_t EA; { (EA = RsV); fLOAD(1,8,u,EA,RddV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RsV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_S2_storew_rl_at_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,4,EA,RtV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RsV);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S4_stored_rl_at_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i64 RttV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,8,EA,RttV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RsV);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_storew_rl_st_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,4,EA,RtV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RsV);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S4_stored_rl_st_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i64 RttV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,8,EA,RttV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RsV);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_L2_deallocframe(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* size4u_t EA; { size8u_t tmp; (EA = RsV); fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); (SP = EA+8); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i64 tmp = tcg_temp_new_i64();
tcg_gen_mov_i32(EA, RsV);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(tmp, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
TCGv_i64 tmp_1 = tcg_temp_new_i64();
TCGv_i32 tmp_2 = tcg_temp_new_i32();
gen_read_reg(tmp_2, HEX_REG_FRAMEKEY);
tcg_gen_concat_i32_i64(tmp_0, tmp_2, tmp_2);
tcg_gen_xor_i64(tmp_1, tmp, tmp_0);
tcg_gen_mov_i64(RddV, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_3, EA, ((int32_t) 0x8));
gen_log_reg_write(ctx, 29, tmp_3);
}

void emit_L4_loadrub_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,1,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L2_ploadrubt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrubt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrubf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrubf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrubtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrubfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrubtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrubfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrubfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_loadrb_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,1,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L2_ploadrbt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrbt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrbf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrbf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrbtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrbfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrbtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrbfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrbfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_loadruh_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,2,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L2_ploadruht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadruht_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadruhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadruhf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadruhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadruhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruht_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruhf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruhtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruhfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadruhtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadruhfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruht_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruhf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruhtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadruhfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_loadrh_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,2,s,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L2_ploadrht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrht_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrhf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrht_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrhf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrhtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrhfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrhtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrhfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrht_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrhf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrhtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrhfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_loadri_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,4,u,EA,RdV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L2_ploadrit_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrit_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrif_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrif_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadritnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrifnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrit_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrif_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadritnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrifnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadritnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrifnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrit_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrif_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadritnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrifnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_loadrd_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,8,u,EA,RddV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_L2_ploadrdt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrdt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrdf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrdf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrdtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrdfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PtN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RtV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrdtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L2_ploadrdfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PtN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_L4_ploadrdfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PtN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
ctx->s1_store_processed = false;
process_store(ctx, 1);
}
gen_set_label(if_label_1);
}

void emit_S4_storerb_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_pstorerbt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storerh_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_pstorerht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerht_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerht_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerht_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storerf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_pstorerft_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerft_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerff_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerff_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerft_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerff_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerftnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerffnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerftnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerffnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerftnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerffnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerft_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerff_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerftnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerffnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeri_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,4,EA,RtV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S2_pstorerit_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerit_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerif_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerif_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerit_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerif_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstoreritnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerifnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstoreritnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerifnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstoreritnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerifnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerit_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerif_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstoreritnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerifnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, RtV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storerd_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,8,EA,RttV);} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_pstorerdt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerdt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerdf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerdf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerdtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerdfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerdfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store8(tcg_env, EA, RttV, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storerinew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S2_pstorerinewt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerinewt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerinewf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerinewf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerinewtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerinewfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerinewfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
gen_store4(tcg_env, EA, NtN, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storerbnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_pstorerbnewt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbnewt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbnewf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbnewf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbnewtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerbnewfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerbnewfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storerhnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
}

void emit_S2_pstorerhnewt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhnewt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhnewf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhnewf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvV);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_3, tmp_2, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (uiV >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, RuV, uiV);
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RsV, tmp_0);
tcg_gen_mov_i32(EA, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_2, PvN);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_4, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_4, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhnewtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S2_pstorerhnewfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_mov_i32(EA, RxV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_2, RxV, siV);
tcg_gen_mov_i32(RxV, tmp_2);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_3, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_1, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_pstorerhnewfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
tcg_gen_movi_i32(EA, uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PvN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_L4_add_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp += RtV; fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_add_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp += RtV; fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_add_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp += RtV; fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_sub_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp -= RtV; fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_sub_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp -= RtV; fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_sub_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp -= RtV; fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_and_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp &= RtV; fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_and_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp &= RtV; fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_and_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp &= RtV; fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_or_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp |= RtV; fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_or_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp |= RtV; fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_or_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp |= RtV; fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, tmp, RtV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_iadd_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp += UiV; fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp, UiV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_iadd_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp += UiV; fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp, UiV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_iadd_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp += UiV; fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp, UiV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_isub_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp -= UiV; fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_subi_i32(tmp_1, tmp, UiV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_isub_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp -= UiV; fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_subi_i32(tmp_1, tmp, UiV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_isub_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp -= UiV; fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_subi_i32(tmp_1, tmp, UiV);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_iand_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp &= (~(1<<UiV)); fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
int32_t qemu_tmp_0 = ((int32_t) 0x1) << UiV;
int32_t qemu_tmp_1 = ~(qemu_tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp, qemu_tmp_1);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_iand_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp &= (~(1<<UiV)); fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
int32_t qemu_tmp_0 = ((int32_t) 0x1) << UiV;
int32_t qemu_tmp_1 = ~(qemu_tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp, qemu_tmp_1);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_iand_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp &= (~(1<<UiV)); fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
int32_t qemu_tmp_0 = ((int32_t) 0x1) << UiV;
int32_t qemu_tmp_1 = ~(qemu_tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp, qemu_tmp_1);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_ior_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp |= (1<<UiV); fSTORE(1,4,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_32 | MO_SIGN | MO_LE);
int32_t qemu_tmp_0 = ((int32_t) 0x1) << UiV;
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_ori_i32(tmp_1, tmp, qemu_tmp_0);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store4(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_ior_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp |= (1<<UiV); fSTORE(1,1,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
int32_t qemu_tmp_0 = ((int32_t) 0x1) << UiV;
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_ori_i32(tmp_1, tmp, qemu_tmp_0);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store1(tcg_env, EA, tmp, insn->slot);
}

void emit_L4_ior_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp |= (1<<UiV); fSTORE(1,2,EA,tmp); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(tmp, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
int32_t qemu_tmp_0 = ((int32_t) 0x1) << UiV;
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_ori_i32(tmp_1, tmp, qemu_tmp_0);
tcg_gen_mov_i32(tmp, tmp_1);
gen_store2(tcg_env, EA, tmp, insn->slot);
}

void emit_S4_storeirbt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (SiV));
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirbf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (SiV));
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirbtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fLSBNEW(PvN)){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (SiV));
gen_store1(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirbfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fLSBNEW(~PvN))){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (SiV));
gen_store1(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (SiV));
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (SiV));
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fLSBNEW(PvN)){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (SiV));
gen_store2(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fLSBNEW(~PvN))){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (SiV));
gen_store2(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirit_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, PvV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (SiV));
gen_store4(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirif_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, tmp_1, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (SiV));
gen_store4(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeiritnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fLSBNEW(PvN)){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PvN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (SiV));
gen_store4(tcg_env, EA, tmp_2, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirifnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fLSBNEW(~PvN))){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PvN);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_2, tmp_1, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_2, 0, if_label_0);
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (SiV));
gen_store4(tcg_env, EA, tmp_3, insn->slot);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_cancel(insn->slot);
gen_set_label(if_label_1);
}

void emit_S4_storeirb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (SiV));
gen_store1(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storeirh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (SiV));
gen_store2(tcg_env, EA, tmp_1, insn->slot);
}

void emit_S4_storeiri_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(EA, tmp_0);
TCGv_i32 tmp_1 = tcg_constant_i32((int32_t) (SiV));
gen_store4(tcg_env, EA, tmp_1, insn->slot);
}

void emit_L2_loadrubgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,1,u,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_LE);
}

void emit_L2_loadrbgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,1,s,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x1), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_8 | MO_SIGN | MO_LE);
}

void emit_L2_loadruhgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,2,u,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_LE);
}

void emit_L2_loadrhgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,2,s,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x2), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_16 | MO_SIGN | MO_LE);
}

void emit_L2_loadrigp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,4,u,EA,RdV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x4), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i32(RdV, EA, ctx->mem_idx, MO_32 | MO_LE);
}

void emit_L2_loadrdgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,8,u,EA,RddV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
if (insn->slot == 0 && pkt->pkt_has_scalar_store_s1) {
probe_noshuf_load(EA, ((int32_t) 0x8), ctx->mem_idx);
process_store(ctx, 1);
}
tcg_gen_qemu_ld_i64(RddV, EA, ctx->mem_idx, MO_64 | MO_LE);
}

void emit_S2_storerbgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RtV, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_5, insn->slot);
}

void emit_S2_storerhgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RtV, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_5, insn->slot);
}

void emit_S2_storerfgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RtV, ((int32_t) 0x1) * 16, 16);
gen_store2(tcg_env, EA, tmp_5, insn->slot);
}

void emit_S2_storerigp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,4,EA,RtV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
gen_store4(tcg_env, EA, RtV, insn->slot);
}

void emit_S2_storerdgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,8,EA,RttV); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
gen_store8(tcg_env, EA, RttV, insn->slot);
}

void emit_S2_storerinewgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
gen_store4(tcg_env, EA, NtN, insn->slot);
}

void emit_S2_storerbnewgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, NtN, ((int32_t) 0x0) * 8, 8);
gen_store1(tcg_env, EA, tmp_5, insn->slot);
}

void emit_S2_storerhnewgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
{
TCGv_i32 EA = tcg_temp_new_i32();
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (insn->extension_valid));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, tmp_2, tmp_0, tmp_3, hex_gpr[43]);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_4, tmp_1, uiV);
tcg_gen_mov_i32(EA, tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, NtN, ((int32_t) 0x0) * 16, 16);
gen_store2(tcg_env, EA, tmp_5, insn->slot);
}

void emit_C2_cmpeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV==RtV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_EQ, tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_cmpgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV>RtV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_GT, tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_cmpgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((fCAST4u(RsV)>fCAST4u(RtV)) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_GTU, tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_cmpeqp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* {PdV=((RssV==RttV) ? 0xff : 0x00);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_0, RssV, RttV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_0);
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_3, tmp_1, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_cmpgtp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* {PdV=((RssV>RttV) ? 0xff : 0x00);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GT, tmp_0, RssV, RttV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_0);
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_3, tmp_1, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_cmpgtup(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* {PdV=((fCAST8u(RssV)>fCAST8u(RttV)) ? 0xff : 0x00);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GTU, tmp_0, RssV, RttV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_0);
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_3, tmp_1, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_A4_rcmpeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); RdV=(RsV==siV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_0, RsV, siV);
tcg_gen_mov_i32(RdV, tmp_0);
}

void emit_A4_rcmpneqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); RdV=(RsV!=siV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_NE, tmp_0, RsV, siV);
tcg_gen_mov_i32(RdV, tmp_0);
}

void emit_A4_rcmpeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=(RsV==RtV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_EQ, tmp_0, RsV, RtV);
tcg_gen_mov_i32(RdV, tmp_0);
}

void emit_A4_rcmpneq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=(RsV!=RtV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_NE, tmp_0, RsV, RtV);
tcg_gen_mov_i32(RdV, tmp_0);
}

void emit_C2_bitsset(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)==RtV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_EQ, tmp_1, tmp_0, RtV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_C2_bitsclr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)==0) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_1, tmp_0, ((int32_t) 0x0));
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_C4_nbitsset(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)!=RtV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_NE, tmp_1, tmp_0, RtV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_C4_nbitsclr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)!=0) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_NE, tmp_1, tmp_0, ((int32_t) 0x0));
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_C2_cmpeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV==siV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_0, RsV, siV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_cmpgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV>siV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_GT, tmp_0, RsV, siV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_cmpgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {fIMMEXT(uiV); PdV=((fCAST4u(RsV)>fCAST4u(uiV)) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_GTU, tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_bitsclri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {PdV=(((RsV&uiV)==0) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_1, tmp_0, ((int32_t) 0x0));
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_C4_nbitsclri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {PdV=(((RsV&uiV)!=0) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_NE, tmp_1, tmp_0, ((int32_t) 0x0));
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_C4_cmpneqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV!=siV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_NE, tmp_0, RsV, siV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_cmpltei(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV<=siV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_LE, tmp_0, RsV, siV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_cmplteui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {fIMMEXT(uiV); PdV=((fCAST4u(RsV)<=fCAST4u(uiV)) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_LEU, tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_cmpneq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV!=RtV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_NE, tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_cmplte(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV<=RtV) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_LE, tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_cmplteu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((fCAST4u(RsV)<=fCAST4u(RtV)) ? 0xff : 0x00);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_LEU, tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PsV & PtV;} */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, PsV, PtV);
tcg_gen_andi_i32(PdV, tmp_0, 0xff);
}

void emit_C2_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PsV | PtV;} */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_0, PsV, PtV);
tcg_gen_andi_i32(PdV, tmp_0, 0xff);
}

void emit_C2_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV)
/* {PdV=PsV ^ PtV;} */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_xor_i32(tmp_0, PsV, PtV);
tcg_gen_andi_i32(PdV, tmp_0, 0xff);
}

void emit_C2_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PtV & (~PsV);} */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PsV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_1, PtV, tmp_0);
tcg_gen_andi_i32(PdV, tmp_1, 0xff);
}

void emit_C2_not(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV)
/* {PdV=~PsV;} */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PsV);
tcg_gen_andi_i32(PdV, tmp_0, 0xff);
}

void emit_C2_orn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PtV | (~PsV);} */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PsV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, PtV, tmp_0);
tcg_gen_andi_i32(PdV, tmp_1, 0xff);
}

void emit_C4_and_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & PtV & PuV; } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, PsV, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_1, tmp_0, PuV);
tcg_gen_andi_i32(PdV, tmp_1, 0xff);
}

void emit_C4_and_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & (PtV | PuV); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_0, PtV, PuV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_1, PsV, tmp_0);
tcg_gen_andi_i32(PdV, tmp_1, 0xff);
}

void emit_C4_or_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | (PtV & PuV); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, PtV, PuV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, PsV, tmp_0);
tcg_gen_andi_i32(PdV, tmp_1, 0xff);
}

void emit_C4_or_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | PtV | PuV; } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_0, PsV, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, tmp_0, PuV);
tcg_gen_andi_i32(PdV, tmp_1, 0xff);
}

void emit_C4_and_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & PtV & (~PuV); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_0, PsV, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PuV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_2, tmp_0, tmp_1);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_and_orn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & (PtV | (~PuV)); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PuV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, PtV, tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_2, PsV, tmp_1);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_or_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | (PtV & (~PuV)); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PuV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_1, PtV, tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_2, PsV, tmp_1);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C4_or_orn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | PtV | (~PuV); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_0, PsV, PtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_1, PuV);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_2, tmp_0, tmp_1);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_any8(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV)
/* { PdV = (PsV ? 0xff : 0x00); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_constant_i32(0);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
TCGv_i32 tmp_2 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_1, PsV, tmp_0, tmp_2, tmp_3);
tcg_gen_andi_i32(PdV, tmp_1, 0xff);
}

void emit_C2_all8(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV)
/* { PdV = (PsV == 0xff ? 0xff : 0x00); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_0, PsV, ((int32_t) 0xff));
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_andi_i32(PdV, tmp_2, 0xff);
}

void emit_C2_vitpack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PsV, TCGv PtV)
/* { RdV = (PsV&0x55) | (PtV&0xAA); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PsV, ((int32_t) 0x55));
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, PtV, ((int32_t) 0xaa));
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_2, tmp_0, tmp_1);
tcg_gen_mov_i32(RdV, tmp_2);
}

void emit_C2_mux(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = ((fGETBIT(0, PuV)) ? RsV : RtV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PuV, ((int32_t) 0x0) * 1, 1);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, RsV, RtV);
tcg_gen_mov_i32(RdV, tmp_2);
}

void emit_C2_cmovenewit(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if (fLSBNEW(PuN)) RdV=siV; else CANCEL;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PuN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
tcg_gen_movi_i32(RdV, siV);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_cmovenewif(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if ((fLSBNEW(~PuN))) RdV=siV; else CANCEL;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PuN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
tcg_gen_movi_i32(RdV, siV);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_cmoveit(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if ((fGETBIT(0, PuV))) RdV=siV; else CANCEL;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PuV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
tcg_gen_movi_i32(RdV, siV);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_cmoveif(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if (fGETBIT(0, ~PuV)) RdV=siV; else CANCEL;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PuV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
tcg_gen_movi_i32(RdV, siV);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_ccombinewnewt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if (fLSBNEW(PuN)) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_0, PuN, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
tcg_gen_deposit_i64(RddV, RddV, tmp_1, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, RsV);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, ((int32_t) 0x1) * 32, 32);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_ccombinewnewf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if ((fLSBNEW(~PuN))) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PuN);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_1, tmp_0, ((uint32_t) 0x1));
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, RtV);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, RsV);
tcg_gen_deposit_i64(RddV, RddV, tmp_3, ((int32_t) 0x1) * 32, 32);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_ccombinewt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if ((fGETBIT(0, PuV))) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PuV, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_0, 0, if_label_0);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
tcg_gen_deposit_i64(RddV, RddV, tmp_1, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, RsV);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, ((int32_t) 0x1) * 32, 32);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_ccombinewf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if (fGETBIT(0, ~PuV)) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_0, PuV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, tmp_0, ((int32_t) 0x0) * 1, 1);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i32(TCG_COND_EQ, tmp_1, 0, if_label_0);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, RtV);
tcg_gen_deposit_i64(RddV, RddV, tmp_2, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, RsV);
tcg_gen_deposit_i64(RddV, RddV, tmp_3, ((int32_t) 0x1) * 32, 32);
TCGLabel *if_label_1 = gen_new_label();
tcg_gen_br(if_label_1);
gen_set_label(if_label_0);
gen_set_label(if_label_1);
}

void emit_C2_muxii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, int siV, int SiV)
/* { fIMMEXT(siV); RdV = ((fGETBIT(0, PuV)) ? siV : SiV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PuV, ((int32_t) 0x0) * 1, 1);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (siV));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (SiV));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
tcg_gen_mov_i32(RdV, tmp_2);
}

void emit_C2_muxir(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV = ((fGETBIT(0, PuV)) ? RsV : siV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PuV, ((int32_t) 0x0) * 1, 1);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (siV));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, RsV, tmp_3);
tcg_gen_mov_i32(RdV, tmp_2);
}

void emit_C2_muxri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV = ((fGETBIT(0, PuV)) ? siV : RsV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PuV, ((int32_t) 0x0) * 1, 1);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (siV));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, RsV);
tcg_gen_mov_i32(RdV, tmp_2);
}

void emit_C2_vmux(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv PuV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,(fGETBIT(i,PuV)?(fGETBYTE(i,RssV)):(fGETBYTE(i,RttV)))); } } */
{
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PuV, i * 1, 1);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, i * 8, 8);
TCGv_i64 tmp_3 = tcg_constant_i64(0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_5, tmp_0);
tcg_gen_movcond_i64(TCG_COND_NE, tmp_4, tmp_5, tmp_3, tmp_1, tmp_2);
tcg_gen_deposit_i64(RddV, RddV, tmp_4, i * 8, 8);
}
}

void emit_C2_mask(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv PtV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,(fGETBIT(i,PtV)?(0xff):(0x00))); } } */
{
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, PtV, i * 1, 1);
TCGv_i32 tmp_1 = tcg_constant_i32(0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
TCGv_i32 tmp_3 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_2, tmp_0, tmp_1, tmp_3, tmp_4);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_5, tmp_2);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, i * 8, 8);
}
}

void emit_A2_vcmpbeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETBYTE(i,RssV) == fGETBYTE(i,RttV))); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, i * 1, 1);
}
}

void emit_A4_vcmpbeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETUBYTE(i,RssV) == uiV)); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_0 = (int64_t)uiV;
tcg_gen_setcondi_i64(TCG_COND_EQ, tmp_1, tmp_0, qemu_tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
tcg_gen_deposit_i32(PdV, PdV, tmp_2, i * 1, 1);
}
}

void emit_A4_vcmpbeq_any(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; PdV = 0; for (i = 0; i < 8; i++) { if (fGETBYTE(i,RssV) == fGETBYTE(i,RttV)) PdV = 0xff; } } */
{
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_andi_i32(PdV, tmp_0, 0xff);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, i * 8, 8);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_3, tmp_1, tmp_2);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i64(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
gen_set_label(if_label_0);
}
}

void emit_A6_vcmpbeq_notany(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; PdV = 0; for (i = 0; i < 8; i++) { if (fGETBYTE(i,RssV) == fGETBYTE(i,RttV)) PdV = 0xff; } PdV = ~PdV; } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i32 tmp_0 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_andi_i32(PdV, tmp_0, 0xff);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, i * 8, 8);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_3, tmp_1, tmp_2);
TCGLabel *if_label_0 = gen_new_label();
tcg_gen_brcondi_i64(TCG_COND_EQ, tmp_3, 0, if_label_0);
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
gen_set_label(if_label_0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_not_i32(tmp_5, PdV);
tcg_gen_andi_i32(PdV, tmp_5, 0xff);
}

void emit_A2_vcmpbgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETUBYTE(i,RssV) > fGETUBYTE(i,RttV))); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GTU, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, i * 1, 1);
}
}

void emit_A4_vcmpbgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETUBYTE(i,RssV) > uiV)); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_0 = (int64_t)uiV;
tcg_gen_setcondi_i64(TCG_COND_GTU, tmp_1, tmp_0, qemu_tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
tcg_gen_deposit_i32(PdV, PdV, tmp_2, i * 1, 1);
}
}

void emit_A4_vcmpbgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETBYTE(i,RssV) > fGETBYTE(i,RttV))); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, i * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GT, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, i * 1, 1);
}
}

void emit_A4_vcmpbgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETBYTE(i,RssV) > siV)); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x8); i++) {
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, i * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_0 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_GT, tmp_1, tmp_0, qemu_tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
tcg_gen_deposit_i32(PdV, PdV, tmp_2, i * 1, 1);
}
}

void emit_A4_cmpbeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETBYTE(0,RsV) == fGETBYTE(0,RtV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_EQ, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_constant_i32(0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_6 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_4, tmp_2, tmp_3, tmp_5, tmp_6);
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
}

void emit_A4_cmpbeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { PdV=((fGETUBYTE(0,RsV) == uiV) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_1, tmp_0, uiV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_A4_cmpbgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETUBYTE(0,RsV) > fGETUBYTE(0,RtV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_GTU, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_constant_i32(0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_6 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_4, tmp_2, tmp_3, tmp_5, tmp_6);
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
}

void emit_A4_cmpbgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); PdV=((fGETUBYTE(0,RsV) > fCAST4u(uiV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_GTU, tmp_1, tmp_0, uiV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_A4_cmpbgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETBYTE(0,RsV) > fGETBYTE(0,RtV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_GT, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_constant_i32(0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_6 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_4, tmp_2, tmp_3, tmp_5, tmp_6);
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
}

void emit_A4_cmpbgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* { PdV=((fGETBYTE(0,RsV) > siV) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_GT, tmp_1, tmp_0, siV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_A2_vcmpheq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2,PdV, (fGETHALF(i,RssV) == fGETHALF(i,RttV))); fSETBIT(i*2+1,PdV,(fGETHALF(i,RssV) == fGETHALF(i,RttV))); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
int32_t qemu_tmp_0 = i * ((int32_t) 0x2);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, i * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, i * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, qemu_tmp_0 * 1, 1);
int32_t qemu_tmp_1 = i * ((int32_t) 0x2);
int32_t qemu_tmp_2 = qemu_tmp_1 + ((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, i * 16, 16);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, i * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_6, tmp_4, tmp_5);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_deposit_i32(PdV, PdV, tmp_7, qemu_tmp_2 * 1, 1);
}
}

void emit_A2_vcmphgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETHALF(i,RssV) > fGETHALF(i,RttV))); fSETBIT(i*2+1,PdV, (fGETHALF(i,RssV) > fGETHALF(i,RttV))); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
int32_t qemu_tmp_0 = i * ((int32_t) 0x2);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, i * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, i * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GT, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, qemu_tmp_0 * 1, 1);
int32_t qemu_tmp_1 = i * ((int32_t) 0x2);
int32_t qemu_tmp_2 = qemu_tmp_1 + ((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, i * 16, 16);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, i * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GT, tmp_6, tmp_4, tmp_5);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_deposit_i32(PdV, PdV, tmp_7, qemu_tmp_2 * 1, 1);
}
}

void emit_A2_vcmphgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETUHALF(i,RssV) > fGETUHALF(i,RttV))); fSETBIT(i*2+1,PdV, (fGETUHALF(i,RssV) > fGETUHALF(i,RttV))); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
int32_t qemu_tmp_0 = i * ((int32_t) 0x2);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, i * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, i * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GTU, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, qemu_tmp_0 * 1, 1);
int32_t qemu_tmp_1 = i * ((int32_t) 0x2);
int32_t qemu_tmp_2 = qemu_tmp_1 + ((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_4, RssV, i * 16, 16);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_5, RttV, i * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GTU, tmp_6, tmp_4, tmp_5);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_deposit_i32(PdV, PdV, tmp_7, qemu_tmp_2 * 1, 1);
}
}

void emit_A4_vcmpheqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2,PdV, (fGETHALF(i,RssV) == siV)); fSETBIT(i*2+1,PdV,(fGETHALF(i,RssV) == siV)); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
int32_t qemu_tmp_0 = i * ((int32_t) 0x2);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, i * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_1 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_EQ, tmp_1, tmp_0, qemu_tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
tcg_gen_deposit_i32(PdV, PdV, tmp_2, qemu_tmp_0 * 1, 1);
int32_t qemu_tmp_2 = i * ((int32_t) 0x2);
int32_t qemu_tmp_3 = qemu_tmp_2 + ((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_3, RssV, i * 16, 16);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
int64_t qemu_tmp_4 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_EQ, tmp_4, tmp_3, qemu_tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_deposit_i32(PdV, PdV, tmp_5, qemu_tmp_3 * 1, 1);
}
}

void emit_A4_vcmphgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETHALF(i,RssV) > siV)); fSETBIT(i*2+1,PdV, (fGETHALF(i,RssV) > siV)); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
int32_t qemu_tmp_0 = i * ((int32_t) 0x2);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, i * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_1 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_GT, tmp_1, tmp_0, qemu_tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
tcg_gen_deposit_i32(PdV, PdV, tmp_2, qemu_tmp_0 * 1, 1);
int32_t qemu_tmp_2 = i * ((int32_t) 0x2);
int32_t qemu_tmp_3 = qemu_tmp_2 + ((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_3, RssV, i * 16, 16);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
int64_t qemu_tmp_4 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_GT, tmp_4, tmp_3, qemu_tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_deposit_i32(PdV, PdV, tmp_5, qemu_tmp_3 * 1, 1);
}
}

void emit_A4_vcmphgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETUHALF(i,RssV) > uiV)); fSETBIT(i*2+1,PdV, (fGETUHALF(i,RssV) > uiV)); } } */
{
tcg_gen_movi_i32(PdV, 0);
for (int i = ((int32_t) 0x0); i < ((int32_t) 0x4); i++) {
int32_t qemu_tmp_0 = i * ((int32_t) 0x2);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, i * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_1 = (int64_t)uiV;
tcg_gen_setcondi_i64(TCG_COND_GTU, tmp_1, tmp_0, qemu_tmp_1);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
tcg_gen_deposit_i32(PdV, PdV, tmp_2, qemu_tmp_0 * 1, 1);
int32_t qemu_tmp_2 = i * ((int32_t) 0x2);
int32_t qemu_tmp_3 = qemu_tmp_2 + ((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_3, RssV, i * 16, 16);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
int64_t qemu_tmp_4 = (int64_t)uiV;
tcg_gen_setcondi_i64(TCG_COND_GTU, tmp_4, tmp_3, qemu_tmp_4);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_deposit_i32(PdV, PdV, tmp_5, qemu_tmp_3 * 1, 1);
}
}

void emit_A4_cmpheq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETHALF(0,RsV) == fGETHALF(0,RtV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_EQ, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_constant_i32(0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_6 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_4, tmp_2, tmp_3, tmp_5, tmp_6);
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
}

void emit_A4_cmphgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETHALF(0,RsV) > fGETHALF(0,RtV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_GT, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_constant_i32(0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_6 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_4, tmp_2, tmp_3, tmp_5, tmp_6);
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
}

void emit_A4_cmphgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETUHALF(0,RsV) > fGETUHALF(0,RtV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_setcond_i32(TCG_COND_GTU, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_constant_i32(0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_6 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_4, tmp_2, tmp_3, tmp_5, tmp_6);
tcg_gen_andi_i32(PdV, tmp_4, 0xff);
}

void emit_A4_cmpheqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); PdV=((fGETHALF(0,RsV) == siV) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_1, tmp_0, siV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_A4_cmphgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); PdV=((fGETHALF(0,RsV) > siV) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_GT, tmp_1, tmp_0, siV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_A4_cmphgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); PdV=((fGETUHALF(0,RsV) > fCAST4u(uiV)) ? 0xff : 0x00); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_GTU, tmp_1, tmp_0, uiV);
TCGv_i32 tmp_2 = tcg_constant_i32(0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
TCGv_i32 tmp_4 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_5 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_3, tmp_1, tmp_2, tmp_4, tmp_5);
tcg_gen_andi_i32(PdV, tmp_3, 0xff);
}

void emit_A2_vcmpweq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)==fGETWORD(0,RttV))); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)==fGETWORD(1,RttV))); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_4, tmp_3, 1);
tcg_gen_neg_i32(tmp_4, tmp_4);
tcg_gen_deposit_i32(PdV, PdV, tmp_4, ((int32_t) 0x0), 4);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_6, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_EQ, tmp_7, tmp_5, tmp_6);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_9, tmp_8, 1);
tcg_gen_neg_i32(tmp_9, tmp_9);
tcg_gen_deposit_i32(PdV, PdV, tmp_9, ((int32_t) 0x4), 4);
}

void emit_A2_vcmpwgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)>fGETWORD(0,RttV))); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)>fGETWORD(1,RttV))); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GT, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_4, tmp_3, 1);
tcg_gen_neg_i32(tmp_4, tmp_4);
tcg_gen_deposit_i32(PdV, PdV, tmp_4, ((int32_t) 0x0), 4);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_6, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GT, tmp_7, tmp_5, tmp_6);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_9, tmp_8, 1);
tcg_gen_neg_i32(tmp_9, tmp_9);
tcg_gen_deposit_i32(PdV, PdV, tmp_9, ((int32_t) 0x4), 4);
}

void emit_A2_vcmpwgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETBITS(3,0,PdV,(fGETUWORD(0,RssV)>fGETUWORD(0,RttV))); fSETBITS(7,4,PdV,(fGETUWORD(1,RssV)>fGETUWORD(1,RttV))); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GTU, tmp_2, tmp_0, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_2);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_4, tmp_3, 1);
tcg_gen_neg_i32(tmp_4, tmp_4);
tcg_gen_deposit_i32(PdV, PdV, tmp_4, ((int32_t) 0x0), 4);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_5, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_6, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_setcond_i64(TCG_COND_GTU, tmp_7, tmp_5, tmp_6);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_9, tmp_8, 1);
tcg_gen_neg_i32(tmp_9, tmp_9);
tcg_gen_deposit_i32(PdV, PdV, tmp_9, ((int32_t) 0x4), 4);
}

void emit_A4_vcmpweqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)==siV)); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)==siV)); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_0 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_EQ, tmp_1, tmp_0, qemu_tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, 1);
tcg_gen_neg_i32(tmp_3, tmp_3);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, ((int32_t) 0x0), 4);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
int64_t qemu_tmp_1 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_EQ, tmp_5, tmp_4, qemu_tmp_1);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_7, tmp_6, 1);
tcg_gen_neg_i32(tmp_7, tmp_7);
tcg_gen_deposit_i32(PdV, PdV, tmp_7, ((int32_t) 0x4), 4);
}

void emit_A4_vcmpwgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)>siV)); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)>siV)); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
int64_t qemu_tmp_0 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_GT, tmp_1, tmp_0, qemu_tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, 1);
tcg_gen_neg_i32(tmp_3, tmp_3);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, ((int32_t) 0x0), 4);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
int64_t qemu_tmp_1 = (int64_t)siV;
tcg_gen_setcondi_i64(TCG_COND_GT, tmp_5, tmp_4, qemu_tmp_1);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_7, tmp_6, 1);
tcg_gen_neg_i32(tmp_7, tmp_7);
tcg_gen_deposit_i32(PdV, PdV, tmp_7, ((int32_t) 0x4), 4);
}

void emit_A4_vcmpwgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { fSETBITS(3,0,PdV,(fGETUWORD(0,RssV)>fCAST4u(uiV))); fSETBITS(7,4,PdV,(fGETUWORD(1,RssV)>fCAST4u(uiV))); } */
{
tcg_gen_movi_i32(PdV, 0);
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
uint64_t qemu_tmp_0 = (uint64_t)uiV;
tcg_gen_setcondi_i64(TCG_COND_GTU, tmp_1, tmp_0, qemu_tmp_0);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_3, tmp_2, 1);
tcg_gen_neg_i32(tmp_3, tmp_3);
tcg_gen_deposit_i32(PdV, PdV, tmp_3, ((int32_t) 0x0), 4);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_4, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
uint64_t qemu_tmp_1 = (uint64_t)uiV;
tcg_gen_setcondi_i64(TCG_COND_GTU, tmp_5, tmp_4, qemu_tmp_1);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_andi_i32(tmp_7, tmp_6, 1);
tcg_gen_neg_i32(tmp_7, tmp_7);
tcg_gen_deposit_i32(PdV, PdV, tmp_7, ((int32_t) 0x4), 4);
}

void emit_A4_boundscheck_hi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { size4u_t src; src = fGETUWORD(1,RssV); PdV = (((fCAST4u(src) >= fGETUWORD(0,RttV)) && (fCAST4u(src) < fGETUWORD(1,RttV))) ? 0xff : 0x00); } */
{
TCGv_i32 src = tcg_temp_new_i32();
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_1, tmp_0);
tcg_gen_mov_i32(src, tmp_1);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_4, src);
tcg_gen_setcond_i64(TCG_COND_GEU, tmp_3, tmp_4, tmp_2);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_5, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_7, src);
tcg_gen_setcond_i64(TCG_COND_LTU, tmp_6, tmp_7, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_constant_i32(0);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_11, tmp_9);
tcg_gen_setcond_i64(TCG_COND_NE, tmp_10, tmp_3, tmp_11);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_13, tmp_9);
tcg_gen_setcond_i64(TCG_COND_NE, tmp_12, tmp_6, tmp_13);
tcg_gen_and_i64(tmp_8, tmp_10, tmp_12);
TCGv_i32 tmp_14 = tcg_constant_i32(0);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_16, tmp_8);
TCGv_i32 tmp_17 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_18 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_15, tmp_16, tmp_14, tmp_17, tmp_18);
tcg_gen_andi_i32(PdV, tmp_15, 0xff);
}

void emit_A4_boundscheck_lo(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { size4u_t src; src = fGETUWORD(0,RssV); PdV = (((fCAST4u(src) >= fGETUWORD(0,RttV)) && (fCAST4u(src) < fGETUWORD(1,RttV))) ? 0xff : 0x00); } */
{
TCGv_i32 src = tcg_temp_new_i32();
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_1, tmp_0);
tcg_gen_mov_i32(src, tmp_1);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_4, src);
tcg_gen_setcond_i64(TCG_COND_GEU, tmp_3, tmp_4, tmp_2);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_5, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_7, src);
tcg_gen_setcond_i64(TCG_COND_LTU, tmp_6, tmp_7, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_constant_i32(0);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_11, tmp_9);
tcg_gen_setcond_i64(TCG_COND_NE, tmp_10, tmp_3, tmp_11);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_13, tmp_9);
tcg_gen_setcond_i64(TCG_COND_NE, tmp_12, tmp_6, tmp_13);
tcg_gen_and_i64(tmp_8, tmp_10, tmp_12);
TCGv_i32 tmp_14 = tcg_constant_i32(0);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_16, tmp_8);
TCGv_i32 tmp_17 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_18 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_15, tmp_16, tmp_14, tmp_17, tmp_18);
tcg_gen_andi_i32(PdV, tmp_15, 0xff);
}

void emit_C2_tfrpr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PsV)
/* { RdV = fZXTN(8,32,PsV); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, PsV);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_1, tmp_0, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_1, 0);
}
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_1);
tcg_gen_mov_i32(RdV, tmp_2);
}

void emit_C2_tfrrp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV)
/* { PdV = fGETUBYTE(0,RsV); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
tcg_gen_andi_i32(PdV, tmp_0, 0xff);
}

void emit_C4_fastcorner9(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV)
/* { size4u_t tmp = 0; size4u_t i; fSETHALF(0,tmp,(PsV<<8)|PtV); fSETHALF(1,tmp,(PsV<<8)|PtV); for (i = 1; i < 9; i++) { tmp &= tmp >> 1; } PdV = ((tmp != 0) ? 0xff : 0x00); } */
{
TCGv_i32 tmp = tcg_temp_new_i32();
tcg_gen_movi_i32(PdV, 0);
tcg_gen_movi_i32(tmp, ((int32_t) 0x0));
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (((int32_t) 0x8) >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, PsV, ((int32_t) 0x8));
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, tmp_0, PtV);
tcg_gen_deposit_i32(tmp, tmp, tmp_1, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
if (((int32_t) 0x8) >= 32) {
tcg_gen_movi_i32(tmp_2, 0);
} else {
tcg_gen_shli_i32(tmp_2, PsV, ((int32_t) 0x8));
}
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_3, tmp_2, PtV);
tcg_gen_deposit_i32(tmp, tmp, tmp_3, ((int32_t) 0x1) * 16, 16);
for (int i = ((int32_t) 0x1); i < ((int32_t) 0x9); i++) {
TCGv_i32 tmp_4 = tcg_temp_new_i32();
if (((int32_t) 0x1) >= 32) {
tcg_gen_movi_i32(tmp_4, 0);
} else {
tcg_gen_shri_i32(tmp_4, tmp, ((int32_t) 0x1));
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_5, tmp, tmp_4);
tcg_gen_mov_i32(tmp, tmp_5);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_NE, tmp_6, tmp, ((int32_t) 0x0));
TCGv_i32 tmp_7 = tcg_constant_i32(0);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
TCGv_i32 tmp_9 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_10 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_8, tmp_6, tmp_7, tmp_9, tmp_10);
tcg_gen_andi_i32(PdV, tmp_8, 0xff);
}

void emit_C4_fastcorner9_not(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV)
/* { size4u_t tmp = 0; size4u_t i; fSETHALF(0,tmp,(PsV<<8)|PtV); fSETHALF(1,tmp,(PsV<<8)|PtV); for (i = 1; i < 9; i++) { tmp &= tmp >> 1; } PdV = ((tmp == 0) ? 0xff : 0x00); } */
{
TCGv_i32 tmp = tcg_temp_new_i32();
tcg_gen_movi_i32(PdV, 0);
tcg_gen_movi_i32(tmp, ((int32_t) 0x0));
TCGv_i32 tmp_0 = tcg_temp_new_i32();
if (((int32_t) 0x8) >= 32) {
tcg_gen_movi_i32(tmp_0, 0);
} else {
tcg_gen_shli_i32(tmp_0, PsV, ((int32_t) 0x8));
}
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_1, tmp_0, PtV);
tcg_gen_deposit_i32(tmp, tmp, tmp_1, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
if (((int32_t) 0x8) >= 32) {
tcg_gen_movi_i32(tmp_2, 0);
} else {
tcg_gen_shli_i32(tmp_2, PsV, ((int32_t) 0x8));
}
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_or_i32(tmp_3, tmp_2, PtV);
tcg_gen_deposit_i32(tmp, tmp, tmp_3, ((int32_t) 0x1) * 16, 16);
for (int i = ((int32_t) 0x1); i < ((int32_t) 0x9); i++) {
TCGv_i32 tmp_4 = tcg_temp_new_i32();
if (((int32_t) 0x1) >= 32) {
tcg_gen_movi_i32(tmp_4, 0);
} else {
tcg_gen_shri_i32(tmp_4, tmp, ((int32_t) 0x1));
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_and_i32(tmp_5, tmp, tmp_4);
tcg_gen_mov_i32(tmp, tmp_5);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_setcondi_i32(TCG_COND_EQ, tmp_6, tmp, ((int32_t) 0x0));
TCGv_i32 tmp_7 = tcg_constant_i32(0);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
TCGv_i32 tmp_9 = tcg_constant_i32((int32_t) (((int32_t) 0xff)));
TCGv_i32 tmp_10 = tcg_constant_i32((int32_t) (((int32_t) 0x0)));
tcg_gen_movcond_i32(TCG_COND_NE, tmp_8, tmp_6, tmp_7, tmp_9, tmp_10);
tcg_gen_andi_i32(PdV, tmp_8, 0xff);
}

void emit_M2_mpy_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpy_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpy_acc_sat_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_acc_sat_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_acc_sat_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_acc_sat_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_acc_sat_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_acc_sat_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_acc_sat_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_acc_sat_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_nac_sat_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_nac_sat_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_nac_sat_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_nac_sat_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_nac_sat_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_nac_sat_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_nac_sat_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RxV, tmp_9);
}

void emit_M2_mpy_nac_sat_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
tcg_gen_mov_i32(RxV, tmp_10);
}

void emit_M2_mpy_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpy_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpy_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpy_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpy_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_sat_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_5);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_sat_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_sat_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_5);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_sat_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_sat_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_5);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_sat_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_sat_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_5);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_sat_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_rnd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_rnd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_rnd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_rnd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_rnd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_rnd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_rnd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpy_rnd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RdV, tmp_7);
}

void emit_M2_mpy_sat_rnd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_sat_rnd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RdV, tmp_9);
}

void emit_M2_mpy_sat_rnd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_sat_rnd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RdV, tmp_9);
}

void emit_M2_mpy_sat_rnd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_sat_rnd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RdV, tmp_9);
}

void emit_M2_mpy_sat_rnd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mpy_sat_rnd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RdV, tmp_9);
}

void emit_M2_mpyd_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyd_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_rnd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_rnd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
tcg_gen_mov_i64(RddV, tmp_6);
}

void emit_M2_mpyd_rnd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_rnd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
tcg_gen_mov_i64(RddV, tmp_6);
}

void emit_M2_mpyd_rnd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_rnd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
tcg_gen_mov_i64(RddV, tmp_6);
}

void emit_M2_mpyd_rnd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV)) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyd_rnd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
tcg_gen_mov_i64(RddV, tmp_6);
}

void emit_M2_mpyu_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, RxV);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, tmp_5, tmp_4);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_7, tmp_6);
tcg_gen_mov_i32(RxV, tmp_7);
}

void emit_M2_mpyu_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, RxV);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_7, tmp_6, tmp_5);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_7);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyu_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpyu_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpyu_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpyu_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpyu_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpyu_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpyu_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M2_mpyu_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_5);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpyud_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, RxxV, tmp_4);
tcg_gen_mov_i64(RxxV, tmp_5);
}

void emit_M2_mpyud_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_6, RxxV, tmp_5);
tcg_gen_mov_i64(RxxV, tmp_6);
}

void emit_M2_mpyud_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyud_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyud_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyud_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyud_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyud_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpyud_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_mov_i64(RddV, tmp_4);
}

void emit_M2_mpyud_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_extract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
tcg_gen_mov_i64(RddV, tmp_5);
}

void emit_M2_mpysip(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RdV=RsV*uiV; } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_muli_i32(tmp_0, RsV, uiV);
tcg_gen_mov_i32(RdV, tmp_0);
}

void emit_M2_mpysin(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV=RsV*-uiV; } */
{
int32_t qemu_tmp_0 = -(uiV);
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_muli_i32(tmp_0, RsV, qemu_tmp_0);
tcg_gen_mov_i32(RdV, tmp_0);
}

void emit_M2_macsip(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RxV=RxV + (RsV*uiV);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_muli_i32(tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, tmp_0);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_macsin(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RxV=RxV - (RsV*uiV);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_muli_i32(tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, RxV, tmp_0);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_dpmpyss_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fMPY32SS(RsV,RtV);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
tcg_gen_mov_i64(RddV, tmp_2);
}

void emit_M2_dpmpyss_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV + fMPY32SS(RsV,RtV);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_3, RxxV, tmp_2);
tcg_gen_mov_i64(RxxV, tmp_3);
}

void emit_M2_dpmpyss_nac_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV - fMPY32SS(RsV,RtV);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_3, RxxV, tmp_2);
tcg_gen_mov_i64(RxxV, tmp_3);
}

void emit_M2_dpmpyuu_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fMPY32UU(fCAST4u(RsV),fCAST4u(RtV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
tcg_gen_mov_i64(RddV, tmp_2);
}

void emit_M2_dpmpyuu_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV + fMPY32UU(fCAST4u(RsV),fCAST4u(RtV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_3, RxxV, tmp_2);
tcg_gen_mov_i64(RxxV, tmp_3);
}

void emit_M2_dpmpyuu_nac_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV - fMPY32UU(fCAST4u(RsV),fCAST4u(RtV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_3, RxxV, tmp_2);
tcg_gen_mov_i64(RxxV, tmp_3);
}

void emit_M2_mpy_up(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32SS(RsV,RtV)>>32;} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x20);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_0;
if (qemu_tmp_0 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_3, tmp_2, shift);
}
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_3);
tcg_gen_mov_i32(RdV, tmp_4);
}

void emit_M2_mpy_up_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32SS(RsV,RtV)>>31;} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1f);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_0;
if (qemu_tmp_0 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_3, tmp_2, shift);
}
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_3);
tcg_gen_mov_i32(RdV, tmp_4);
}

void emit_M2_mpy_up_s1_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fMPY32SS(RsV,RtV)>>31);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1f);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_0;
if (qemu_tmp_0 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_3, tmp_2, shift);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
TCGv_i32 tmp_5 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_5, tmp_4, tmp_3, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_5);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_6, tmp_4);
tcg_gen_mov_i32(RdV, tmp_6);
}

void emit_M2_mpyu_up(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32UU(fCAST4u(RsV),fCAST4u(RtV))>>32;} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x20);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shri_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_3);
tcg_gen_mov_i32(RdV, tmp_4);
}

void emit_M2_mpysu_up(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32SU(RsV,fCAST4u(RtV))>>32;} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extu_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x20);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_0;
if (qemu_tmp_0 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_3, tmp_2, shift);
}
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_3);
tcg_gen_mov_i32(RdV, tmp_4);
}

void emit_M2_dpmpyss_rnd_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=(fMPY32SS(RsV,RtV)+fCONSTLL(0x80000000))>>32;} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RsV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RtV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x80000000);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_3, tmp_2, qemu_tmp_0);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_4);
tcg_gen_mov_i32(RdV, tmp_5);
}

void emit_M4_mac_up_s1_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, (fSE32_64(RxV)) + (fMPY32SS(RsV,RtV)>>31));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RxV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RsV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, RtV);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1f);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_0;
if (qemu_tmp_0 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, tmp_0, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M4_nac_up_s1_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, (fSE32_64(RxV)) - (fMPY32SS(RsV,RtV)>>31));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_0, RxV);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RsV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, RtV);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1f);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_0;
if (qemu_tmp_0 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_5, tmp_0, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RxV, tmp_8);
}

void emit_M2_mpyi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV=RsV*RtV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_0, RsV, RtV);
tcg_gen_mov_i32(RdV, tmp_0);
}

void emit_M2_maci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV + RsV*RtV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RxV, tmp_0);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_mnaci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV - RsV*RtV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, RxV, tmp_0);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_acci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV + RsV + RtV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, RsV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, tmp_0, RtV);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_accii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RxV=RxV + RsV + siV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, RsV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, siV);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_nacci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV - (RsV + RtV);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, RxV, tmp_0);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_naccii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RxV=RxV - (RsV + siV);} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_0, RsV, siV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, RxV, tmp_0);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M2_subacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RxV=RxV + RtV - RsV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_0, RxV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sub_i32(tmp_1, tmp_0, RsV);
tcg_gen_mov_i32(RxV, tmp_1);
}

void emit_M4_mpyrr_addr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RyV, TCGv_i32 RuV, TCGv_i32 RsV)
/* { RyV = RuV + RsV*RyV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_0, RsV, RyV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RuV, tmp_0);
tcg_gen_mov_i32(RyV, tmp_1);
}

void emit_M4_mpyri_addr_u2(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RuV, TCGv_i32 RsV, int uiV)
/* { RdV = RuV + RsV*uiV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_muli_i32(tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RuV, tmp_0);
tcg_gen_mov_i32(RdV, tmp_1);
}

void emit_M4_mpyri_addr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RuV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RdV = RuV + RsV*uiV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_muli_i32(tmp_0, RsV, uiV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_add_i32(tmp_1, RuV, tmp_0);
tcg_gen_mov_i32(RdV, tmp_1);
}

void emit_M4_mpyri_addi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV, int UiV)
/* { fIMMEXT(uiV); RdV = uiV + RsV*UiV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_muli_i32(tmp_0, RsV, UiV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, uiV);
tcg_gen_mov_i32(RdV, tmp_1);
}

void emit_M4_mpyrr_addi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* { fIMMEXT(uiV); RdV = uiV + RsV*RtV;} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_0, RsV, RtV);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_addi_i32(tmp_1, tmp_0, uiV);
tcg_gen_mov_i32(RdV, tmp_1);
}

void emit_M2_vmpy2s_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmpy2s_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmac2s_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_11, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_12, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_3);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmac2s_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_11, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_12, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_3);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmpy2su_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 0)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmpy2su_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmac2su_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_11, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_12, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_3);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmac2su_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_11, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_12, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_3);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmpy2s_s0pack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + 0x8000))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, tmp_7, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_9);
tcg_gen_deposit_i32(RdV, RdV, tmp_10, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_11, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_12, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_4 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_4);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_17, tmp_16, qemu_tmp_5);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, tmp_18, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_20);
tcg_gen_deposit_i32(RdV, RdV, tmp_21, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_vmpy2s_s1pack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_6, tmp_5, qemu_tmp_2);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, tmp_7, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_9);
tcg_gen_deposit_i32(RdV, RdV, tmp_10, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_11, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_12, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_4 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_4);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_17, tmp_16, qemu_tmp_5);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, tmp_18, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_20);
tcg_gen_deposit_i32(RdV, RdV, tmp_21, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_vmac2(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fGETWORD(0,RxxV) + fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV))); fSETWORD(1,RxxV,fGETWORD(1,RxxV) + fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_6, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_13, tmp_7, tmp_12);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_13, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmpy2es_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RddV, RddV, tmp_8, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RddV, RddV, tmp_18, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmpy2es_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RddV, RddV, tmp_8, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RddV, RddV, tmp_18, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmac2es_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, tmp_0, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
TCGv_i32 tmp_11 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_11, tmp_10, tmp_9, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_11);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_10, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_13, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_14, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_15, tmp_13);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_16, tmp_14);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_20, 0);
} else {
tcg_gen_shli_i64(tmp_20, tmp_19, qemu_tmp_3);
}
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_21, tmp_12, tmp_20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
TCGv_i32 tmp_23 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_23, tmp_22, tmp_21, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_23);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_22, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmac2es_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, tmp_0, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
TCGv_i32 tmp_11 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_11, tmp_10, tmp_9, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_11);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_10, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_13, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_14, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_15, tmp_13);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_16, tmp_14);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_20, 0);
} else {
tcg_gen_shli_i64(tmp_20, tmp_19, qemu_tmp_3);
}
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_21, tmp_12, tmp_20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
TCGv_i32 tmp_23 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_23, tmp_22, tmp_21, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_23);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_22, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vmac2es(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fGETWORD(0,RxxV) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV))); fSETWORD(1,RxxV,fGETWORD(1,RxxV) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_0, tmp_7);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_9, tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_17, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vrmac_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, RxxV, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_7, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_23, tmp_15, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_28, tmp_26, tmp_27);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_29, tmp_28);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_30, tmp_29, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_30, 0);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_31, tmp_23, tmp_30);
tcg_gen_mov_i64(RxxV, tmp_31);
}

void emit_M2_vrmpy_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_15, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_15);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_19, tmp_17, tmp_18);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_20, tmp_19);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_21, tmp_20, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_21, 0);
}
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_22, tmp_14, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_22, tmp_29);
tcg_gen_mov_i64(RddV, tmp_30);
}

void emit_M2_vdmpyrs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0) + 0x8000)))); fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0) + 0x8000))));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_3);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_16, tmp_7, tmp_15);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_17, tmp_16, qemu_tmp_4);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, tmp_18, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_20);
tcg_gen_deposit_i32(RdV, RdV, tmp_21, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_22);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_6);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_30, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_31, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_32 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_32, tmp_30);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_31);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_34, tmp_32, tmp_33);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_35, tmp_34);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_36, tmp_35, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_36, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_37, 0);
} else {
tcg_gen_shli_i64(tmp_37, tmp_36, qemu_tmp_8);
}
TCGv_i64 tmp_38 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_38, tmp_29, tmp_37);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_39, tmp_38, qemu_tmp_9);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
TCGv_i32 tmp_41 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_41, tmp_40, tmp_39, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_41);
TCGv_i64 tmp_42 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_42, tmp_40, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_43 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_43, tmp_42);
tcg_gen_deposit_i32(RdV, RdV, tmp_43, ((int32_t) 0x1) * 16, 16);
}

void emit_M2_vdmpyrs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1) + 0x8000)))); fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1) + 0x8000))));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_3);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_16, tmp_7, tmp_15);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_17, tmp_16, qemu_tmp_4);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, tmp_18, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_20);
tcg_gen_deposit_i32(RdV, RdV, tmp_21, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_22);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_6);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_30, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_31, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_32 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_32, tmp_30);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_31);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_34, tmp_32, tmp_33);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_35, tmp_34);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_36, tmp_35, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_36, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_37, 0);
} else {
tcg_gen_shli_i64(tmp_37, tmp_36, qemu_tmp_8);
}
TCGv_i64 tmp_38 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_38, tmp_29, tmp_37);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_39, tmp_38, qemu_tmp_9);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
TCGv_i32 tmp_41 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_41, tmp_40, tmp_39, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_41);
TCGv_i64 tmp_42 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_42, tmp_40, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_43 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_43, tmp_42);
tcg_gen_deposit_i32(RdV, RdV, tmp_43, ((int32_t) 0x1) * 16, 16);
}

void emit_M5_vrmpybuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,(fMPY16SS(fGETUBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETUBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETUBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETUBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RddV,(fMPY16SS(fGETUBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETUBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETUBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETUBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_0, RssV, ((int32_t) 0x0) * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_7, RssV, ((int32_t) 0x1) * 8, 8);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_8, RttV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_15, RssV, ((int32_t) 0x2) * 8, 8);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_16, RttV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_15);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_19, tmp_17, tmp_18);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_20, tmp_19);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_21, tmp_20, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_21, 0);
}
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_22, tmp_14, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_23, RssV, ((int32_t) 0x3) * 8, 8);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_24, RttV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_22, tmp_29);
tcg_gen_deposit_i64(RddV, RddV, tmp_30, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_31, RssV, ((int32_t) 0x4) * 8, 8);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_32, RttV, ((int32_t) 0x4) * 8, 8);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_31);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_34, tmp_32);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_35, tmp_33, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_36, tmp_35);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_37, tmp_36, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_37, 0);
}
TCGv_i64 tmp_38 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_38, RssV, ((int32_t) 0x5) * 8, 8);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_39, RttV, ((int32_t) 0x5) * 8, 8);
TCGv_i32 tmp_40 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_40, tmp_38);
TCGv_i32 tmp_41 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_41, tmp_39);
TCGv_i32 tmp_42 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_42, tmp_40, tmp_41);
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_43, tmp_42);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_44 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_44, tmp_43, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_44, 0);
}
TCGv_i64 tmp_45 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_45, tmp_37, tmp_44);
TCGv_i64 tmp_46 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_46, RssV, ((int32_t) 0x6) * 8, 8);
TCGv_i64 tmp_47 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_47, RttV, ((int32_t) 0x6) * 8, 8);
TCGv_i32 tmp_48 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_48, tmp_46);
TCGv_i32 tmp_49 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_49, tmp_47);
TCGv_i32 tmp_50 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_50, tmp_48, tmp_49);
TCGv_i64 tmp_51 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_51, tmp_50);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_52 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_52, tmp_51, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_52, 0);
}
TCGv_i64 tmp_53 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_53, tmp_45, tmp_52);
TCGv_i64 tmp_54 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_54, RssV, ((int32_t) 0x7) * 8, 8);
TCGv_i64 tmp_55 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_55, RttV, ((int32_t) 0x7) * 8, 8);
TCGv_i32 tmp_56 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_56, tmp_54);
TCGv_i32 tmp_57 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_57, tmp_55);
TCGv_i32 tmp_58 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_58, tmp_56, tmp_57);
TCGv_i64 tmp_59 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_59, tmp_58);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_60 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_60, tmp_59, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_60, 0);
}
TCGv_i64 tmp_61 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_61, tmp_53, tmp_60);
tcg_gen_deposit_i64(RddV, RddV, tmp_61, ((int32_t) 0x1) * 32, 32);
}

void emit_M5_vrmacbuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,(fGETWORD(0,RxxV) + fMPY16SS(fGETUBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETUBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETUBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETUBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RxxV,(fGETWORD(1,RxxV) + fMPY16SS(fGETUBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETUBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETUBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETUBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RssV, ((int32_t) 0x0) * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_0, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_9, RssV, ((int32_t) 0x1) * 8, 8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_10, RttV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_16, tmp_8, tmp_15);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_17, RssV, ((int32_t) 0x2) * 8, 8);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_18, RttV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_20, tmp_18);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_21, tmp_19, tmp_20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_22, tmp_21);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_23, tmp_22, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_23, 0);
}
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_24, tmp_16, tmp_23);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_25, RssV, ((int32_t) 0x3) * 8, 8);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_26, RttV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_32, tmp_24, tmp_31);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_33, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_34, RssV, ((int32_t) 0x4) * 8, 8);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_35, RttV, ((int32_t) 0x4) * 8, 8);
TCGv_i32 tmp_36 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_36, tmp_34);
TCGv_i32 tmp_37 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_37, tmp_35);
TCGv_i32 tmp_38 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_38, tmp_36, tmp_37);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_39, tmp_38);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_40, tmp_39, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_40, 0);
}
TCGv_i64 tmp_41 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_41, tmp_33, tmp_40);
TCGv_i64 tmp_42 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_42, RssV, ((int32_t) 0x5) * 8, 8);
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_43, RttV, ((int32_t) 0x5) * 8, 8);
TCGv_i32 tmp_44 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_44, tmp_42);
TCGv_i32 tmp_45 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_45, tmp_43);
TCGv_i32 tmp_46 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_46, tmp_44, tmp_45);
TCGv_i64 tmp_47 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_47, tmp_46);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_48 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_48, tmp_47, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_48, 0);
}
TCGv_i64 tmp_49 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_49, tmp_41, tmp_48);
TCGv_i64 tmp_50 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_50, RssV, ((int32_t) 0x6) * 8, 8);
TCGv_i64 tmp_51 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_51, RttV, ((int32_t) 0x6) * 8, 8);
TCGv_i32 tmp_52 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_52, tmp_50);
TCGv_i32 tmp_53 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_53, tmp_51);
TCGv_i32 tmp_54 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_54, tmp_52, tmp_53);
TCGv_i64 tmp_55 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_55, tmp_54);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_56 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_56, tmp_55, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_56, 0);
}
TCGv_i64 tmp_57 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_57, tmp_49, tmp_56);
TCGv_i64 tmp_58 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_58, RssV, ((int32_t) 0x7) * 8, 8);
TCGv_i64 tmp_59 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_59, RttV, ((int32_t) 0x7) * 8, 8);
TCGv_i32 tmp_60 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_60, tmp_58);
TCGv_i32 tmp_61 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_61, tmp_59);
TCGv_i32 tmp_62 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_62, tmp_60, tmp_61);
TCGv_i64 tmp_63 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_63, tmp_62);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_64 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_64, tmp_63, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_64, 0);
}
TCGv_i64 tmp_65 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_65, tmp_57, tmp_64);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_65, ((int32_t) 0x1) * 32, 32);
}

void emit_M5_vrmpybsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,(fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RddV,(fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x1) * 8, 8);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_8, RttV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_15, RssV, ((int32_t) 0x2) * 8, 8);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_16, RttV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_15);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_19, tmp_17, tmp_18);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_20, tmp_19);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_21, tmp_20, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_21, 0);
}
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_22, tmp_14, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RssV, ((int32_t) 0x3) * 8, 8);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_24, RttV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_22, tmp_29);
tcg_gen_deposit_i64(RddV, RddV, tmp_30, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_31, RssV, ((int32_t) 0x4) * 8, 8);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_32, RttV, ((int32_t) 0x4) * 8, 8);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_31);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_34, tmp_32);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_35, tmp_33, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_36, tmp_35);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_37, tmp_36, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_37, 0);
}
TCGv_i64 tmp_38 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_38, RssV, ((int32_t) 0x5) * 8, 8);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_39, RttV, ((int32_t) 0x5) * 8, 8);
TCGv_i32 tmp_40 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_40, tmp_38);
TCGv_i32 tmp_41 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_41, tmp_39);
TCGv_i32 tmp_42 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_42, tmp_40, tmp_41);
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_43, tmp_42);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_44 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_44, tmp_43, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_44, 0);
}
TCGv_i64 tmp_45 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_45, tmp_37, tmp_44);
TCGv_i64 tmp_46 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_46, RssV, ((int32_t) 0x6) * 8, 8);
TCGv_i64 tmp_47 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_47, RttV, ((int32_t) 0x6) * 8, 8);
TCGv_i32 tmp_48 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_48, tmp_46);
TCGv_i32 tmp_49 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_49, tmp_47);
TCGv_i32 tmp_50 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_50, tmp_48, tmp_49);
TCGv_i64 tmp_51 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_51, tmp_50);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_52 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_52, tmp_51, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_52, 0);
}
TCGv_i64 tmp_53 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_53, tmp_45, tmp_52);
TCGv_i64 tmp_54 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_54, RssV, ((int32_t) 0x7) * 8, 8);
TCGv_i64 tmp_55 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_55, RttV, ((int32_t) 0x7) * 8, 8);
TCGv_i32 tmp_56 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_56, tmp_54);
TCGv_i32 tmp_57 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_57, tmp_55);
TCGv_i32 tmp_58 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_58, tmp_56, tmp_57);
TCGv_i64 tmp_59 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_59, tmp_58);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_60 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_60, tmp_59, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_60, 0);
}
TCGv_i64 tmp_61 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_61, tmp_53, tmp_60);
tcg_gen_deposit_i64(RddV, RddV, tmp_61, ((int32_t) 0x1) * 32, 32);
}

void emit_M5_vrmacbsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,(fGETWORD(0,RxxV) + fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RxxV,(fGETWORD(1,RxxV) + fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_0, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RssV, ((int32_t) 0x1) * 8, 8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_10, RttV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_16, tmp_8, tmp_15);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RssV, ((int32_t) 0x2) * 8, 8);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_18, RttV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_20, tmp_18);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_21, tmp_19, tmp_20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_22, tmp_21);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_23, tmp_22, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_23, 0);
}
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_24, tmp_16, tmp_23);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RssV, ((int32_t) 0x3) * 8, 8);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_26, RttV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_32, tmp_24, tmp_31);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_33, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, RssV, ((int32_t) 0x4) * 8, 8);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_35, RttV, ((int32_t) 0x4) * 8, 8);
TCGv_i32 tmp_36 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_36, tmp_34);
TCGv_i32 tmp_37 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_37, tmp_35);
TCGv_i32 tmp_38 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_38, tmp_36, tmp_37);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_39, tmp_38);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_40, tmp_39, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_40, 0);
}
TCGv_i64 tmp_41 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_41, tmp_33, tmp_40);
TCGv_i64 tmp_42 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_42, RssV, ((int32_t) 0x5) * 8, 8);
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_43, RttV, ((int32_t) 0x5) * 8, 8);
TCGv_i32 tmp_44 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_44, tmp_42);
TCGv_i32 tmp_45 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_45, tmp_43);
TCGv_i32 tmp_46 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_46, tmp_44, tmp_45);
TCGv_i64 tmp_47 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_47, tmp_46);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_48 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_48, tmp_47, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_48, 0);
}
TCGv_i64 tmp_49 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_49, tmp_41, tmp_48);
TCGv_i64 tmp_50 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_50, RssV, ((int32_t) 0x6) * 8, 8);
TCGv_i64 tmp_51 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_51, RttV, ((int32_t) 0x6) * 8, 8);
TCGv_i32 tmp_52 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_52, tmp_50);
TCGv_i32 tmp_53 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_53, tmp_51);
TCGv_i32 tmp_54 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_54, tmp_52, tmp_53);
TCGv_i64 tmp_55 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_55, tmp_54);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_56 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_56, tmp_55, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_56, 0);
}
TCGv_i64 tmp_57 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_57, tmp_49, tmp_56);
TCGv_i64 tmp_58 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_58, RssV, ((int32_t) 0x7) * 8, 8);
TCGv_i64 tmp_59 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_59, RttV, ((int32_t) 0x7) * 8, 8);
TCGv_i32 tmp_60 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_60, tmp_58);
TCGv_i32 tmp_61 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_61, tmp_59);
TCGv_i32 tmp_62 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_62, tmp_60, tmp_61);
TCGv_i64 tmp_63 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_63, tmp_62);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_64 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_64, tmp_63, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_64, 0);
}
TCGv_i64 tmp_65 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_65, tmp_57, tmp_64);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_65, ((int32_t) 0x1) * 32, 32);
}

void emit_M5_vmpybuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RddV,(fMPY16SS(fGETUBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RddV,(fMPY16SS(fGETUBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RddV,(fMPY16SS(fGETUBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RddV,(fMPY16SS(fGETUBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_4, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_5, RsV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_6, RtV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_7, tmp_5, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_8, tmp_7);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_9, tmp_8, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_9, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_9, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_10, RsV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_11, RtV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_15, RsV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_16, RtV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_19, ((int32_t) 0x3) * 16, 16);
}

void emit_M5_vmpybsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RddV,(fMPY16SS(fGETBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RddV,(fMPY16SS(fGETBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RddV,(fMPY16SS(fGETBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RddV,(fMPY16SS(fGETBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RtV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_4, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RsV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_6, RtV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_7, tmp_5, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_8, tmp_7);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_9, tmp_8, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_9, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_9, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_10, RsV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_11, RtV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_15, RsV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_16, RtV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
tcg_gen_deposit_i64(RddV, RddV, tmp_19, ((int32_t) 0x3) * 16, 16);
}

void emit_M5_vmacbuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RxxV,(fGETHALF(0,RxxV)+fMPY16SS(fGETUBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RxxV,(fGETHALF(1,RxxV)+fMPY16SS(fGETUBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RxxV,(fGETHALF(2,RxxV)+fMPY16SS(fGETUBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RxxV,(fGETHALF(3,RxxV)+fMPY16SS(fGETUBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_1, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_6, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RxxV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_8, RsV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_9, RtV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_13, tmp_7, tmp_12);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_13, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_14, RxxV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_15, RsV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_16, RtV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_20, tmp_14, tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_20, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RxxV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_22, RsV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_23, RtV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_24, tmp_22, tmp_23);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_25, tmp_24);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_26, tmp_25, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_26, 0);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_27, tmp_21, tmp_26);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_27, ((int32_t) 0x3) * 16, 16);
}

void emit_M5_vmacbsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RxxV,(fGETHALF(0,RxxV)+fMPY16SS(fGETBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RxxV,(fGETHALF(1,RxxV)+fMPY16SS(fGETBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RxxV,(fGETHALF(2,RxxV)+fMPY16SS(fGETBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RxxV,(fGETHALF(3,RxxV)+fMPY16SS(fGETBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_2, RtV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_6, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RxxV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_9, RtV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_13, tmp_7, tmp_12);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_13, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_14, RxxV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_15, RsV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_16, RtV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_20, tmp_14, tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_20, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RxxV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_22, RsV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_extract_i32(tmp_23, RtV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_24, tmp_22, tmp_23);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_25, tmp_24);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_26, tmp_25, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_26, 0);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_27, tmp_21, tmp_26);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_27, ((int32_t) 0x3) * 16, 16);
}

void emit_M5_vdmpybsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fSATN(16,(fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV))))); fSETHALF(1,RddV,fSATN(16,(fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV))))); fSETHALF(2,RddV,fSATN(16,(fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV))))); fSETHALF(3,RddV,fSATN(16,(fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV))))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 8, 8);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x1) * 8, 8);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_8, RttV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RddV, RddV, tmp_15, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RssV, ((int32_t) 0x2) * 8, 8);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_18, RttV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_20, tmp_18);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_21, tmp_19, tmp_20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_22, tmp_21);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_23, tmp_22, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_23, 0);
}
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x3) * 8, 8);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_25, RttV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_28, tmp_26, tmp_27);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_29, tmp_28);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_30, tmp_29, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_30, 0);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_31, tmp_23, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RddV, RddV, tmp_32, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, RssV, ((int32_t) 0x4) * 8, 8);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_35, RttV, ((int32_t) 0x4) * 8, 8);
TCGv_i32 tmp_36 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_36, tmp_34);
TCGv_i32 tmp_37 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_37, tmp_35);
TCGv_i32 tmp_38 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_38, tmp_36, tmp_37);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_39, tmp_38);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_40, tmp_39, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_40, 0);
}
TCGv_i64 tmp_41 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_41, RssV, ((int32_t) 0x5) * 8, 8);
TCGv_i64 tmp_42 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_42, RttV, ((int32_t) 0x5) * 8, 8);
TCGv_i32 tmp_43 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_43, tmp_41);
TCGv_i32 tmp_44 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_44, tmp_42);
TCGv_i32 tmp_45 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_45, tmp_43, tmp_44);
TCGv_i64 tmp_46 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_46, tmp_45);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_47 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_47, tmp_46, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_47, 0);
}
TCGv_i64 tmp_48 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_48, tmp_40, tmp_47);
TCGv_i64 tmp_49 = tcg_temp_new_i64();
TCGv_i32 tmp_50 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_50, tmp_49, tmp_48, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_50);
tcg_gen_deposit_i64(RddV, RddV, tmp_49, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_51 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_51, RssV, ((int32_t) 0x6) * 8, 8);
TCGv_i64 tmp_52 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_52, RttV, ((int32_t) 0x6) * 8, 8);
TCGv_i32 tmp_53 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_53, tmp_51);
TCGv_i32 tmp_54 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_54, tmp_52);
TCGv_i32 tmp_55 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_55, tmp_53, tmp_54);
TCGv_i64 tmp_56 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_56, tmp_55);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_57 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_57, tmp_56, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_57, 0);
}
TCGv_i64 tmp_58 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_58, RssV, ((int32_t) 0x7) * 8, 8);
TCGv_i64 tmp_59 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_59, RttV, ((int32_t) 0x7) * 8, 8);
TCGv_i32 tmp_60 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_60, tmp_58);
TCGv_i32 tmp_61 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_61, tmp_59);
TCGv_i32 tmp_62 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_62, tmp_60, tmp_61);
TCGv_i64 tmp_63 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_63, tmp_62);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_64 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_64, tmp_63, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_64, 0);
}
TCGv_i64 tmp_65 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_65, tmp_57, tmp_64);
TCGv_i64 tmp_66 = tcg_temp_new_i64();
TCGv_i32 tmp_67 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_67, tmp_66, tmp_65, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_67);
tcg_gen_deposit_i64(RddV, RddV, tmp_66, ((int32_t) 0x3) * 16, 16);
}

void emit_M5_vdmacbsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RxxV,fSATN(16,(fGETHALF(0,RxxV) + fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV))))); fSETHALF(1,RxxV,fSATN(16,(fGETHALF(1,RxxV) + fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV))))); fSETHALF(2,RxxV,fSATN(16,(fGETHALF(2,RxxV) + fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV))))); fSETHALF(3,RxxV,fSATN(16,(fGETHALF(3,RxxV) + fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV))))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 8, 8);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x0) * 8, 8);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_0, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RssV, ((int32_t) 0x1) * 8, 8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_10, RttV, ((int32_t) 0x1) * 8, 8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_13, tmp_11, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_14, tmp_13);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_15, tmp_14, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_15, 0);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_16, tmp_8, tmp_15);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
TCGv_i32 tmp_18 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_18, tmp_17, tmp_16, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_18);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_17, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_19, RxxV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, RssV, ((int32_t) 0x2) * 8, 8);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_21, RttV, ((int32_t) 0x2) * 8, 8);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_22, tmp_20);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_23, tmp_21);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_24, tmp_22, tmp_23);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_25, tmp_24);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_26, tmp_25, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_26, 0);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_27, tmp_19, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_28, RssV, ((int32_t) 0x3) * 8, 8);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_29, RttV, ((int32_t) 0x3) * 8, 8);
TCGv_i32 tmp_30 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_30, tmp_28);
TCGv_i32 tmp_31 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_31, tmp_29);
TCGv_i32 tmp_32 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_32, tmp_30, tmp_31);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_33, tmp_32);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_34, tmp_33, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_34, 0);
}
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_35, tmp_27, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
TCGv_i32 tmp_37 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_37, tmp_36, tmp_35, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_37);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_36, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_38 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_38, RxxV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_39, RssV, ((int32_t) 0x4) * 8, 8);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_40, RttV, ((int32_t) 0x4) * 8, 8);
TCGv_i32 tmp_41 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_41, tmp_39);
TCGv_i32 tmp_42 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_42, tmp_40);
TCGv_i32 tmp_43 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_43, tmp_41, tmp_42);
TCGv_i64 tmp_44 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_44, tmp_43);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_45 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_45, tmp_44, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_45, 0);
}
TCGv_i64 tmp_46 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_46, tmp_38, tmp_45);
TCGv_i64 tmp_47 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_47, RssV, ((int32_t) 0x5) * 8, 8);
TCGv_i64 tmp_48 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_48, RttV, ((int32_t) 0x5) * 8, 8);
TCGv_i32 tmp_49 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_49, tmp_47);
TCGv_i32 tmp_50 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_50, tmp_48);
TCGv_i32 tmp_51 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_51, tmp_49, tmp_50);
TCGv_i64 tmp_52 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_52, tmp_51);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_53 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_53, tmp_52, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_53, 0);
}
TCGv_i64 tmp_54 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_54, tmp_46, tmp_53);
TCGv_i64 tmp_55 = tcg_temp_new_i64();
TCGv_i32 tmp_56 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_56, tmp_55, tmp_54, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_56);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_55, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_57 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_57, RxxV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_58 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_58, RssV, ((int32_t) 0x6) * 8, 8);
TCGv_i64 tmp_59 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_59, RttV, ((int32_t) 0x6) * 8, 8);
TCGv_i32 tmp_60 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_60, tmp_58);
TCGv_i32 tmp_61 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_61, tmp_59);
TCGv_i32 tmp_62 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_62, tmp_60, tmp_61);
TCGv_i64 tmp_63 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_63, tmp_62);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_64 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_64, tmp_63, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_64, 0);
}
TCGv_i64 tmp_65 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_65, tmp_57, tmp_64);
TCGv_i64 tmp_66 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_66, RssV, ((int32_t) 0x7) * 8, 8);
TCGv_i64 tmp_67 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_67, RttV, ((int32_t) 0x7) * 8, 8);
TCGv_i32 tmp_68 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_68, tmp_66);
TCGv_i32 tmp_69 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_69, tmp_67);
TCGv_i32 tmp_70 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_70, tmp_68, tmp_69);
TCGv_i64 tmp_71 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_71, tmp_70);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_72 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_72, tmp_71, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_72, 0);
}
TCGv_i64 tmp_73 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_73, tmp_65, tmp_72);
TCGv_i64 tmp_74 = tcg_temp_new_i64();
TCGv_i32 tmp_75 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_75, tmp_74, tmp_73, 16);
gen_set_usr_field_if(ctx, USR_OVF,tmp_75);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_74, ((int32_t) 0x3) * 16, 16);
}

void emit_M2_vdmacs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, tmp_0, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_18, tmp_9, tmp_17);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
TCGv_i32 tmp_20 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_20, tmp_19, tmp_18, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_20);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_19, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_22);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_5);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_21, tmp_29);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_31, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_32, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_31);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_34, tmp_32);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_35, tmp_33, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_36, tmp_35);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_37, tmp_36, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_37, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_38 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_38, 0);
} else {
tcg_gen_shli_i64(tmp_38, tmp_37, qemu_tmp_7);
}
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_39, tmp_30, tmp_38);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
TCGv_i32 tmp_41 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_41, tmp_40, tmp_39, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_41);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_40, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vdmacs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, tmp_0, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_10);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_18, tmp_9, tmp_17);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
TCGv_i32 tmp_20 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_20, tmp_19, tmp_18, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_20);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_19, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_22);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_5);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_21, tmp_29);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_31, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_32, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_31);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_34, tmp_32);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_35, tmp_33, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_36, tmp_35);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_37, tmp_36, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_37, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_38 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_38, 0);
} else {
tcg_gen_shli_i64(tmp_38, tmp_37, qemu_tmp_7);
}
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_39, tmp_30, tmp_38);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
TCGv_i32 tmp_41 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_41, tmp_40, tmp_39, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_41);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_40, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vdmpys_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_3);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_16, tmp_7, tmp_15);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
TCGv_i32 tmp_18 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_18, tmp_17, tmp_16, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_18);
tcg_gen_deposit_i64(RddV, RddV, tmp_17, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_19, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_19);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_22, tmp_20);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_23, tmp_21, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_24, tmp_23);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_25, tmp_24, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_25, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_26, 0);
} else {
tcg_gen_shli_i64(tmp_26, tmp_25, qemu_tmp_5);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_27, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_28, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_29, tmp_27);
TCGv_i32 tmp_30 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_30, tmp_28);
TCGv_i32 tmp_31 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_31, tmp_29, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_32, tmp_31);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_33, tmp_32, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_33, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_34, 0);
} else {
tcg_gen_shli_i64(tmp_34, tmp_33, qemu_tmp_7);
}
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_35, tmp_26, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
TCGv_i32 tmp_37 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_37, tmp_36, tmp_35, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_37);
tcg_gen_deposit_i64(RddV, RddV, tmp_36, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vdmpys_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_3);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_16, tmp_7, tmp_15);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
TCGv_i32 tmp_18 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_18, tmp_17, tmp_16, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_18);
tcg_gen_deposit_i64(RddV, RddV, tmp_17, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_19, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_19);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_22, tmp_20);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_23, tmp_21, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_24, tmp_23);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_25, tmp_24, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_25, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_26, 0);
} else {
tcg_gen_shli_i64(tmp_26, tmp_25, qemu_tmp_5);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_27, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_28, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_29, tmp_27);
TCGv_i32 tmp_30 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_30, tmp_28);
TCGv_i32 tmp_31 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_31, tmp_29, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_32, tmp_31);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_33, tmp_32, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_33, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_34, 0);
} else {
tcg_gen_shli_i64(tmp_34, tmp_33, qemu_tmp_7);
}
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_35, tmp_26, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
TCGv_i32 tmp_37 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_37, tmp_36, tmp_35, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_37);
tcg_gen_deposit_i64(RddV, RddV, tmp_36, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_cmpyrs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0) + 0x8000))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_12, tmp_5, tmp_11);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_13, tmp_12, qemu_tmp_4);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, tmp_14, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_16);
tcg_gen_deposit_i32(RdV, RdV, tmp_17, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_6);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_8);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_30, tmp_23, tmp_29);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_31, tmp_30, qemu_tmp_9);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, tmp_32, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_35, tmp_34);
tcg_gen_deposit_i32(RdV, RdV, tmp_35, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_cmpyrs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_12, tmp_5, tmp_11);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_13, tmp_12, qemu_tmp_4);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, tmp_14, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_16);
tcg_gen_deposit_i32(RdV, RdV, tmp_17, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_6);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_8);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_30, tmp_23, tmp_29);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_31, tmp_30, qemu_tmp_9);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, tmp_32, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_35, tmp_34);
tcg_gen_deposit_i32(RdV, RdV, tmp_35, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_cmpyrsc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0) + 0x8000))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_12, tmp_5, tmp_11);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_13, tmp_12, qemu_tmp_4);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, tmp_14, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_16);
tcg_gen_deposit_i32(RdV, RdV, tmp_17, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_6);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_8);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_23, tmp_29);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_31, tmp_30, qemu_tmp_9);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, tmp_32, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_35, tmp_34);
tcg_gen_deposit_i32(RdV, RdV, tmp_35, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_cmpyrsc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000))));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_12, tmp_5, tmp_11);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_13, tmp_12, qemu_tmp_4);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, tmp_14, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_16);
tcg_gen_deposit_i32(RdV, RdV, tmp_17, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_6);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_8);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_23, tmp_29);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_31, tmp_30, qemu_tmp_9);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, tmp_32, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_35, tmp_34);
tcg_gen_deposit_i32(RdV, RdV, tmp_35, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_cmacs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_7, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_24, tmp_17, tmp_23);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_26, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_30, 0);
} else {
tcg_gen_shli_i64(tmp_30, tmp_29, qemu_tmp_7);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_24, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cmacs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_7, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_24, tmp_17, tmp_23);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_26, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_30, 0);
} else {
tcg_gen_shli_i64(tmp_30, tmp_29, qemu_tmp_7);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_24, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cmacsc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_7, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_24, tmp_17, tmp_23);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_26, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_30, 0);
} else {
tcg_gen_shli_i64(tmp_30, tmp_29, qemu_tmp_7);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_31, tmp_24, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cmacsc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_9, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_10, tmp_8, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_11, tmp_10);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_12, tmp_11, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_12, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_3);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_7, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_24, tmp_17, tmp_23);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_26, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_30, 0);
} else {
tcg_gen_shli_i64(tmp_30, tmp_29, qemu_tmp_7);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_31, tmp_24, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cmpys_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_12, tmp_5, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
TCGv_i32 tmp_14 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_14, tmp_13, tmp_12, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_14);
tcg_gen_deposit_i64(RddV, RddV, tmp_13, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_15, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_16, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_20, 0);
} else {
tcg_gen_shli_i64(tmp_20, tmp_19, qemu_tmp_5);
}
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_21, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_22, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_23, tmp_21, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_24, tmp_23);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_25, tmp_24, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_25, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_26, 0);
} else {
tcg_gen_shli_i64(tmp_26, tmp_25, qemu_tmp_7);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_27, tmp_20, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
TCGv_i32 tmp_29 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_29, tmp_28, tmp_27, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_29);
tcg_gen_deposit_i64(RddV, RddV, tmp_28, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cmpys_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_12, tmp_5, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
TCGv_i32 tmp_14 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_14, tmp_13, tmp_12, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_14);
tcg_gen_deposit_i64(RddV, RddV, tmp_13, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_15, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_16, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_20, 0);
} else {
tcg_gen_shli_i64(tmp_20, tmp_19, qemu_tmp_5);
}
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_21, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_22, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_23, tmp_21, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_24, tmp_23);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_25, tmp_24, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_25, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_26, 0);
} else {
tcg_gen_shli_i64(tmp_26, tmp_25, qemu_tmp_7);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_27, tmp_20, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
TCGv_i32 tmp_29 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_29, tmp_28, tmp_27, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_29);
tcg_gen_deposit_i64(RddV, RddV, tmp_28, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cmpysc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_12, tmp_5, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
TCGv_i32 tmp_14 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_14, tmp_13, tmp_12, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_14);
tcg_gen_deposit_i64(RddV, RddV, tmp_13, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_15, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_16, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_20, 0);
} else {
tcg_gen_shli_i64(tmp_20, tmp_19, qemu_tmp_5);
}
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_21, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_22, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_23, tmp_21, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_24, tmp_23);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_25, tmp_24, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_25, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_26, 0);
} else {
tcg_gen_shli_i64(tmp_26, tmp_25, qemu_tmp_7);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_27, tmp_20, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
TCGv_i32 tmp_29 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_29, tmp_28, tmp_27, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_29);
tcg_gen_deposit_i64(RddV, RddV, tmp_28, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cmpysc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_5, 0);
} else {
tcg_gen_shli_i64(tmp_5, tmp_4, qemu_tmp_1);
}
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_12, tmp_5, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
TCGv_i32 tmp_14 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_14, tmp_13, tmp_12, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_14);
tcg_gen_deposit_i64(RddV, RddV, tmp_13, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_15, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_16, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_17, tmp_15, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_18, tmp_17);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_19, tmp_18, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_19, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_20, 0);
} else {
tcg_gen_shli_i64(tmp_20, tmp_19, qemu_tmp_5);
}
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_21, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_22, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_23, tmp_21, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_24, tmp_23);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_25, tmp_24, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_25, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_26, 0);
} else {
tcg_gen_shli_i64(tmp_26, tmp_25, qemu_tmp_7);
}
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_27, tmp_20, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
TCGv_i32 tmp_29 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_29, tmp_28, tmp_27, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_29);
tcg_gen_deposit_i64(RddV, RddV, tmp_28, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cnacs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0))));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_9, tmp_7, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_10, tmp_9);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_11, tmp_10, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_11, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_12, 0);
} else {
tcg_gen_shli_i64(tmp_12, tmp_11, qemu_tmp_3);
}
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_13, tmp_6, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_0, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_7);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_30, tmp_23, tmp_29);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_17, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cnacs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1))));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_9, tmp_7, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_10, tmp_9);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_11, tmp_10, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_11, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_12, 0);
} else {
tcg_gen_shli_i64(tmp_12, tmp_11, qemu_tmp_3);
}
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_13, tmp_6, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_0, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_7);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_30, tmp_23, tmp_29);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_17, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cnacsc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0))));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_9, tmp_7, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_10, tmp_9);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_11, tmp_10, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_11, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_12, 0);
} else {
tcg_gen_shli_i64(tmp_12, tmp_11, qemu_tmp_3);
}
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_13, tmp_6, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_0, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_7);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_23, tmp_29);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_17, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_cnacsc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1))));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_2, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_3, tmp_1, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_4, tmp_3);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_5, tmp_4, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_5, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_6, 0);
} else {
tcg_gen_shli_i64(tmp_6, tmp_5, qemu_tmp_1);
}
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_8, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_9, tmp_7, tmp_8);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_10, tmp_9);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_11, tmp_10, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_11, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_12, 0);
} else {
tcg_gen_shli_i64(tmp_12, tmp_11, qemu_tmp_3);
}
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_13, tmp_6, tmp_12);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_0, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
TCGv_i32 tmp_16 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_16, tmp_15, tmp_14, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_16);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_15, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_18, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_19, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_23, 0);
} else {
tcg_gen_shli_i64(tmp_23, tmp_22, qemu_tmp_5);
}
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_24, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_25, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_7);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_23, tmp_29);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_17, tmp_30);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
TCGv_i32 tmp_33 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_33, tmp_32, tmp_31, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_33);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_32, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_vrcmpys_s1_h(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, tmp_1, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, tmp_10, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_9);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_18, tmp_8, tmp_17);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
TCGv_i32 tmp_20 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_20, tmp_19, tmp_18, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_20);
tcg_gen_deposit_i64(RddV, RddV, tmp_19, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, tmp_22, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_21);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_5);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_30, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_31, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_32, tmp_31, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_30);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_34, tmp_32);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_35, tmp_33, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_36, tmp_35);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_37, tmp_36, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_37, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_38 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_38, 0);
} else {
tcg_gen_shli_i64(tmp_38, tmp_37, qemu_tmp_7);
}
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_39, tmp_29, tmp_38);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
TCGv_i32 tmp_41 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_41, tmp_40, tmp_39, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_41);
tcg_gen_deposit_i64(RddV, RddV, tmp_40, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_vrcmpys_s1_l(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, tmp_1, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, tmp_10, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_9);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_18, tmp_8, tmp_17);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
TCGv_i32 tmp_20 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_20, tmp_19, tmp_18, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_20);
tcg_gen_deposit_i64(RddV, RddV, tmp_19, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, tmp_22, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_21);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_26, tmp_24, tmp_25);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_27, tmp_26);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_28, tmp_27, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_28, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_29, 0);
} else {
tcg_gen_shli_i64(tmp_29, tmp_28, qemu_tmp_5);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_30, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_31, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_32, tmp_31, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_33 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_33, tmp_30);
TCGv_i32 tmp_34 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_34, tmp_32);
TCGv_i32 tmp_35 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_35, tmp_33, tmp_34);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_36, tmp_35);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_37 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_37, tmp_36, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_37, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_38 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_38, 0);
} else {
tcg_gen_shli_i64(tmp_38, tmp_37, qemu_tmp_7);
}
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_39, tmp_29, tmp_38);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
TCGv_i32 tmp_41 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_41, tmp_40, tmp_39, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_41);
tcg_gen_deposit_i64(RddV, RddV, tmp_40, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_vrcmpys_acc_s1_h(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_3, tmp_2, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_1);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_3);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_6, tmp_4, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_7, tmp_6);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_8, tmp_7, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_8, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_9, 0);
} else {
tcg_gen_shli_i64(tmp_9, tmp_8, qemu_tmp_1);
}
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_10, tmp_0, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_13, tmp_12, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_14, tmp_11);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_15, tmp_13);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_16, tmp_14, tmp_15);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_17, tmp_16);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_18, tmp_17, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_18, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_19, 0);
} else {
tcg_gen_shli_i64(tmp_19, tmp_18, qemu_tmp_3);
}
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_20, tmp_10, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
TCGv_i32 tmp_22 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_22, tmp_21, tmp_20, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_22);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_21, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, tmp_25, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_24);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_32, 0);
} else {
tcg_gen_shli_i64(tmp_32, tmp_31, qemu_tmp_5);
}
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_33, tmp_23, tmp_32);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_35, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_36, tmp_35, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_37 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_37, tmp_34);
TCGv_i32 tmp_38 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_38, tmp_36);
TCGv_i32 tmp_39 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_39, tmp_37, tmp_38);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_40, tmp_39);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_41 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_41, tmp_40, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_41, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_42 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_42, 0);
} else {
tcg_gen_shli_i64(tmp_42, tmp_41, qemu_tmp_7);
}
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_43, tmp_33, tmp_42);
TCGv_i64 tmp_44 = tcg_temp_new_i64();
TCGv_i32 tmp_45 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_45, tmp_44, tmp_43, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_45);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_44, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_vrcmpys_acc_s1_l(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_3, tmp_2, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_1);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_5, tmp_3);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_6, tmp_4, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_7, tmp_6);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_8, tmp_7, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_8, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_9, 0);
} else {
tcg_gen_shli_i64(tmp_9, tmp_8, qemu_tmp_1);
}
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_10, tmp_0, tmp_9);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_13, tmp_12, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_14, tmp_11);
TCGv_i32 tmp_15 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_15, tmp_13);
TCGv_i32 tmp_16 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_16, tmp_14, tmp_15);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_17, tmp_16);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_18, tmp_17, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_18, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_19, 0);
} else {
tcg_gen_shli_i64(tmp_19, tmp_18, qemu_tmp_3);
}
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_20, tmp_10, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
TCGv_i32 tmp_22 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_22, tmp_21, tmp_20, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_22);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_21, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, tmp_25, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_24);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_32, 0);
} else {
tcg_gen_shli_i64(tmp_32, tmp_31, qemu_tmp_5);
}
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_33, tmp_23, tmp_32);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_35, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_36, tmp_35, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_37 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_37, tmp_34);
TCGv_i32 tmp_38 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_38, tmp_36);
TCGv_i32 tmp_39 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_39, tmp_37, tmp_38);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_40, tmp_39);
uint64_t qemu_tmp_6 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_41 = tcg_temp_new_i64();
if (qemu_tmp_6 != 0) {
tcg_gen_sextract_i64(tmp_41, tmp_40, 0, qemu_tmp_6);
} else {
tcg_gen_movi_i64(tmp_41, 0);
}
int64_t qemu_tmp_7 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_42 = tcg_temp_new_i64();
if (qemu_tmp_7 >= 64) {
tcg_gen_movi_i64(tmp_42, 0);
} else {
tcg_gen_shli_i64(tmp_42, tmp_41, qemu_tmp_7);
}
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_43, tmp_33, tmp_42);
TCGv_i64 tmp_44 = tcg_temp_new_i64();
TCGv_i32 tmp_45 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_45, tmp_44, tmp_43, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_45);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_44, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_vrcmpys_s1rp_h(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(1,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1) + 0x8000))); fSETHALF(0,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1) + 0x8000)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, tmp_1, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, tmp_10, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_9);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_18, tmp_8, tmp_17);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_19, tmp_18, qemu_tmp_4);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
TCGv_i32 tmp_21 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_21, tmp_20, tmp_19, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_21);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, tmp_20, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_23, tmp_22);
tcg_gen_deposit_i32(RdV, RdV, tmp_23, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, tmp_25, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_24);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_32, 0);
} else {
tcg_gen_shli_i64(tmp_32, tmp_31, qemu_tmp_6);
}
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_33, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, RttV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_35, tmp_34, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_36 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_36, tmp_33);
TCGv_i32 tmp_37 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_37, tmp_35);
TCGv_i32 tmp_38 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_38, tmp_36, tmp_37);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_39, tmp_38);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_40, tmp_39, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_40, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_41 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_41, 0);
} else {
tcg_gen_shli_i64(tmp_41, tmp_40, qemu_tmp_8);
}
TCGv_i64 tmp_42 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_42, tmp_32, tmp_41);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_43, tmp_42, qemu_tmp_9);
TCGv_i64 tmp_44 = tcg_temp_new_i64();
TCGv_i32 tmp_45 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_45, tmp_44, tmp_43, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_45);
TCGv_i64 tmp_46 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_46, tmp_44, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_47 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_47, tmp_46);
tcg_gen_deposit_i32(RdV, RdV, tmp_47, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_vrcmpys_s1rp_l(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(1,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1) + 0x8000))); fSETHALF(0,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1) + 0x8000)));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, tmp_1, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_0);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_8, 0);
} else {
tcg_gen_shli_i64(tmp_8, tmp_7, qemu_tmp_1);
}
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, tmp_10, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_12, tmp_9);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
TCGv_i32 tmp_14 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_14, tmp_12, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_15, tmp_14);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_16, tmp_15, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_16, 0);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_17, 0);
} else {
tcg_gen_shli_i64(tmp_17, tmp_16, qemu_tmp_3);
}
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_18, tmp_8, tmp_17);
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_19, tmp_18, qemu_tmp_4);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
TCGv_i32 tmp_21 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_21, tmp_20, tmp_19, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_21);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, tmp_20, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_23, tmp_22);
tcg_gen_deposit_i32(RdV, RdV, tmp_23, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, tmp_25, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_24);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_5 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_5 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_5);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
int64_t qemu_tmp_6 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_32 = tcg_temp_new_i64();
if (qemu_tmp_6 >= 64) {
tcg_gen_movi_i64(tmp_32, 0);
} else {
tcg_gen_shli_i64(tmp_32, tmp_31, qemu_tmp_6);
}
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_33, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_34, RttV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_35, tmp_34, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_36 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_36, tmp_33);
TCGv_i32 tmp_37 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_37, tmp_35);
TCGv_i32 tmp_38 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_38, tmp_36, tmp_37);
TCGv_i64 tmp_39 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_39, tmp_38);
uint64_t qemu_tmp_7 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_40 = tcg_temp_new_i64();
if (qemu_tmp_7 != 0) {
tcg_gen_sextract_i64(tmp_40, tmp_39, 0, qemu_tmp_7);
} else {
tcg_gen_movi_i64(tmp_40, 0);
}
int64_t qemu_tmp_8 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_41 = tcg_temp_new_i64();
if (qemu_tmp_8 >= 64) {
tcg_gen_movi_i64(tmp_41, 0);
} else {
tcg_gen_shli_i64(tmp_41, tmp_40, qemu_tmp_8);
}
TCGv_i64 tmp_42 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_42, tmp_32, tmp_41);
int64_t qemu_tmp_9 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_43 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_43, tmp_42, qemu_tmp_9);
TCGv_i64 tmp_44 = tcg_temp_new_i64();
TCGv_i32 tmp_45 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_45, tmp_44, tmp_43, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_45);
TCGv_i64 tmp_46 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_46, tmp_44, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_47 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_47, tmp_46);
tcg_gen_deposit_i32(RdV, RdV, tmp_47, ((int32_t) 0x0) * 16, 16);
}

void emit_M2_mmacls_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0))>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmacls_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1))>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmachs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0))>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmachs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1))>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmacls_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0)+0x8000)>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmacls_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1)+0x8000)>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmachs_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0)+0x8000)>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmachs_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1)+0x8000)>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_12, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyl_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyl_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyh_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyh_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M4_vrmpyeh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
tcg_gen_mov_i64(RddV, tmp_8);
}

void emit_M4_vrmpyeh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
tcg_gen_mov_i64(RddV, tmp_8);
}

void emit_M4_vrmpyeh_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, RxxV, tmp_8);
tcg_gen_mov_i64(RxxV, tmp_9);
}

void emit_M4_vrmpyeh_acc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, RxxV, tmp_8);
tcg_gen_mov_i64(RxxV, tmp_9);
}

void emit_M4_vrmpyoh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
tcg_gen_mov_i64(RddV, tmp_8);
}

void emit_M4_vrmpyoh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
tcg_gen_mov_i64(RddV, tmp_8);
}

void emit_M4_vrmpyoh_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, RxxV, tmp_8);
tcg_gen_mov_i64(RxxV, tmp_9);
}

void emit_M4_vrmpyoh_acc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1);} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_5, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_6, tmp_4, tmp_5);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_1 >= 64) {
tcg_gen_movi_i64(tmp_7, 0);
} else {
tcg_gen_shli_i64(tmp_7, tmp_6, qemu_tmp_1);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_9, RxxV, tmp_8);
tcg_gen_mov_i64(RxxV, tmp_9);
}

void emit_M2_hmmpyl_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(0,RtV)) << 1)+0x8000)>>16); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RsV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RdV, tmp_9);
}

void emit_M2_hmmpyh_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(1,RtV)) << 1)+0x8000)>>16); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RsV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
tcg_gen_mov_i32(RdV, tmp_9);
}

void emit_M2_hmmpyl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(0,RtV)) << 1))>>16); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RsV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_hmmpyh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(1,RtV)) << 1))>>16); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_1, RsV);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_8, tmp_6);
tcg_gen_mov_i32(RdV, tmp_8);
}

void emit_M2_mmaculs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0))>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_11, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmaculs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1))>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_11, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmacuhs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0))>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_11, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmacuhs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1))>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_6, tmp_0, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
TCGv_i32 tmp_8 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_8, tmp_7, tmp_6, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_8);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_7, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_11, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_12, tmp_10, tmp_11);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_13, 0);
} else {
tcg_gen_shli_i64(tmp_13, tmp_12, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_14, tmp_13, shift);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_9, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_16, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyul_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_8, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyul_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_8, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyuh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyuh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1))>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_4, tmp_3, shift);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
TCGv_i32 tmp_6 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_6, tmp_5, tmp_4, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_6);
tcg_gen_deposit_i64(RddV, RddV, tmp_5, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_9, tmp_7, tmp_8);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_10, 0);
} else {
tcg_gen_shli_i64(tmp_10, tmp_9, qemu_tmp_2);
}
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_3;
if (qemu_tmp_3 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_11, tmp_10, shift);
}
TCGv_i64 tmp_12 = tcg_temp_new_i64();
TCGv_i32 tmp_13 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_13, tmp_12, tmp_11, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_13);
tcg_gen_deposit_i64(RddV, RddV, tmp_12, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmaculs_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0)+0x8000)>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_12, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmaculs_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1)+0x8000)>>16)) ); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_12, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmacuhs_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0)+0x8000)>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_12, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmacuhs_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1)+0x8000)>>16 ))); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_2, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_1, tmp_2);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_4, 0);
} else {
tcg_gen_shli_i64(tmp_4, tmp_3, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_5, tmp_4, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_6, tmp_5, shift);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, tmp_0, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
TCGv_i32 tmp_9 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_9, tmp_8, tmp_7, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_9);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_8, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_10, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_11, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_12, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_13, tmp_11, tmp_12);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_14, 0);
} else {
tcg_gen_shli_i64(tmp_14, tmp_13, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_15, tmp_14, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_16, tmp_15, shift);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_10, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyul_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_9, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyul_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_9, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyuh_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_mmpyuh_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1)+0x8000)>>16)); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_1, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_2, tmp_0, tmp_1);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
if (qemu_tmp_0 >= 64) {
tcg_gen_movi_i64(tmp_3, 0);
} else {
tcg_gen_shli_i64(tmp_3, tmp_2, qemu_tmp_0);
}
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_4, tmp_3, qemu_tmp_1);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_2;
if (qemu_tmp_2 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_5, tmp_4, shift);
}
TCGv_i64 tmp_6 = tcg_temp_new_i64();
TCGv_i32 tmp_7 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_7, tmp_6, tmp_5, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_7);
tcg_gen_deposit_i64(RddV, RddV, tmp_6, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_extract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_10, tmp_8, tmp_9);
int64_t qemu_tmp_3 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_11 = tcg_temp_new_i64();
if (qemu_tmp_3 >= 64) {
tcg_gen_movi_i64(tmp_11, 0);
} else {
tcg_gen_shli_i64(tmp_11, tmp_10, qemu_tmp_3);
}
int64_t qemu_tmp_4 = (int64_t)((int32_t) 0x8000);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_12, tmp_11, qemu_tmp_4);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x10);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_5;
if (qemu_tmp_5 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_13, tmp_12, shift);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
TCGv_i32 tmp_15 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_15, tmp_14, tmp_13, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_15);
tcg_gen_deposit_i64(RddV, RddV, tmp_14, ((int32_t) 0x0) * 32, 32);
}

void emit_M2_vrcmaci_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, RxxV, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_7, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_23, tmp_15, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_28, tmp_26, tmp_27);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_29, tmp_28);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_30, tmp_29, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_30, 0);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_31, tmp_23, tmp_30);
tcg_gen_mov_i64(RxxV, tmp_31);
}

void emit_M2_vrcmacr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, RxxV, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_15, tmp_7, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_23, tmp_15, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_28, tmp_26, tmp_27);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_29, tmp_28);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_30, tmp_29, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_30, 0);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_23, tmp_30);
tcg_gen_mov_i64(RxxV, tmp_31);
}

void emit_M2_vrcmaci_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, RxxV, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_15, tmp_7, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_23, tmp_15, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_28, tmp_26, tmp_27);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_29, tmp_28);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_30, tmp_29, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_30, 0);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_31, tmp_23, tmp_30);
tcg_gen_mov_i64(RxxV, tmp_31);
}

void emit_M2_vrcmacr_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_7, RxxV, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_7, tmp_14);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_17, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_19, tmp_17);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_20, tmp_18, tmp_19);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_21, tmp_20);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_22, tmp_21, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_22, 0);
}
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_23, tmp_15, tmp_22);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_28, tmp_26, tmp_27);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_29, tmp_28);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_30, tmp_29, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_30, 0);
}
TCGv_i64 tmp_31 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_31, tmp_23, tmp_30);
tcg_gen_mov_i64(RxxV, tmp_31);
}

void emit_M2_cmaci_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) + fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_11, tmp_5, tmp_10);
tcg_gen_mov_i64(RxxV, tmp_11);
}

void emit_M2_cmacr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) - fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_5, RxxV, tmp_4);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_7, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_8 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_8, tmp_6, tmp_7);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_9, tmp_8);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_10, tmp_9, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_10, 0);
}
TCGv_i64 tmp_11 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_11, tmp_5, tmp_10);
tcg_gen_mov_i64(RxxV, tmp_11);
}

void emit_M2_vrcmpyi_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_15, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_15);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_19, tmp_17, tmp_18);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_20, tmp_19);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_21, tmp_20, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_21, 0);
}
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_22, tmp_14, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_22, tmp_29);
tcg_gen_mov_i64(RddV, tmp_30);
}

void emit_M2_vrcmpyr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_15, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_15);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_19, tmp_17, tmp_18);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_20, tmp_19);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_21, tmp_20, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_21, 0);
}
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_22, tmp_14, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_30, tmp_22, tmp_29);
tcg_gen_mov_i64(RddV, tmp_30);
}

void emit_M2_vrcmpyi_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_15, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_15);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_19, tmp_17, tmp_18);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_20, tmp_19);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_21, tmp_20, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_21, 0);
}
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_22, tmp_14, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_30, tmp_22, tmp_29);
tcg_gen_mov_i64(RddV, tmp_30);
}

void emit_M2_vrcmpyr_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_15, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_16, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_17 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_17, tmp_15);
TCGv_i32 tmp_18 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_18, tmp_16);
TCGv_i32 tmp_19 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_19, tmp_17, tmp_18);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_20, tmp_19);
uint64_t qemu_tmp_2 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
if (qemu_tmp_2 != 0) {
tcg_gen_sextract_i64(tmp_21, tmp_20, 0, qemu_tmp_2);
} else {
tcg_gen_movi_i64(tmp_21, 0);
}
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_22, tmp_14, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_23, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_24, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_25, tmp_23);
TCGv_i32 tmp_26 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_26, tmp_24);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_27, tmp_25, tmp_26);
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_28, tmp_27);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_29, tmp_28, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_29, 0);
}
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_30, tmp_22, tmp_29);
tcg_gen_mov_i64(RddV, tmp_30);
}

void emit_M2_cmpyi_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RddV = fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) + fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_7, tmp_5, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_8, tmp_7);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_9, tmp_8, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_9, 0);
}
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_10, tmp_4, tmp_9);
tcg_gen_mov_i64(RddV, tmp_10);
}

void emit_M2_cmpyr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RddV = fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) - fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)); } */
{
TCGv_i32 tmp_0 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_0, RsV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_2, tmp_0, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_3, tmp_2);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_4, tmp_3, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_4, 0);
}
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RsV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_6 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_6, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_7 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_7, tmp_5, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_8, tmp_7);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_9, tmp_8, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_9, 0);
}
TCGv_i64 tmp_10 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_10, tmp_4, tmp_9);
tcg_gen_mov_i64(RddV, tmp_10);
}

void emit_M4_cmpyi_wh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RtV)) + fMPY3216SS(fGETWORD(1,RssV),fGETHALF(0,RtV)) + 0x4000)>>15); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_0, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_7, tmp_4, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x4000);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_9, tmp_8, qemu_tmp_0);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0xf);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_10, tmp_9, shift);
}
TCGv_i64 tmp_11 = tcg_temp_new_i64();
TCGv_i32 tmp_12 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_12, tmp_11, tmp_10, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_12);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
tcg_gen_mov_i32(RdV, tmp_13);
}

void emit_M4_cmpyr_wh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RtV)) - fMPY3216SS(fGETWORD(1,RssV),fGETHALF(1,RtV)) + 0x4000)>>15); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_0, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_7, tmp_4, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_8, tmp_3, tmp_7);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x4000);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_9, tmp_8, qemu_tmp_0);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0xf);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_10, tmp_9, shift);
}
TCGv_i64 tmp_11 = tcg_temp_new_i64();
TCGv_i32 tmp_12 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_12, tmp_11, tmp_10, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_12);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
tcg_gen_mov_i32(RdV, tmp_13);
}

void emit_M4_cmpyi_whc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(1,RssV),fGETHALF(0,RtV)) - fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RtV)) + 0x4000)>>15); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_0, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_7, tmp_4, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_8, tmp_3, tmp_7);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x4000);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_9, tmp_8, qemu_tmp_0);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0xf);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_10, tmp_9, shift);
}
TCGv_i64 tmp_11 = tcg_temp_new_i64();
TCGv_i32 tmp_12 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_12, tmp_11, tmp_10, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_12);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
tcg_gen_mov_i32(RdV, tmp_13);
}

void emit_M4_cmpyr_whc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RtV)) + fMPY3216SS(fGETWORD(1,RssV),fGETHALF(1,RtV)) + 0x4000)>>15); } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 32, 32);
TCGv_i32 tmp_1 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_1, RtV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_2, tmp_1);
TCGv_i64 tmp_3 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_3, tmp_0, tmp_2);
TCGv_i64 tmp_4 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_4, RssV, ((int32_t) 0x1) * 32, 32);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_sextract_i32(tmp_5, RtV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_mul_i64(tmp_7, tmp_4, tmp_6);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_8, tmp_3, tmp_7);
int64_t qemu_tmp_0 = (int64_t)((int32_t) 0x4000);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_addi_i64(tmp_9, tmp_8, qemu_tmp_0);
int64_t qemu_tmp_1 = (int64_t)((int32_t) 0xf);
TCGv_i64 tmp_10 = tcg_temp_new_i64();
{
int64_t shift = qemu_tmp_1;
if (qemu_tmp_1 >= 64) {
    shift = 64 - 1;
}
tcg_gen_sari_i64(tmp_10, tmp_9, shift);
}
TCGv_i64 tmp_11 = tcg_temp_new_i64();
TCGv_i32 tmp_12 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_12, tmp_11, tmp_10, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_12);
TCGv_i32 tmp_13 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_13, tmp_11);
tcg_gen_mov_i32(RdV, tmp_13);
}

void emit_M2_vcmpy_s0_sat_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV)) << 0)));; } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_2);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RddV, RddV, tmp_16, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_18, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_19, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_20, tmp_18);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_19);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_22, tmp_20, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_23, tmp_22);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_24, tmp_23, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_24, 0);
}
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_32, tmp_24, tmp_31);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_33, 0);
} else {
tcg_gen_shli_i64(tmp_33, tmp_32, qemu_tmp_5);
}
TCGv_i64 tmp_34 = tcg_temp_new_i64();
TCGv_i32 tmp_35 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_35, tmp_34, tmp_33, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_35);
tcg_gen_deposit_i64(RddV, RddV, tmp_34, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vcmpy_s0_sat_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));; } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_6, tmp_13);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_2);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RddV, RddV, tmp_16, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_18, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_19, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_20, tmp_18);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_19);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_22, tmp_20, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_23, tmp_22);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_24, tmp_23, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_24, 0);
}
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_32, tmp_24, tmp_31);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_33, 0);
} else {
tcg_gen_shli_i64(tmp_33, tmp_32, qemu_tmp_5);
}
TCGv_i64 tmp_34 = tcg_temp_new_i64();
TCGv_i32 tmp_35 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_35, tmp_34, tmp_33, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_35);
tcg_gen_deposit_i64(RddV, RddV, tmp_34, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vcmpy_s1_sat_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV)) << 1)));; } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_14, tmp_6, tmp_13);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_2);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RddV, RddV, tmp_16, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_18, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_19, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_20, tmp_18);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_19);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_22, tmp_20, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_23, tmp_22);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_24, tmp_23, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_24, 0);
}
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_32, tmp_24, tmp_31);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_33, 0);
} else {
tcg_gen_shli_i64(tmp_33, tmp_32, qemu_tmp_5);
}
TCGv_i64 tmp_34 = tcg_temp_new_i64();
TCGv_i32 tmp_35 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_35, tmp_34, tmp_33, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_35);
tcg_gen_deposit_i64(RddV, RddV, tmp_34, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vcmpy_s1_sat_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1)));; } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_2 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_2, tmp_0);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_4, tmp_2, tmp_3);
TCGv_i64 tmp_5 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_5, tmp_4);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_6, tmp_5, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_6, 0);
}
TCGv_i64 tmp_7 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_7, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_9 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_9, tmp_7);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_11, tmp_9, tmp_10);
TCGv_i64 tmp_12 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_12, tmp_11);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_13, tmp_12, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_13, 0);
}
TCGv_i64 tmp_14 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_14, tmp_6, tmp_13);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_15 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_15, 0);
} else {
tcg_gen_shli_i64(tmp_15, tmp_14, qemu_tmp_2);
}
TCGv_i64 tmp_16 = tcg_temp_new_i64();
TCGv_i32 tmp_17 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_17, tmp_16, tmp_15, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_17);
tcg_gen_deposit_i64(RddV, RddV, tmp_16, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_18, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_19 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_19, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_20 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_20, tmp_18);
TCGv_i32 tmp_21 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_21, tmp_19);
TCGv_i32 tmp_22 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_22, tmp_20, tmp_21);
TCGv_i64 tmp_23 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_23, tmp_22);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_24 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_24, tmp_23, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_24, 0);
}
TCGv_i64 tmp_25 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_25, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_26, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_27 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_27, tmp_25);
TCGv_i32 tmp_28 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_28, tmp_26);
TCGv_i32 tmp_29 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_29, tmp_27, tmp_28);
TCGv_i64 tmp_30 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_30, tmp_29);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_31 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_31, tmp_30, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_31, 0);
}
TCGv_i64 tmp_32 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_32, tmp_24, tmp_31);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x1);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_33, 0);
} else {
tcg_gen_shli_i64(tmp_33, tmp_32, qemu_tmp_5);
}
TCGv_i64 tmp_34 = tcg_temp_new_i64();
TCGv_i32 tmp_35 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_35, tmp_34, tmp_33, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_35);
tcg_gen_deposit_i64(RddV, RddV, tmp_34, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vcmac_s0_sat_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV)) << 0)));; } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_15, tmp_7, tmp_14);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_2);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_0, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RssV, ((int32_t) 0x3) * 16, 16);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_23, tmp_21);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_22);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_25, tmp_23, tmp_24);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_26, tmp_25);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_27, tmp_26, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_27, 0);
}
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_28, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_29 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_29, RttV, ((int32_t) 0x3) * 16, 16);
TCGv_i32 tmp_30 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_30, tmp_28);
TCGv_i32 tmp_31 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_31, tmp_29);
TCGv_i32 tmp_32 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_32, tmp_30, tmp_31);
TCGv_i64 tmp_33 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_33, tmp_32);
uint64_t qemu_tmp_4 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_34 = tcg_temp_new_i64();
if (qemu_tmp_4 != 0) {
tcg_gen_sextract_i64(tmp_34, tmp_33, 0, qemu_tmp_4);
} else {
tcg_gen_movi_i64(tmp_34, 0);
}
TCGv_i64 tmp_35 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_35, tmp_27, tmp_34);
int64_t qemu_tmp_5 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_36 = tcg_temp_new_i64();
if (qemu_tmp_5 >= 64) {
tcg_gen_movi_i64(tmp_36, 0);
} else {
tcg_gen_shli_i64(tmp_36, tmp_35, qemu_tmp_5);
}
TCGv_i64 tmp_37 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_37, tmp_20, tmp_36);
TCGv_i64 tmp_38 = tcg_temp_new_i64();
TCGv_i32 tmp_39 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_39, tmp_38, tmp_37, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_39);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_38, ((int32_t) 0x1) * 32, 32);
}

void emit_M2_vcmac_s0_sat_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));; } */
{
TCGv_i64 tmp_0 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_0, RxxV, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_1 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_1, RssV, ((int32_t) 0x0) * 16, 16);
TCGv_i64 tmp_2 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_2, RttV, ((int32_t) 0x0) * 16, 16);
TCGv_i32 tmp_3 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_3, tmp_1);
TCGv_i32 tmp_4 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_4, tmp_2);
TCGv_i32 tmp_5 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_5, tmp_3, tmp_4);
TCGv_i64 tmp_6 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_6, tmp_5);
uint64_t qemu_tmp_0 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_7 = tcg_temp_new_i64();
if (qemu_tmp_0 != 0) {
tcg_gen_sextract_i64(tmp_7, tmp_6, 0, qemu_tmp_0);
} else {
tcg_gen_movi_i64(tmp_7, 0);
}
TCGv_i64 tmp_8 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_8, RssV, ((int32_t) 0x1) * 16, 16);
TCGv_i64 tmp_9 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_9, RttV, ((int32_t) 0x1) * 16, 16);
TCGv_i32 tmp_10 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_10, tmp_8);
TCGv_i32 tmp_11 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_11, tmp_9);
TCGv_i32 tmp_12 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_12, tmp_10, tmp_11);
TCGv_i64 tmp_13 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_13, tmp_12);
uint64_t qemu_tmp_1 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_14 = tcg_temp_new_i64();
if (qemu_tmp_1 != 0) {
tcg_gen_sextract_i64(tmp_14, tmp_13, 0, qemu_tmp_1);
} else {
tcg_gen_movi_i64(tmp_14, 0);
}
TCGv_i64 tmp_15 = tcg_temp_new_i64();
tcg_gen_sub_i64(tmp_15, tmp_7, tmp_14);
int64_t qemu_tmp_2 = (int64_t)((int32_t) 0x0);
TCGv_i64 tmp_16 = tcg_temp_new_i64();
if (qemu_tmp_2 >= 64) {
tcg_gen_movi_i64(tmp_16, 0);
} else {
tcg_gen_shli_i64(tmp_16, tmp_15, qemu_tmp_2);
}
TCGv_i64 tmp_17 = tcg_temp_new_i64();
tcg_gen_add_i64(tmp_17, tmp_0, tmp_16);
TCGv_i64 tmp_18 = tcg_temp_new_i64();
TCGv_i32 tmp_19 = tcg_temp_new_i32();
gen_sat_i64_ovfl(tmp_19, tmp_18, tmp_17, 32);
gen_set_usr_field_if(ctx, USR_OVF,tmp_19);
tcg_gen_deposit_i64(RxxV, RxxV, tmp_18, ((int32_t) 0x0) * 32, 32);
TCGv_i64 tmp_20 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_20, RxxV, ((int32_t) 0x1) * 32, 32);
TCGv_i64 tmp_21 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_21, RssV, ((int32_t) 0x2) * 16, 16);
TCGv_i64 tmp_22 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_22, RttV, ((int32_t) 0x2) * 16, 16);
TCGv_i32 tmp_23 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_23, tmp_21);
TCGv_i32 tmp_24 = tcg_temp_new_i32();
tcg_gen_trunc_i64_tl(tmp_24, tmp_22);
TCGv_i32 tmp_25 = tcg_temp_new_i32();
tcg_gen_mul_i32(tmp_25, tmp_23, tmp_24);
TCGv_i64 tmp_26 = tcg_temp_new_i64();
tcg_gen_ext_i32_i64(tmp_26, tmp_25);
uint64_t qemu_tmp_3 = (uint64_t)((uint32_t) 0x20);
TCGv_i64 tmp_27 = tcg_temp_new_i64();
if (qemu_tmp_3 != 0) {
tcg_gen_sextract_i64(tmp_27, tmp_26, 0, qemu_tmp_3);
} else {
tcg_gen_movi_i64(tmp_27, 0);
}
TCGv_i64 tmp_28 = tcg_temp_new_i64();
tcg_gen_sextract_i64(tmp_