/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;

public class MatchContext {
    private AnnotationFS annotation;
    private RuleElement element;
    private RutaBlock parent;
    private RuleMatch ruleMatch;
    private boolean direction = true;

    public MatchContext(AnnotationFS annotation, RuleElement element, RuleMatch ruleMatch, boolean direction) {
        this.annotation = annotation;
        this.element = element;
        if (element != null) {
            this.parent = element.getParent();
        }
        this.ruleMatch = ruleMatch;
        this.direction = direction;
    }

    public MatchContext(RuleElement element, RuleMatch ruleMatch, boolean direction) {
        this(null, element, ruleMatch, direction);
    }

    public MatchContext(AbstractRuleElement element, RuleMatch ruleMatch) {
        this(element, ruleMatch, true);
    }

    public MatchContext(RutaBlock parent) {
        this.parent = parent;
    }

    public AnnotationFS getAnnotation() {
        List<AnnotationFS> matchedAnnotationsOfElement;
        if (this.annotation != null) {
            return this.annotation;
        }
        if (this.element != null && this.ruleMatch != null && (matchedAnnotationsOfElement = this.ruleMatch.getMatchedAnnotationsOfElement(this.element)) != null && !matchedAnnotationsOfElement.isEmpty()) {
            if (this.direction) {
                return matchedAnnotationsOfElement.get(matchedAnnotationsOfElement.size() - 1);
            }
            return matchedAnnotationsOfElement.get(0);
        }
        return null;
    }

    public void setAnnotation(AnnotationFS annotation) {
        this.annotation = annotation;
    }

    public RuleElement getElement() {
        return this.element;
    }

    public void setElement(RuleElement element) {
        this.element = element;
    }

    public RuleMatch getRuleMatch() {
        return this.ruleMatch;
    }

    public void setRuleMatch(RuleMatch ruleMatch) {
        this.ruleMatch = ruleMatch;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public RutaBlock getParent() {
        return this.parent;
    }

    public void setParent(RutaBlock parent) {
        this.parent = parent;
    }
}

