/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;

public class ExceptionConfig {
    private static final Logger logger = Logger.getLogger(ExceptionConfig.class.getName());
    protected final Set<String> includes = new HashSet<String>();
    protected final Set<String> excludes = new HashSet<String>();
    private final ConcurrentMap<Class<? extends Exception>, Boolean> cache = new ConcurrentHashMap<Class<? extends Exception>, Boolean>();

    public static void wrapBatchException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new BatchContainerRuntimeException(e);
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public boolean accept(Exception e) {
        if (e == null) {
            return false;
        }
        Class<?> key = e.getClass();
        Boolean computed = (Boolean)this.cache.get(key);
        if (computed != null) {
            return computed;
        }
        int includeScore = ExceptionConfig.contains(this.includes, e);
        int excludeScore = ExceptionConfig.contains(this.excludes, e);
        if (excludeScore < 0) {
            boolean result = includeScore >= 0;
            this.cache.putIfAbsent(key, result);
            return result;
        }
        boolean result = includeScore >= 0 && includeScore - excludeScore <= 0;
        this.cache.putIfAbsent(key, result);
        return result;
    }

    private static int contains(Set<String> list, Exception e) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        int score = -1;
        for (String exClassName : list) {
            try {
                Class<?> aClass = tccl.loadClass(exClassName);
                if (!aClass.isInstance(e)) continue;
                int thisScore = ExceptionConfig.score(aClass, e.getClass());
                if (score < 0) {
                    score = thisScore;
                    continue;
                }
                score = Math.min(thisScore, score);
            }
            catch (ClassNotFoundException cnfe) {
                logger.log(Level.WARNING, "Class {0} not found! Maybe there is a typo in yout skippable-exception-classes or repeatable-exception-classes?");
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new BatchContainerRuntimeException("Cannot load parts of the class defined in the batch jobs XML: " + exClassName, ncdfe);
            }
        }
        return score;
    }

    private static int score(Class<?> config, Class<?> ex) {
        int score = 0;
        for (Class<?> current = ex; current != null && !current.equals(config); current = current.getSuperclass()) {
            ++score;
        }
        return score;
    }
}

