/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class JavaTranslateVisitor
extends AbstractTranslateVisitor {
    private static final String vertexClassName = ReferenceVertex.class.getSimpleName();

    public JavaTranslateVisitor() {
        super("g");
    }

    public JavaTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.sb.append(ctx.getText()).append(".instance()");
        } else {
            this.visit((ParseTree)ctx.classType());
            this.sb.append(".build()");
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            if (configs.size() > 0 && ctx.getChild(1).getText().equals(OptionsStrategy.class.getSimpleName())) {
                for (int ix = 0; ix < configs.size(); ++ix) {
                    this.sb.append(".with(\"");
                    this.sb.append(((ParseTree)configs.get(ix)).getChild(0).getText());
                    this.sb.append("\", ");
                    this.visit(((ParseTree)configs.get(ix)).getChild(2));
                    this.sb.append(")");
                }
            } else {
                for (ParseTree config : configs) {
                    this.sb.append(".");
                    this.visit(config);
                }
            }
            this.sb.append(".create()");
        }
        return null;
    }

    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        this.sb.append(ctx.getChild(0).getText()).append("(");
        this.visit(ctx.getChild(2));
        this.sb.append(")");
        return null;
    }

    public Void visitClassType(GremlinParser.ClassTypeContext ctx) {
        if (ctx.getParent() instanceof GremlinParser.TraversalSourceSelfMethod_withoutStrategiesContext || ctx.getParent() instanceof GremlinParser.ClassTypeExprContext) {
            this.sb.append(ctx.getText()).append(".class");
        } else {
            this.sb.append(ctx.getText());
        }
        return null;
    }

    public Void visitGenericMapLiteral(GremlinParser.GenericMapLiteralContext ctx) {
        this.sb.append("new LinkedHashMap<Object, Object>() {{ ");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(" ");
        }
        this.sb.append(" }}");
        return null;
    }

    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        this.sb.append("put(");
        this.visit((ParseTree)ctx.mapKey());
        this.sb.append(", ");
        this.visit((ParseTree)ctx.genericLiteral());
        this.sb.append(");");
        return null;
    }

    public Void visitMapKey(GremlinParser.MapKeyContext ctx) {
        int keyIndex = ctx.LPAREN() != null && ctx.RPAREN() != null ? 1 : 0;
        this.visit(ctx.getChild(keyIndex));
        return null;
    }

    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        OffsetDateTime dt = DatetimeHelper.parse(JavaTranslateVisitor.removeFirstAndLastCharacters(dtString));
        this.sb.append("OffsetDateTime.parse(\"");
        this.sb.append(dt);
        this.sb.append("\")");
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("Double.NaN");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral() != null && ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("Double.NEGATIVE_INFINITY");
        } else {
            this.sb.append("Double.POSITIVE_INFINITY");
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        String integerLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = integerLiteral.length() - 1;
        char lastCharacter = integerLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'b': {
                this.sb.append("new Byte(");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            case 's': {
                this.sb.append("new Short(");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            case 'i': {
                this.sb.append(integerLiteral, 0, lastCharIndex);
                break;
            }
            case 'l': {
                this.sb.append(integerLiteral);
                break;
            }
            case 'n': {
                this.sb.append("new BigInteger(\"");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append("\")");
                break;
            }
            default: {
                this.sb.append(integerLiteral);
            }
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        if (ctx.infLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.infLiteral());
        }
        if (ctx.nanLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.nanLiteral());
        }
        String floatLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = floatLiteral.length() - 1;
        char lastCharacter = floatLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'd': 
            case 'f': {
                this.sb.append(floatLiteral);
                break;
            }
            case 'm': {
                this.sb.append("new BigDecimal(\"");
                this.sb.append(floatLiteral, 0, lastCharIndex);
                this.sb.append("\")");
                break;
            }
            default: {
                this.sb.append(floatLiteral);
            }
        }
        return null;
    }

    public Void visitGenericRangeLiteral(GremlinParser.GenericRangeLiteralContext ctx) {
        throw new TranslatorException("Java does not support range literals");
    }

    public Void visitGenericSetLiteral(GremlinParser.GenericSetLiteralContext ctx) {
        this.sb.append("new HashSet<Object>() {{ ");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.sb.append("add(");
            this.visit((ParseTree)genericLiteralContext);
            this.sb.append(");");
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(" ");
        }
        this.sb.append(" }}");
        return null;
    }

    public Void visitGenericCollectionLiteral(GremlinParser.GenericCollectionLiteralContext ctx) {
        this.sb.append("new ArrayList<Object>() {{ ");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.sb.append("add(");
            this.visit((ParseTree)genericLiteralContext);
            this.sb.append(");");
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(" ");
        }
        this.sb.append(" }}");
        return null;
    }
}

