/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public enum GType {
    BIGDECIMAL(BigDecimal.class),
    BIGINT(BigInteger.class),
    BINARY(ByteBuffer.class),
    BOOLEAN(Boolean.class),
    BYTE(Byte.class),
    CHAR(Character.class),
    DATETIME(OffsetDateTime.class),
    DOUBLE(Double.class),
    DURATION(Duration.class),
    EDGE(Edge.class),
    FLOAT(Float.class),
    GRAPH(Graph.class),
    INT(Integer.class),
    LIST(List.class),
    LONG(Long.class),
    MAP(Map.class),
    NULL(null),
    NUMBER(Number.class),
    PATH(Path.class),
    PROPERTY(Property.class),
    SET(Set.class),
    SHORT(Short.class),
    STRING(String.class),
    TREE(Tree.class),
    UUID(UUID.class),
    VERTEX(Vertex.class),
    VPROPERTY(VertexProperty.class);

    private final Class<?> javaType;

    private GType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public Class<?> getType() {
        return this.javaType;
    }

    public boolean isNumeric() {
        Class<?> type = this.getType();
        return Number.class.isAssignableFrom(type);
    }

    public static Class<?> getType(String name) {
        return GType.valueOf((String)name).javaType;
    }
}

