/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.util;

import java.io.IOException;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.util.Serializer;

public final class VertexProgramHelper {
    private VertexProgramHelper() {
    }

    public static Set<String> vertexComputeKeysAsSet(Set<VertexComputeKey> vertexComputeKeySet) {
        HashSet<String> set = new HashSet<String>(vertexComputeKeySet.size());
        for (VertexComputeKey key : vertexComputeKeySet) {
            set.add(key.getKey());
        }
        return set;
    }

    public static boolean isTransientVertexComputeKey(String key, Set<VertexComputeKey> vertexComputeKeySet) {
        for (VertexComputeKey vertexComputeKey : vertexComputeKeySet) {
            if (!vertexComputeKey.getKey().equals(key)) continue;
            return vertexComputeKey.isTransient();
        }
        throw new IllegalArgumentException("Could not find key in vertex compute key set: " + key);
    }

    public static String[] vertexComputeKeysAsArray(Set<VertexComputeKey> vertexComputeKeySet) {
        return VertexProgramHelper.vertexComputeKeysAsSet(vertexComputeKeySet).toArray(new String[vertexComputeKeySet.size()]);
    }

    public static void serialize(Object object, Configuration configuration, String key) {
        try {
            configuration.setProperty(key, (Object)Base64.getEncoder().encodeToString(Serializer.serializeObject(object)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <T> T deserialize(Configuration configuration, String key) {
        try {
            try {
                return (T)Serializer.deserializeObject(Base64.getDecoder().decode(configuration.getString(key).getBytes()));
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <S, E> Traversal.Admin<S, E> reverse(Traversal.Admin<S, E> traversal) {
        for (Step step : traversal.getSteps()) {
            if (step instanceof VertexStep) {
                ((VertexStep)step).reverseDirection();
            }
            if (!(step instanceof EdgeVertexStep)) continue;
            ((EdgeVertexStep)step).reverseDirection();
        }
        return traversal;
    }

    public static void legalConfigurationKeyValueArray(Object ... configurationKeyValues) throws IllegalArgumentException {
        if (configurationKeyValues.length % 2 != 0) {
            throw new IllegalArgumentException("The provided arguments must have a size that is a factor of 2");
        }
        for (int i = 0; i < configurationKeyValues.length; i += 2) {
            if (configurationKeyValues[i] instanceof String) continue;
            throw new IllegalArgumentException("The provided key/value array must have a String key on even array indices");
        }
    }
}

