/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLStoreFilesModificationWatcher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SSLStoreFilesModificationWatcher.class);
    private final Path keyStore;
    private final Path trustStore;
    private final Runnable onModificationRunnable;
    private ZonedDateTime lastModifiedTimeKeyStore = null;
    private ZonedDateTime lastModifiedTimeTrustStore = null;

    public SSLStoreFilesModificationWatcher(String keyStore, String trustStore, Runnable onModificationRunnable) {
        this.keyStore = keyStore != null ? Paths.get(keyStore, new String[0]) : null;
        this.trustStore = trustStore != null ? Paths.get(trustStore, new String[0]) : null;
        this.onModificationRunnable = onModificationRunnable;
        try {
            if (this.keyStore != null) {
                this.lastModifiedTimeKeyStore = SSLStoreFilesModificationWatcher.getLastModifiedTime(this.keyStore);
            }
            if (this.trustStore != null) {
                this.lastModifiedTimeTrustStore = SSLStoreFilesModificationWatcher.getLastModifiedTime(this.trustStore);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        logger.info("Started listening to modifications to the KeyStore and TrustStore files");
    }

    @Override
    public void run() {
        try {
            boolean keyStoreUpdated = false;
            boolean trustStoreUpdated = false;
            ZonedDateTime keyStoreModificationDateTime = null;
            ZonedDateTime trustStoreModificationDateTime = null;
            if (this.keyStore != null && Files.exists(this.keyStore, new LinkOption[0]) && (keyStoreUpdated = this.lastModifiedTimeKeyStore.isBefore(keyStoreModificationDateTime = SSLStoreFilesModificationWatcher.getLastModifiedTime(this.keyStore)))) {
                logger.info("KeyStore file has been modified.");
            }
            if (this.trustStore != null && Files.exists(this.trustStore, new LinkOption[0]) && (trustStoreUpdated = this.lastModifiedTimeTrustStore.isBefore(trustStoreModificationDateTime = SSLStoreFilesModificationWatcher.getLastModifiedTime(this.trustStore)))) {
                logger.info("TrustStore file has been modified.");
            }
            if (keyStoreUpdated || trustStoreUpdated) {
                this.onModificationRunnable.run();
                if (keyStoreUpdated) {
                    this.lastModifiedTimeKeyStore = keyStoreModificationDateTime;
                    logger.info("Updated KeyStore configuration");
                }
                if (trustStoreUpdated) {
                    this.lastModifiedTimeTrustStore = trustStoreModificationDateTime;
                    logger.info("Updated TrustStore configuration");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ZonedDateTime getLastModifiedTime(Path filepath) throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(filepath, BasicFileAttributes.class, new LinkOption[0]);
        return ZonedDateTime.ofInstant(attributes.lastModifiedTime().toInstant(), ZoneOffset.UTC);
    }
}

