/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.ListFunction;

public final class CombineStep<S, E>
extends ScalarMapStep<S, List<?>>
implements TraversalParent,
ListFunction {
    private Traversal.Admin<S, E> valueTraversal;
    private Object parameterItems;

    public CombineStep(Traversal.Admin traversal, Object values) {
        super(traversal);
        if (values instanceof Traversal) {
            this.valueTraversal = this.integrateChild(((Traversal)values).asAdmin());
        } else {
            this.parameterItems = values;
        }
    }

    @Override
    public String getStepName() {
        return "combine";
    }

    @Override
    protected List<?> map(Traverser.Admin<S> traverser) {
        Collection listA = this.convertTraverserToCollection(traverser);
        Collection listB = null != this.valueTraversal ? this.convertTraversalToCollection(traverser, this.valueTraversal) : this.convertArgumentToCollection(this.parameterItems);
        ArrayList combined = new ArrayList(listA);
        combined.addAll(listB);
        return combined;
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return null == this.valueTraversal ? Collections.emptyList() : Collections.singletonList(this.valueTraversal);
    }

    public Object getParameterItems() {
        return this.parameterItems;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (this.valueTraversal != null) {
            this.integrateChild(this.valueTraversal);
        }
    }

    @Override
    public CombineStep<S, E> clone() {
        CombineStep clone = (CombineStep)super.clone();
        if (null != this.valueTraversal) {
            clone.valueTraversal = this.valueTraversal.clone();
        } else {
            clone.parameterItems = this.parameterItems;
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return Objects.hash(result, this.valueTraversal, this.parameterItems);
    }
}

