/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class NonSyncDataOutputStream
extends DataOutputStream {
    public NonSyncDataOutputStream(OutputStream stream) {
        super(stream);
    }

    private void incrementWritten(int len) {
        this.written += len;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.incrementWritten(1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incrementWritten(len);
    }
}

