---
permalink: /docs/
---

# Teaclave Documentation

## Try

- [My First Function](my-first-function.md)
- [Function in Python](functions-in-python.md)
- [How to Add Built-in Functions](builtin-functions.md)
- [Deploying Teaclave on Azure Confidential Computing VM](azure-confidential-computing.md)
- [Executing WebAssembly in Teaclave](executing-wasm.md)
- [Inference Task with TVM in Teaclave](inference-with-tvm.md)

## Design

- [Access Control in Teaclave](access-control.md)
- [Build System](build-system.md)
- [Mutual Attestation: Why and How](mutual-attestation.md)
- [Threat Model](threat-model.md)
- [Teaclave Service Internals](service-internals.md)
- [Adding Executors](adding-executors.md)
- [Papers, Talks, and Related Articles](papers-talks.md)

## Contribute

- [Release Guide](release-guide.md)
- [Development Tips](development-tips.md)
- [Rust Development Guideline](rust-guideline.md)

## Codebase

- [Attestation](../attestation/README.md)
- [Binder](../binder/README.md)
- [Built-in Functions](../function/README.md)
- [Client SDK](../sdk/README.md)
- [Command Line Tool](../cli/README.md)
- [Common Libraries](../common/README.md)
- [Configurations in Teaclave](../config/README.md)
- [Crypto Primitives](../crypto/README.md)
- [Data Center Attestation Service](../dcap/README.md)
- [Dockerfile and Compose File](../docker/README.md)
- [Examples](../examples/README.md)
- [Executor Runtime](../runtime/README.md)
- [File Agent](../file_agent/README.md)
- [Function Executors](../executor/README.md)
- [Keys and Certificates](../keys/README.md)
- [RPC](../rpc/README.md)
- [Teaclave Services](../services/README.md)
- [Teaclave Worker](../worker/README.md)
- [Test Harness and Test Cases](../tests/README.md)
- [Third-Party Dependency Vendoring](../third_party/README.md)
- [Tools](../tools/README.md)
- [Types](../types/README.md)

## API References

- [Teaclave SGX SDK](https://teaclave.apache.org/docs/sgx-sdk/)
- [Teaclave Client SDK (Python)](https://teaclave.apache.org/docs/client-sdk-python/)
- [Crates in Teaclave (Enclave)](https://teaclave.apache.org/docs/crates-enclave/)
- [Crates in Teaclave (App)](https://teaclave.apache.org/docs/crates-app/)
