--
--   Licensed to the Apache Software Foundation (ASF) under one or more
--   contributor license agreements.  See the NOTICE file distributed with
--   this work for additional information regarding copyright ownership.
--   The ASF licenses this file to You under the Apache License, Version 2.0
--   (the "License"); you may not use this file except in compliance with
--   the License.  You may obtain a copy of the License at
--
--      http://www.apache.org/licenses/LICENSE-2.0
--
--   Unless required by applicable law or agreed to in writing, software
--   distributed under the License is distributed on an "AS IS" BASIS,
--   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
--   See the License for the specific language governing permissions and
--   limitations under the License.
--

-- Binary Comparison

CREATE TEMPORARY VIEW t AS SELECT 1;

SELECT cast(1 as binary) = '1' FROM t;
SELECT cast(1 as binary) > '2' FROM t;
SELECT cast(1 as binary) >= '2' FROM t;
SELECT cast(1 as binary) < '2' FROM t;
SELECT cast(1 as binary) <= '2' FROM t;
SELECT cast(1 as binary) <> '2' FROM t;
SELECT cast(1 as binary) = cast(null as string) FROM t;
SELECT cast(1 as binary) > cast(null as string) FROM t;
SELECT cast(1 as binary) >= cast(null as string) FROM t;
SELECT cast(1 as binary) < cast(null as string) FROM t;
SELECT cast(1 as binary) <= cast(null as string) FROM t;
SELECT cast(1 as binary) <> cast(null as string) FROM t;
SELECT '1' = cast(1 as binary) FROM t;
SELECT '2' > cast(1 as binary) FROM t;
SELECT '2' >= cast(1 as binary) FROM t;
SELECT '2' < cast(1 as binary) FROM t;
SELECT '2' <= cast(1 as binary) FROM t;
SELECT '2' <> cast(1 as binary) FROM t;
SELECT cast(null as string) = cast(1 as binary) FROM t;
SELECT cast(null as string) > cast(1 as binary) FROM t;
SELECT cast(null as string) >= cast(1 as binary) FROM t;
SELECT cast(null as string) < cast(1 as binary) FROM t;
SELECT cast(null as string) <= cast(1 as binary) FROM t;
SELECT cast(null as string) <> cast(1 as binary) FROM t;
SELECT cast(1 as tinyint) = '1' FROM t;
SELECT cast(1 as tinyint) > '2' FROM t;
SELECT cast(1 as tinyint) >= '2' FROM t;
SELECT cast(1 as tinyint) < '2' FROM t;
SELECT cast(1 as tinyint) <= '2' FROM t;
SELECT cast(1 as tinyint) <> '2' FROM t;
SELECT cast(1 as tinyint) = cast(null as string) FROM t;
SELECT cast(1 as tinyint) > cast(null as string) FROM t;
SELECT cast(1 as tinyint) >= cast(null as string) FROM t;
SELECT cast(1 as tinyint) < cast(null as string) FROM t;
SELECT cast(1 as tinyint) <= cast(null as string) FROM t;
SELECT cast(1 as tinyint) <> cast(null as string) FROM t;
SELECT '1' = cast(1 as tinyint) FROM t;
SELECT '2' > cast(1 as tinyint) FROM t;
SELECT '2' >= cast(1 as tinyint) FROM t;
SELECT '2' < cast(1 as tinyint) FROM t;
SELECT '2' <= cast(1 as tinyint) FROM t;
SELECT '2' <> cast(1 as tinyint) FROM t;
SELECT cast(null as string) = cast(1 as tinyint) FROM t;
SELECT cast(null as string) > cast(1 as tinyint) FROM t;
SELECT cast(null as string) >= cast(1 as tinyint) FROM t;
SELECT cast(null as string) < cast(1 as tinyint) FROM t;
SELECT cast(null as string) <= cast(1 as tinyint) FROM t;
SELECT cast(null as string) <> cast(1 as tinyint) FROM t;
SELECT cast(1 as smallint) = '1' FROM t;
SELECT cast(1 as smallint) > '2' FROM t;
SELECT cast(1 as smallint) >= '2' FROM t;
SELECT cast(1 as smallint) < '2' FROM t;
SELECT cast(1 as smallint) <= '2' FROM t;
SELECT cast(1 as smallint) <> '2' FROM t;
SELECT cast(1 as smallint) = cast(null as string) FROM t;
SELECT cast(1 as smallint) > cast(null as string) FROM t;
SELECT cast(1 as smallint) >= cast(null as string) FROM t;
SELECT cast(1 as smallint) < cast(null as string) FROM t;
SELECT cast(1 as smallint) <= cast(null as string) FROM t;
SELECT cast(1 as smallint) <> cast(null as string) FROM t;
SELECT '1' = cast(1 as smallint) FROM t;
SELECT '2' > cast(1 as smallint) FROM t;
SELECT '2' >= cast(1 as smallint) FROM t;
SELECT '2' < cast(1 as smallint) FROM t;
SELECT '2' <= cast(1 as smallint) FROM t;
SELECT '2' <> cast(1 as smallint) FROM t;
SELECT cast(null as string) = cast(1 as smallint) FROM t;
SELECT cast(null as string) > cast(1 as smallint) FROM t;
SELECT cast(null as string) >= cast(1 as smallint) FROM t;
SELECT cast(null as string) < cast(1 as smallint) FROM t;
SELECT cast(null as string) <= cast(1 as smallint) FROM t;
SELECT cast(null as string) <> cast(1 as smallint) FROM t;
SELECT cast(1 as int) = '1' FROM t;
SELECT cast(1 as int) > '2' FROM t;
SELECT cast(1 as int) >= '2' FROM t;
SELECT cast(1 as int) < '2' FROM t;
SELECT cast(1 as int) <= '2' FROM t;
SELECT cast(1 as int) <> '2' FROM t;
SELECT cast(1 as int) = cast(null as string) FROM t;
SELECT cast(1 as int) > cast(null as string) FROM t;
SELECT cast(1 as int) >= cast(null as string) FROM t;
SELECT cast(1 as int) < cast(null as string) FROM t;
SELECT cast(1 as int) <= cast(null as string) FROM t;
SELECT cast(1 as int) <> cast(null as string) FROM t;
SELECT '1' = cast(1 as int) FROM t;
SELECT '2' > cast(1 as int) FROM t;
SELECT '2' >= cast(1 as int) FROM t;
SELECT '2' < cast(1 as int) FROM t;
SELECT '2' <> cast(1 as int) FROM t;
SELECT '2' <= cast(1 as int) FROM t;
SELECT cast(null as string) = cast(1 as int) FROM t;
SELECT cast(null as string) > cast(1 as int) FROM t;
SELECT cast(null as string) >= cast(1 as int) FROM t;
SELECT cast(null as string) < cast(1 as int) FROM t;
SELECT cast(null as string) <> cast(1 as int) FROM t;
SELECT cast(null as string) <= cast(1 as int) FROM t;
SELECT cast(1 as bigint) = '1' FROM t;
SELECT cast(1 as bigint) > '2' FROM t;
SELECT cast(1 as bigint) >= '2' FROM t;
SELECT cast(1 as bigint) < '2' FROM t;
SELECT cast(1 as bigint) <= '2' FROM t;
SELECT cast(1 as bigint) <> '2' FROM t;
SELECT cast(1 as bigint) = cast(null as string) FROM t;
SELECT cast(1 as bigint) > cast(null as string) FROM t;
SELECT cast(1 as bigint) >= cast(null as string) FROM t;
SELECT cast(1 as bigint) < cast(null as string) FROM t;
SELECT cast(1 as bigint) <= cast(null as string) FROM t;
SELECT cast(1 as bigint) <> cast(null as string) FROM t;
SELECT '1' = cast(1 as bigint) FROM t;
SELECT '2' > cast(1 as bigint) FROM t;
SELECT '2' >= cast(1 as bigint) FROM t;
SELECT '2' < cast(1 as bigint) FROM t;
SELECT '2' <= cast(1 as bigint) FROM t;
SELECT '2' <> cast(1 as bigint) FROM t;
SELECT cast(null as string) = cast(1 as bigint) FROM t;
SELECT cast(null as string) > cast(1 as bigint) FROM t;
SELECT cast(null as string) >= cast(1 as bigint) FROM t;
SELECT cast(null as string) < cast(1 as bigint) FROM t;
SELECT cast(null as string) <= cast(1 as bigint) FROM t;
SELECT cast(null as string) <> cast(1 as bigint) FROM t;
SELECT cast(1 as decimal(10, 0)) = '1' FROM t;
SELECT cast(1 as decimal(10, 0)) > '2' FROM t;
SELECT cast(1 as decimal(10, 0)) >= '2' FROM t;
SELECT cast(1 as decimal(10, 0)) < '2' FROM t;
SELECT cast(1 as decimal(10, 0)) <> '2' FROM t;
SELECT cast(1 as decimal(10, 0)) <= '2' FROM t;
SELECT cast(1 as decimal(10, 0)) = cast(null as string) FROM t;
SELECT cast(1 as decimal(10, 0)) > cast(null as string) FROM t;
SELECT cast(1 as decimal(10, 0)) >= cast(null as string) FROM t;
SELECT cast(1 as decimal(10, 0)) < cast(null as string) FROM t;
SELECT cast(1 as decimal(10, 0)) <> cast(null as string) FROM t;
SELECT cast(1 as decimal(10, 0)) <= cast(null as string) FROM t;
SELECT '1' = cast(1 as decimal(10, 0)) FROM t;
SELECT '2' > cast(1 as decimal(10, 0)) FROM t;
SELECT '2' >= cast(1 as decimal(10, 0)) FROM t;
SELECT '2' < cast(1 as decimal(10, 0)) FROM t;
SELECT '2' <= cast(1 as decimal(10, 0)) FROM t;
SELECT '2' <> cast(1 as decimal(10, 0)) FROM t;
SELECT cast(null as string) = cast(1 as decimal(10, 0)) FROM t;
SELECT cast(null as string) > cast(1 as decimal(10, 0)) FROM t;
SELECT cast(null as string) >= cast(1 as decimal(10, 0)) FROM t;
SELECT cast(null as string) < cast(1 as decimal(10, 0)) FROM t;
SELECT cast(null as string) <= cast(1 as decimal(10, 0)) FROM t;
SELECT cast(null as string) <> cast(1 as decimal(10, 0)) FROM t;
SELECT cast(1 as double) = '1' FROM t;
SELECT cast(1 as double) > '2' FROM t;
SELECT cast(1 as double) >= '2' FROM t;
SELECT cast(1 as double) < '2' FROM t;
SELECT cast(1 as double) <= '2' FROM t;
SELECT cast(1 as double) <> '2' FROM t;
SELECT cast(1 as double) = cast(null as string) FROM t;
SELECT cast(1 as double) > cast(null as string) FROM t;
SELECT cast(1 as double) >= cast(null as string) FROM t;
SELECT cast(1 as double) < cast(null as string) FROM t;
SELECT cast(1 as double) <= cast(null as string) FROM t;
SELECT cast(1 as double) <> cast(null as string) FROM t;
SELECT '1' = cast(1 as double) FROM t;
SELECT '2' > cast(1 as double) FROM t;
SELECT '2' >= cast(1 as double) FROM t;
SELECT '2' < cast(1 as double) FROM t;
SELECT '2' <= cast(1 as double) FROM t;
SELECT '2' <> cast(1 as double) FROM t;
SELECT cast(null as string) = cast(1 as double) FROM t;
SELECT cast(null as string) > cast(1 as double) FROM t;
SELECT cast(null as string) >= cast(1 as double) FROM t;
SELECT cast(null as string) < cast(1 as double) FROM t;
SELECT cast(null as string) <= cast(1 as double) FROM t;
SELECT cast(null as string) <> cast(1 as double) FROM t;
SELECT cast(1 as float) = '1' FROM t;
SELECT cast(1 as float) > '2' FROM t;
SELECT cast(1 as float) >= '2' FROM t;
SELECT cast(1 as float) < '2' FROM t;
SELECT cast(1 as float) <= '2' FROM t;
SELECT cast(1 as float) <> '2' FROM t;
SELECT cast(1 as float) = cast(null as string) FROM t;
SELECT cast(1 as float) > cast(null as string) FROM t;
SELECT cast(1 as float) >= cast(null as string) FROM t;
SELECT cast(1 as float) < cast(null as string) FROM t;
SELECT cast(1 as float) <= cast(null as string) FROM t;
SELECT cast(1 as float) <> cast(null as string) FROM t;
SELECT '1' = cast(1 as float) FROM t;
SELECT '2' > cast(1 as float) FROM t;
SELECT '2' >= cast(1 as float) FROM t;
SELECT '2' < cast(1 as float) FROM t;
SELECT '2' <= cast(1 as float) FROM t;
SELECT '2' <> cast(1 as float) FROM t;
SELECT cast(null as string) = cast(1 as float) FROM t;
SELECT cast(null as string) > cast(1 as float) FROM t;
SELECT cast(null as string) >= cast(1 as float) FROM t;
SELECT cast(null as string) < cast(1 as float) FROM t;
SELECT cast(null as string) <= cast(1 as float) FROM t;
SELECT cast(null as string) <> cast(1 as float) FROM t;
-- the following queries return 1 if the search condition is satisfied
-- and returns nothing if the search condition is not satisfied
SELECT '1996-09-09' = date('1996-09-09') FROM t;
SELECT '1996-9-10' > date('1996-09-09') FROM t;
SELECT '1996-9-10' >= date('1996-09-09') FROM t;
SELECT '1996-9-10' < date('1996-09-09') FROM t;
SELECT '1996-9-10' <= date('1996-09-09') FROM t;
SELECT '1996-9-10' <> date('1996-09-09') FROM t;
SELECT cast(null as string) = date('1996-09-09') FROM t;
SELECT cast(null as string)> date('1996-09-09') FROM t;
SELECT cast(null as string)>= date('1996-09-09') FROM t;
SELECT cast(null as string)< date('1996-09-09') FROM t;
SELECT cast(null as string)<= date('1996-09-09') FROM t;
SELECT cast(null as string)<> date('1996-09-09') FROM t;
SELECT date('1996-09-09') = '1996-09-09' FROM t;
SELECT date('1996-9-10') > '1996-09-09' FROM t;
SELECT date('1996-9-10') >= '1996-09-09' FROM t;
SELECT date('1996-9-10') < '1996-09-09' FROM t;
SELECT date('1996-9-10') <= '1996-09-09' FROM t;
SELECT date('1996-9-10') <> '1996-09-09' FROM t;
SELECT date('1996-09-09') = cast(null as string) FROM t;
SELECT date('1996-9-10') > cast(null as string) FROM t;
SELECT date('1996-9-10') >= cast(null as string) FROM t;
SELECT date('1996-9-10') < cast(null as string) FROM t;
SELECT date('1996-9-10') <= cast(null as string) FROM t;
SELECT date('1996-9-10') <> cast(null as string) FROM t;
SELECT '1996-09-09 12:12:12.4' = timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT '1996-09-09 12:12:12.5' > timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT '1996-09-09 12:12:12.5' >= timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT '1996-09-09 12:12:12.5' < timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT '1996-09-09 12:12:12.5' <= timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT '1996-09-09 12:12:12.5' <> timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT cast(null as string) = timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT cast(null as string) > timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT cast(null as string) >= timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT cast(null as string) < timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT cast(null as string) <= timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT cast(null as string) <> timestamp('1996-09-09 12:12:12.4') FROM t;
SELECT timestamp('1996-09-09 12:12:12.4' )= '1996-09-09 12:12:12.4' FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )> '1996-09-09 12:12:12.4' FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )>= '1996-09-09 12:12:12.4' FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )< '1996-09-09 12:12:12.4' FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )<= '1996-09-09 12:12:12.4' FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )<> '1996-09-09 12:12:12.4' FROM t;
SELECT timestamp('1996-09-09 12:12:12.4' )= cast(null as string) FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )> cast(null as string) FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )>= cast(null as string) FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )< cast(null as string) FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )<= cast(null as string) FROM t;
SELECT timestamp('1996-09-09 12:12:12.5' )<> cast(null as string) FROM t;
SELECT ' ' = X'0020' FROM t;
SELECT ' ' > X'001F' FROM t;
SELECT ' ' >= X'001F' FROM t;
SELECT ' ' < X'001F' FROM t;
SELECT ' ' <= X'001F' FROM t;
SELECT ' ' <> X'001F' FROM t;
SELECT cast(null as string) = X'0020' FROM t;
SELECT cast(null as string) > X'001F' FROM t;
SELECT cast(null as string) >= X'001F' FROM t;
SELECT cast(null as string) < X'001F' FROM t;
SELECT cast(null as string) <= X'001F' FROM t;
SELECT cast(null as string) <> X'001F' FROM t;
SELECT X'0020' = ' ' FROM t;
SELECT X'001F' > ' ' FROM t;
SELECT X'001F' >= ' ' FROM t;
SELECT X'001F' < ' ' FROM t;
SELECT X'001F' <= ' ' FROM t;
SELECT X'001F' <> ' ' FROM t;
SELECT X'0020' = cast(null as string) FROM t;
SELECT X'001F' > cast(null as string) FROM t;
SELECT X'001F' >= cast(null as string) FROM t;
SELECT X'001F' < cast(null as string) FROM t;
SELECT X'001F' <= cast(null as string) FROM t;
SELECT X'001F' <> cast(null as string) FROM t;
