% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jvm.R
\name{sparkR.callJStatic}
\alias{sparkR.callJStatic}
\title{Call Static Java Methods}
\usage{
sparkR.callJStatic(x, methodName, ...)
}
\arguments{
\item{x}{fully qualified Java class name that contains the static method to invoke.}

\item{methodName}{name of static method to invoke.}

\item{...}{parameters to pass to the Java method.}
}
\value{
the return value of the Java method. Either returned as a R object
 if it can be deserialized or returned as a "jobj". See details section for more.
}
\description{
Call a static method in the JVM running the Spark driver. The return
value is automatically converted to R objects for simple objects. Other
values are returned as "jobj" which are references to objects on JVM.
}
\details{
This is a low level function to access the JVM directly and should only be used
for advanced use cases. The arguments and return values that are primitive R
types (like integer, numeric, character, lists) are automatically translated to/from
Java types (like Integer, Double, String, Array). A full list can be found in
serialize.R and deserialize.R in the Apache Spark code base.
}
\note{
sparkR.callJStatic since 2.0.1
}
\examples{
\dontrun{
sparkR.session() # Need to have a Spark JVM running before calling callJStatic
sparkR.callJStatic("java.lang.System", "currentTimeMillis")
sparkR.callJStatic("java.lang.System", "getProperty", "java.home")
}
}
\seealso{
\link{sparkR.callJMethod}, \link{sparkR.newJObject}
}
