/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.compress.Compression;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.VotersRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.network.TransferableChannel;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.AbstractRecords;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.ConvertedRecords;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.Record;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.RecordBatch;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.RecordBatchIterator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.RecordsUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.SimpleRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.TimestampType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.AbstractIterator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.BufferSupplier;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.CloseableIterator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Time;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Utils;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

public class MemoryRecords
extends AbstractRecords {
    private static final Logger log = LoggerFactory.getLogger(MemoryRecords.class);
    public static final MemoryRecords EMPTY = MemoryRecords.readableRecords(ByteBuffer.allocate(0));
    private final ByteBuffer buffer;
    private final Iterable<MutableRecordBatch> batches = this::batchIterator;
    private int validBytes = -1;

    private MemoryRecords(ByteBuffer buffer) {
        Objects.requireNonNull(buffer, "buffer should not be null");
        this.buffer = buffer;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.limit();
    }

    @Override
    public int writeTo(TransferableChannel channel, int position, int length) throws IOException {
        if ((long)position + (long)length > (long)this.buffer.limit()) {
            throw new IllegalArgumentException("position+length should not be greater than buffer.limit(), position: " + position + ", length: " + length + ", buffer.limit(): " + this.buffer.limit());
        }
        return Utils.tryWriteTo(channel, position, length, this.buffer);
    }

    public int writeFullyTo(GatheringByteChannel channel) throws IOException {
        int written;
        this.buffer.mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer)) {
        }
        this.buffer.reset();
        return written;
    }

    public int validBytes() {
        if (this.validBytes >= 0) {
            return this.validBytes;
        }
        int bytes = 0;
        for (RecordBatch recordBatch : this.batches()) {
            bytes += recordBatch.sizeInBytes();
        }
        this.validBytes = bytes;
        return bytes;
    }

    public ConvertedRecords<MemoryRecords> downConvert(byte toMagic, long firstOffset, Time time) {
        return RecordsUtil.downConvert(this.batches(), toMagic, firstOffset, time);
    }

    public AbstractIterator<MutableRecordBatch> batchIterator() {
        return new RecordBatchIterator<MutableRecordBatch>(new ByteBufferLogInputStream(this.buffer.duplicate(), Integer.MAX_VALUE));
    }

    public Integer firstBatchSize() {
        if (this.buffer.remaining() < 17) {
            return null;
        }
        return new ByteBufferLogInputStream(this.buffer, Integer.MAX_VALUE).nextBatchSize();
    }

    public FilterResult filterTo(TopicPartition partition, RecordFilter filter, ByteBuffer destinationBuffer, int maxRecordBatchSize, BufferSupplier decompressionBufferSupplier) {
        return MemoryRecords.filterTo(partition, this.batches(), filter, destinationBuffer, maxRecordBatchSize, decompressionBufferSupplier);
    }

    private static FilterResult filterTo(TopicPartition partition, Iterable<MutableRecordBatch> batches, RecordFilter filter, ByteBuffer destinationBuffer, int maxRecordBatchSize, BufferSupplier decompressionBufferSupplier) {
        FilterResult filterResult = new FilterResult(destinationBuffer);
        ByteBufferOutputStream bufferOutputStream = new ByteBufferOutputStream(destinationBuffer);
        for (MutableRecordBatch batch : batches) {
            ByteBuffer outputBuffer;
            RecordFilter.BatchRetentionResult batchRetentionResult = filter.checkBatchRetention(batch);
            boolean containsMarkerForEmptyTxn = batchRetentionResult.containsMarkerForEmptyTxn;
            RecordFilter.BatchRetention batchRetention = batchRetentionResult.batchRetention;
            FilterResult filterResult2 = filterResult;
            filterResult2.bytesRead = filterResult2.bytesRead + batch.sizeInBytes();
            if (batchRetention == RecordFilter.BatchRetention.DELETE) continue;
            byte batchMagic = batch.magic();
            ArrayList<Record> retainedRecords = new ArrayList<Record>();
            BatchFilterResult iterationResult = MemoryRecords.filterBatch(batch, decompressionBufferSupplier, filterResult, filter, batchMagic, true, retainedRecords);
            boolean containsTombstones = iterationResult.containsTombstones;
            boolean writeOriginalBatch = iterationResult.writeOriginalBatch;
            long maxOffset = iterationResult.maxOffset;
            if (!retainedRecords.isEmpty()) {
                boolean needToSetDeleteHorizon;
                boolean bl = needToSetDeleteHorizon = batch.magic() >= 2 && (containsTombstones || containsMarkerForEmptyTxn) && !batch.deleteHorizonMs().isPresent();
                if (writeOriginalBatch && !needToSetDeleteHorizon) {
                    batch.writeTo(bufferOutputStream);
                    filterResult.updateRetainedBatchMetadata(batch, retainedRecords.size(), false);
                } else {
                    long deleteHorizonMs = needToSetDeleteHorizon ? filter.currentTime + filter.deleteRetentionMs : batch.deleteHorizonMs().orElse(-1L);
                    try (MemoryRecordsBuilder builder = MemoryRecords.buildRetainedRecordsInto(batch, retainedRecords, bufferOutputStream, deleteHorizonMs);){
                        MemoryRecords records = builder.build();
                        int filteredBatchSize = records.sizeInBytes();
                        if (filteredBatchSize > batch.sizeInBytes() && filteredBatchSize > maxRecordBatchSize) {
                            log.warn("Record batch from {} with last offset {} exceeded max record batch size {} after cleaning (new size is {}). Consumers with version earlier than 0.10.1.0 may need to increase their fetch sizes.", partition, batch.lastOffset(), maxRecordBatchSize, filteredBatchSize);
                        }
                        MemoryRecordsBuilder.RecordsInfo info = builder.info();
                        filterResult.updateRetainedBatchMetadata(info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, maxOffset, retainedRecords.size(), filteredBatchSize);
                    }
                }
            } else if (batchRetention == RecordFilter.BatchRetention.RETAIN_EMPTY) {
                if (batchMagic < 2) {
                    throw new IllegalStateException("Empty batches are only supported for magic v2 and above");
                }
                bufferOutputStream.ensureRemaining(61);
                DefaultRecordBatch.writeEmptyHeader(bufferOutputStream.buffer(), batchMagic, batch.producerId(), batch.producerEpoch(), batch.baseSequence(), batch.baseOffset(), batch.lastOffset(), batch.partitionLeaderEpoch(), batch.timestampType(), batch.maxTimestamp(), batch.isTransactional(), batch.isControlBatch());
                filterResult.updateRetainedBatchMetadata(batch, 0, true);
            }
            if ((outputBuffer = bufferOutputStream.buffer()) == destinationBuffer) continue;
            filterResult.outputBuffer = outputBuffer;
            return filterResult;
        }
        return filterResult;
    }

    private static BatchFilterResult filterBatch(RecordBatch batch, BufferSupplier decompressionBufferSupplier, FilterResult filterResult, RecordFilter filter, byte batchMagic, boolean writeOriginalBatch, List<Record> retainedRecords) {
        long maxOffset = -1L;
        boolean containsTombstones = false;
        try (CloseableIterator<Record> iterator = batch.streamingIterator(decompressionBufferSupplier);){
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                FilterResult filterResult2 = filterResult;
                filterResult2.messagesRead = filterResult2.messagesRead + 1;
                if (filter.shouldRetainRecord(batch, record)) {
                    if (!record.hasMagic(batchMagic)) {
                        writeOriginalBatch = false;
                    }
                    if (record.offset() > maxOffset) {
                        maxOffset = record.offset();
                    }
                    retainedRecords.add(record);
                    if (record.hasValue()) continue;
                    containsTombstones = true;
                    continue;
                }
                writeOriginalBatch = false;
            }
            BatchFilterResult batchFilterResult = new BatchFilterResult(writeOriginalBatch, containsTombstones, maxOffset);
            return batchFilterResult;
        }
    }

    private static MemoryRecordsBuilder buildRetainedRecordsInto(RecordBatch originalBatch, List<Record> retainedRecords, ByteBufferOutputStream bufferOutputStream, long deleteHorizonMs) {
        byte magic = originalBatch.magic();
        Compression compression = Compression.of(originalBatch.compressionType()).build();
        TimestampType timestampType = originalBatch.timestampType();
        long logAppendTime = timestampType == TimestampType.LOG_APPEND_TIME ? originalBatch.maxTimestamp() : -1L;
        long baseOffset = magic >= 2 ? originalBatch.baseOffset() : retainedRecords.get(0).offset();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(bufferOutputStream, magic, compression, timestampType, baseOffset, logAppendTime, originalBatch.producerId(), originalBatch.producerEpoch(), originalBatch.baseSequence(), originalBatch.isTransactional(), originalBatch.isControlBatch(), originalBatch.partitionLeaderEpoch(), bufferOutputStream.limit(), deleteHorizonMs);
        for (Record record : retainedRecords) {
            builder.append(record);
        }
        if (magic >= 2) {
            builder.overrideLastOffset(originalBatch.lastOffset());
        }
        return builder;
    }

    public ByteBuffer buffer() {
        return this.buffer.duplicate();
    }

    public Iterable<MutableRecordBatch> batches() {
        return this.batches;
    }

    public String toString() {
        return "MemoryRecords(size=" + this.sizeInBytes() + ", buffer=" + this.buffer + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryRecords that = (MemoryRecords)o;
        return this.buffer.equals(that.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public static MemoryRecords readableRecords(ByteBuffer buffer) {
        return new MemoryRecords(buffer);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, Compression compression, TimestampType timestampType, long baseOffset) {
        return MemoryRecords.builder(buffer, (byte)2, compression, timestampType, baseOffset);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, Compression compression, TimestampType timestampType, long baseOffset, int maxSize) {
        long logAppendTime = -1L;
        if (timestampType == TimestampType.LOG_APPEND_TIME) {
            logAppendTime = System.currentTimeMillis();
        }
        return new MemoryRecordsBuilder(buffer, 2, compression, timestampType, baseOffset, logAppendTime, -1L, -1, -1, false, false, -1, maxSize);
    }

    public static MemoryRecordsBuilder idempotentBuilder(ByteBuffer buffer, Compression compression, long baseOffset, long producerId, short producerEpoch, int baseSequence) {
        return MemoryRecords.builder(buffer, (byte)2, compression, TimestampType.CREATE_TIME, baseOffset, System.currentTimeMillis(), producerId, producerEpoch, baseSequence);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, Compression compression, TimestampType timestampType, long baseOffset, long logAppendTime) {
        return MemoryRecords.builder(buffer, magic, compression, timestampType, baseOffset, logAppendTime, -1L, (short)-1, -1, false, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, Compression compression, TimestampType timestampType, long baseOffset) {
        long logAppendTime = -1L;
        if (timestampType == TimestampType.LOG_APPEND_TIME) {
            logAppendTime = System.currentTimeMillis();
        }
        return MemoryRecords.builder(buffer, magic, compression, timestampType, baseOffset, logAppendTime, -1L, (short)-1, -1, false, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, Compression compression, TimestampType timestampType, long baseOffset, long logAppendTime, int partitionLeaderEpoch) {
        return MemoryRecords.builder(buffer, magic, compression, timestampType, baseOffset, logAppendTime, -1L, (short)-1, -1, false, partitionLeaderEpoch);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, Compression compression, long baseOffset, long producerId, short producerEpoch, int baseSequence, boolean isTransactional) {
        return MemoryRecords.builder(buffer, (byte)2, compression, TimestampType.CREATE_TIME, baseOffset, -1L, producerId, producerEpoch, baseSequence, isTransactional, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, Compression compression, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence) {
        return MemoryRecords.builder(buffer, magic, compression, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, false, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, Compression compression, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, int partitionLeaderEpoch) {
        return MemoryRecords.builder(buffer, magic, compression, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, false, partitionLeaderEpoch);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, Compression compression, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, boolean isControlBatch, int partitionLeaderEpoch) {
        return new MemoryRecordsBuilder(buffer, magic, compression, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, isControlBatch, partitionLeaderEpoch, buffer.remaining());
    }

    public static MemoryRecords withRecords(Compression compression, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, compression, records);
    }

    public static MemoryRecords withRecords(Compression compression, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, 0L, compression, TimestampType.CREATE_TIME, -1L, (short)-1, -1, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withRecords(byte magic, Compression compression, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, 0L, compression, TimestampType.CREATE_TIME, records);
    }

    public static MemoryRecords withRecords(long initialOffset, Compression compression, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, initialOffset, compression, TimestampType.CREATE_TIME, records);
    }

    public static MemoryRecords withRecords(byte magic, long initialOffset, Compression compression, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, initialOffset, compression, TimestampType.CREATE_TIME, records);
    }

    public static MemoryRecords withRecords(long initialOffset, Compression compression, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, initialOffset, compression, TimestampType.CREATE_TIME, -1L, (short)-1, -1, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withIdempotentRecords(Compression compression, long producerId, short producerEpoch, int baseSequence, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, 0L, compression, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, -1, false, records);
    }

    public static MemoryRecords withIdempotentRecords(byte magic, long initialOffset, Compression compression, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, initialOffset, compression, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withIdempotentRecords(long initialOffset, Compression compression, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, initialOffset, compression, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withTransactionalRecords(Compression compression, long producerId, short producerEpoch, int baseSequence, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, 0L, compression, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, -1, true, records);
    }

    public static MemoryRecords withTransactionalRecords(byte magic, long initialOffset, Compression compression, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, initialOffset, compression, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, true, records);
    }

    public static MemoryRecords withTransactionalRecords(long initialOffset, Compression compression, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withTransactionalRecords((byte)2, initialOffset, compression, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, records);
    }

    public static MemoryRecords withRecords(byte magic, long initialOffset, Compression compression, TimestampType timestampType, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, initialOffset, compression, timestampType, -1L, (short)-1, -1, -1, false, records);
    }

    public static MemoryRecords withRecords(byte magic, long initialOffset, Compression compression, TimestampType timestampType, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, boolean isTransactional, SimpleRecord ... records) {
        if (records.length == 0) {
            return EMPTY;
        }
        int sizeEstimate = AbstractRecords.estimateSizeInBytes(magic, compression.type(), Arrays.asList(records));
        ByteBufferOutputStream bufferStream = new ByteBufferOutputStream(sizeEstimate);
        long logAppendTime = -1L;
        if (timestampType == TimestampType.LOG_APPEND_TIME) {
            logAppendTime = System.currentTimeMillis();
        }
        try (MemoryRecordsBuilder builder = new MemoryRecordsBuilder(bufferStream, magic, compression, timestampType, initialOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, false, partitionLeaderEpoch, sizeEstimate);){
            for (SimpleRecord record : records) {
                builder.append(record);
            }
            MemoryRecords memoryRecords = builder.build();
            return memoryRecords;
        }
    }

    public static MemoryRecords withEndTransactionMarker(long producerId, short producerEpoch, EndTransactionMarker marker) {
        return MemoryRecords.withEndTransactionMarker(0L, System.currentTimeMillis(), -1, producerId, producerEpoch, marker);
    }

    public static MemoryRecords withEndTransactionMarker(long timestamp, long producerId, short producerEpoch, EndTransactionMarker marker) {
        return MemoryRecords.withEndTransactionMarker(0L, timestamp, -1, producerId, producerEpoch, marker);
    }

    public static MemoryRecords withEndTransactionMarker(long initialOffset, long timestamp, int partitionLeaderEpoch, long producerId, short producerEpoch, EndTransactionMarker marker) {
        int endTxnMarkerBatchSize = 61 + EndTransactionMarker.CURRENT_END_TXN_SCHEMA_RECORD_SIZE;
        ByteBuffer buffer = ByteBuffer.allocate(endTxnMarkerBatchSize);
        MemoryRecords.writeEndTransactionalMarker(buffer, initialOffset, timestamp, partitionLeaderEpoch, producerId, producerEpoch, marker);
        buffer.flip();
        return MemoryRecords.readableRecords(buffer);
    }

    public static void writeEndTransactionalMarker(ByteBuffer buffer, long initialOffset, long timestamp, int partitionLeaderEpoch, long producerId, short producerEpoch, EndTransactionMarker marker) {
        boolean isTransactional = true;
        try (MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 2, (Compression)Compression.NONE, TimestampType.CREATE_TIME, initialOffset, timestamp, producerId, producerEpoch, -1, isTransactional, true, partitionLeaderEpoch, buffer.capacity());){
            builder.appendEndTxnMarker(timestamp, marker);
        }
    }

    public static MemoryRecords withLeaderChangeMessage(long initialOffset, long timestamp, int leaderEpoch, ByteBuffer buffer, LeaderChangeMessage leaderChangeMessage) {
        try (MemoryRecordsBuilder builder = MemoryRecords.createKraftControlRecordBuilder(initialOffset, timestamp, leaderEpoch, buffer);){
            builder.appendLeaderChangeMessage(timestamp, leaderChangeMessage);
            MemoryRecords memoryRecords = builder.build();
            return memoryRecords;
        }
    }

    public static MemoryRecords withSnapshotHeaderRecord(long initialOffset, long timestamp, int leaderEpoch, ByteBuffer buffer, SnapshotHeaderRecord snapshotHeaderRecord) {
        try (MemoryRecordsBuilder builder = MemoryRecords.createKraftControlRecordBuilder(initialOffset, timestamp, leaderEpoch, buffer);){
            builder.appendSnapshotHeaderMessage(timestamp, snapshotHeaderRecord);
            MemoryRecords memoryRecords = builder.build();
            return memoryRecords;
        }
    }

    public static MemoryRecords withSnapshotFooterRecord(long initialOffset, long timestamp, int leaderEpoch, ByteBuffer buffer, SnapshotFooterRecord snapshotFooterRecord) {
        try (MemoryRecordsBuilder builder = MemoryRecords.createKraftControlRecordBuilder(initialOffset, timestamp, leaderEpoch, buffer);){
            builder.appendSnapshotFooterMessage(timestamp, snapshotFooterRecord);
            MemoryRecords memoryRecords = builder.build();
            return memoryRecords;
        }
    }

    public static MemoryRecords withKRaftVersionRecord(long initialOffset, long timestamp, int leaderEpoch, ByteBuffer buffer, KRaftVersionRecord kraftVersionRecord) {
        try (MemoryRecordsBuilder builder = MemoryRecords.createKraftControlRecordBuilder(initialOffset, timestamp, leaderEpoch, buffer);){
            builder.appendKRaftVersionMessage(timestamp, kraftVersionRecord);
            MemoryRecords memoryRecords = builder.build();
            return memoryRecords;
        }
    }

    public static MemoryRecords withVotersRecord(long initialOffset, long timestamp, int leaderEpoch, ByteBuffer buffer, VotersRecord votersRecord) {
        try (MemoryRecordsBuilder builder = MemoryRecords.createKraftControlRecordBuilder(initialOffset, timestamp, leaderEpoch, buffer);){
            builder.appendVotersMessage(timestamp, votersRecord);
            MemoryRecords memoryRecords = builder.build();
            return memoryRecords;
        }
    }

    private static MemoryRecordsBuilder createKraftControlRecordBuilder(long initialOffset, long timestamp, int leaderEpoch, ByteBuffer buffer) {
        return new MemoryRecordsBuilder(buffer, 2, (Compression)Compression.NONE, TimestampType.CREATE_TIME, initialOffset, timestamp, -1L, -1, -1, false, true, leaderEpoch, buffer.capacity());
    }

    public static class FilterResult {
        private ByteBuffer outputBuffer;
        private int messagesRead = 0;
        private int bytesRead = 0;
        private int messagesRetained = 0;
        private int bytesRetained = 0;
        private long maxOffset = -1L;
        private long maxTimestamp = -1L;
        private long shallowOffsetOfMaxTimestamp = -1L;

        private FilterResult(ByteBuffer outputBuffer) {
            this.outputBuffer = outputBuffer;
        }

        private void updateRetainedBatchMetadata(MutableRecordBatch retainedBatch, int numMessagesInBatch, boolean headerOnly) {
            int bytesRetained = headerOnly ? 61 : retainedBatch.sizeInBytes();
            this.updateRetainedBatchMetadata(retainedBatch.maxTimestamp(), retainedBatch.lastOffset(), retainedBatch.lastOffset(), numMessagesInBatch, bytesRetained);
        }

        private void updateRetainedBatchMetadata(long maxTimestamp, long shallowOffsetOfMaxTimestamp, long maxOffset, int messagesRetained, int bytesRetained) {
            this.validateBatchMetadata(maxTimestamp, shallowOffsetOfMaxTimestamp, maxOffset);
            if (maxTimestamp > this.maxTimestamp) {
                this.maxTimestamp = maxTimestamp;
                this.shallowOffsetOfMaxTimestamp = shallowOffsetOfMaxTimestamp;
            }
            this.maxOffset = Math.max(maxOffset, this.maxOffset);
            this.messagesRetained += messagesRetained;
            this.bytesRetained += bytesRetained;
        }

        private void validateBatchMetadata(long maxTimestamp, long shallowOffsetOfMaxTimestamp, long maxOffset) {
            if (maxTimestamp != -1L && shallowOffsetOfMaxTimestamp < 0L) {
                throw new IllegalArgumentException("shallowOffset undefined for maximum timestamp " + maxTimestamp);
            }
            if (maxOffset < 0L) {
                throw new IllegalArgumentException("maxOffset undefined");
            }
        }

        public ByteBuffer outputBuffer() {
            return this.outputBuffer;
        }

        public int messagesRead() {
            return this.messagesRead;
        }

        public int bytesRead() {
            return this.bytesRead;
        }

        public int messagesRetained() {
            return this.messagesRetained;
        }

        public int bytesRetained() {
            return this.bytesRetained;
        }

        public long maxOffset() {
            return this.maxOffset;
        }

        public long maxTimestamp() {
            return this.maxTimestamp;
        }

        public long shallowOffsetOfMaxTimestamp() {
            return this.shallowOffsetOfMaxTimestamp;
        }
    }

    public static abstract class RecordFilter {
        public final long currentTime;
        public final long deleteRetentionMs;

        public RecordFilter(long currentTime, long deleteRetentionMs) {
            this.currentTime = currentTime;
            this.deleteRetentionMs = deleteRetentionMs;
        }

        protected abstract BatchRetentionResult checkBatchRetention(RecordBatch var1);

        protected abstract boolean shouldRetainRecord(RecordBatch var1, Record var2);

        public static enum BatchRetention {
            DELETE,
            RETAIN_EMPTY,
            DELETE_EMPTY;

        }

        public static class BatchRetentionResult {
            public final BatchRetention batchRetention;
            public final boolean containsMarkerForEmptyTxn;

            public BatchRetentionResult(BatchRetention batchRetention, boolean containsMarkerForEmptyTxn) {
                this.batchRetention = batchRetention;
                this.containsMarkerForEmptyTxn = containsMarkerForEmptyTxn;
            }
        }
    }

    private static class BatchFilterResult {
        private final boolean writeOriginalBatch;
        private final boolean containsTombstones;
        private final long maxOffset;

        private BatchFilterResult(boolean writeOriginalBatch, boolean containsTombstones, long maxOffset) {
            this.writeOriginalBatch = writeOriginalBatch;
            this.containsTombstones = containsTombstones;
            this.maxOffset = maxOffset;
        }
    }
}

