/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.context.TracingThreadListener;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatusContext;
import org.apache.skywalking.apm.agent.core.profile.ProfileTask;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskChannelService;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskExecutionContext;
import org.apache.skywalking.apm.util.StringUtil;

@DefaultImplementor
public class ProfileTaskExecutionService
implements BootService,
TracingThreadListener {
    private static final ILog LOGGER = LogManager.getLogger(ProfileTaskExecutionService.class);
    private static final ScheduledExecutorService PROFILE_TASK_SCHEDULE = Executors.newSingleThreadScheduledExecutor(new DefaultNamedThreadFactory("PROFILE-TASK-SCHEDULE"));
    private volatile long lastCommandCreateTime = -1L;
    private final AtomicReference<ProfileTaskExecutionContext> taskExecutionContext = new AtomicReference();
    private static final ExecutorService PROFILE_EXECUTOR = Executors.newSingleThreadExecutor(new DefaultNamedThreadFactory("PROFILING-TASK"));
    private final List<ProfileTask> profileTaskList = Collections.synchronizedList(new LinkedList());

    public void addProfileTask(ProfileTask task) {
        CheckResult dataError;
        if (task.getCreateTime() > this.lastCommandCreateTime) {
            this.lastCommandCreateTime = task.getCreateTime();
        }
        if (!(dataError = this.checkProfileTaskSuccess(task)).isSuccess()) {
            LOGGER.warn("check command error, cannot process this profile task. reason: {}", dataError.getErrorReason());
            return;
        }
        this.profileTaskList.add(task);
        long timeToProcessMills = task.getStartTime() - System.currentTimeMillis();
        PROFILE_TASK_SCHEDULE.schedule(() -> this.processProfileTask(task), timeToProcessMills, TimeUnit.MILLISECONDS);
    }

    public ProfileStatusContext addProfiling(TracingContext tracingContext, String traceSegmentId, String firstSpanOPName) {
        ProfileTaskExecutionContext executionContext = this.taskExecutionContext.get();
        if (executionContext == null) {
            return ProfileStatusContext.createWithNone();
        }
        return executionContext.attemptProfiling(tracingContext, traceSegmentId, firstSpanOPName);
    }

    public void continueProfiling(TracingContext tracingContext, String traceSegmentId) {
        ProfileTaskExecutionContext executionContext = this.taskExecutionContext.get();
        if (executionContext == null) {
            return;
        }
        executionContext.continueProfiling(tracingContext, traceSegmentId);
    }

    public void profilingRecheck(TracingContext tracingContext, String traceSegmentId, String firstSpanOPName) {
        ProfileTaskExecutionContext executionContext = this.taskExecutionContext.get();
        if (executionContext == null) {
            return;
        }
        executionContext.profilingRecheck(tracingContext, traceSegmentId, firstSpanOPName);
    }

    private synchronized void processProfileTask(ProfileTask task) {
        this.stopCurrentProfileTask(this.taskExecutionContext.get());
        ProfileTaskExecutionContext currentStartedTaskContext = new ProfileTaskExecutionContext(task);
        this.taskExecutionContext.set(currentStartedTaskContext);
        currentStartedTaskContext.startProfiling(PROFILE_EXECUTOR);
        PROFILE_TASK_SCHEDULE.schedule(() -> this.stopCurrentProfileTask(currentStartedTaskContext), (long)task.getDuration(), TimeUnit.MINUTES);
    }

    synchronized void stopCurrentProfileTask(ProfileTaskExecutionContext needToStop) {
        if (needToStop == null || !this.taskExecutionContext.compareAndSet(needToStop, null)) {
            return;
        }
        needToStop.stopProfiling();
        this.profileTaskList.remove(needToStop.getTask());
        ServiceManager.INSTANCE.findService(ProfileTaskChannelService.class).notifyProfileTaskFinish(needToStop.getTask());
    }

    @Override
    public void prepare() {
    }

    @Override
    public void boot() {
    }

    @Override
    public void onComplete() {
        TracingContext.TracingThreadListenerManager.add(this);
    }

    @Override
    public void shutdown() {
        TracingContext.TracingThreadListenerManager.remove(this);
        PROFILE_TASK_SCHEDULE.shutdown();
        PROFILE_EXECUTOR.shutdown();
    }

    public long getLastCommandCreateTime() {
        return this.lastCommandCreateTime;
    }

    private CheckResult checkProfileTaskSuccess(ProfileTask task) {
        if (StringUtil.isEmpty(task.getFirstSpanOPName())) {
            return new CheckResult(false, "endpoint name cannot be empty");
        }
        if (task.getDuration() < 1) {
            return new CheckResult(false, "monitor duration must greater than 1 minutes");
        }
        if (task.getDuration() > 15) {
            return new CheckResult(false, "The duration of the monitoring task cannot be greater than 15 minutes");
        }
        if (task.getMinDurationThreshold() < 0) {
            return new CheckResult(false, "min duration threshold must greater than or equals zero");
        }
        if (task.getThreadDumpPeriod() < 10) {
            return new CheckResult(false, "dump period must be greater than or equals 10 milliseconds");
        }
        if (task.getMaxSamplingCount() <= 0) {
            return new CheckResult(false, "max sampling count must greater than zero");
        }
        if (task.getMaxSamplingCount() >= 10) {
            return new CheckResult(false, "max sampling count must less than 10");
        }
        long taskProcessFinishTime = this.calcProfileTaskFinishTime(task);
        for (ProfileTask profileTask : this.profileTaskList) {
            if (taskProcessFinishTime < profileTask.getStartTime() || taskProcessFinishTime > this.calcProfileTaskFinishTime(profileTask)) continue;
            return new CheckResult(false, "there already have processing task in time range, could not add a new task again. processing task monitor endpoint name: " + profileTask.getFirstSpanOPName());
        }
        return new CheckResult(true, null);
    }

    private long calcProfileTaskFinishTime(ProfileTask task) {
        return task.getStartTime() + TimeUnit.MINUTES.toMillis(task.getDuration());
    }

    @Override
    public void afterMainThreadFinish(TracingContext tracingContext) {
        ProfileTaskExecutionContext currentExecutionContext;
        if (tracingContext.profileStatus().isBeingWatched() && (currentExecutionContext = this.taskExecutionContext.get()) != null) {
            currentExecutionContext.stopTracingProfile(tracingContext);
        }
    }

    private static class CheckResult {
        private boolean success;
        private String errorReason;

        public CheckResult(boolean success, String errorReason) {
            this.success = success;
            this.errorReason = errorReason;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getErrorReason() {
            return this.errorReason;
        }
    }
}

