/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.commons;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.util.StringUtil;

public class PathMappingCache {
    private static final String PATH_SEPARATOR = "/";
    private String classPath = "";
    private ConcurrentHashMap<Method, String> methodPathMapping = new ConcurrentHashMap();

    public PathMappingCache(String classPath) {
        if (!StringUtil.isEmpty((String)classPath) && !classPath.startsWith(PATH_SEPARATOR)) {
            classPath = PATH_SEPARATOR + classPath;
        }
        this.classPath = classPath;
    }

    public String findPathMapping(Method method) {
        return this.methodPathMapping.get(method);
    }

    public void addPathMapping(Method method, String methodPath) {
        if (!(StringUtil.isEmpty((String)methodPath) || methodPath.startsWith(PATH_SEPARATOR) || this.classPath.endsWith(PATH_SEPARATOR))) {
            methodPath = PATH_SEPARATOR + methodPath;
        }
        this.methodPathMapping.put(method, (this.classPath + methodPath).replace("//", PATH_SEPARATOR));
    }
}

