/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum PatternType {
    UNKNOWN(0),
    ANY(1),
    MATCH(2),
    LITERAL(3),
    PREFIXED(4);

    private static final Map<Byte, PatternType> CODE_TO_VALUE;
    private static final Map<String, PatternType> NAME_TO_VALUE;
    private final byte code;

    private PatternType(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isSpecific() {
        return this != UNKNOWN && this != ANY && this != MATCH;
    }

    public static PatternType fromCode(byte code) {
        return CODE_TO_VALUE.getOrDefault(code, UNKNOWN);
    }

    public static PatternType fromString(String name) {
        return NAME_TO_VALUE.getOrDefault(name, UNKNOWN);
    }

    static {
        CODE_TO_VALUE = Collections.unmodifiableMap(Arrays.stream(PatternType.values()).collect(Collectors.toMap(PatternType::code, Function.identity())));
        NAME_TO_VALUE = Collections.unmodifiableMap(Arrays.stream(PatternType.values()).collect(Collectors.toMap(Enum::name, Function.identity())));
    }
}

