/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.CommonFields;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Struct;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Type;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.DescribeLogDirsResponse;

public class DescribeLogDirsRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema DESCRIBE_LOG_DIRS_REQUEST_V0;
    private static final Schema DESCRIBE_LOG_DIRS_REQUEST_V1;
    private final Set<TopicPartition> topicPartitions;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_LOG_DIRS_REQUEST_V0, DESCRIBE_LOG_DIRS_REQUEST_V1};
    }

    public DescribeLogDirsRequest(Struct struct, short version) {
        super(ApiKeys.DESCRIBE_LOG_DIRS, version);
        if (struct.getArray(TOPICS_KEY_NAME) == null) {
            this.topicPartitions = null;
        } else {
            this.topicPartitions = new HashSet<TopicPartition>();
            for (Object topicStructObj : struct.getArray(TOPICS_KEY_NAME)) {
                Struct topicStruct = (Struct)topicStructObj;
                String topic = topicStruct.get(CommonFields.TOPIC_NAME);
                for (Object partitionObj : topicStruct.getArray(PARTITIONS_KEY_NAME)) {
                    int partition = (Integer)partitionObj;
                    this.topicPartitions.add(new TopicPartition(topic, partition));
                }
            }
        }
    }

    public DescribeLogDirsRequest(Set<TopicPartition> topicPartitions, short version) {
        super(ApiKeys.DESCRIBE_LOG_DIRS, version);
        this.topicPartitions = topicPartitions;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DESCRIBE_LOG_DIRS.requestSchema(this.version()));
        if (this.topicPartitions == null) {
            struct.set(TOPICS_KEY_NAME, null);
            return struct;
        }
        HashMap partitionsByTopic = new HashMap();
        for (TopicPartition tp : this.topicPartitions) {
            if (!partitionsByTopic.containsKey(tp.topic())) {
                partitionsByTopic.put(tp.topic(), new ArrayList());
            }
            ((List)partitionsByTopic.get(tp.topic())).add(tp.partition());
        }
        ArrayList<Struct> topicStructArray = new ArrayList<Struct>();
        for (Map.Entry partitionsByTopicEntry : partitionsByTopic.entrySet()) {
            Struct topicStruct = struct.instance(TOPICS_KEY_NAME);
            topicStruct.set(CommonFields.TOPIC_NAME, (String)partitionsByTopicEntry.getKey());
            topicStruct.set(PARTITIONS_KEY_NAME, (Object)((List)partitionsByTopicEntry.getValue()).toArray());
            topicStructArray.add(topicStruct);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicStructArray.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new DescribeLogDirsResponse(throttleTimeMs, new HashMap<String, DescribeLogDirsResponse.LogDirInfo>());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DESCRIBE_LOG_DIRS.latestVersion()));
    }

    public boolean isAllTopicPartitions() {
        return this.topicPartitions == null;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public static DescribeLogDirsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeLogDirsRequest(ApiKeys.DESCRIBE_LOG_DIRS.parseRequest(version, buffer), version);
    }

    static {
        DESCRIBE_LOG_DIRS_REQUEST_V1 = DESCRIBE_LOG_DIRS_REQUEST_V0 = new Schema(new Field(TOPICS_KEY_NAME, ArrayOf.nullable(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(Type.INT32), "List of partition ids of the topic.")))));
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeLogDirsRequest> {
        private final Set<TopicPartition> topicPartitions;

        public Builder(Set<TopicPartition> partitions) {
            super(ApiKeys.DESCRIBE_LOG_DIRS);
            this.topicPartitions = partitions;
        }

        @Override
        public DescribeLogDirsRequest build(short version) {
            return new DescribeLogDirsRequest(this.topicPartitions, version);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(type=DescribeLogDirsRequest").append(", topicPartitions=").append(this.topicPartitions).append(")");
            return builder.toString();
        }
    }
}

