/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.micrometer;

import io.micrometer.observation.Observation;
import io.micrometer.observation.transport.ReceiverContext;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.toolkit.activation.micrometer.SpanHelper;
import org.apache.skywalking.apm.toolkit.activation.micrometer.TaggingHelper;
import org.apache.skywalking.apm.util.StringUtil;

public class MicrometerReceiverTracingHandlerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String methodName = method.getName();
        if ("onStart".equals(methodName)) {
            ReceiverContext context = (ReceiverContext)allArguments[0];
            ContextCarrier contextCarrier = new ContextCarrier();
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                next.setHeadValue(context.getGetter().get(context.getCarrier(), next.getHeadKey()));
            }
            AbstractSpan span = ContextManager.createEntrySpan((String)MicrometerReceiverTracingHandlerInterceptor.getOperationName(context), (ContextCarrier)contextCarrier);
            span.setComponent((Component)ComponentsDefine.MICROMETER);
        } else if ("onStop".equals(methodName)) {
            ReceiverContext context = (ReceiverContext)allArguments[0];
            SpanLayer spanLayer = TaggingHelper.toLayer(context.getAllKeyValues());
            AbstractSpan abstractSpan = ContextManager.activeSpan();
            abstractSpan.setPeer(SpanHelper.tryToGetPeer(context.getRemoteServiceAddress(), context.getRemoteServiceName(), context.getAllKeyValues())).setOperationName(MicrometerReceiverTracingHandlerInterceptor.getOperationName(context));
            context.getAllKeyValues().forEach(keyValue -> abstractSpan.tag(Tags.ofKey((String)keyValue.getKey()), keyValue.getValue()));
            if (spanLayer != null) {
                abstractSpan.setLayer(spanLayer);
            }
            ContextManager.stopSpan();
        } else if ("onError".equals(methodName)) {
            Observation.Context context = (Observation.Context)allArguments[0];
            ContextManager.activeSpan().log(context.getError());
        }
    }

    private static String getOperationName(ReceiverContext<Object> context) {
        return StringUtil.isBlank((String)context.getContextualName()) ? context.getName() : context.getContextualName();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

