/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.httpclient.v5.wrapper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;

public class AsyncResponseConsumerWrapper<T>
implements AsyncResponseConsumer<T> {
    private AsyncResponseConsumer<T> consumer;

    public AsyncResponseConsumerWrapper(AsyncResponseConsumer<T> consumer) {
        this.consumer = consumer;
    }

    public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context, FutureCallback<T> resultCallback) throws HttpException, IOException {
        if (ContextManager.isActive()) {
            int statusCode = response.getCode();
            AbstractSpan span = ContextManager.activeSpan();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
            if (statusCode >= 400) {
                span.errorOccurred();
            }
            ContextManager.stopSpan();
        }
        this.consumer.consumeResponse(response, entityDetails, context, resultCallback);
    }

    public void informationResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (ContextManager.isActive()) {
            int statusCode = response.getCode();
            AbstractSpan span = ContextManager.activeSpan();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
            if (statusCode >= 400) {
                span.errorOccurred();
            }
            ContextManager.stopSpan();
        }
        this.consumer.informationResponse(response, context);
    }

    public void failed(Exception cause) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().errorOccurred().log((Throwable)cause);
            ContextManager.stopSpan();
        }
        this.consumer.failed(cause);
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.consumer.updateCapacity(capacityChannel);
    }

    public void consume(ByteBuffer src) throws IOException {
        this.consumer.consume(src);
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.consumer.streamEnd(trailers);
    }

    public void releaseResources() {
        this.consumer.releaseResources();
    }
}

