/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.thrift.wrapper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.plugin.thrift.wrapper.AbstractProtocolWrapper;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;

public class ClientOutProtocolWrapper
extends AbstractProtocolWrapper {
    private static final ILog LOGGER = LogManager.getLogger(ClientOutProtocolWrapper.class);
    private boolean injected = true;

    public ClientOutProtocolWrapper(TProtocol protocol) {
        super(protocol);
    }

    public final void writeMessageBegin(TMessage message) throws TException {
        this.injected = false;
        super.writeMessageBegin(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFieldStop() throws TException {
        if (!this.injected && ContextManager.isActive()) {
            try {
                ContextCarrier carrier = new ContextCarrier();
                ContextManager.inject((ContextCarrier)carrier);
                CarrierItem items = carrier.items();
                HashMap<String, String> header = new HashMap<String, String>(3);
                while (items.hasNext()) {
                    items = items.next();
                    header.put(items.getHeadKey(), items.getHeadValue());
                }
                this.writeHeader(header);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to propagating CarrierItems.", throwable);
            }
            finally {
                this.injected = true;
            }
        }
        super.writeFieldStop();
    }

    private void writeHeader(Map<String, String> header) throws TException {
        super.writeFieldBegin(new TField("SW_MAGIC_FIELD", 13, 8888));
        super.writeMapBegin(new TMap(11, 11, header.size()));
        Set<Map.Entry<String, String>> entries = header.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            super.writeString(entry.getKey());
            super.writeString(entry.getValue());
        }
        super.writeMapEnd();
        super.writeFieldEnd();
    }
}

