/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.influxdb.interceptor;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.influxdb.InfluxDBPluginConfig;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;

public class InfluxDBMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String methodName = method.getName();
        String peer = String.valueOf(objInst.getSkyWalkingDynamicField());
        AbstractSpan span = ContextManager.createExitSpan((String)("InfluxDB/" + methodName), (String)peer);
        span.setComponent((Component)ComponentsDefine.INFLUXDB_JAVA);
        SpanLayer.asDB((AbstractSpan)span);
        Tags.DB_TYPE.set(span, "InfluxDB");
        if (allArguments.length <= 0 || !InfluxDBPluginConfig.Plugin.InfluxDB.TRACE_INFLUXQL) {
            return;
        }
        if (allArguments[0] instanceof Query) {
            Query query = (Query)allArguments[0];
            Tags.DB_INSTANCE.set(span, query.getDatabase());
            Tags.DB_STATEMENT.set(span, query.getCommand());
            return;
        }
        if ("write".equals(methodName)) {
            if (allArguments[0] instanceof BatchPoints) {
                BatchPoints batchPoints = (BatchPoints)allArguments[0];
                Tags.DB_INSTANCE.set(span, batchPoints.getDatabase());
                Tags.DB_STATEMENT.set(span, batchPoints.lineProtocol());
                return;
            }
            if (allArguments.length == 5) {
                if (allArguments[0] instanceof String) {
                    Tags.DB_INSTANCE.set(span, (String)allArguments[0]);
                }
                if (allArguments[4] instanceof String) {
                    Tags.DB_STATEMENT.set(span, (String)allArguments[4]);
                }
                return;
            }
            if (allArguments.length == 3 && allArguments[2] instanceof Point) {
                Tags.DB_INSTANCE.set(span, (String)allArguments[0]);
                Tags.DB_STATEMENT.set(span, ((Point)allArguments[2]).lineProtocol());
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

