/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.trace;

import java.sql.SQLException;
import java.sql.Statement;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class StatementTracing {
    public static <R> R execute(Statement realStatement, ConnectionInfo connectInfo, String method, String sql, Executable<R> exec) throws SQLException {
        try {
            AbstractSpan span = ContextManager.createExitSpan((String)(connectInfo.getDBType() + "/JDBC/Statement/" + method), (String)connectInfo.getDatabasePeer());
            Tags.DB_TYPE.set(span, connectInfo.getDBType());
            Tags.DB_INSTANCE.set(span, connectInfo.getDatabaseName());
            Tags.DB_STATEMENT.set(span, sql);
            span.setComponent((Component)connectInfo.getComponent());
            SpanLayer.asDB((AbstractSpan)span);
            R r = exec.exe(realStatement, sql);
            return r;
        }
        catch (SQLException e) {
            AbstractSpan span = ContextManager.activeSpan();
            span.log((Throwable)e);
            throw e;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    public static interface Executable<R> {
        public R exe(Statement var1, String var2) throws SQLException;
    }
}

