/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.version;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;

public enum Version {
    CURRENT;

    private static final ILog LOGGER;
    private static final String VERSION_FILE_NAME = "skywalking-agent-version.properties";
    private final String buildVersion;
    private final String commitIdAbbrev;

    private Version() {
        try {
            InputStream inputStream = Version.class.getClassLoader().getResourceAsStream(VERSION_FILE_NAME);
            if (inputStream == null) {
                throw new IOException("Can't find skywalking-agent-version.properties");
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            this.buildVersion = properties.getProperty("git.build.version");
            this.commitIdAbbrev = properties.getProperty("git.commit.id.abbrev");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public String toString() {
        return String.format("%s-%s", this.buildVersion, this.commitIdAbbrev);
    }

    @Generated
    public String getBuildVersion() {
        return this.buildVersion;
    }

    @Generated
    public String getCommitIdAbbrev() {
        return this.commitIdAbbrev;
    }

    static {
        LOGGER = LogManager.getLogger(Version.class);
        LOGGER.info("SkyWalking agent version: {}", new Object[]{CURRENT});
    }
}

