/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.provider.log.listener;

import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.LogDataBody;
import org.apache.skywalking.apm.network.logging.v3.TraceContext;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogSinkListener;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogSinkListenerFactory;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.Log;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.source.TagAutocomplete;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.ProtoBufJsonUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSinkListener
implements LogSinkListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordSinkListener.class);
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;
    private final List<String> searchableTagKeys;
    private final Log log = new Log();

    @Override
    public void build() {
        this.sourceReceiver.receive((ISource)this.log);
        this.addAutocompleteTags();
    }

    @Override
    public LogSinkListener parse(LogData.Builder logData, Message extraLog) {
        TraceContext traceContext;
        LogDataBody body = logData.getBody();
        this.log.setUniqueId(UUID.randomUUID().toString().replace("-", ""));
        this.log.setTimestamp(logData.getTimestamp());
        this.log.setTimeBucket(TimeBucket.getRecordTimeBucket((long)logData.getTimestamp()));
        String serviceName = this.namingControl.formatServiceName(logData.getService());
        String serviceId = IDManager.ServiceID.buildId((String)serviceName, (boolean)true);
        this.log.setServiceId(serviceId);
        if (StringUtil.isNotEmpty((String)logData.getServiceInstance())) {
            this.log.setServiceInstanceId(IDManager.ServiceInstanceID.buildId((String)serviceId, (String)this.namingControl.formatInstanceName(logData.getServiceInstance())));
        }
        if (StringUtil.isNotEmpty((String)logData.getEndpoint())) {
            String endpointName = this.namingControl.formatEndpointName(serviceName, logData.getEndpoint());
            this.log.setEndpointId(IDManager.EndpointID.buildId((String)serviceId, (String)endpointName));
        }
        if (StringUtil.isNotEmpty((String)(traceContext = logData.getTraceContext()).getTraceId())) {
            this.log.setTraceId(traceContext.getTraceId());
        }
        if (StringUtil.isNotEmpty((String)traceContext.getTraceSegmentId())) {
            this.log.setTraceSegmentId(traceContext.getTraceSegmentId());
            this.log.setSpanId(traceContext.getSpanId());
        }
        if (body.hasText()) {
            this.log.setContentType(ContentType.TEXT);
            this.log.setContent(body.getText().getText());
        } else if (body.hasYaml()) {
            this.log.setContentType(ContentType.YAML);
            this.log.setContent(body.getYaml().getYaml());
        } else if (body.hasJson()) {
            this.log.setContentType(ContentType.JSON);
            this.log.setContent(body.getJson().getJson());
        } else if (extraLog != null) {
            this.log.setContentType(ContentType.JSON);
            this.log.setContent(ProtoBufJsonUtils.toJSON((Message)extraLog));
        }
        if (logData.getTags().getDataCount() > 0) {
            this.log.setTagsRawData(logData.getTags().toByteArray());
        }
        this.log.getTags().addAll(this.appendSearchableTags(logData));
        return this;
    }

    private Collection<Tag> appendSearchableTags(LogData.Builder logData) {
        HashSet<Tag> logTags = new HashSet<Tag>();
        logData.getTags().getDataList().forEach(tag -> {
            if (this.searchableTagKeys.contains(tag.getKey())) {
                Tag logTag = new Tag(tag.getKey(), tag.getValue());
                if (tag.getValue().length() > 256 || logTag.toString().length() > 256) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Log tag : {} length > : {}, dropped", (Object)logTag, (Object)256);
                    }
                    return;
                }
                logTags.add(logTag);
            }
        });
        return logTags;
    }

    private void addAutocompleteTags() {
        this.log.getTags().forEach(tag -> {
            TagAutocomplete tagAutocomplete = new TagAutocomplete();
            tagAutocomplete.setTagKey(tag.getKey());
            tagAutocomplete.setTagValue(tag.getValue());
            tagAutocomplete.setTagType(TagType.LOG);
            tagAutocomplete.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)this.log.getTimestamp()));
            this.sourceReceiver.receive((ISource)tagAutocomplete);
        });
    }

    @Generated
    public RecordSinkListener(SourceReceiver sourceReceiver, NamingControl namingControl, List<String> searchableTagKeys) {
        this.sourceReceiver = sourceReceiver;
        this.namingControl = namingControl;
        this.searchableTagKeys = searchableTagKeys;
    }

    @Generated
    public Log getLog() {
        return this.log;
    }

    public static class Factory
    implements LogSinkListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;
        private final List<String> searchableTagKeys;

        public Factory(ModuleManager moduleManager, LogAnalyzerModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
            ConfigService configService = (ConfigService)moduleManager.find("core").provider().getService(ConfigService.class);
            this.searchableTagKeys = Arrays.asList(configService.getSearchableLogsTags().split(","));
        }

        @Override
        public RecordSinkListener create() {
            return new RecordSinkListener(this.sourceReceiver, this.namingControl, this.searchableTagKeys);
        }
    }
}

