/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.management.ManagementData;
import org.apache.skywalking.oap.server.core.profiling.continuous.storage.ContinuousProfilingPolicy;
import org.apache.skywalking.oap.server.core.storage.profiling.continuous.IContinuousProfilingPolicyDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ManagementCRUDEsDAO;

public class ContinuousProfilingPolicyEsDAO
extends ManagementCRUDEsDAO
implements IContinuousProfilingPolicyDAO {
    public ContinuousProfilingPolicyEsDAO(ElasticSearchClient client, StorageBuilder storageBuilder) {
        super(client, (StorageBuilder<ManagementData>)storageBuilder);
    }

    public void savePolicy(ContinuousProfilingPolicy policy) throws IOException {
        if (!super.create("continuous_profiling_policy", (ManagementData)policy)) {
            super.update("continuous_profiling_policy", (ManagementData)policy);
        }
    }

    public List<ContinuousProfilingPolicy> queryPolicies(List<String> serviceIdList) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("continuous_profiling_policy");
        BoolQueryBuilder query = Query.bool().must((QueryBuilder)Query.term((String)"management_table", (Object)"continuous_profiling_policy"));
        query.must((QueryBuilder)Query.terms((String)"service_id", serviceIdList));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(serviceIdList.size()));
        return this.buildPolicies(((ElasticSearchClient)this.getClient()).search(index, search.build()));
    }

    private List<ContinuousProfilingPolicy> buildPolicies(SearchResponse response) {
        ArrayList<ContinuousProfilingPolicy> policies = new ArrayList<ContinuousProfilingPolicy>();
        for (SearchHit hit : response.getHits()) {
            Map sourceAsMap = hit.getSource();
            ContinuousProfilingPolicy.Builder builder = new ContinuousProfilingPolicy.Builder();
            policies.add(builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("continuous_profiling_policy", sourceAsMap)));
        }
        return policies;
    }
}

